/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.edit.parts;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.gmf.map.edit.provider.custom.MapEditUtil;
import com.indy.gmf.map.edit.provider.custom.MapIconAPI;
import com.indy.map.ItemProperty;
import com.indy.map.MapPackage;
import com.indy.map.Template;
import com.indy.map.diagram.edit.policies.ItemPropertyItemSemanticEditPolicy;
import com.indy.map.diagram.edit.policies.MapTextNonResizableEditPolicy;
import com.indy.map.diagram.part.MapVisualIDRegistry;
import com.indy.map.diagram.providers.MapElementTypes;
import com.indy.map.diagram.providers.MapParserProvider;
import com.stambia.md.MdNode;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ListItemComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.internal.mapmode.IdentityMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.edit.policies.labels.IRefreshableFeedbackEditPolicy;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class ItemPropertyEditPart
extends CompartmentEditPart {
    public static final int VISUAL_ID = 3014;
    private DirectEditManager manager;
    private IParser parser;
    private List<?> parserElements;
    private IdentityMapMode mapMode = new IdentityMapMode();

    public ItemPropertyEditPart(View view) {
        super((EObject)view);
    }

    public DragTracker getDragTracker(Request request) {
        if (request instanceof SelectionRequest && ((SelectionRequest)request).getLastButtonPressed() == 3) {
            return null;
        }
        return new DragEditPartsTrackerEx((EditPart)this);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ItemPropertyItemSemanticEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new MapTextNonResizableEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ListItemComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
    }

    protected void setLabelIconHelper(IFigure figure, Image icon) {
        ((ItemPropertyFigure)figure).refFigure.setIcon(icon);
    }

    public void setLabel(IFigure figure) {
        this.unregisterVisuals();
        this.setFigure(figure);
        this.registerVisuals();
        this.refreshVisuals();
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public IGraphicalEditPart getChildBySemanticHint(String semanticHint) {
        return null;
    }

    protected EObject getParserElement() {
        return this.resolveSemanticElement();
    }

    protected void refreshRefFigure() {
        Object o;
        EObject parserElement = this.getParserElement();
        if (parserElement == null) {
            return;
        }
        Image image = null;
        String text = "";
        if (parserElement instanceof ItemProperty && (o = ((ItemProperty)parserElement).getValueObject()) instanceof MdNode) {
            image = MapEditUtil.getImage((Object)o);
            text = ((MdNode)o).getName();
        }
        ((ItemPropertyFigure)this.getFigure()).refFigure.setText(text);
        ((ItemPropertyFigure)this.getFigure()).refFigure.setIcon(image);
    }

    protected String getLabelText() {
        Object text = null;
        EObject parserElement = this.getParserElement();
        if (parserElement instanceof ItemProperty) {
            text = ((ItemProperty)parserElement).getDescriptor() != null ? ((ItemProperty)parserElement).getDescriptor().getDisplayLabel() : ((ItemProperty)parserElement).getName().toString();
        }
        if (((ItemProperty)parserElement).getValue() != null) {
            text = (String)text + " : " + ((ItemProperty)parserElement).getValue();
        }
        return text;
    }

    public String getEditText() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return "";
        }
        return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.getParserElement()), this.getParserOptions().intValue());
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IParser getParser() {
        if (this.parser == null) {
            this.parser = MapParserProvider.getParser(MapElementTypes.ItemProperty_3014, this.getParserElement(), MapVisualIDRegistry.getType(3014));
        }
        return this.parser;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabel();
        this.refreshFont();
        this.refreshFontColor();
        this.refreshUnderline();
        this.refreshStrikeThrough();
    }

    protected void refreshLabel() {
        this.refreshRefFigure();
        this.refreshPropFigure();
    }

    private void refreshPropFigure() {
        EObject parserElement = this.getParserElement();
        if (parserElement instanceof ItemProperty) {
            ((ItemPropertyFigure)this.getFigure()).propFigure.setText(((ItemProperty)parserElement).getName().toString());
        }
    }

    protected void refreshUnderline() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextUnderline(style.isUnderline());
        }
    }

    protected void refreshStrikeThrough() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextStrikeThrough(style.isStrikeThrough());
        }
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            FontData fontData = new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
            this.setFont(fontData);
        }
    }

    private void refreshSelectionFeedback() {
        this.requestEditPolicyFeedbackRefresh("PrimaryDrag Policy");
        this.requestEditPolicyFeedbackRefresh("Selection Feedback");
    }

    private void requestEditPolicyFeedbackRefresh(String editPolicyKey) {
        EditPolicy editPolicy = this.getEditPolicy(editPolicyKey);
        if (editPolicy instanceof IRefreshableFeedbackEditPolicy) {
            ((IRefreshableFeedbackEditPolicy)editPolicy).refreshFeedback();
        }
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    protected void addSemanticListeners() {
        if (this.getParser() instanceof ISemanticParser) {
            EObject element = this.resolveSemanticElement();
            this.parserElements = ((ISemanticParser)this.getParser()).getSemanticElementsBeingParsed(element);
            int i = 0;
            while (i < this.parserElements.size()) {
                this.addListenerFilter("SemanticModel" + i, (NotificationListener)this, (EObject)this.parserElements.get(i));
                ++i;
            }
        } else {
            super.addSemanticListeners();
        }
    }

    protected void removeSemanticListeners() {
        if (this.parserElements != null) {
            int i = 0;
            while (i < this.parserElements.size()) {
                this.removeListenerFilter("SemanticModel" + i);
                ++i;
            }
        } else {
            super.removeSemanticListeners();
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = ((ItemPropertyFigure)ItemPropertyEditPart.this.getFigure()).propFigure.getText();
                }
            };
        }
        return this.accessibleEP;
    }

    private View getFontStyleOwnerView() {
        return this.getPrimaryView();
    }

    public Object getAdapter(Class key) {
        return super.getAdapter(key);
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.addListenerFilter("PrimaryView", (NotificationListener)this, (EObject)this.getPrimaryView());
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("PrimaryView");
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else {
            ISemanticParser modelParser;
            if (this.getParser() != null && this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue())) {
                this.refreshLabel();
            }
            if (this.getParser() instanceof ISemanticParser && (modelParser = (ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)event)) {
                this.removeSemanticListeners();
                if (this.resolveSemanticElement() != null) {
                    this.addSemanticListeners();
                }
                this.refreshLabel();
            }
        }
        super.handleNotificationEvent(event);
        if (event.getFeature() == MapPackage.eINSTANCE.getItemProperty_Value()) {
            this.refreshLabel();
        }
        if (event.getFeature() == MapPackage.eINSTANCE.getItemProperty_Name()) {
            this.refreshPropFigure();
        }
    }

    protected IFigure createFigure() {
        IFigure label = this.createFigurePrim();
        return label;
    }

    protected IFigure createFigurePrim() {
        return new ItemPropertyFigure();
    }

    public boolean isSelectable() {
        return true;
    }

    public class ItemPropertyFigure
    extends Figure
    implements IMapMode {
        private WrappingLabel propFigure = new WrappingLabel();
        private WrappingLabel refFigure = new WrappingLabel();

        public Dimension getPreferredSize(int wHint, int hHint) {
            Dimension d = super.getPreferredSize(wHint, hHint);
            return d;
        }

        public ItemPropertyFigure() {
            this.add((IFigure)this.propFigure);
            this.add((IFigure)this.refFigure);
            this.propFigure.setForegroundColor(ColorConstants.black);
            this.refFigure.setForegroundColor(ColorConstants.black);
            GridLayout gd = new GridLayout(2, false);
            gd.verticalSpacing = 0;
            gd.marginHeight = 0;
            this.setLayoutManager((LayoutManager)gd);
            this.getLayoutManager().setConstraint((IFigure)this.propFigure, (Object)new GridData(1, 1, false, false));
            this.getLayoutManager().setConstraint((IFigure)this.refFigure, (Object)new GridData(4, 1, true, false));
            ItemProperty p = (ItemProperty)ItemPropertyEditPart.this.resolveSemanticElement();
            Label tpl = new Label();
            tpl.setIcon(MapEditUtil.getTemplateImage((Template)((Template)p.getTriggerRef())));
            tpl.setText(Messages.ItemPropertyEditPart_2 + ((Template)p.getTriggerRef()).getName());
            this.setToolTip((IFigure)tpl);
            this.propFigure.setIcon(MapIconAPI.getPropertyIcon_16x16());
            this.refFigure.setIcon(MapIconAPI.getPropertyBlankIcon_16x16());
            this.propFigure.setText("");
            this.refFigure.setText("");
        }

        public int LPtoDP(int logicalUnit) {
            return ItemPropertyEditPart.this.mapMode.LPtoDP(logicalUnit);
        }

        public int DPtoLP(int deviceUnit) {
            return ItemPropertyEditPart.this.mapMode.DPtoLP(deviceUnit);
        }

        public Translatable LPtoDP(Translatable t) {
            return ItemPropertyEditPart.this.mapMode.LPtoDP(t);
        }

        public Translatable DPtoLP(Translatable t) {
            return ItemPropertyEditPart.this.mapMode.DPtoLP(t);
        }
    }
}

