/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.edit.policies;

import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.diagram.edit.policies.FeatureCompartmentCanonicalEditPolicy;
import com.indy.map.diagram.notation.mappingNotation.NodeView;
import com.indy.map.diagram.part.MapNodeDescriptor;
import com.indy.map.diagram.part.MapVisualIDRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

public class CollapsableFieldCompartmentCanonicalEditPolicy
extends FeatureCompartmentCanonicalEditPolicy {
    private EStructuralFeature fieldSelectorEnablementFeature;

    public CollapsableFieldCompartmentCanonicalEditPolicy(EStructuralFeature feature, Function<View, Boolean> isDiagramElement, Function<View, List<MapNodeDescriptor>> sementicChildrenDescriptor, EStructuralFeature fieldSelectorEnablementFeature) {
        super(feature, isDiagramElement, sementicChildrenDescriptor);
        this.fieldSelectorEnablementFeature = fieldSelectorEnablementFeature;
    }

    private List<MapNodeDescriptor> getChildDescriptors(Field field) {
        View view = (View)this.getHost().getModel();
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        IContainer modelElement = (IContainer)containerView.getElement();
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        boolean fieldSelectorEnabled = this.isFieldSelectorEnabled(modelElement);
        for (Field childElement : (List)modelElement.eGet(this.getFeatureToSynchronize())) {
            int visualID;
            if (childElement.getParent() != field || fieldSelectorEnabled && !childElement.isInView()) continue;
            boolean inView = false;
            for (Object o : containerView.getDiagram().getChildren()) {
                Field rootField;
                if (!(o instanceof NodeView) || !(((NodeView)o).getSubElement() instanceof Field) || (rootField = (Field)((NodeView)o).getSubElement()).eContainer() != modelElement) continue;
                Field f = childElement.getParent();
                while (f != null && f != rootField) {
                    f = f.getParent();
                }
                if (f != rootField) continue;
                inView = true;
                break;
            }
            if (inView || childElement.getParent() != null && childElement.hasParentCollapse() || (visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement)) != 3008) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    private boolean isFieldSelectorEnabled(IContainer container) {
        if (this.fieldSelectorEnablementFeature != null) {
            return (Boolean)container.eGet(this.fieldSelectorEnablementFeature);
        }
        return false;
    }

    public void refresh(Field field) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            this.setEnable(false);
            if (this.resolveSemanticElement() != null) {
                LinkedList createdViews = new LinkedList();
                List<MapNodeDescriptor> childDescriptors = this.getChildDescriptors(field);
                LinkedList orphaned = new LinkedList();
                LinkedList<View> knownViewChildren = new LinkedList<View>();
                for (View v : this.getViewChildren()) {
                    if (!this.isMyDiagramElement(v) || ((Field)v.getElement()).getParent() != field) continue;
                    knownViewChildren.add(v);
                }
                Iterator<MapNodeDescriptor> descriptorsIterator = childDescriptors.iterator();
                while (descriptorsIterator.hasNext()) {
                    MapNodeDescriptor next = descriptorsIterator.next();
                    String hint = MapVisualIDRegistry.getType(next.getVisualID());
                    LinkedList<View> perfectMatch = new LinkedList<View>();
                    for (View childView : this.getViewChildren()) {
                        EObject semanticElement = childView.getElement();
                        if (!next.getModelElement().equals(semanticElement) || !hint.equals(childView.getType())) continue;
                        perfectMatch.add(childView);
                    }
                    if (perfectMatch.size() <= 0) continue;
                    descriptorsIterator.remove();
                    knownViewChildren.remove(perfectMatch.getFirst());
                }
                orphaned.addAll(knownViewChildren);
                ArrayList<CreateViewRequest.ViewDescriptor> viewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>(childDescriptors.size());
                for (MapNodeDescriptor next : childDescriptors) {
                    String hint = MapVisualIDRegistry.getType(next.getVisualID());
                    CanonicalEditPolicy.CanonicalElementAdapter elementAdapter = new CanonicalEditPolicy.CanonicalElementAdapter(next.getModelElement(), hint);
                    CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, hint, -1, false, this.host().getDiagramPreferencesHint());
                    viewDescriptors.add(descriptor);
                }
                boolean changed = this.deleteViews(orphaned.iterator());
                CreateViewRequest request = this.getCreateViewRequest(viewDescriptors);
                Command cmd = this.getCreateViewCommand((CreateRequest)request);
                if (cmd != null && cmd.canExecute()) {
                    SetViewMutabilityCommand.makeMutable((IAdaptable)new EObjectAdapter((EObject)this.host().getNotationView())).execute();
                    this.executeCommand(cmd);
                    List nl = (List)request.getNewObject();
                    createdViews.addAll(nl);
                }
                if (changed || createdViews.size() > 0) {
                    this.postProcessRefreshSemantic(createdViews);
                }
                if (createdViews.size() > 1) {
                    DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
                    this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
                }
                this.makeViewsImmutable(createdViews);
            }
        }
        finally {
            this.setEnable(true);
        }
    }
}

