/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.navigator;

import com.indy.map.diagram.navigator.MapDomainNavigatorContentProvider;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.navigator.CommonViewer;

public class MapBuildDomainNavigatorContentProvider
extends MapDomainNavigatorContentProvider {
    private Logger logger = LogManager.getLogger(MapBuildDomainNavigatorContentProvider.class);

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile && "map".equals(((IFile)parentElement).getFileExtension())) {
            CommonViewer cnf;
            Viewer viewer;
            Resource resource;
            block16: {
                IFile file = (IFile)parentElement;
                URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                resource = null;
                try {
                    resource = this.getEditingDomain().getResourceSet().getResource(fileURI, true);
                    if (!resource.getURI().equals(fileURI)) {
                        resource.unload();
                        this.getEditingDomain().getResourceSet().getResources().remove((Object)resource);
                        resource = this.getEditingDomain().getResourceSet().getResource(fileURI, true);
                    }
                }
                catch (Exception ex) {
                    resource = this.getEditingDomain().getResourceSet().getResource(fileURI, false);
                    if (resource != null) break block16;
                    this.logger.error("Unable to load resource {}", (Object)fileURI, (Object)ex);
                }
            }
            if ((viewer = this.myViewer) instanceof CommonViewer && !(cnf = (CommonViewer)viewer).getNavigatorContentService().getFilterService().isActive("com.indy.gmf.map.diagram.commonFilter.builtAsChildren")) {
                URI mdUri = URIUtils.getMappingBuiltMdFile((URI)resource.getURI());
                URI procUri = URIUtils.getMappingBuiltProcFile((URI)resource.getURI());
                IFile mdFile = Util.convertEMFURIToFile((URI)mdUri);
                IFile procFile = Util.convertEMFURIToFile((URI)procUri);
                IFile mapRef = Util.convertEMFURIToFile((URI)procUri.trimFileExtension().appendFileExtension("map_ref"));
                ArrayList<Object> childs = new ArrayList<Object>();
                if (!mdFile.exists()) {
                    try {
                        mdFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        this.logger.error("failed to refresh {}", (Object)mdFile, (Object)e);
                    }
                }
                if (mdFile.exists()) {
                    childs.add(mdFile);
                }
                if (procFile.exists()) {
                    childs.add(procFile);
                }
                try {
                    mdFile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    this.logger.error("failed to refresh {}", (Object)mdFile, (Object)e);
                }
                try {
                    IResource[] iResourceArray = mdFile.getParent().members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource r = iResourceArray[n2];
                        if (r.getType() == 1 && r != mdFile && r != procFile && r != mapRef && r.getProjectRelativePath().removeFileExtension().lastSegment().startsWith(mapRef.getProjectRelativePath().removeFileExtension().lastSegment() + "-ref-") && "md".equals(r.getFileExtension())) {
                            childs.add(r);
                        }
                        ++n2;
                    }
                }
                catch (Exception ex) {
                    this.logger.error("Unexpected", (Throwable)ex);
                }
                return this.wrapEObjects(childs.toArray(new Object[childs.size()]), parentElement);
            }
        }
        return EMPTY_ARRAY;
    }
}

