/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.navigator;

import com.indy.map.Filter;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.diagram.navigator.MapNavigatorGroup;
import com.indy.map.diagram.navigator.MapNavigatorItem;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.diagram.part.MapVisualIDRegistry;
import com.indy.map.diagram.providers.MapElementTypes;
import com.indy.map.diagram.providers.MapParserProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class MapNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
ITreePathLabelProvider {
    static {
        MapDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        MapDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof MapNavigatorItem && !this.isOwnView(((MapNavigatorItem)((Object)element)).getView())) {
            return;
        }
        label.setText(this.getText(element));
        label.setImage(this.getImage(element));
    }

    public Image getImage(Object element) {
        if (element instanceof MapNavigatorGroup) {
            MapNavigatorGroup group = (MapNavigatorGroup)((Object)element);
            return MapDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
        }
        if (element instanceof MapNavigatorItem) {
            MapNavigatorItem navigatorItem = (MapNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return super.getImage(element);
            }
            return this.getImage(navigatorItem.getView());
        }
        return super.getImage(element);
    }

    public Image getImage(View view) {
        switch (MapVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return this.getImage("Navigator?Diagram?http://www.indy.com/v2/map?Map", MapElementTypes.Map_1000);
            }
            case 2001: {
                return this.getImage("Navigator?TopLevelNode?http://www.indy.com/v2/map?Query", MapElementTypes.Query_2001);
            }
            case 2002: {
                return this.getImage("Navigator?TopLevelNode?http://www.indy.com/v2/map?Filter", MapElementTypes.Filter_2002);
            }
            case 2003: {
                return this.getImage("Navigator?TopLevelNode?http://www.indy.com/v2/map?Variable", MapElementTypes.Variable_2003);
            }
            case 2004: {
                return this.getImage("Navigator?TopLevelNode?http://www.indy.com/v2/map?Datastore", MapElementTypes.Datastore_2004);
            }
            case 2005: {
                return this.getImage("Navigator?TopLevelNode?http://www.indy.com/v2/map?Join", MapElementTypes.Join_2005);
            }
            case 2007: {
                return this.getImage("Navigator?TopLevelNode?http://www.indy.com/v2/map?InputParameter", MapElementTypes.InputParameter_2007);
            }
            case 3001: {
                return this.getImage("Navigator?Node?http://www.indy.com/v2/map?SetDescriptor", MapElementTypes.SetDescriptor_3001);
            }
            case 3014: {
                return this.getImage("Navigator?Node?http://www.indy.com/v2/map?ItemProperty", MapElementTypes.ItemProperty_3014);
            }
            case 3002: {
                return this.getImage("Navigator?Node?http://www.indy.com/v2/map?QueryField", MapElementTypes.QueryField_3002);
            }
            case 3007: {
                return this.getImage("Navigator?Node?http://www.indy.com/v2/map?SetDescriptor", MapElementTypes.SetDescriptor_3007);
            }
            case 3008: {
                return this.getImage("Navigator?Node?http://www.indy.com/v2/map?Field", MapElementTypes.Field_3008);
            }
            case 3005: {
                return this.getImage("Navigator?Node?http://www.indy.com/v2/map?Constraint", MapElementTypes.Constraint_3005);
            }
            case 3012: {
                return this.getImage("Navigator?Node?http://www.indy.com/v2/map?ComputedField", MapElementTypes.ComputedField_3012);
            }
        }
        return this.getImage("Navigator?UnknownElement", null);
    }

    private Image getImage(String key, IElementType elementType) {
        ImageRegistry imageRegistry = MapDiagramEditorPlugin.getInstance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null && elementType != null && MapElementTypes.isKnownElementType(elementType)) {
            image = MapElementTypes.getImage((IAdaptable)elementType);
            imageRegistry.put(key, image);
        }
        if (image == null) {
            image = imageRegistry.get("Navigator?ImageNotFound");
            imageRegistry.put(key, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof MapNavigatorGroup) {
            MapNavigatorGroup group = (MapNavigatorGroup)((Object)element);
            return group.getGroupName();
        }
        if (element instanceof MapNavigatorItem) {
            MapNavigatorItem navigatorItem = (MapNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return null;
            }
            return this.getText(navigatorItem.getView());
        }
        return super.getText(element);
    }

    public String getText(View view) {
        if (view.getElement() != null && view.getElement().eIsProxy()) {
            return this.getUnresolvedDomainElementProxyText(view);
        }
        switch (MapVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return this.getMap_1000Text(view);
            }
            case 2001: {
                return this.getQuery_2001Text(view);
            }
            case 2002: {
                return this.getFilter_2002Text(view);
            }
            case 2003: {
                return this.getVariable_2003Text(view);
            }
            case 2004: {
                return this.getDatastore_2004Text(view);
            }
            case 2005: {
                return this.getJoin_2005Text(view);
            }
            case 2007: {
                return this.getInputParameter_2007Text(view);
            }
            case 3001: {
                return this.getSetDescriptor_3001Text(view);
            }
            case 3014: {
                return this.getItemProperty_3014Text(view);
            }
            case 3002: {
                return this.getQueryField_3002Text(view);
            }
            case 3007: {
                return this.getSetDescriptor_3007Text(view);
            }
            case 3008: {
                return this.getField_3008Text(view);
            }
            case 3005: {
                return this.getConstraint_3005Text(view);
            }
            case 3012: {
                return this.getComputedField_3012Text(view);
            }
        }
        return this.getUnknownElementText(view);
    }

    private String getMap_1000Text(View view) {
        Map domainModelElement = (Map)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        MapDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 1000");
        return "";
    }

    private String getQuery_2001Text(View view) {
        IParser parser = MapParserProvider.getParser(MapElementTypes.Query_2001, (EObject)(view.getElement() != null ? view.getElement() : view), MapVisualIDRegistry.getType(5001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        MapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5001");
        return "";
    }

    private String getFilter_2002Text(View view) {
        Filter domainModelElement = (Filter)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getId());
        }
        MapDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 2002");
        return "";
    }

    private String getVariable_2003Text(View view) {
        IParser parser = MapParserProvider.getParser(MapElementTypes.Variable_2003, (EObject)(view.getElement() != null ? view.getElement() : view), MapVisualIDRegistry.getType(5002));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        MapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5002");
        return "";
    }

    private String getDatastore_2004Text(View view) {
        IParser parser = MapParserProvider.getParser(MapElementTypes.Datastore_2004, (EObject)(view.getElement() != null ? view.getElement() : view), MapVisualIDRegistry.getType(5005));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        MapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5005");
        return "";
    }

    private String getJoin_2005Text(View view) {
        Join domainModelElement = (Join)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getId());
        }
        MapDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 2005");
        return "";
    }

    private String getInputParameter_2007Text(View view) {
        IParser parser = MapParserProvider.getParser(MapElementTypes.InputParameter_2007, (EObject)(view.getElement() != null ? view.getElement() : view), MapVisualIDRegistry.getType(5010));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        MapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5010");
        return "";
    }

    private String getSetDescriptor_3001Text(View view) {
        IParser parser = MapParserProvider.getParser(MapElementTypes.SetDescriptor_3001, (EObject)(view.getElement() != null ? view.getElement() : view), MapVisualIDRegistry.getType(3001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        MapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 3001");
        return "";
    }

    private String getItemProperty_3014Text(View view) {
        IParser parser = MapParserProvider.getParser(MapElementTypes.ItemProperty_3014, (EObject)(view.getElement() != null ? view.getElement() : view), MapVisualIDRegistry.getType(3014));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        MapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 3014");
        return "";
    }

    private String getQueryField_3002Text(View view) {
        IParser parser = MapParserProvider.getParser(MapElementTypes.QueryField_3002, (EObject)(view.getElement() != null ? view.getElement() : view), MapVisualIDRegistry.getType(3002));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        MapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 3002");
        return "";
    }

    private String getSetDescriptor_3007Text(View view) {
        IParser parser = MapParserProvider.getParser(MapElementTypes.SetDescriptor_3007, (EObject)(view.getElement() != null ? view.getElement() : view), MapVisualIDRegistry.getType(3007));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        MapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 3007");
        return "";
    }

    private String getField_3008Text(View view) {
        IParser parser = MapParserProvider.getParser(MapElementTypes.Field_3008, (EObject)(view.getElement() != null ? view.getElement() : view), MapVisualIDRegistry.getType(3008));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        MapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 3008");
        return "";
    }

    private String getConstraint_3005Text(View view) {
        IParser parser = MapParserProvider.getParser(MapElementTypes.Constraint_3005, (EObject)(view.getElement() != null ? view.getElement() : view), MapVisualIDRegistry.getType(3005));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        MapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 3005");
        return "";
    }

    private String getComputedField_3012Text(View view) {
        IParser parser = MapParserProvider.getParser(MapElementTypes.ComputedField_3012, (EObject)(view.getElement() != null ? view.getElement() : view), MapVisualIDRegistry.getType(3012));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        MapDiagramEditorPlugin.getInstance().logError("Parser was not found for label 3012");
        return "";
    }

    private String getUnknownElementText(View view) {
        return "<UnknownElement Visual_ID = " + view.getType() + ">";
    }

    private String getUnresolvedDomainElementProxyText(View view) {
        return "<Unresolved domain element Visual_ID = " + view.getType() + ">";
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    private boolean isOwnView(View view) {
        return "Map".equals(MapVisualIDRegistry.getModelID(view));
    }
}

