/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.part;

import com.indy.gmf.map.diagram.custom.edit.policies.MapDragDropEditPolicy;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.ComputedField;
import com.indy.map.Constraint;
import com.indy.map.DataSet;
import com.indy.map.Datastore;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.Filter;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.ISerde;
import com.indy.map.Inliner;
import com.indy.map.InputParameter;
import com.indy.map.ItemProperty;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.Operator;
import com.indy.map.Outliner;
import com.indy.map.Query;
import com.indy.map.QueryField;
import com.indy.map.SerdeField;
import com.indy.map.SetDescriptor;
import com.indy.map.TargetFilter;
import com.indy.map.Variable;
import com.indy.map.diagram.notation.mappingNotation.NodeView;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.diagram.part.MapLinkDescriptor;
import com.indy.map.diagram.part.MapNodeDescriptor;
import com.indy.map.diagram.part.MapVisualIDRegistry;
import com.indy.map.extension.properties.IPropertyDescriptor;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RParameter;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RVariable;
import com.indy.map.util.InheritanceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;

public class MapDiagramUpdater {
    public static List<MapNodeDescriptor> getSemanticChildren(View view) {
        switch (MapVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return MapDiagramUpdater.getMap_1000SemanticChildren(view);
            }
            case 2009: {
                return MapDiagramUpdater.getOutliner_2009SemanticChildren(view);
            }
            case 7001: {
                return MapDiagramUpdater.getQueryCompartment_7001SemanticChildren(view);
            }
            case 7002: {
                return MapDiagramUpdater.getQueryCompartment_7002SemanticChildren(view);
            }
            case 7003: {
                return MapDiagramUpdater.getDatastoreCompartment_7003SemanticChildren(view);
            }
            case 7004: {
                return MapDiagramUpdater.getDatastoreCompartment_7004SemanticChildren(view);
            }
            case 7005: {
                return MapDiagramUpdater.getDatastoreCompartment_7005SemanticChildren(view);
            }
            case 7007: {
                return MapDiagramUpdater.getDatastoreCompartment_7007SemanticChildren(view);
            }
            case 7009: {
                return MapDiagramUpdater.getDatastoreCompartment_7009SemanticChildren(view);
            }
            case 7011: {
                return MapDiagramUpdater.getQueryCompartment_7011SemanticChildren(view);
            }
            case 7091: {
                return MapDiagramUpdater.getOutlinerFieldCompartment_7091SemanticChildren(view);
            }
            case 7092: {
                return MapDiagramUpdater.getSerdeOutputCompartment7092SemanticChildren(view);
            }
            case 7093: {
                return MapDiagramUpdater.getOutlinerInputCompartment_7093SemanticChildren(view);
            }
        }
        return Collections.emptyList();
    }

    private static List<MapNodeDescriptor> getOutlinerInputCompartment_7093SemanticChildren(View view) {
        Outliner outliner;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        EObject eObject = containerView.getElement();
        if (eObject instanceof Outliner && MapVisualIDRegistry.getNodeVisualID(view, (EObject)(outliner = (Outliner)eObject).getInputField()) == 3002) {
            result.add(new MapNodeDescriptor((EObject)outliner.getInputField(), 3002));
        } else {
            EObject eObject2 = containerView.getElement();
            if (eObject2 instanceof Inliner) {
                Inliner inliner = (Inliner)eObject2;
                inliner.getInputField().stream().filter(f -> MapDiagramUpdater.isFieldVisible(inliner.isFieldSelectorEnabled(), f, containerView, (IContainer)inliner)).filter(f -> MapVisualIDRegistry.getNodeVisualID(view, (EObject)f) == 3008).forEach(f -> {
                    boolean bl = result.add(new MapNodeDescriptor((EObject)f, 3008));
                });
            }
        }
        return result;
    }

    private static List<MapNodeDescriptor> getMap_1000SemanticChildren(View view) {
        int visualID;
        if (!view.isSetElement()) {
            return Collections.emptyList();
        }
        Map modelElement = (Map)view.getElement();
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        for (Query childElement : modelElement.getQuery()) {
            int visualID2 = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID2 != 2001) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID2));
        }
        Stream<ISerde> serdeStream = Stream.concat(modelElement.getOutliner().stream(), modelElement.getInliner().stream());
        serdeStream.forEach(s -> {
            int visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)s);
            if (visualID == 2009) {
                result.add(new MapNodeDescriptor((EObject)s, visualID));
            }
        });
        for (Filter childElement : modelElement.getFilter()) {
            visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 2002) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        for (Variable childElement : modelElement.getVariable()) {
            visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 2003) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        for (Datastore childElement : modelElement.getDatastore()) {
            visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 2004) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
            if (!MapDragDropEditPolicy.supportDatastoreView()) continue;
            for (Field f : childElement.getSubsetRootField()) {
                result.add(new MapNodeDescriptor((EObject)f, "datastore.view"));
            }
        }
        for (Join childElement : modelElement.getJoin()) {
            visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 2005) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        for (Operator childElement : modelElement.getOperator()) {
            visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 2008) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        for (InputParameter childElement : modelElement.getInputParameter()) {
            visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 2007) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        for (IContainer containerElement : modelElement.getContainer()) {
            for (TargetFilter childElement : containerElement.getTargetFilter()) {
                DataSet ds = childElement.getDataSet();
                if (ds == null) {
                    result.add(new MapNodeDescriptor.TargetFilterNodeDescriptor((EObject)childElement, null));
                    continue;
                }
                RTargetSet ts = ((RMap)((Map)childElement.eContainer().eContainer()).getMapReference()).getTargetSetRef((IContainer)childElement.eContainer());
                if (ts != null) {
                    List legacy = InheritanceHelper.getDataSetLegacy((DataSet)ds);
                    HashSet<DataSet> concernedDataSets = new HashSet<DataSet>();
                    for (DataSet _d : ts.getSourceSet().getDataSet()) {
                        if (!legacy.contains(_d)) continue;
                        concernedDataSets.add(_d);
                    }
                    ArrayList toRemove = new ArrayList();
                    for (DataSet d : concernedDataSets) {
                        List l = InheritanceHelper.getDataSetHierarchy((DataSet)d);
                        l.remove(d);
                        toRemove.addAll(l);
                    }
                    concernedDataSets.removeAll(toRemove);
                    for (DataSet d : concernedDataSets) {
                        result.add(new MapNodeDescriptor.TargetFilterNodeDescriptor((EObject)childElement, (EObject)d));
                    }
                    if (!concernedDataSets.isEmpty()) continue;
                    result.add(new MapNodeDescriptor.TargetFilterNodeDescriptor((EObject)childElement, (EObject)ds));
                    continue;
                }
                result.add(new MapNodeDescriptor.TargetFilterNodeDescriptor((EObject)childElement, null));
            }
        }
        return result;
    }

    private static List<MapNodeDescriptor> getQueryCompartment_7001SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Query modelElement = (Query)containerView.getElement();
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        for (SetDescriptor childElement : modelElement.getSetDescriptor()) {
            int visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3001) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    private static List<MapNodeDescriptor> getQueryCompartment_7002SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Query modelElement = (Query)containerView.getElement();
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        for (QueryField childElement : modelElement.getField()) {
            int visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3002) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    private static List<MapNodeDescriptor> getQueryCompartment_7011SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        MapModelItem modelElement = (MapModelItem)containerView.getElement();
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        for (ItemProperty childElement : modelElement.getProperty()) {
            int visualID;
            if (childElement.getDescriptor().getType() != IPropertyDescriptor.Type.Reference || (visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement)) != 3014) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<MapNodeDescriptor> getDatastoreLabel_5007SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        ArrayList<MapNodeDescriptor> l = new ArrayList<MapNodeDescriptor>();
        l.add(new MapNodeDescriptor(view.getElement(), 5007));
        return l;
    }

    private static List<MapNodeDescriptor> getDatastoreCompartment_7003SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Datastore modelElement = (Datastore)containerView.getElement();
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        for (SetDescriptor childElement : modelElement.getSetDescriptor()) {
            int visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3007) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    private static boolean isFieldVisible(boolean fieldSelectorEnabled, Field childElement, View containerView, IContainer fieldOwner) {
        if (fieldSelectorEnabled && !childElement.isInView()) {
            return false;
        }
        boolean inView = false;
        for (Object o : containerView.getDiagram().getChildren()) {
            Field rootField;
            if (!(o instanceof NodeView) || !(((NodeView)o).getSubElement() instanceof Field) || (rootField = (Field)((NodeView)o).getSubElement()).eContainer() != fieldOwner) continue;
            Field f = childElement.getParent();
            while (f != null && f != rootField) {
                f = f.getParent();
            }
            if (f != rootField) continue;
            inView = true;
            break;
        }
        if (inView) {
            return false;
        }
        return childElement.getParent() == null || !childElement.hasParentCollapse();
    }

    private static List<MapNodeDescriptor> getDatastoreCompartment_7004SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Datastore modelElement = (Datastore)containerView.getElement();
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        for (Field childElement : modelElement.getField()) {
            int visualID;
            if (!MapDiagramUpdater.isFieldVisible(modelElement.isFieldSelectorEnabled(), childElement, containerView, (IContainer)modelElement) || (visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement)) != 3008) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    private static List<MapNodeDescriptor> getDatastoreCompartment_7005SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Datastore modelElement = (Datastore)containerView.getElement();
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        for (Constraint childElement : modelElement.getConstraint()) {
            int visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3005) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    private static List<MapNodeDescriptor> getDatastoreCompartment_7007SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        IContainer modelElement = (IContainer)containerView.getElement();
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        for (ComputedField childElement : modelElement.getComputedField()) {
            int visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3012) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<MapNodeDescriptor> getDatastoreCompartment_7009SemanticChildren(View view) {
        View containerView;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View view2 = containerView = view.getType().equals("3008") || view.getType().equals("3002") ? view : (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        MapModelItem modelElement = (MapModelItem)containerView.getElement();
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        for (ItemProperty childElement : modelElement.getProperty()) {
            if (childElement.getDescriptor().getType() != IPropertyDescriptor.Type.Reference) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, 3014));
        }
        return result;
    }

    public static List<MapLinkDescriptor> getMap_1000ContainedLinks(View view) {
        ArrayList<MapLinkDescriptor> l = new ArrayList<MapLinkDescriptor>();
        Map map = (Map)view.getElement();
        for (Filter f : map.getFilter()) {
            List sourcContainers = f.getInvolvedContainers();
            for (RSourceItem it : ((RClause)f.getMapReference()).getRealSourceRef()) {
                l.add(new MapLinkDescriptor((EObject)f, (EObject)(it instanceof RVariable || it instanceof RParameter ? it.getDataModel() : it.getDataModel().eContainer()), null, -1, sourcContainers.contains(it.getDataModel().eContainer()) ? "joinLink" : "joinDeductedLink"));
            }
        }
        for (Operator op : map.getOperator()) {
            if (op.getFilteringDataSet() == null) continue;
            l.add(new MapLinkDescriptor((EObject)op, (EObject)op.getFilteringDataSet(), null, -1, "operatorLink", null, null, (EObject)op.getFilteringDataSet()));
        }
        for (Filter f : map.getJoin()) {
            DataSet parent = null;
            ArrayList<Object> linkedObject = new ArrayList<Object>();
            if (f.getLeft() != null && f.getRight() != null && f.getLeft().getDataset() != f.getRight().getDataset()) {
                if (f.getLeft().getDataset().getParent().contains((Object)f.getRight().getDataset())) {
                    parent = f.getRight().getDataset();
                } else if (f.getLeft().getDataset().getChild().contains((Object)f.getRight().getDataset())) {
                    parent = f.getLeft().getDataset();
                }
            }
            List sourcContainers = f.getInvolvedContainers();
            for (RSourceItem it : ((RClause)f.getMapReference()).getRealSourceRef()) {
                MapModelItem obj;
                Object object = obj = it instanceof RVariable || it instanceof RParameter ? it.getDataModel() : it.getDataModel().eContainer();
                if (parent != null && !parent.getContainer().contains((Object)obj) && (obj == f.getRight() || obj == f.getLeft()) || linkedObject.contains(obj)) continue;
                l.add(new MapLinkDescriptor((EObject)f, (EObject)obj, null, -1, sourcContainers.contains(it.getDataModel().eContainer()) ? "joinLink" : "joinDeductedLink"));
                linkedObject.add(obj);
            }
            if (!(f.getRight() == null || parent != null && parent.getContainer().contains((Object)f.getRight()) || linkedObject.contains(f.getRight()))) {
                if (parent != null) {
                    l.add(new MapLinkDescriptor((EObject)f, (EObject)f.getRight(), null, -1, "inheritanceLink"));
                    linkedObject.add(f.getRight());
                } else {
                    l.add(new MapLinkDescriptor((EObject)f, (EObject)f.getRight(), null, -1, "joinLink"));
                    linkedObject.add(f.getRight());
                }
            }
            if (f.getLeft() == null || parent != null && parent.getContainer().contains((Object)f.getLeft()) || linkedObject.contains(f.getLeft())) continue;
            if (parent != null) {
                l.add(new MapLinkDescriptor((EObject)f, (EObject)f.getLeft(), null, -1, "inheritanceLink"));
                linkedObject.add(f.getLeft());
                continue;
            }
            l.add(new MapLinkDescriptor((EObject)f, (EObject)f.getLeft(), null, -1, "joinLink"));
            linkedObject.add(f.getLeft());
        }
        MultiStatus ms = new MultiStatus("com.indy.gmf.map.diagram", 2, NLS.bind((String)Messages.MapDiagramUpdater_2, (Object)map.eResource().getURI().toPlatformString(true)), null);
        for (IContainer c : map.getContainer()) {
            HashSet<DataSet> sourcesDatasets = new HashSet<DataSet>();
            boolean isMapped = false;
            boolean hasView = c instanceof Datastore && !((Datastore)c).getSubsetRootField().isEmpty();
            HashMap<SetDescriptor, Object> descriptors = new HashMap<SetDescriptor, Object>();
            HashMap setDescriptorSourceDataset = new HashMap();
            for (SetDescriptor d : c.getSetDescriptor()) {
                setDescriptorSourceDataset.put(d, new HashSet());
                ArrayList targetSetLinkDescriptors = new ArrayList();
                descriptors.put(d, targetSetLinkDescriptors);
                for (ILogicalField f : c.getLogicalField()) {
                    Expression e2 = f.getExpression(d);
                    if (e2 == null || e2.getExpression() == null || e2.getExpression().trim().isEmpty()) continue;
                    isMapped = true;
                    for (RSourceItem i : ((RExpression)e2.getMapReference()).getSourceRef()) {
                        if (i instanceof RVariable || i instanceof RParameter) {
                            l.add(new MapLinkDescriptor((EObject)c, (EObject)i.getDataModel(), null, -1, "targetLink", (EObject)f, (EObject)i.getDataModel(), null));
                            continue;
                        }
                        if (!(i instanceof RLogicalField) || (IContainer)i.getDataModel().eContainer() == null || (IContainer)i.getDataModel().eContainer() == e2.eContainer().eContainer()) continue;
                        ((Set)setDescriptorSourceDataset.get(d)).add(((IContainer)i.getDataModel().eContainer()).getDataset());
                        sourcesDatasets.add(((IContainer)i.getDataModel().eContainer()).getDataset());
                        l.add(new MapLinkDescriptor((EObject)c, i.getDataModel().eContainer(), null, -1, "targetLink", (EObject)f, (EObject)i.getDataModel(), (EObject)e2.getSetDescriptorRef()));
                        targetSetLinkDescriptors.add(new MapLinkDescriptor((EObject)c, null, null, -1, "targetSetLink", (EObject)f, (EObject)i.getDataModel(), (EObject)e2.getSetDescriptorRef()));
                    }
                }
            }
            if (isMapped) {
                if (!hasView) {
                    ArrayList<Object> toRemove = new ArrayList<Object>();
                    for (DataSet ds : sourcesDatasets) {
                        if (ds == null) {
                            toRemove.add(ds);
                            continue;
                        }
                        for (DataSet p : ds.getParent()) {
                            ArrayList parentToExplcure = new ArrayList(InheritanceHelper.getDataSetHierarchy((DataSet)p));
                            for (SetDescriptor d : setDescriptorSourceDataset.keySet()) {
                                if (((Set)setDescriptorSourceDataset.get(d)).size() != 1) continue;
                                parentToExplcure.removeAll((Collection)setDescriptorSourceDataset.get(d));
                            }
                            toRemove.addAll(parentToExplcure);
                        }
                    }
                    sourcesDatasets.removeAll(toRemove);
                }
                for (DataSet ds : sourcesDatasets) {
                    if (ds == null) continue;
                    l.add(new MapLinkDescriptor((EObject)c, (EObject)ds, null, -1, "targetDataSetLink", null, null, (EObject)ds));
                }
                for (TargetFilter f : c.getTargetFilter()) {
                    DataSet ds = f.getDataSet();
                    if (ds == null) {
                        l.add(new MapLinkDescriptor((EObject)f, (EObject)c, null, -1, "joinLink"));
                        continue;
                    }
                    RTargetSet ts = ((RMap)((Map)f.eContainer().eContainer()).getMapReference()).getTargetSetRef((IContainer)f.eContainer());
                    if (ts != null) {
                        List legacy = InheritanceHelper.getDataSetLegacy((DataSet)ds);
                        HashSet<DataSet> concernedDataSets = new HashSet<DataSet>();
                        for (DataSet _d : ts.getSourceSet().getDataSet()) {
                            if (!legacy.contains(_d)) continue;
                            concernedDataSets.add(_d);
                        }
                        ArrayList dataSetstoRemove = new ArrayList();
                        for (DataSet d : concernedDataSets) {
                            InheritanceHelper.getDataSetHierarchy((DataSet)d).stream().filter(e -> e != d).forEach(e -> {
                                boolean bl = dataSetstoRemove.add(d);
                            });
                        }
                        concernedDataSets.removeAll(dataSetstoRemove);
                        for (DataSet d : concernedDataSets) {
                            l.add(new MapLinkDescriptor((EObject)f, (EObject)c, null, -1, "joinLink", null, null, (EObject)d));
                        }
                        if (!concernedDataSets.isEmpty()) continue;
                        l.add(new MapLinkDescriptor((EObject)f, (EObject)c, null, -1, "joinLink", null, null, (EObject)ds));
                        continue;
                    }
                    l.add(new MapLinkDescriptor((EObject)f, (EObject)c, null, -1, "joinLink"));
                }
            }
            l.addAll(descriptors.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).toList());
        }
        if (ms.getChildren().length > 0) {
            MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)ms);
        }
        return l;
    }

    private static List<MapNodeDescriptor> getOutlinerFieldCompartment_7091SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        ISerde modelElement = (ISerde)containerView.getElement();
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        for (SerdeField childElement : modelElement.getField()) {
            int visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3009) continue;
            result.add(new MapNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    private static List<MapNodeDescriptor> getSerdeOutputCompartment7092SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        EObject eObject = containerView.getElement();
        if (eObject instanceof Outliner) {
            Outliner outliner = (Outliner)eObject;
            outliner.getOutputField().stream().filter(f -> MapDiagramUpdater.isFieldVisible(outliner.isFieldSelectorEnabled(), f, containerView, (IContainer)outliner)).filter(f -> MapVisualIDRegistry.getNodeVisualID(view, (EObject)f) == 3008).forEach(f -> {
                boolean bl = result.add(new MapNodeDescriptor((EObject)f, 3008));
            });
        } else {
            Inliner inliner;
            EObject eObject2 = containerView.getElement();
            if (eObject2 instanceof Inliner && MapVisualIDRegistry.getNodeVisualID(view, (EObject)(inliner = (Inliner)eObject2).getOutputField()) == 3002) {
                result.add(new MapNodeDescriptor((EObject)inliner.getOutputField(), 3002));
            }
        }
        return result;
    }

    private static List<MapNodeDescriptor> getOutliner_2009SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Outliner modelElement = (Outliner)containerView.getElement();
        LinkedList<MapNodeDescriptor> result = new LinkedList<MapNodeDescriptor>();
        int visualID = MapVisualIDRegistry.getNodeVisualID(view, (EObject)modelElement.getInputField());
        if (visualID == 3002) {
            result.add(new MapNodeDescriptor((EObject)modelElement.getInputField(), visualID));
        }
        return result;
    }
}

