/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.text.editor.views.parsing;

import com.semarchy.xdi.designer.core.CodeCapability;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.navigator.CommonViewer;

public class MdVariableHyperlinkDetector
extends AbstractHyperlinkDetector {
    private CodeCapability codeCapability;

    public MdVariableHyperlinkDetector(CodeCapability codeCapability) {
        this.codeCapability = codeCapability;
    }

    public IHyperlink[] detectHyperlinks(final ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        int offsetInLine;
        String line;
        IRegion lineInfo;
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        int offset = region.getOffset();
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
        final TreeMap<String, Region> hyperLinkRegions = new TreeMap<String, Region>();
        ArrayList<Region> variableRegions = new ArrayList<Region>();
        final HashMap<Region, URI> udfDefinitions = new HashMap<Region, URI>();
        int i = offsetInLine = offset - lineInfo.getOffset();
        while (i >= 0) {
            if (i < line.length() && line.charAt(i) == '{') {
                String block;
                if (i - 1 >= 0 && line.charAt(i - 1) == '%') {
                    try {
                        block = line.substring(i - 1, line.indexOf("}%", i - 1) + 2);
                        hyperLinkRegions.put(block.substring(2, block.length() - 2), new Region(offset - offsetInLine + i - 1, block.length()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                if (i - 1 >= 0 && line.charAt(i - 1) == '$') {
                    try {
                        block = line.substring(i - 1, line.indexOf("}$", i - 1) + 2);
                        variableRegions.add(new Region(offset - offsetInLine + i - 1, block.length()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
            --i;
        }
        Iterator it = ((ISourceViewer)textViewer).getAnnotationModel().getAnnotationIterator();
        while (it.hasNext()) {
            Position position;
            Annotation a = (Annotation)it.next();
            if (!"UDF".equals(a.getType()) || !(position = ((ISourceViewer)textViewer).getAnnotationModel().getPosition(a)).overlapsWith(region.getOffset(), region.getLength())) continue;
            udfDefinitions.put(new Region(position.getOffset(), position.getLength()), URI.createURI((String)a.getText()));
        }
        if (hyperLinkRegions.isEmpty() && variableRegions.isEmpty() && udfDefinitions.isEmpty()) {
            return null;
        }
        int count = 0;
        IHyperlink[] rs = new IHyperlink[hyperLinkRegions.size() + variableRegions.size() + udfDefinitions.size()];
        for (final String string : hyperLinkRegions.keySet()) {
            rs[count++] = new IHyperlink(){
                String varName;
                {
                    this.varName = string2;
                }

                public void open() {
                    CodeCapability.MdVariableResolver resolver = (CodeCapability.MdVariableResolver)MdVariableHyperlinkDetector.this.codeCapability.getAdapter(CodeCapability.MdVariableResolver.class);
                    try {
                        switch (resolver.getMode(this.varName)) {
                            case ENVRIONEMENT: {
                                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)textViewer.getTextWidget().getShell(), (String)"com.indy.ui.custom.out.StringVariablePreferencePage", (String[])new String[]{"com.indy.ui.custom.out.StringVariablePreferencePage"}, null);
                                dialog.open();
                                break;
                            }
                            case MD_LINK: {
                                EObject targetEObject = resolver.getResolvedTarget(this.varName);
                                if (targetEObject == null) break;
                                try {
                                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new URIEditorInput(EcoreUtil.getURI((EObject)targetEObject)), "com.stambia.md.presentation.MdEditorID");
                                    break;
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }

                private void showInProjectExplorer(EObject targetEObject) {
                    IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
                    CommonViewer viewer = (CommonViewer)view.getAdapter(CommonViewer.class);
                    IStructuredSelection newSelection = (IStructuredSelection)Platform.getAdapterManager().getAdapter((Object)targetEObject, StructuredSelection.class);
                    if (!newSelection.isEmpty()) {
                        HashSet<Object> newExpandedElements = new HashSet<Object>();
                        newExpandedElements.addAll(newSelection.toList());
                        Object[] objectArray = viewer.getExpandedElements();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            newExpandedElements.add(o);
                            ++n2;
                        }
                        if (!newExpandedElements.isEmpty()) {
                            viewer.setExpandedElements(newExpandedElements.toArray(new Object[newExpandedElements.size()]));
                            List list = newSelection.toList();
                            Collections.sort(list, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    if (o1 instanceof IResource) {
                                        if (o2 instanceof IResource) {
                                            return ((IResource)o1).getFullPath().toString().compareTo(((IResource)o2).getFullPath().toString());
                                        }
                                        return -1;
                                    }
                                    if (o2 instanceof IResource) {
                                        return 1;
                                    }
                                    return 0;
                                }
                            });
                            viewer.setSelection((ISelection)new StructuredSelection(list.get(list.size() - 1)), true);
                        }
                    }
                }

                public String getTypeLabel() {
                    return this.varName;
                }

                public String getHyperlinkText() {
                    return this.varName;
                }

                public IRegion getHyperlinkRegion() {
                    return (IRegion)hyperLinkRegions.get(string);
                }
            };
        }
        for (final IRegion iRegion : variableRegions) {
            rs[count++] = new IHyperlink(){

                public void open() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/com.indy.ui.help/html/seidg/Working-with-Variables.html?cp=3_5_9_0_1#UsingMetadataVariablesinProcess");
                }

                public String getTypeLabel() {
                    return null;
                }

                public String getHyperlinkText() {
                    return null;
                }

                public IRegion getHyperlinkRegion() {
                    return iRegion;
                }
            };
        }
        for (final IRegion iRegion : udfDefinitions.keySet()) {
            rs[count++] = new IHyperlink(){

                public void open() {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new URIEditorInput((URI)udfDefinitions.get(iRegion)), "com.stambia.md.presentation.MdEditorID");
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }

                public String getTypeLabel() {
                    return null;
                }

                public String getHyperlinkText() {
                    return null;
                }

                public IRegion getHyperlinkRegion() {
                    return iRegion;
                }
            };
        }
        return rs;
    }
}

