/*
 * Decompiled with CFR 0.152.
 */
package com.indy.product.actions;

import com.indy.administration.AdministrationHelper;
import com.indy.emf.uri.CacheUtil;
import com.indy.emf.uri.StatusListener;
import com.indy.emf.uri.ValidationStatus;
import com.indy.emf.uri.validation2.Validation;
import com.indy.product.actions.Messages;
import com.indy.ui.custom.out.Activator;
import com.semarchy.xdi.designer.core.services.IComponentService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.ui.licence.manager.tools.composite.HostSessionComposite;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AboutDlg
extends Dialog {
    private static String CHECK;
    private static String UNCHECK;
    private LicenceComposite comp;
    FormToolkit tk = null;
    StatusListener statusListener = new StatusListener(){

        public void statusChanged(ValidationStatus status) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    (this).AboutDlg.this.comp.handlekeyChange();
                }
            });
        }
    };

    static {
        try {
            UNCHECK = new String(new byte[]{-30, -104, -112}, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            CHECK = new String(new byte[]{-30, -104, -111}, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public AboutDlg(Shell parentShell) {
        super(parentShell);
        this.tk = new FormToolkit(parentShell.getDisplay());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.licensePopup_text);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AboutDlg.this.tk.dispose();
                AboutDlg.this.tk = null;
            }
        });
        this.tk.setBackground(parent.getShell().getDisplay().getSystemColor(1));
        this.tk.adapt(parentComposite);
        parentComposite.setLayout((Layout)new FillLayout());
        TabFolder tabFolder = new TabFolder(parentComposite, 0);
        tabFolder.setLayout((Layout)new GridLayout());
        this.tk.adapt((Composite)tabFolder);
        TabItem licenceIt = new TabItem(tabFolder, 0);
        licenceIt.setText(Messages.AboutDlg_license_folder);
        this.comp = new LicenceComposite((Composite)tabFolder, 2048);
        this.tk.adapt((Composite)this.comp);
        licenceIt.setControl((Control)this.comp);
        this.createComponents(tabFolder);
        tabFolder.setSelection(0);
        this.comp.handlekeyChange();
        return parentComposite;
    }

    private void createComponents(TabFolder folder) {
        final TabItem componentsIt = new TabItem(folder, 0);
        componentsIt.setText(Messages.AboutDlg_component_folder);
        Composite c = new Composite((Composite)folder, 0);
        c.setLayout((Layout)new FillLayout());
        final TableViewer v = new TableViewer(c, 68352);
        v.setContentProvider((IContentProvider)new ArrayContentProvider());
        v.getTable().setHeaderVisible(true);
        TableViewerColumn col = new TableViewerColumn(v, 16384);
        col.getColumn().setText(Messages.AboutDlg_column_component_name);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ComponentInfo)element).componentLabel;
            }

            public Color getForeground(Object element) {
                if (((ComponentInfo)element).granted) {
                    return Activator.getDefault().getColor(0, 0, 0);
                }
                return Activator.getDefault().getColor(128, 128, 128);
            }
        });
        col = new TableViewerColumn(v, 0x1000000);
        col.getColumn().setText(Messages.AboutDlg_column_component_grant);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((ComponentInfo)element).granted) {
                    return CHECK;
                }
                return UNCHECK;
            }
        });
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item == componentsIt && v.getInput() == null) {
                    IComponentService s = (IComponentService)E4InjectorHelper.getService(IComponentService.class);
                    List l = s.getComponents().stream().map(c -> new ComponentInfo(c.getLabel(), c.getLicensePermission() != null, AdministrationHelper.componentAuthorized((IComponentService.IComponent)c))).sorted(Comparator.comparing(ComponentInfo::getLabel)).collect(Collectors.toList());
                    l.add(new ComponentInfo(Messages.AboutDlg_featureSchedulerLabel, true, AdministrationHelper.supportScheduler()));
                    l.add(new ComponentInfo(Messages.AboutDlg_featureWebServicePublicationLabel, true, AdministrationHelper.supportWebServicePublication()));
                    l.add(new ComponentInfo(Messages.AboutDlg_featureRuntimeSelectionLabel, true, AdministrationHelper.supportRuntimeSelection()));
                    l.add(new ComponentInfo(Messages.AboutDlg_featureIndexTechInWkspLabel, true, AdministrationHelper.supportTechModelFromWorkspace()));
                    l.sort(Comparator.comparing(ComponentInfo::getLabel));
                    v.setInput(l);
                    Table table = v.getTable();
                    int i = 0;
                    int n = table.getColumnCount();
                    while (i < n) {
                        table.getColumn(i).pack();
                        ++i;
                    }
                }
            }
        });
        componentsIt.setControl((Control)c);
    }

    public int open() {
        CacheUtil.addStatusListener((StatusListener)this.statusListener);
        int ret = super.open();
        CacheUtil.removeStatusListener((StatusListener)this.statusListener);
        return ret;
    }

    protected Point getInitialSize() {
        return new Point(510, 515);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    private class ComponentInfo {
        String componentLabel;
        boolean underLicense;
        boolean granted;

        public ComponentInfo(String componentLabel, boolean underlicence, boolean granted) {
            this.componentLabel = componentLabel;
            this.granted = granted;
            this.underLicense = underlicence;
        }

        String getLabel() {
            return this.componentLabel;
        }
    }

    class LicenceComposite
    extends Composite {
        private Text expirationDate;
        private Text macAdress;
        private Text licenseMode;
        private Text status;
        private Text licenseServerURL;
        private Text group;
        private HostSessionComposite hsc;
        SimpleDateFormat formatter;
        SimpleDateFormat hourFormatter;
        String groupAddress;

        protected void handlekeyChange() {
            CacheUtil.LicenseInformations i = CacheUtil.getLicenseInformations();
            Date _date = i.getExpirationDate();
            if (_date == null) {
                this.expirationDate.setText(Messages.AboutDlg_NoExpirationDate);
            } else {
                LocalDate localDate = Instant.ofEpochMilli(_date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
                String formattedDate = localDate.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG));
                this.expirationDate.setText(formattedDate);
            }
            this.macAdress.setText(i.getMacAddressesToDisplay() == null ? Messages.AboutDlg_NoMacAdress : i.getMacAddressesToDisplay());
            try {
                if (i.getLicenseMode() != null) {
                    this.licenseMode.setText(i.getLicenseMode().getLabel());
                    this.hsc.setVisible(i.getLicenseMode() != Validation.Mode.TRIAL && i.getLicenseMode() != Validation.Mode.OFFLINE);
                    this.licenseServerURL.setText(i.getLicenseServerURL());
                    this.group.setText(i.getGroup());
                    this.status.setText(i.getStatus());
                    this.groupAddress = i.getLicenseServerURL();
                    if (this.groupAddress != null) {
                        if (!this.groupAddress.endsWith("/")) {
                            this.groupAddress = String.valueOf(this.groupAddress) + "/";
                        }
                        this.groupAddress = String.valueOf(this.groupAddress) + "api/2/";
                        if (!i.getGroup().isEmpty()) {
                            this.groupAddress = String.valueOf(this.groupAddress) + i.getGroup();
                        }
                    }
                }
            }
            catch (Exception exception) {}
        }

        LicenceComposite(Composite parent, int style) {
            super(parent, style);
            this.formatter = new SimpleDateFormat("yyyyMMdd");
            this.hourFormatter = new SimpleDateFormat("mm:ss");
            this.groupAddress = "";
            LicenceComposite cmp = this;
            AboutDlg.this.tk.adapt((Composite)cmp);
            GridLayout lay = new GridLayout();
            lay.numColumns = 2;
            cmp.setLayout((Layout)lay);
            Label l = new Label((Composite)cmp, 0);
            l.setText(Messages.AboutDlg_LicenseMode);
            l.setBackground(parent.getBackground());
            this.licenseMode = new Text((Composite)cmp, 8);
            this.licenseMode.setBackground(parent.getBackground());
            this.licenseMode.setLayoutData((Object)new GridData(4, 1, true, false));
            l = new Label((Composite)cmp, 0);
            l.setText(Messages.AboutDlg_MacAddress);
            l.setBackground(parent.getBackground());
            this.macAdress = new Text((Composite)cmp, 8);
            this.macAdress.setBackground(parent.getBackground());
            this.macAdress.setLayoutData((Object)new GridData(4, 1, true, false));
            l = new Label((Composite)cmp, 0);
            l.setText(Messages.AboutDlg_Group);
            l.setBackground(parent.getBackground());
            this.group = new Text((Composite)cmp, 8);
            this.group.setBackground(parent.getBackground());
            this.group.setLayoutData((Object)new GridData(4, 1, true, false));
            l = new Label((Composite)cmp, 0);
            l.setText(Messages.AboutDlg_ExpirationDate);
            l.setBackground(parent.getBackground());
            this.expirationDate = new Text((Composite)cmp, 8);
            this.expirationDate.setBackground(parent.getBackground());
            this.expirationDate.setLayoutData((Object)new GridData(4, 1, true, false));
            l = new Label((Composite)cmp, 0);
            l.setText(Messages.AboutDlg_serverUrl);
            l.setBackground(parent.getBackground());
            this.licenseServerURL = new Text((Composite)cmp, 8);
            this.licenseServerURL.setBackground(parent.getBackground());
            this.licenseServerURL.setLayoutData((Object)new GridData(4, 1, true, false));
            l = new Label((Composite)cmp, 0);
            l.setText(Messages.AboutDlg_status);
            l.setBackground(parent.getBackground());
            this.status = new Text((Composite)cmp, 8);
            this.status.setBackground(parent.getBackground());
            this.status.setLayoutData((Object)new GridData(4, 1, true, false));
            this.handlekeyChange();
            Button b = new Button((Composite)cmp, 8);
            b.setText(Messages.AboutDlg_register);
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CacheUtil.checkLicense();
                }
            });
            l = new Label((Composite)cmp, 0);
            l.setText("");
            l.setBackground(parent.getBackground());
            this.hsc = new HostSessionComposite(cmp, 64, true){

                public String getAdress() {
                    return LicenceComposite.this.groupAddress;
                }

                public void handleRefreshEnvt() {
                }
            };
            AboutDlg.this.tk.adapt((Composite)this.hsc);
            GridData gd = new GridData(1812);
            this.hsc.setLayoutData((Object)gd);
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            this.hsc.setVisible(false);
        }
    }
}

