/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.SignatureVerifier;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.jgit.util.StringUtils;

public final class SignatureUtils {
    private SignatureUtils() {
    }

    public static String toString(SignatureVerifier.SignatureVerification verification, PersonIdent creator, GitDateFormatter formatter) {
        StringBuilder result = new StringBuilder();
        PersonIdent dateId = new PersonIdent(creator, verification.creationDate());
        result.append(MessageFormat.format(JGitText.get().verifySignatureMade, formatter.formatDate(dateId)));
        result.append('\n');
        result.append(MessageFormat.format(JGitText.get().verifySignatureKey, verification.keyFingerprint().toUpperCase(Locale.ROOT)));
        result.append('\n');
        if (!StringUtils.isEmptyOrNull(verification.signer())) {
            result.append(MessageFormat.format(JGitText.get().verifySignatureIssuer, verification.signer()));
            result.append('\n');
        }
        String msg = verification.verified() ? (verification.expired() ? JGitText.get().verifySignatureExpired : JGitText.get().verifySignatureGood) : JGitText.get().verifySignatureBad;
        result.append(MessageFormat.format(msg, verification.keyUser()));
        if (!SignatureVerifier.TrustLevel.UNKNOWN.equals((Object)verification.trustLevel())) {
            result.append(" " + MessageFormat.format(JGitText.get().verifySignatureTrust, verification.trustLevel().name().toLowerCase(Locale.ROOT)));
        }
        result.append('\n');
        msg = verification.message();
        if (!StringUtils.isEmptyOrNull(msg)) {
            result.append(msg);
            result.append('\n');
        }
        return result.toString();
    }
}

