/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ResourceLoaderUtil {
    private static final ClassLoader CLASSLOADER = ResourceLoaderUtil.class.getClassLoader();

    public static String readTextContent(InputStream stream) {
        try {
            return ResourceLoaderUtil.readTextContentChecked(stream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read: ");
        }
    }

    private static String readTextContentChecked(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Not found: ");
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            String string = ResourceLoaderUtil.readLines(reader);
            return string;
        }
        finally {
            stream.close();
        }
    }

    private static String readLines(BufferedReader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        String line = reader.readLine();
        while (line != null) {
            builder.append(line);
            builder.append('\n');
            line = reader.readLine();
        }
        return builder.toString();
    }
}

