/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management;

import com.indy.administration.AdministrationHelper;
import com.indy.engine.core.IDecryptService;
import com.indy.engine.core.IJsonUtils;
import com.indy.engine.core.ISecretService;
import com.indy.engine.core.IXmlUtils;
import com.indy.engine.core.UtilsService;
import com.indy.engine.core.module.IModuleService;
import com.indy.engine.core.module.classloader.StambiaClassLoaderRegistry;
import com.indy.engine.core.module.configuration.RuntimeConfiguration;
import com.indy.engine.core.module.impl.ModuleServiceImpl;
import com.indy.libraries.management.Messages;
import com.indy.libraries.management.ModuleInstallationInfo;
import com.indy.osgihook.utils.HookHelper;
import com.indy.osgihook.utils.JavaProps;
import com.indy.osgihook.utils.StambiaEnvironmentPropertyReader;
import com.semarchy.xdi.designer.core.services.IBaseModuleProvider;
import com.semarchy.xdi.designer.core.services.IComponentService;
import com.semarchy.xdi.designer.core.services.IModuleClassLoaderProvider;
import com.semarchy.xdi.designer.core.utils.RuntimeLocationHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={IModuleService.class, IModuleClassLoaderProvider.class, IBaseModuleProvider.class}, scope=ServiceScope.SINGLETON, immediate=true)
public class ModuleServiceComponent
extends ModuleServiceImpl
implements IModuleClassLoaderProvider,
IBaseModuleProvider {
    private static final String BASE_MODULE_FILE_NAME = "module_descriptor.properties";
    private static final String EXTENSION_FILE_NAME = "extension_descriptor.properties";
    private static final String P_BASE_MODULE_LABEL = "baseModule.label";
    private static final String P_BASE_MODULE_BUNDLE_EXTRACT = "baseModule.bundleExtract";
    private static final String P_EXTENSION_BUNDLE_EXTRACT = "baseModule.extension.bundleExtract";
    private static final String P_EXTENSION_LABEL = "baseModule.extension.label";
    private static final String P_EXTENSION_EXTENDED_BASEMODULE_ID = "baseModule.extension.baseModule.id";
    private static final String P_EXTENSION_IS_FULL = "baseModule.extension.full";
    private static final String P_BASE_MODULE_IS_FULL = "baseModule.full";
    EnvironmentInfo info;
    private BundleContext ctx;
    private ResolvedBundleListener bundleListener = new ResolvedBundleListener();
    private HashMap<String, URL> _tmpGeneratedBundles = new HashMap();
    private File tmpBundleExtractionFolder = null;
    private Map<ClassLoader, Map<String, ClassLoader>> classLoaders = new HashMap<ClassLoader, Map<String, ClassLoader>>();
    private List<IModuleService.IBaseModule> cachedModulesBase = null;
    private Map<String, IModuleService.IBaseModule> cachedModulesBaseMap = null;
    private List<IModuleService.IBaseModuleExtension> cachedModulesextensions = null;
    private Map<String, List<IModuleService.IBaseModuleExtension>> cachedModuleExtensionPerMap = null;
    @Reference
    private IComponentService componentService;
    @Reference
    private IWorkspace workspace;
    private Map<String, Version> versionByBundleNameToDeploy = new HashMap<String, Version>();

    @Reference(service=EnvironmentInfo.class, policy=ReferencePolicy.STATIC, unbind="unbind")
    public void bind(EnvironmentInfo info) {
        this.info = info;
    }

    public void unbind(EnvironmentInfo info) {
        info = null;
    }

    protected File getRuntimeLocation() {
        return RuntimeLocationHelper.getRuntimeLocation();
    }

    protected String getModuleFolderPath() {
        Object s = StambiaEnvironmentPropertyReader.readProperty((String)"xdi.designer.module.path.v1", (EnvironmentInfo)this.info);
        if (s == null || ((String)s).isEmpty()) {
            s = RuntimeLocationHelper.getRuntimeLocation().getAbsolutePath();
            if (!((String)s).endsWith(File.separator)) {
                s = (String)s + File.separator;
            }
            s = (String)s + "modules";
        }
        return s;
    }

    protected boolean startModuleWatcherOnInit() {
        return false;
    }

    @Activate
    public void activate(BundleContext context) throws Exception {
        this.getLogger().info("activating component " + ((Object)((Object)this)).getClass().getSimpleName());
        context.addBundleListener((BundleListener)this.bundleListener);
        this.ctx = context;
        try {
            StambiaClassLoaderRegistry.INSTANCE.init(null);
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "fail to call StambiaClassLoaderRegistry.init", e);
        }
        this.init(RuntimeConfiguration.ModuleRefreshMode.dynamic);
        HashMap<Class, ClassLoader> clPerServiceClass = new HashMap<Class, ClassLoader>();
        ClassLoader engineCommonCl = ((BundleWiring)Platform.getBundle((String)"com.indy.engine.common").adapt(BundleWiring.class)).getClassLoader();
        ClassLoader engineCl = ((BundleWiring)Platform.getBundle((String)"com.indy.engine").adapt(BundleWiring.class)).getClassLoader();
        clPerServiceClass.put(IXmlUtils.class, engineCommonCl);
        clPerServiceClass.put(IJsonUtils.class, engineCommonCl);
        clPerServiceClass.put(ISecretService.class, engineCommonCl);
        clPerServiceClass.put(IDecryptService.class, engineCl);
        UtilsService.initUtils(clPerServiceClass);
        HashMap<IModuleService.IModule, IModuleService.IModuleInstallationInfo> updateInfo = new HashMap<IModuleService.IModule, IModuleService.IModuleInstallationInfo>();
        HashMap<String, IModuleService.IBaseModule> baseModuleMap = new HashMap<String, IModuleService.IBaseModule>();
        HashMap<String, IModuleService.IBaseModuleExtension> extensionModuleMap = new HashMap<String, IModuleService.IBaseModuleExtension>();
        for (IModuleService.IBaseModule iBaseModule : this.internalGetBaseModules()) {
            baseModuleMap.put(iBaseModule.getInfo().getId(), iBaseModule);
        }
        for (IModuleService.IBaseModuleExtension iBaseModuleExtension : this.getBaseModuleExtensions()) {
            extensionModuleMap.put(iBaseModuleExtension.getInfo().getId(), iBaseModuleExtension);
        }
        for (IModuleService.IModule iModule : this.internalGetModules()) {
            if (iModule.getName().equalsIgnoreCase("internal") || iModule.getName().equalsIgnoreCase("core") || this.isDevModule(iModule)) continue;
            try {
                boolean needUpdate;
                IModuleService.IBaseModuleInfo currentBaseModuleInfo;
                IModuleService.IBaseModule baseModule;
                IModuleService.IModuleDescriptor desc = iModule.getDescriptor();
                if (desc == null || (baseModule = (IModuleService.IBaseModule)baseModuleMap.get((currentBaseModuleInfo = desc.getBaseModuleInfo()).getId())) == null) continue;
                IModuleService.IBaseModuleExtension extension = desc.getBaseModuleExtensionInfo() == null ? null : (IModuleService.IBaseModuleExtension)extensionModuleMap.get(desc.getBaseModuleExtensionInfo().getId());
                boolean extensionRemoved = desc.getBaseModuleExtensionInfo() != null && extension == null;
                boolean bl = needUpdate = !extensionRemoved;
                if (needUpdate) {
                    try {
                        updateInfo.put(iModule, this.createIntaller(baseModule, extension, null));
                    }
                    catch (Exception ex) {
                        this.getLogger().log(Level.WARNING, Messages.ModuleServiceComponent_21 + iModule.getName(), ex);
                    }
                    continue;
                }
                String warningMessage = String.format(Messages.ModuleServiceComponent_22, iModule.getName());
                this.getLogger().log(Level.WARNING, warningMessage);
            }
            catch (Throwable t) {
                this.getLogger().log(Level.WARNING, "Unexpected error", t);
            }
        }
        try {
            if (this.getModule("default") == null) {
                IModuleService.IModuleInstallationInfo iModuleInstallationInfo = this.createIntaller((IModuleService.IBaseModule)baseModuleMap.get("com.indy.baseModule.default"), null, null);
                this.createModule("default", iModuleInstallationInfo);
            }
        }
        catch (Throwable throwable) {
            this.getLogger().log(Level.WARNING, "Unexpected error", throwable);
        }
        for (IModuleService.IModule iModule : updateInfo.keySet()) {
            try {
                this.removeModule(iModule.getName());
                this.createModule(iModule.getName(), (IModuleService.IModuleInstallationInfo)updateInfo.get(iModule));
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                this.getLogger().log(Level.WARNING, String.format("Failed to upgrade the module %s", iModule.getName()), ex);
            }
        }
        if (Boolean.valueOf(StambiaEnvironmentPropertyReader.readProperty((JavaProps)JavaProps.MODULES_AUTOMATIC_CREATION, (EnvironmentInfo)this.info)).booleanValue()) {
            baseModuleMap.values().stream().filter(b -> b.isFull() && this.getModule(b.getLabel()) == null).forEach(b -> this.installDefaultModule((IModuleService.IBaseModule)b));
        }
        this.watchModules(new File(this.getModuleFolderPath()).toPath());
    }

    private void installDefaultModule(IModuleService.IBaseModule baseModule) {
        try {
            this.getLogger().info(String.format("Installing module %s", baseModule.getLabel()));
            IModuleService.IModuleInstallationInfo installer = this.createIntaller(baseModule, null, Collections.EMPTY_LIST);
            this.createModule(baseModule.getLabel(), installer);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.INFO, String.format("Failed to install module %s", baseModule.getLabel()), ex);
        }
    }

    @Deactivate
    public void deactivate(BundleContext context) {
        context.removeBundleListener((BundleListener)this.bundleListener);
        StambiaClassLoaderRegistry.INSTANCE.release();
        this.ctx = null;
    }

    public ClassLoader getClassLoader(ClassLoader parent, String moduleName, IModuleClassLoaderProvider.ClassLoaderValidator validator) throws Exception, IModuleClassLoaderProvider.ModuleServiceException {
        Collection c;
        IModuleService.IModule lib;
        Map<String, ClassLoader> cls = this.classLoaders.get(parent);
        if (cls == null) {
            cls = new HashMap<String, ClassLoader>();
            this.classLoaders.put(parent, cls);
        }
        boolean hasModuleName = true;
        ClassLoader cl = null;
        if (moduleName == null || moduleName.isEmpty()) {
            hasModuleName = false;
            moduleName = "default";
            cl = cls.get("default");
        } else {
            cl = cls.get(moduleName);
        }
        if (cl == null) {
            lib = this.getModule(moduleName);
            if (lib == null && hasModuleName) {
                throw new IModuleClassLoaderProvider.ModuleServiceException(String.format(Messages.ModuleServiceComponent_24, moduleName));
            }
            if (lib != null) {
                try {
                    c = lib.getURLs();
                    cl = new StambiaClassLoaderRegistry.NamedURLClassLoader(moduleName, c.toArray(new URL[c.size()]), parent);
                    cls.put(moduleName, cl);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (cl != null && (lib = this.getModule(moduleName)) != null) {
            String baseModuleId = lib.getDescriptor().getBaseModuleInfo().getId();
            IModuleService.IBaseModule bm = this.findBaseModule(baseModuleId);
            if (bm == null) {
                throw new IModuleClassLoaderProvider.ModuleServiceException(String.format(Messages.ModuleServiceComponent_26, moduleName));
            }
            if (!this.filterFromRoles().test(bm)) {
                throw new IModuleClassLoaderProvider.ModuleServiceException(String.format(Messages.ModuleServiceComponent_27, moduleName));
            }
        }
        if (validator != null) {
            try {
                validator.checkClassLoader(cl);
            }
            catch (Exception e) {
                cls.remove(cl);
                if (!hasModuleName) {
                    c = this.getModule("internal").getURLs();
                    cl = new StambiaClassLoaderRegistry.NamedURLClassLoader(moduleName, c.toArray(new URL[c.size()]), parent);
                    validator.checkClassLoader(cl);
                    cls.put(moduleName, cl);
                }
                throw new IModuleClassLoaderProvider.ModuleServiceException(Messages.ModuleServiceComponent_25 + e.getMessage(), e);
            }
        }
        return cl;
    }

    public void closeClassLoader(String moduleName) {
        if (moduleName == null || moduleName.equals("internal")) {
            return;
        }
        for (Map<String, ClassLoader> m : this.classLoaders.values()) {
            ClassLoader cl = m.get(moduleName);
            if (!(cl instanceof URLClassLoader)) continue;
            try {
                ((URLClassLoader)cl).close();
                m.remove(moduleName);
            }
            catch (IOException e) {
                this.getLogger().log(Level.WARNING, "Unexpected", e);
            }
        }
    }

    private static List<String> splitPropertyValue(String p) {
        List<String> files = Collections.EMPTY_LIST;
        if (p != null && !p.isEmpty()) {
            files = Arrays.asList(p.split(";"));
        }
        return files;
    }

    private String[] findBundleProvider4Entry(Bundle bundle, String entryPath) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            this.getLogger().warning(String.format("Could not find wiring for ", bundle.getSymbolicName()));
        } else {
            for (BundleWire wire : wiring.getProvidedWires("osgi.wiring.host")) {
                BundleWiring w = wire.getRequirerWiring();
                BundleRevision rev = w.getRevision();
                BundleInfo.Generation gen = (BundleInfo.Generation)((ModuleRevision)rev).getRevisionInfo();
                URL u = gen.getEntry(entryPath);
                if (u == null) continue;
                return new String[]{rev.getSymbolicName(), rev.getVersion().toString()};
            }
        }
        return new String[]{bundle.getSymbolicName(), bundle.getVersion().toString()};
    }

    private boolean extractBaseModuleInformation(Bundle b, Set<URL> handledURL, Map<String, IModuleService.IBaseModule> modulesMap, List<IModuleService.IBaseModule> modules, List<IModuleService.IBaseModuleExtension> extensions) {
        AbstractBase baseModule2;
        Integer defaultIndex;
        List drivers;
        BufferedInputStream is;
        Object var13_17;
        URL descriptorURL;
        this.getLogger().info("Analyzing bundle " + b.getSymbolicName() + "...");
        Enumeration e = b.findEntries("/modules", BASE_MODULE_FILE_NAME, true);
        boolean res = false;
        if (e != null) {
            while (e.hasMoreElements()) {
                descriptorURL = (URL)e.nextElement();
                Properties p = new Properties();
                this.getLogger().info("Found baseModule " + String.valueOf(descriptorURL));
                String entryPath = descriptorURL.toString();
                entryPath = entryPath.substring(entryPath.indexOf("/modules/"));
                String[] bundleProviderId = this.findBundleProvider4Entry(b, entryPath);
                try {
                    Throwable throwable = null;
                    var13_17 = null;
                    try {
                        is = new BufferedInputStream(descriptorURL.openStream());
                        try {
                            p.load(is);
                            drivers = ModuleServiceImpl.JDBCDriverDescriptorParser.INSTANCE.parseProperties(p);
                            defaultIndex = null;
                            try {
                                defaultIndex = Integer.parseInt(p.getProperty("jdbc.defaultDriver"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            baseModule2 = new BaseModule((IModuleService.IBaseModuleInfo)new ModuleServiceImpl.BaseModuleInfo(bundleProviderId[0], bundleProviderId[1], p.getProperty("baseModule.version"), p.getProperty("baseModule.id"), p.getProperty("baseModule.component.bundle")), p.getProperty(P_BASE_MODULE_LABEL), Boolean.valueOf(p.getProperty(P_BASE_MODULE_IS_FULL)) == false, p.getProperty("baseModule.description"), ModuleServiceComponent.splitPropertyValue(p.getProperty("baseModule.files.pattern")), ModuleServiceComponent.splitPropertyValue(p.getProperty(P_BASE_MODULE_BUNDLE_EXTRACT)), drivers, defaultIndex);
                            if (!handledURL.add(descriptorURL)) continue;
                            modules.add((IModuleService.IBaseModule)baseModule2);
                            modulesMap.put(baseModule2.getInfo().getId(), (IModuleService.IBaseModule)baseModule2);
                            res = true;
                        }
                        finally {
                            if (is != null) {
                                ((InputStream)is).close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    this.getLogger().log(Level.WARNING, "Could not create BaseModule from Bundle " + b.getSymbolicName() + "/" + descriptorURL.getPath(), ex);
                }
            }
        } else {
            this.getLogger().info("No baseModule found");
        }
        e = b.findEntries("/modules", EXTENSION_FILE_NAME, true);
        if (e != null) {
            while (e.hasMoreElements()) {
                descriptorURL = (URL)e.nextElement();
                this.getLogger().info("Found baseModuleExtension " + String.valueOf(descriptorURL));
                String entryPath = descriptorURL.toString();
                entryPath = entryPath.substring(entryPath.indexOf("/modules/"));
                String[] bundleProviderId = this.findBundleProvider4Entry(b, entryPath);
                Properties p = new Properties();
                try {
                    Throwable ex = null;
                    var13_17 = null;
                    try {
                        is = new BufferedInputStream(descriptorURL.openStream());
                        try {
                            p.load(is);
                            drivers = ModuleServiceImpl.JDBCDriverDescriptorParser.INSTANCE.parseProperties(p);
                            defaultIndex = null;
                            try {
                                defaultIndex = Integer.parseInt(p.getProperty("jdbc.defaultDriver"));
                            }
                            catch (Exception baseModule2) {
                                // empty catch block
                            }
                            baseModule2 = new BaseModuleExtension(p.getProperty(P_EXTENSION_EXTENDED_BASEMODULE_ID), (IModuleService.IBaseModuleInfo)new ModuleServiceImpl.BaseModuleInfo(bundleProviderId[0], bundleProviderId[1], p.getProperty("baseModule.extension.version"), p.getProperty("baseModule.extension.id"), p.getProperty("baseModule.component.bundle")), p.getProperty(P_EXTENSION_LABEL), Boolean.valueOf(p.getProperty(P_EXTENSION_IS_FULL)) == false, ModuleServiceComponent.splitPropertyValue(p.getProperty("baseModule.extension.files")), ModuleServiceComponent.splitPropertyValue(p.getProperty(P_EXTENSION_BUNDLE_EXTRACT)), drivers, defaultIndex);
                            if (!handledURL.add(descriptorURL)) continue;
                            extensions.add((IModuleService.IBaseModuleExtension)baseModule2);
                            res = true;
                        }
                        finally {
                            if (is != null) {
                                ((InputStream)is).close();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (ex == null) {
                            ex = throwable;
                        } else if (ex != throwable) {
                            ex.addSuppressed(throwable);
                        }
                        throw ex;
                    }
                }
                catch (Exception ex) {
                    this.getLogger().log(Level.WARNING, "Could not create BaseModule from Bundle " + b.getSymbolicName() + "/" + descriptorURL.getPath(), ex);
                }
            }
        } else {
            this.getLogger().info("No baseModuleExtension found");
        }
        return res;
    }

    private void gatherBaseModuleInformations() {
        ArrayList<IModuleService.IBaseModule> modules = new ArrayList<IModuleService.IBaseModule>();
        ArrayList<IModuleService.IBaseModuleExtension> extensions = new ArrayList<IModuleService.IBaseModuleExtension>();
        HashMap<String, IModuleService.IBaseModule> modulesMap = new HashMap<String, IModuleService.IBaseModule>();
        HashSet<URL> handledURL = new HashSet<URL>();
        Bundle[] bundleArray = this.ctx.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            this.extractBaseModuleInformation(b, handledURL, modulesMap, modules, extensions);
            ++n2;
        }
        this.cachedModulesBase = modules;
        this.cachedModulesextensions = extensions;
        this.cachedModulesBaseMap = modulesMap;
    }

    public List<IModuleService.IBaseModule> getBaseModules() {
        if (this.cachedModulesBase == null) {
            this.gatherBaseModuleInformations();
        }
        return this.cachedModulesBase.stream().filter(this.filterFromRoles()).collect(Collectors.toList());
    }

    private List<IModuleService.IBaseModule> internalGetBaseModules() {
        if (this.cachedModulesBase == null) {
            this.gatherBaseModuleInformations();
        }
        return this.cachedModulesBase.stream().collect(Collectors.toList());
    }

    private List<IModuleService.IBaseModuleExtension> getBaseModuleExtensions() {
        if (this.cachedModulesextensions == null) {
            this.gatherBaseModuleInformations();
        }
        return this.cachedModulesextensions;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected Map<String, URL> gatherFileURL(IModuleService.IBaseModuleInfo info, IModuleService.IBaseModuleContent content) throws Exception {
        providerBundler = null;
        var7_4 = this.ctx.getBundles();
        var6_5 = var7_4.length;
        var5_8 = 0;
        while (var5_8 < var6_5) {
            b = var7_4[var5_8];
            if (b.getSymbolicName().equals(info.getBundleProviderId()) && b.getVersion().toString().equals(info.getBundleProviderVersion())) {
                providerBundler = b;
                break;
            }
            ++var5_8;
        }
        filesURL = new HashMap<String, URL>();
        _baseProvider = providerBundler;
        for (String fName : content.getFilePatterns()) {
            try {
                path = null;
                pattern = null;
                if (fName.startsWith("platform:plugin")) {
                    if (fName.contains("*")) {
                        p = null;
                        bundleName = null;
                        if (fName.startsWith("platform:plugin")) {
                            p = fName.replace("platform:plugin/", "");
                            bundleName = p.substring(0, p.indexOf("/"));
                            var15_30 = this.ctx.getBundles();
                            var14_27 = var15_30.length;
                            var13_24 = 0;
                            while (var13_24 < var14_27) {
                                b = var15_30[var13_24];
                                if (b.getSymbolicName().equals(bundleName)) {
                                    providerBundler = b;
                                    p = p.substring(bundleName.length());
                                    path = p.substring(0, p.lastIndexOf("/"));
                                    pattern = p.substring(p.lastIndexOf("/") + 1);
                                    break;
                                }
                                ++var13_24;
                            }
                        }
                    } else {
                        u = new URL(fName);
                        bundleName = filesURL.put(u.toString().substring(u.toString().lastIndexOf("/") + 1), u);
                    }
                } else {
                    path = fName.substring(0, fName.lastIndexOf("/"));
                    pattern = fName.substring(fName.lastIndexOf("/") + 1);
                }
                if (path == null || pattern == null) continue;
                e2 = providerBundler.findEntries(path, pattern, true);
                if (e2 != null) ** GOTO lbl53
                this.getLogger().log(Level.WARNING, "Unable to find any entries from bundle " + _baseProvider.getSymbolicName() + " matching the pattern " + path + ":" + pattern);
                continue;
lbl-1000:
                // 1 sources

                {
                    u = (URL)e2.nextElement();
                    var12_23 /* !! */  = filesURL.put(u.toString().substring(u.toString().lastIndexOf("/") + 1), u);
lbl53:
                    // 2 sources

                    ** while (e2.hasMoreElements())
                }
lbl54:
                // 1 sources

            }
            finally {
                providerBundler = _baseProvider;
            }
        }
        block7: for (String bundleName : content.getExtractedBundles()) {
            fragmentId = null;
            if (bundleName.contains("/")) {
                i = -1;
                i = bundleName.indexOf("/");
                s = bundleName.substring(0, i);
                fragmentId = bundleName.substring(i + 1);
                bundleName = s;
            }
            var12_23 /* !! */  = this.ctx.getBundles();
            var11_22 = var12_23 /* !! */ .length;
            var10_19 = 0;
            while (var10_19 < var11_22) {
                b = var12_23 /* !! */ [var10_19];
                if (b.getSymbolicName().equals(bundleName)) {
                    wiring = (BundleWiring)b.adapt(BundleWiring.class);
                    if (fragmentId != null) {
                        for (BundleWire wire : wiring.getProvidedWires("osgi.wiring.host")) {
                            w = wire.getRequirerWiring();
                            rev = w.getRevision();
                            if (!rev.getSymbolicName().equals(fragmentId)) continue;
                            gen = (BundleInfo.Generation)((ModuleRevision)rev).getRevisionInfo();
                            bundleFile = gen.getBundleFile();
                            u = this.extractBundle(rev.getSymbolicName() + "_" + rev.getVersion().toString(), bundleFile, rev.getVersion(), bundleName);
                            filesURL.put(u.toString().substring(u.toString().lastIndexOf("/") + 1), u);
                            break;
                        }
                    } else {
                        rev = wiring.getRevision();
                        gen = (BundleInfo.Generation)((ModuleRevision)rev).getRevisionInfo();
                        bundleFile = gen.getBundleFile();
                        u = this.extractBundle(rev.getSymbolicName() + "_" + rev.getVersion().toString(), bundleFile, rev.getVersion(), bundleName);
                        filesURL.put(u.toString().substring(u.toString().lastIndexOf("/") + 1), u);
                        continue block7;
                    }
                }
                ++var10_19;
            }
        }
        return filesURL;
    }

    public Collection<String> getProvidedFiles(IModuleService.IBaseModule baseModule, IModuleService.IBaseModuleExtension extension) throws Exception {
        if (extension != null && !extension.getExtendedBaseModuleId().equals(baseModule.getInfo().getId())) {
            throw new Exception(String.format(Messages.ModuleServiceComponent_extensionIncompatibility, extension.getInfo().getId(), baseModule.getInfo().getId()));
        }
        Map<String, URL> filesURL = this.gatherFileURL(baseModule.getInfo(), (IModuleService.IBaseModuleContent)baseModule);
        Map<String, URL> extensionFilesURL = null;
        try {
            if (extension != null) {
                extensionFilesURL = this.gatherFileURL(extension.getInfo(), (IModuleService.IBaseModuleContent)extension);
            }
        }
        catch (Exception ex) {
            throw new Exception(Messages.ModuleServiceComponent_0 + extension.getInfo().getId());
        }
        HashSet<String> res = new HashSet<String>();
        res.addAll(filesURL.keySet());
        if (extensionFilesURL != null) {
            res.addAll(extensionFilesURL.keySet());
        }
        return res;
    }

    public IModuleService.IModuleInstallationInfo createIntaller(IModuleService.IBaseModule baseModule, IModuleService.IBaseModuleExtension extension, Collection<URL> userFiles) throws Exception {
        if (extension != null && !extension.getExtendedBaseModuleId().equals(baseModule.getInfo().getId())) {
            throw new Exception(String.format(Messages.ModuleServiceComponent_extensionIncompatibility, extension.getInfo().getId(), baseModule.getInfo().getId()));
        }
        Map<String, URL> filesURL = this.gatherFileURL(baseModule.getInfo(), (IModuleService.IBaseModuleContent)baseModule);
        Map<String, URL> extensionFilesURL = null;
        try {
            if (extension != null) {
                extensionFilesURL = this.gatherFileURL(extension.getInfo(), (IModuleService.IBaseModuleContent)extension);
            }
        }
        catch (Exception ex) {
            throw new Exception(String.format(Messages.ModuleServiceComponent_5, extension.getInfo().getId()));
        }
        HashMap<String, URL> userFilesMap = new HashMap<String, URL>();
        if (userFiles != null) {
            for (URL u : userFiles) {
                String fName = null;
                if ("platform".equals(u.toURI().getScheme())) {
                    fName = u.toURI().toString();
                    fName = fName.substring(fName.lastIndexOf("/") + 1);
                } else {
                    File f = new File(u.toURI());
                    fName = f.getName();
                }
                if (filesURL.get(fName) != null) {
                    throw new Exception(String.format(Messages.ModuleServiceComponent_6, fName));
                }
                if (extensionFilesURL != null && extensionFilesURL.get(fName) != null) {
                    throw new Exception(String.format(Messages.ModuleServiceComponent_7, fName, extension.getLabel()));
                }
                URL old = userFilesMap.put(fName, u);
                if (old == null) continue;
                throw new Exception(String.format(Messages.ModuleServiceComponent_8, fName));
            }
        }
        return new ModuleInstallationInfo(baseModule, filesURL, extension, extensionFilesURL, userFilesMap);
    }

    private synchronized URL extractBundle(String fileName, BundleFile bundleFile, Version revisionVersion, String bundleName) throws Exception {
        Version curVersion = this.versionByBundleNameToDeploy.get(bundleName);
        if (curVersion != null && curVersion.compareTo(revisionVersion) >= 0) {
            return this._tmpGeneratedBundles.get(fileName);
        }
        this.versionByBundleNameToDeploy.put(bundleName, revisionVersion);
        if (this.tmpBundleExtractionFolder == null) {
            this.tmpBundleExtractionFolder = File.createTempFile("stambia.module.bundle.extract.folder", Long.toString(System.nanoTime()));
            Throwable throwable = null;
            Object var7_8 = null;
            try (Stream<Path> stream = Files.walk(this.tmpBundleExtractionFolder.toPath(), new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.tmpBundleExtractionFolder.mkdirs();
            this.tmpBundleExtractionFolder.deleteOnExit();
        }
        URL u = HookHelper.extractBundle((String)fileName, (BundleFile)bundleFile, (File)this.tmpBundleExtractionFolder).toURL();
        File ff = new File(u.toURI());
        ff.deleteOnExit();
        this._tmpGeneratedBundles.put(fileName, u);
        return u;
    }

    public List<IModuleService.IBaseModuleExtension> getAvailableExtensions(String baseModuleId) {
        List<IModuleService.IBaseModuleExtension> res;
        if (this.cachedModuleExtensionPerMap == null) {
            this.cachedModuleExtensionPerMap = new HashMap<String, List<IModuleService.IBaseModuleExtension>>();
            for (IModuleService.IBaseModuleExtension ext : this.getBaseModuleExtensions()) {
                List<IModuleService.IBaseModuleExtension> l = this.cachedModuleExtensionPerMap.get(ext.getExtendedBaseModuleId());
                if (l == null) {
                    l = new ArrayList<IModuleService.IBaseModuleExtension>();
                    this.cachedModuleExtensionPerMap.put(ext.getExtendedBaseModuleId(), l);
                }
                l.add(ext);
            }
        }
        if ((res = this.cachedModuleExtensionPerMap.get(baseModuleId)) == null) {
            return Collections.EMPTY_LIST;
        }
        return res;
    }

    public IModuleService.IBaseModule findBaseModule(String baseModuleId) {
        if (this.cachedModulesBaseMap == null) {
            this.getBaseModules();
        }
        return this.cachedModulesBaseMap.get(baseModuleId);
    }

    public void removeModule(String moduleName) throws Exception {
        if (moduleName.equals("internal")) {
            throw new Exception(String.format(Messages.ModuleServiceComponent_1, "internal"));
        }
        this.closeClassLoader(moduleName);
        for (Map<String, ClassLoader> m : this.classLoaders.values()) {
            if (m.get(moduleName) == null) continue;
            this.getLogger().warning(String.format(Messages.ModuleServiceComponent_13, moduleName));
            return;
        }
        StambiaClassLoaderRegistry.INSTANCE.closeClassLoader(moduleName);
        super.removeModule(moduleName);
    }

    public Collection<IModuleService.IModule> getModules() {
        return Collections.unmodifiableCollection(super.getModules().stream().filter(this.filterFromRoles()).filter(m -> !"internal".equals(m.getName())).collect(Collectors.toList()));
    }

    public Collection<IModuleService.IModule> internalGetModules() {
        return Collections.unmodifiableCollection(super.getModules().stream().filter(m -> !"internal".equals(m.getName())).collect(Collectors.toList()));
    }

    private <T> Predicate<T> filterFromRoles() {
        return new Predicate<T>(){

            String getBundleName(Object o) {
                try {
                    if (o instanceof IModuleService.IBaseModule) {
                        return ((IModuleService.IBaseModule)o).getInfo().getBundleProviderId();
                    }
                    if (o instanceof IModuleService.IModule) {
                        return ((IModuleService.IModule)o).getDescriptor().getBaseModuleInfo().getBundleProviderId();
                    }
                }
                catch (Exception ex) {
                    ModuleServiceComponent.this.getLogger().log(Level.WARNING, "Unexpected", ex);
                }
                return null;
            }

            String getComponentBundleName(Object o) {
                try {
                    if (o instanceof IModuleService.IBaseModule) {
                        return ((IModuleService.IBaseModule)o).getInfo().getComponentBundle();
                    }
                    if (o instanceof IModuleService.IModule) {
                        return ((IModuleService.IModule)o).getDescriptor().getBaseModuleInfo().getComponentBundle();
                    }
                }
                catch (Exception ex) {
                    ModuleServiceComponent.this.getLogger().log(Level.WARNING, "Unexpected", ex);
                }
                return null;
            }

            @Override
            public boolean test(T obj) {
                String bundleProvider = this.getBundleName(obj);
                if (bundleProvider != null && !bundleProvider.isEmpty()) {
                    String componentBundleName;
                    Optional component = ModuleServiceComponent.this.componentService.getComponentByBundleProvider(bundleProvider);
                    if (!component.isPresent() && (componentBundleName = this.getComponentBundleName(obj)) != null) {
                        component = ModuleServiceComponent.this.componentService.getComponentByBundleProvider(componentBundleName);
                    }
                    if (component.isPresent() && !AdministrationHelper.componentAuthorized((IComponentService.IComponent)((IComponentService.IComponent)component.get()))) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    private static abstract class AbstractBase {
        private Collection<String> filePatterns;
        private Collection<String> extractedBundles;
        private List<IModuleService.IJDBCDriverDescriptor> jdbcDriverDesc;
        private IModuleService.IBaseModuleInfo info;
        private String label;
        private boolean expectUserFiles;

        private AbstractBase(IModuleService.IBaseModuleInfo baseModuleInfo, String label, boolean expectUserFiles, Collection<String> filePatterns, Collection<String> extractedBundles, List<IModuleService.IJDBCDriverDescriptor> jdbcDriverDesc) throws Exception {
            this.info = baseModuleInfo;
            this.filePatterns = Collections.unmodifiableCollection(filePatterns);
            this.extractedBundles = Collections.unmodifiableCollection(extractedBundles);
            this.jdbcDriverDesc = Collections.unmodifiableList(jdbcDriverDesc);
            this.label = label;
            this.expectUserFiles = expectUserFiles;
            if (this.label == null) {
                throw new Exception(Messages.ModuleServiceComponent_10 + baseModuleInfo.getId() + "_" + String.valueOf(baseModuleInfo.getVersion()));
            }
        }

        public String getLabel() {
            return this.label;
        }

        public Collection<String> getFilePatterns() {
            return this.filePatterns;
        }

        public List<IModuleService.IJDBCDriverDescriptor> getJDBCProviders() {
            return this.jdbcDriverDesc;
        }

        public Collection<String> getExtractedBundles() {
            return this.extractedBundles;
        }

        public IModuleService.IBaseModuleInfo getInfo() {
            return this.info;
        }

        public boolean expectAdditionalFiles() {
            return this.expectUserFiles;
        }
    }

    private static class BaseModule
    extends AbstractBase
    implements IModuleService.IBaseModule {
        private String description;
        private Integer defaultJDBCIndex;

        private BaseModule(IModuleService.IBaseModuleInfo baseModuleInfo, String label, boolean expectUserFiles, String description, Collection<String> filePatterns, Collection<String> extractedBundles, List<IModuleService.IJDBCDriverDescriptor> jdbcDriverDesc, Integer defaultJDBCIndex) throws Exception {
            super(baseModuleInfo, label, expectUserFiles, filePatterns, extractedBundles, jdbcDriverDesc);
            this.description = description == null || description.trim().isEmpty() ? "Handle communication with " + this.getLabel() : description;
            this.defaultJDBCIndex = defaultJDBCIndex;
        }

        public String getDescription() {
            return this.description;
        }

        public Integer getDefaultJDBCDriverDescriptorIndex() {
            return this.defaultJDBCIndex;
        }

        public boolean isFull() {
            return !super.expectAdditionalFiles();
        }
    }

    private static class BaseModuleExtension
    extends AbstractBase
    implements IModuleService.IBaseModuleExtension {
        String extendedBaseModuleId;
        private Integer defaultJDBCIndex;

        private BaseModuleExtension(String extendedBaseModuleId, IModuleService.IBaseModuleInfo baseModuleInfo, String label, boolean expectUserFiles, Collection<String> filePatterns, Collection<String> extractedBundles, List<IModuleService.IJDBCDriverDescriptor> jdbcDriverDesc, Integer defaultJDBCIndex) throws Exception {
            super(baseModuleInfo, label, expectUserFiles, filePatterns, extractedBundles, jdbcDriverDesc);
            this.extendedBaseModuleId = extendedBaseModuleId;
            if (this.extendedBaseModuleId == null) {
                throw new Exception(Messages.ModuleServiceComponent_12 + baseModuleInfo.getId() + "_" + String.valueOf(baseModuleInfo.getVersion()));
            }
            this.defaultJDBCIndex = defaultJDBCIndex;
        }

        public String getExtendedBaseModuleId() {
            return this.extendedBaseModuleId;
        }

        public Integer getDefaultJDBCDriverDescriptorIndex() {
            return this.defaultJDBCIndex;
        }
    }

    private class ResolvedBundleListener
    implements BundleListener {
        private ResolvedBundleListener() {
        }

        public void bundleChanged(BundleEvent event) {
            if (event.getType() == 32) {
                ModuleServiceComponent.this.getLogger().info("Bundle " + event.getBundle().getSymbolicName() + " resolved");
                boolean b = ModuleServiceComponent.this.extractBaseModuleInformation(event.getBundle(), new HashSet<URL>(), ModuleServiceComponent.this.cachedModulesBaseMap, ModuleServiceComponent.this.cachedModulesBase, ModuleServiceComponent.this.cachedModulesextensions);
                if (b) {
                    ModuleServiceComponent.this.cachedModuleExtensionPerMap = null;
                }
            }
        }
    }
}

