/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator;

import com.indy.engine.core.common.objects2.DeliveryRepositoryInfoExchange;
import com.indy.engine.core.common.objects2.IDeliveryRepositoryInfo;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineRegistry;
import com.indy.ui.common.listener.NotificationManager;
import com.indy.ui.common.resource.IResource;
import com.indy.ui.common.resource.IStambiaRuntime;
import com.stambia.app.authorization.Action;
import com.stambia.ui.navigator.NavigatorFacade;
import com.stambia.ui.navigator.data.IPotentialResource;
import com.stambia.ui.navigator.internal.data.OwnRuntime;
import com.stambia.ui.navigator.internal.data.OwnRuntimeRepositories;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class RuntimeSynchronizer {
    private static final Logger LOGGER = Logger.getLogger(RuntimeSynchronizer.class.getName());
    Queue<OwnRuntime> toSynch = new ConcurrentLinkedQueue<OwnRuntime>();
    Queue<OwnRuntime> synchronizing = new ConcurrentLinkedQueue<OwnRuntime>();
    ConcurrentHashMap<OwnRuntime, Object[]> toRefreshInUI = new ConcurrentHashMap();
    Display display;
    Job job = new Job("Synchronizing runtimes"){

        protected IStatus run(IProgressMonitor monitor) {
            RuntimeSynchronizer.this.synchronizing.addAll(RuntimeSynchronizer.this.toSynch);
            RuntimeSynchronizer.this.toSynch.clear();
            while (!RuntimeSynchronizer.this.synchronizing.isEmpty()) {
                final OwnRuntime curRuntime = RuntimeSynchronizer.this.synchronizing.poll();
                IStambiaRuntime runtime = curRuntime.getRuntime();
                ArrayList<1> resources = new ArrayList<1>();
                try {
                    AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(runtime.getHost(), Integer.valueOf(runtime.getPort()), runtime.getUser(), runtime.getPassword());
                    if (engine.isConnected()) {
                        curRuntime.setStatus(1);
                        Map map = engine.getVersion();
                        if (map != null) {
                            curRuntime.setVersion((String)map.get("branding.engine"));
                        }
                        Map repos = EngineRegistry.getDefault().isRuntimes17_4_2(engine) ? engine.getRepositories(null) : this.getDefaultMap();
                        for (Map repoMap : repos.values()) {
                            DeliveryRepositoryInfoExchange esd = new DeliveryRepositoryInfoExchange(repoMap);
                            final String resourceName = esd.getName() != null ? esd.getName() : "default";
                            final String resourceId = String.valueOf(curRuntime.getResourceId()) + "/" + resourceName;
                            resources.add(new IPotentialResource((IDeliveryRepositoryInfo)esd, engine){
                                private final /* synthetic */ IDeliveryRepositoryInfo val$esd;
                                private final /* synthetic */ AnalyticsEngineWrapper val$engine;
                                {
                                    this.val$esd = iDeliveryRepositoryInfo;
                                    this.val$engine = analyticsEngineWrapper;
                                }

                                @Override
                                public String getName() {
                                    return resourceName;
                                }

                                @Override
                                public IResource createResource() {
                                    return new OwnRuntimeRepositories(resourceName, curRuntime, resourceId, this.val$esd, this.val$engine);
                                }

                                @Override
                                public String getId() {
                                    return resourceId;
                                }
                            });
                        }
                    }
                    curRuntime.setConnectionException(null);
                    curRuntime.cacheSchedules(engine);
                }
                catch (Exception e) {
                    curRuntime.setStatus(-1);
                    curRuntime.setConnectionException(e);
                    LOGGER.log(Level.WARNING, e.toString(), e);
                }
                if (RuntimeSynchronizer.this.display == null || RuntimeSynchronizer.this.display.isDisposed()) continue;
                RuntimeSynchronizer.this.display.syncExec(() -> NavigatorFacade.navigatorUISynchItem(RuntimeSynchronizer.this.display, curRuntime, resources));
            }
            if (!RuntimeSynchronizer.this.toSynch.isEmpty()) {
                RuntimeSynchronizer.this.job.schedule(1000L);
            }
            return Status.OK_STATUS;
        }

        private Map<String, Map<String, Object>> getDefaultMap() {
            HashMap<String, Object> defaultRepoMap = new HashMap<String, Object>();
            defaultRepoMap.put("isWebservice", false);
            defaultRepoMap.put("isDefault", true);
            defaultRepoMap.put("name", null);
            defaultRepoMap.put("type", "File");
            HashMap<String, Map<String, Object>> defaultMap = new HashMap<String, Map<String, Object>>();
            defaultMap.put("default", defaultRepoMap);
            return defaultMap;
        }
    };

    public void setDisplay(Display display) {
        this.display = display;
    }

    public synchronized void refresh(OwnRuntime runtime) {
        if (NavigatorFacade.isAuthorized(Action.RUNTIME_DELIVERY_ACCESS)) {
            if (!this.toSynch.contains(runtime)) {
                this.toSynch.add(runtime);
            }
            runtime.setStatus(2);
            NotificationManager.getInstance().refreshItem((IResource)runtime);
            this.job.schedule(1000L);
        }
    }
}

