/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.data;

import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineRegistry;
import com.indy.ui.common.constante.Constante;
import com.indy.ui.common.editor.input.DeliveryEditorInput;
import com.indy.ui.common.resource.IResource;
import com.indy.ui.common.resource.IResourceWithCache;
import com.stambia.app.authorization.Action;
import com.stambia.app.authorization.AuthManager;
import com.stambia.ui.navigator.NavigatorActivator;
import com.stambia.ui.navigator.data.IDeliveries;
import com.stambia.ui.navigator.data.IPotentialResource;
import com.stambia.ui.navigator.internal.data.OwnRuntime;
import com.stambia.ui.navigator.internal.data.OwnRuntimeRepositories;
import com.stambia.ui.navigator.internal.data.OwnSchedule;
import com.stambia.ui.navigator.internal.data.ResourceWithChildren;
import com.stambia.ui.navigator.message.Messages;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class OwnDelivery
extends ResourceWithChildren
implements IDeliveries,
IResourceWithCache {
    private String logLevel;
    private static final Logger LOGGER = Logger.getLogger(OwnDelivery.class.getName());

    public OwnDelivery(String name, IResource parent, String resourceId, String logLevel) {
        super(name, parent, resourceId);
        this.logLevel = logLevel;
        ((OwnRuntimeRepositories)parent).getChildren().put(resourceId, this);
    }

    public OwnRuntime getRuntime() {
        return (OwnRuntime)this.getParent().getParent();
    }

    public String getRepoDir() {
        if (this.getParent() instanceof OwnRuntimeRepositories) {
            return ((OwnRuntimeRepositories)this.getParent()).getDirName();
        }
        return null;
    }

    private List<Map<String, Object>> getDeliverySchedules(boolean refresh) {
        if (refresh) {
            ((OwnRuntime)this.getParent().getParent()).clearDeliverySchedules(this.name);
            try {
                AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(this.getRuntime().getHost(), Integer.valueOf(this.getRuntime().getPort()), this.getRuntime().getUser(), this.getRuntime().getPassword());
                engine.getLstSchedules(this.name).forEach(schedule -> this.getRuntime().addSchedule(this.name, (Map<String, Object>)schedule, !EngineRegistry.getDefault().isRuntimes17_3_0(engine)));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.toString(), e);
            }
        }
        return ((OwnRuntime)this.getParent().getParent()).getSchedules(this.name);
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public Image getImage() {
        return NavigatorActivator.getDefault().getImage("ExecDelivery16x16.png");
    }

    public boolean openEditor(IWorkbenchPage activePage, String actionId) {
        boolean result = false;
        try {
            activePage.openEditor((IEditorInput)new DeliveryEditorInput(this.getName(), this.getResourceId(), this.getRuntime().getRuntime().getUUID(), this.getRuntime().getName(), this.getRuntime().getPort(), this.getRuntime().getHost(), this.getRuntime().getUser(), this.getRuntime().getPassword(), this.getRepoDir(), this.getRuntime().isNoSessionAccess()), Constante.DELIVERY_FORM_EDITOR);
        }
        catch (PartInitException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            result = false;
        }
        return result;
    }

    @Override
    public void remove() {
        block2: {
            try {
                String host = this.getRuntime().getHost();
                int port = this.getRuntime().getPort();
                String user = this.getRuntime().getUser();
                String password = this.getRuntime().getPassword();
                EngineRegistry.getDefault().deleteDelivery(host, Integer.valueOf(port), user, password, this.getName(), this.getParent().getName());
                ((OwnRuntimeRepositories)this.getParent()).removeChild(this);
            }
            catch (Exception e) {
                if (!(e instanceof ServerException)) break block2;
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.get().StambiaResourceNavigator_4, (String)((ServerException)e).detail.getMessage());
            }
        }
    }

    public Collection<IPotentialResource> processDeliverySchedules(boolean refresh) {
        ArrayList<IPotentialResource> resources = new ArrayList<IPotentialResource>();
        boolean syncSchedule = AuthManager.isAuthorized((Action)Action.RUNTIME_DELIVERY_SCHEDULE_ACCESS);
        if (syncSchedule && this.getParent() != null && Boolean.TRUE.equals(((OwnRuntimeRepositories)this.getParent()).isDefault())) {
            List<Map<String, Object>> schedules = this.getDeliverySchedules(refresh);
            schedules.forEach(schedule -> {
                String resourceId = String.valueOf(this.getResourceId()) + "/" + schedule.get("triggerName");
                resources.add(new IPotentialResource((Map)schedule, resourceId){
                    private final /* synthetic */ Map val$schedule;
                    private final /* synthetic */ String val$resourceId;
                    {
                        this.val$schedule = map;
                        this.val$resourceId = string;
                    }

                    @Override
                    public String getName() {
                        String label = this.val$schedule.get("scheduleName") != null ? (String)this.val$schedule.get("scheduleName") : (String)this.val$schedule.get("triggerName");
                        if (!this.val$schedule.get("jobName").equals(this.val$schedule.get("deliveryName"))) {
                            label = this.val$schedule.get("jobName") + "/" + label;
                        }
                        return label;
                    }

                    @Override
                    public IResource createResource() {
                        return new OwnSchedule(this.getName(), OwnDelivery.this, this.val$resourceId, (String)this.val$schedule.get("triggerName"));
                    }

                    @Override
                    public String getId() {
                        return this.val$resourceId;
                    }
                });
            });
        }
        return resources;
    }

    public void synchronize(boolean deeply) {
        Collection<IPotentialResource> resources = this.processDeliverySchedules(false);
        this.synchronize(resources, deeply);
    }

    public IResource synchronizeSchedule(String id) {
        Collection<IPotentialResource> resources = this.processDeliverySchedules(true);
        this.synchronize(resources, true);
        for (IResource schedule : this.getResources()) {
            if (!schedule.getResourceId().equals(id)) continue;
            return schedule;
        }
        return null;
    }

    public void refreshCache() {
        Collection<IPotentialResource> resources = this.processDeliverySchedules(true);
        this.synchronize(resources, true);
    }

    class ScheduleInfo {
        String jobName;
        String scheduleName;
        String triggerName;
        String deliveryName;

        ScheduleInfo() {
        }
    }
}

