/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.signing;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Locale;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.signing.ExternalGpg;
import org.eclipse.egit.core.internal.signing.ExternalProcessRunner;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SignatureVerifier;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.TemporaryBuffer;

public class ExternalGpgSignatureVerifier
implements SignatureVerifier {
    private static final DateTimeFormatter GPGSM_DATE_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter(Locale.ROOT);
    private final boolean x509;

    public ExternalGpgSignatureVerifier() {
        this(false);
    }

    public ExternalGpgSignatureVerifier(boolean x509) {
        this.x509 = x509;
    }

    public SignatureVerifier.SignatureVerification verify(Repository repository, GpgConfig config, byte[] data, byte[] signatureData) throws IOException {
        String program = config.getProgram();
        if (StringUtils.isEmptyOrNull((String)program)) {
            String string = program = this.x509 ? ExternalGpg.getGpgSm() : ExternalGpg.getGpg();
            if (StringUtils.isEmptyOrNull((String)program)) {
                throw new IOException(CoreText.ExternalGpgSigner_gpgNotFound);
            }
        }
        File signatureFile = null;
        SignatureVerifier.SignatureVerification[] verification = new SignatureVerifier.SignatureVerification[1];
        try {
            signatureFile = File.createTempFile("egit", ".sig");
            Files.write(signatureFile.toPath(), signatureData, new OpenOption[0]);
            ProcessBuilder process = new ProcessBuilder(new String[0]);
            process.command(program, "--status-fd", "1", "--verify", signatureFile.getAbsolutePath(), "-");
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (ByteArrayInputStream dataIn = new ByteArrayInputStream(data);){
                    ExternalProcessRunner.run(process, dataIn, b -> {
                        signatureVerificationArray[0] = this.fromGpg(b);
                    }, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CanceledException canceledException) {}
        }
        finally {
            if (signatureFile != null && !signatureFile.delete()) {
                signatureFile.deleteOnExit();
            }
        }
        return verification[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SignatureVerifier.SignatureVerification fromGpg(TemporaryBuffer buffer) {
        Date createdAt = Date.from(Instant.EPOCH);
        boolean haveDate = false;
        SignatureVerifier.TrustLevel trust = SignatureVerifier.TrustLevel.UNKNOWN;
        String fingerprint = null;
        boolean validates = false;
        boolean expired = false;
        String message = null;
        String keyId = null;
        String userId = null;
        try {
            Throwable throwable = null;
            Object var12_14 = null;
            try (BufferedReader r = new BufferedReader(new InputStreamReader(buffer.openInputStream(), StandardCharsets.UTF_8));){
                String line;
                block31: while ((line = r.readLine()) != null) {
                    if (!line.startsWith("[GNUPG:]")) continue;
                    if ((line = line.substring(8).trim()).startsWith("TRUST_")) {
                        String level;
                        int i = line.indexOf(32);
                        if (i < 0) {
                            i = line.length();
                        }
                        if ("FULLY".equals(level = line.substring(6, i))) {
                            trust = SignatureVerifier.TrustLevel.FULL;
                            continue;
                        }
                        try {
                            trust = SignatureVerifier.TrustLevel.valueOf((String)level);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        continue;
                    }
                    if (line.startsWith("SIG_ID")) {
                        String[] parts = line.split(" ");
                        if (parts.length <= 3) continue;
                        try {
                            createdAt = Date.from(Instant.ofEpochSecond(Long.parseLong(parts[3].trim())));
                            haveDate = true;
                        }
                        catch (NumberFormatException level) {}
                        continue;
                    }
                    if (line.startsWith("VALIDSIG")) {
                        int i = line.indexOf(32);
                        int j = -1;
                        if (i > 0) {
                            j = line.indexOf(32, i + 1);
                        }
                        if (j > i) {
                            fingerprint = line.substring(i + 1, j);
                        }
                        if (haveDate || (i = line.indexOf(32, j + 1)) <= j) continue;
                        j = line.indexOf(32, i + 1);
                        String dateTime = line.substring(i + 1, j);
                        if (dateTime.indexOf(84) > 0) {
                            try {
                                createdAt = Date.from(GPGSM_DATE_FORMAT.parse((CharSequence)dateTime, LocalDateTime::from).atOffset(ZoneOffset.UTC).toInstant());
                                haveDate = true;
                            }
                            catch (DateTimeParseException dateTimeParseException) {}
                            continue;
                        }
                        try {
                            createdAt = Date.from(Instant.ofEpochSecond(Long.parseLong(dateTime)));
                            haveDate = true;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    int i = line.indexOf(32);
                    if (i < 0) {
                        i = line.length();
                    }
                    String key = line.substring(0, i);
                    boolean haveUserId = true;
                    switch (key) {
                        case "ERRSIG": {
                            haveUserId = false;
                            message = CoreText.ExternalGpgVerifier_erroneousSignature;
                            break;
                        }
                        case "GOODSIG": {
                            validates = true;
                            break;
                        }
                        case "BADSIG": {
                            message = CoreText.ExternalGpgVerifier_badSignature;
                            break;
                        }
                        case "EXPSIG": {
                            expired = true;
                            message = CoreText.ExternalGpgVerifier_expiredSignature;
                            break;
                        }
                        case "EXPKEYSIG": {
                            expired = true;
                            message = CoreText.ExternalGpgVerifier_expiredKeySignature;
                            break;
                        }
                        case "REVKEYSIG": {
                            message = CoreText.ExternalGpgVerifier_revokedKeySignature;
                            break;
                        }
                        default: {
                            continue block31;
                        }
                    }
                    if (keyId != null) {
                        validates = false;
                        message = CoreText.ExternalGpgVerifier_multipleSignatures;
                        break;
                    }
                    int j = line.indexOf(32, i + 1);
                    if (j <= i) {
                        j = line.length();
                    }
                    keyId = line.substring(i + 1, j);
                    if (haveUserId && j < line.length()) {
                        userId = line.substring(j + 1);
                    }
                    if (message == null) continue;
                    message = MessageFormat.format(message, keyId, userId);
                }
                if (!StringUtils.isEmptyOrNull(fingerprint)) return new SignatureVerifier.SignatureVerification(this.getName(), createdAt, userId, fingerprint, userId, validates, expired, trust, message);
                fingerprint = keyId;
                return new SignatureVerifier.SignatureVerification(this.getName(), createdAt, userId, fingerprint, userId, validates, expired, trust, message);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            message = MessageFormat.format(CoreText.ExternalGpgVerifier_failure, e.getLocalizedMessage());
            return new SignatureVerifier.SignatureVerification(this.getName(), createdAt, userId, fingerprint, userId, false, expired, trust, message);
        }
    }

    public String getName() {
        return this.x509 ? "gpgsm" : "gpg";
    }

    public void clear() {
    }
}

