/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.commands;

import com.indy.emf.uri.Activator;
import com.indy.emf.uri.Messages;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.log.LogService;

public class EnableDuplicateResourceHandler
extends AbstractHandler {
    ImageRegistry registry = new ImageRegistry(JFaceResources.getResources((Display)Display.getDefault()));

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection s = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ArrayList<IEditorPart> dirtyEditors = new ArrayList<IEditorPart>();
        HashMap<URI, Object> replacement = new HashMap<URI, Object>();
        ICacheService cache = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
        for (Object o : ((IStructuredSelection)s).toList()) {
            if (!(o instanceof IFile)) continue;
            IFile f = (IFile)o;
            URI uri = Util.convertIFileToEMFURI((IFile)f);
            IEditorPart ep = null;
            try {
                ep = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)new URIEditorInput(uri));
                if (ep != null) {
                    if (ep.isDirty()) {
                        dirtyEditors.add(ep);
                    } else {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(ep, false);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String duplicateID = cache.getSourceId(uri);
            URI currentURI = cache.findResourceURIByFileId(duplicateID);
            ep = null;
            try {
                ep = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)new URIEditorInput(currentURI));
                if (ep != null) {
                    if (ep.isDirty()) {
                        dirtyEditors.add(ep);
                    } else {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(ep, false);
                    }
                }
            }
            catch (Exception ex) {
                ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(EnableDuplicateResourceHandler.class).error(String.format("Failed to close opened editor %s", currentURI), (Object)ex);
            }
            replacement.put(currentURI, uri);
        }
        if (!dirtyEditors.isEmpty()) {
            SaveDirtyDialog d = new SaveDirtyDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            HashMap<URI, IEditorPart> map = new HashMap<URI, IEditorPart>();
            for (IEditorPart p : dirtyEditors) {
                if (!(p.getEditorInput() instanceof URIEditorInput)) continue;
                map.put(((URIEditorInput)p.getEditorInput()).getURI(), p);
            }
            d.setInput(map.keySet());
            if (d.open() == 0) {
                final ArrayList<IEditorPart> editors = new ArrayList<IEditorPart>();
                Object[] objectArray = d.getResult();
                int duplicateID = objectArray.length;
                int ep = 0;
                while (ep < duplicateID) {
                    Object o = objectArray[ep];
                    editors.add((IEditorPart)map.get(o));
                    ++ep;
                }
                final IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                WorkspaceJob j = new WorkspaceJob(Messages.EnableDuplicateResourceHandler_3){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                for (IEditorPart p : editors) {
                                    page.saveEditor(p, false);
                                    page.closeEditor(p, false);
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                j.setSystem(true);
                j.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                j.schedule();
                try {
                    j.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                return null;
            }
        }
        cache.enableTrigger(false);
        ICacheService.IWorkspaceSynchronizer syncrhonizer = (ICacheService.IWorkspaceSynchronizer)E4InjectorHelper.getService(ICacheService.IWorkspaceSynchronizer.class);
        for (URI k : replacement.keySet()) {
            try {
                syncrhonizer.handleReplace(k, (URI)replacement.get(k));
            }
            catch (Exception ex) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.emf.uri", Messages.bind((String)Messages.EnableDuplicateResourceHandler_4, (Object[])new Object[]{k.toPlatformString(true), ((URI)replacement.get(k)).toPlatformString(true)}), (Throwable)ex));
            }
        }
        cache.enableTrigger(true);
        return null;
    }

    private class SaveDirtyDialog
    extends ListDialog {
        public SaveDirtyDialog(Shell parent) {
            super(parent);
            this.setTitle(Messages.EnableDuplicateResourceHandler_0);
            this.setMessage(Messages.EnableDuplicateResourceHandler_1);
            this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            this.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return URI.decode((String)((URI)element).trimFragment().toString());
                }

                public Image getImage(Object element) {
                    IEditorRegistry r;
                    ImageDescriptor d;
                    Image im = ((SaveDirtyDialog)SaveDirtyDialog.this).EnableDuplicateResourceHandler.this.registry.get(((URI)element).fileExtension());
                    if (im == null && (d = (r = PlatformUI.getWorkbench().getEditorRegistry()).getImageDescriptor(((URI)element).trimFragment().lastSegment())) != null) {
                        ((SaveDirtyDialog)SaveDirtyDialog.this).EnableDuplicateResourceHandler.this.registry.put(((URI)element).fileExtension(), d);
                        im = ((SaveDirtyDialog)SaveDirtyDialog.this).EnableDuplicateResourceHandler.this.registry.get(((URI)element).fileExtension());
                    }
                    return im;
                }
            });
        }

        protected int getTableStyle() {
            return super.getTableStyle() | 0x20;
        }

        protected void okPressed() {
            ArrayList<Object> res = new ArrayList<Object>();
            TableItem[] tableItemArray = this.getTableViewer().getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem it = tableItemArray[n2];
                if (it.getChecked()) {
                    res.add(it.getData());
                }
                ++n2;
            }
            super.okPressed();
            this.setResult(res);
        }
    }
}

