/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.internal;

import com.indy.emf.uri.CacheDecorator;
import com.indy.emf.uri.CacheUtil;
import com.indy.emf.uri.Messages;
import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.Constants;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IComponentService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.cache.ICacheState;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MarkerHelper {
    public static final MarkerHelper INSTANCE = new MarkerHelper();
    private Logger logger = LogManager.getLogger(MarkerHelper.class);
    XDIModelURIResolver modelResolver = (XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class);

    private MarkerHelper() {
    }

    public void destroyMarkers() {
        WorkspaceJob job = new WorkspaceJob(Messages.MarkerHelper_2){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("com.stambia.marker", true, 2);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker m = iMarkerArray[n2];
                    try {
                        m.delete();
                    }
                    catch (Exception ex) {
                        MarkerHelper.this.logger.error("Failed to delete marker on {}", (Object)m.getResource().getFullPath(), (Object)ex);
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStambiaMarkers() throws CoreException {
        IMarker m;
        IMarker[] sr;
        ICacheService cacheService;
        this.logger.info("Updating markers...");
        IMarker[] markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("com.stambia.marker", true, 2);
        HashSet<Object> changedResources = new HashSet<Object>();
        HashMap crossRefMap = null;
        HashMap unparsedResources = null;
        HashMap invalidXMLResources = null;
        HashMap withDuplicateIdXMLResources = null;
        Map<IResource, String[]> inactiveResources = null;
        ArrayList unbuildResources = null;
        ArrayList outdatedResource = null;
        List<IResource> duplicateResources = null;
        List<IResource> duplicatedResources = null;
        HashMap featureNotFoundResources = null;
        HashMap<URI, String> mandatoryMissingResources = null;
        HashMap discardedByLicense = null;
        ICacheService iCacheService = cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
        synchronized (iCacheService) {
            CacheInfo cacheInfo = new CacheInfo();
            ICacheState cacheState = cacheService.getCacheState();
            crossRefMap = new HashMap(cacheService.computeMissingCrossReferenceInfo());
            invalidXMLResources = new HashMap(cacheState.getInvalidXMLResources());
            withDuplicateIdXMLResources = new HashMap(cacheState.getXMLResourcesWithDuplicatedId());
            unparsedResources = new HashMap(cacheState.getUnparsedResources());
            unbuildResources = new ArrayList(cacheState.getUnbuiltResources());
            outdatedResource = new ArrayList(cacheState.getOutdatedResources());
            featureNotFoundResources = new HashMap(cacheState.getFeatureNotFoundResource());
            discardedByLicense = new HashMap(cacheState.getDiscardedByLicense());
            duplicateResources = cacheInfo.duplicateResource;
            duplicatedResources = cacheInfo.duplicatedResource;
            mandatoryMissingResources = new HashMap<URI, String>();
            inactiveResources = cacheInfo.inactiveResource;
            BundleContext ctx = Activator.getDefault().getBundle().getBundleContext();
            sr = ctx.getServiceReference(ICacheState.IBrokenSourceProvider.class);
            ICacheState.IBrokenSourceProvider brokenSourceProvider = null;
            if (sr != null) {
                brokenSourceProvider = (ICacheState.IBrokenSourceProvider)ctx.getService((ServiceReference)sr);
            }
            try {
                Set c;
                Set set = c = cacheState.getSourceWithBrokenRequirement();
                synchronized (set) {
                    for (URI s : c) {
                        if (!s.isPlatformResource()) continue;
                        mandatoryMissingResources.put(s, brokenSourceProvider == null ? Messages.MarkerHelper_3 : brokenSourceProvider.getSourceWithBrokenRequirementMessage(s));
                    }
                }
            }
            finally {
                if (sr != null) {
                    ctx.ungetService((ServiceReference)sr);
                    brokenSourceProvider = null;
                }
            }
        }
        crossRefMap.keySet().removeAll(duplicateResources.stream().map(r -> URIUtils.convertIPathToEMFURI2((IPath)r.getFullPath())).collect(Collectors.toList()));
        unbuildResources.removeAll(duplicateResources.stream().map(r -> URIUtils.convertIPathToEMFURI2((IPath)r.getFullPath())).collect(Collectors.toList()));
        ArrayList<IResource> restoredDuplicateMarkers = new ArrayList<IResource>();
        sr = markers;
        int ctx = markers.length;
        int cacheState = 0;
        while (cacheState < ctx) {
            IMarker iMarker = sr[cacheState];
            if (iMarker.exists()) {
                if (iMarker.getType().equals("com.stambia.resource.marker")) {
                    if (crossRefMap.get(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath())) == null) {
                        if (iMarker.getResource().exists()) {
                            changedResources.add(iMarker.getResource());
                            iMarker.delete();
                        }
                    } else {
                        if (iMarker.getResource().exists()) {
                            this.updateCrossRefMarker(iMarker, (ICacheService.MissingCrossReferenceInfo)crossRefMap.get(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath())));
                        }
                        crossRefMap.remove(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()));
                    }
                } else if (iMarker.getType().equals("com.stambia.resource.marker.invalidmodel")) {
                    if (unparsedResources.get(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath())) == null) {
                        if (iMarker.getResource().exists()) {
                            changedResources.add(iMarker.getResource());
                            iMarker.delete();
                        }
                    } else {
                        if (iMarker.getResource().exists()) {
                            this.updateInvalidModelMarker(iMarker, (ICacheState.IUnparsedResourceInfo)unparsedResources.get(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath())));
                        }
                        unparsedResources.remove(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()));
                    }
                } else if (iMarker.getType().equals("com.stambia.resource.marker.invalidXML")) {
                    if (invalidXMLResources.get(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath())) == null) {
                        if (iMarker.getResource().exists()) {
                            changedResources.add(iMarker.getResource());
                            iMarker.delete();
                        }
                    } else {
                        if (iMarker.getResource().exists()) {
                            this.updateInvalidModelMarker(iMarker, (ICacheState.IUnparsedResourceInfo)invalidXMLResources.get(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath())));
                        }
                        invalidXMLResources.remove(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()));
                    }
                } else if (iMarker.getType().equals("com.stambia.resource.marker.duplicateid")) {
                    if (withDuplicateIdXMLResources.get(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath())) == null) {
                        if (iMarker.getResource().exists()) {
                            changedResources.add(iMarker.getResource());
                            iMarker.delete();
                        }
                    } else {
                        if (iMarker.getResource().exists()) {
                            this.updateInvalidModelMarker(iMarker, (ICacheState.IUnparsedResourceInfo)withDuplicateIdXMLResources.get(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath())));
                        }
                        withDuplicateIdXMLResources.remove(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()));
                    }
                } else if (iMarker.getType().equals("com.stambia.resource.marker.invalidbuild")) {
                    if (!unbuildResources.contains(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()))) {
                        if (iMarker.getResource().exists()) {
                            changedResources.add(iMarker.getResource());
                            iMarker.delete();
                        }
                    } else {
                        unbuildResources.remove(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()));
                    }
                } else if (iMarker.getType().equals("com.stambia.resource.marker.outdatedmodel")) {
                    if (!outdatedResource.contains(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()))) {
                        if (iMarker.getResource().exists()) {
                            changedResources.add(iMarker.getResource());
                            iMarker.delete();
                        }
                    } else {
                        outdatedResource.remove(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()));
                    }
                } else if (iMarker.getType().equals("com.stambia.resource.marker.duplicate")) {
                    if (!duplicateResources.contains(iMarker.getResource())) {
                        changedResources.add(iMarker.getResource());
                        iMarker.delete();
                        iMarker.getResource().setPersistentProperty(CacheUtil.RESOURCE_PROPERTY_IS_DUPLICATE, null);
                    } else if (iMarker.getResource().getPersistentProperty(CacheUtil.RESOURCE_PROPERTY_IS_DUPLICATE) != null) {
                        duplicateResources.remove(iMarker.getResource());
                    } else {
                        restoredDuplicateMarkers.add(iMarker.getResource());
                    }
                } else if (iMarker.getType().equals("com.stambia.resource.marker.duplicated")) {
                    if (!duplicatedResources.contains(iMarker.getResource())) {
                        changedResources.add(iMarker.getResource());
                        iMarker.delete();
                        iMarker.getResource().setPersistentProperty(CacheUtil.RESOURCE_PROPERTY_HAS_DUPLICATE, null);
                    } else {
                        duplicatedResources.remove(iMarker.getResource());
                    }
                } else if (iMarker.getType().equals("com.stambia.resource.marker.brokenRequirement")) {
                    if (!mandatoryMissingResources.keySet().contains(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()))) {
                        if (iMarker.getResource().exists()) {
                            changedResources.add(iMarker.getResource());
                            iMarker.delete();
                        }
                    } else {
                        message = (String[])mandatoryMissingResources.get(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()));
                        if (!((String)message).equals(iMarker.getAttribute("message"))) {
                            iMarker.setAttribute("message", message);
                        }
                        mandatoryMissingResources.remove(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()));
                    }
                } else if (iMarker.getType().equals("com.stambia.resource.marker.inactive")) {
                    if (!inactiveResources.keySet().contains(iMarker.getResource())) {
                        if (iMarker.getResource().exists()) {
                            changedResources.add(iMarker.getResource());
                            iMarker.delete();
                            iMarker.getResource().setPersistentProperty(CacheUtil.RESOURCE_PROPERTY_ACTIVE_FILE_ID, null);
                        }
                    } else {
                        message = inactiveResources.get(iMarker.getResource());
                        if (!message[0].equals(iMarker.getAttribute("message"))) {
                            iMarker.setAttribute("message", (Object)message[0]);
                        }
                        if (!message[1].equals(iMarker.getAttribute("message"))) {
                            iMarker.getResource().setPersistentProperty(CacheUtil.RESOURCE_PROPERTY_ACTIVE_FILE_ID, (String)message[1]);
                        }
                        inactiveResources.remove(iMarker.getResource());
                    }
                } else if (iMarker.getType().equals("com.stambia.resource.marker.featureNotFound")) {
                    if (!featureNotFoundResources.keySet().contains(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()))) {
                        if (iMarker.getResource().exists()) {
                            changedResources.add(iMarker.getResource());
                            iMarker.delete();
                        }
                    } else {
                        message = (String)featureNotFoundResources.get(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()));
                        if (!((String)message).equals(iMarker.getAttribute("message"))) {
                            iMarker.setAttribute("message", message);
                        }
                        featureNotFoundResources.remove(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()));
                    }
                } else if (iMarker.getType().equals("com.semarchy.resource.marker.roleRequired")) {
                    if (!discardedByLicense.keySet().contains(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()))) {
                        if (iMarker.getResource().exists()) {
                            changedResources.add(iMarker.getResource());
                            iMarker.delete();
                        }
                    } else {
                        message = this.getRoleRequiredMessage((IComponentService.IComponent)discardedByLicense.get(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath())));
                        if (!((String)message).equals(iMarker.getAttribute("message"))) {
                            iMarker.setAttribute("message", message);
                        }
                        discardedByLicense.remove(URIUtils.convertIPathToEMFURI2((IPath)iMarker.getResource().getFullPath()));
                    }
                }
            }
            ++cacheState;
        }
        for (Map.Entry entry : crossRefMap.entrySet()) {
            if (!((URI)entry.getKey()).isPlatformResource() || !this.modelResolver.exists((URI)entry.getKey())) continue;
            IFile r2 = Util.convertEMFURIToFile((URI)((URI)entry.getKey()));
            m = r2.createMarker("com.stambia.resource.marker");
            m.setAttribute("severity", 2);
            m.setAttribute("message", (Object)((ICacheService.MissingCrossReferenceInfo)entry.getValue()).getMessage());
            m.setAttribute("location", (Object)((ICacheService.MissingCrossReferenceInfo)entry.getValue()).getLocation());
            m.setAttribute("com.indy.emf.uri.referenceId", (Object)((ICacheService.MissingCrossReferenceInfo)entry.getValue()).getAttributeId());
            changedResources.add(r2);
        }
        for (Map.Entry entry : invalidXMLResources.entrySet()) {
            if (!((URI)entry.getKey()).isPlatformResource() || !this.modelResolver.exists((URI)entry.getKey())) continue;
            IFile r3 = Util.convertEMFURIToFile((URI)((URI)entry.getKey()));
            m = r3.createMarker(((ICacheState.IUnparsedResourceInfo)entry.getValue()).getMarkerType());
            m.setAttribute("message", (Object)((ICacheState.IUnparsedResourceInfo)entry.getValue()).getMessage());
            m.setAttribute("severity", 1);
            m.setAttribute("location", (Object)((ICacheState.IUnparsedResourceInfo)entry.getValue()).getLocation());
            m.setAttribute("lineNumber", ((ICacheState.IUnparsedResourceInfo)entry.getValue()).getLine());
            m.setAttribute("priority", 1);
            changedResources.add(r3);
        }
        for (Map.Entry entry : withDuplicateIdXMLResources.entrySet()) {
            if (!((URI)entry.getKey()).isPlatformResource() || !this.modelResolver.exists((URI)entry.getKey())) continue;
            IFile r4 = Util.convertEMFURIToFile((URI)((URI)entry.getKey()));
            m = r4.createMarker(((ICacheState.IUnparsedResourceInfo)entry.getValue()).getMarkerType());
            m.setAttribute("message", (Object)((ICacheState.IUnparsedResourceInfo)entry.getValue()).getMessage());
            m.setAttribute("severity", 1);
            m.setAttribute("location", (Object)((ICacheState.IUnparsedResourceInfo)entry.getValue()).getLocation());
            m.setAttribute("lineNumber", ((ICacheState.IUnparsedResourceInfo)entry.getValue()).getLine());
            m.setAttribute("priority", 1);
            changedResources.add(r4);
        }
        for (Map.Entry entry : unparsedResources.entrySet()) {
            if (!((URI)entry.getKey()).isPlatformResource() || !this.modelResolver.exists((URI)entry.getKey())) continue;
            IFile r5 = Util.convertEMFURIToFile((URI)((URI)entry.getKey()));
            m = r5.createMarker("com.stambia.resource.marker.invalidmodel");
            if (((ICacheState.IUnparsedResourceInfo)entry.getValue()).isWarning()) {
                m.setAttribute("message", (Object)((ICacheState.IUnparsedResourceInfo)entry.getValue()).getMessage());
                m.setAttribute("severity", 1);
            } else {
                m.setAttribute("message", (Object)(Messages.MarkerHelper_4 + ((ICacheState.IUnparsedResourceInfo)entry.getValue()).getMessage()));
                m.setAttribute("severity", 2);
            }
            m.setAttribute("location", (Object)((ICacheState.IUnparsedResourceInfo)entry.getValue()).getLocation());
            m.setAttribute("lineNumber", ((ICacheState.IUnparsedResourceInfo)entry.getValue()).getLine());
            m.setAttribute("priority", 2);
            changedResources.add(r5);
        }
        for (URI uRI : unbuildResources) {
            if (!uRI.isPlatformResource() || !this.modelResolver.exists(uRI)) continue;
            IFile r6 = Util.convertEMFURIToFile((URI)uRI);
            m = r6.createMarker("com.stambia.resource.marker.invalidbuild");
            m.setAttribute("severity", 2);
            m.setAttribute("message", (Object)Messages.MarkerHelper_5);
            changedResources.add(r6);
        }
        for (URI uRI : outdatedResource) {
            if (!uRI.isPlatformResource() || !this.modelResolver.exists(uRI)) continue;
            IFile r7 = Util.convertEMFURIToFile((URI)uRI);
            m = r7.createMarker("com.stambia.resource.marker.outdatedmodel");
            m.setAttribute("severity", 1);
            m.setAttribute("message", (Object)Messages.MarkerHelper_6);
            changedResources.add(r7);
        }
        for (IResource iResource : duplicateResources) {
            if (!iResource.exists()) continue;
            iResource.setPersistentProperty(CacheUtil.RESOURCE_PROPERTY_IS_DUPLICATE, Boolean.TRUE.toString());
            if (!restoredDuplicateMarkers.contains(iResource)) {
                IMarker m2 = iResource.createMarker("com.stambia.resource.marker.duplicate");
                m2.setAttribute("severity", 0);
                m2.setAttribute("message", (Object)Messages.MarkerHelper_7);
            }
            changedResources.add(iResource);
        }
        for (IResource iResource : duplicatedResources) {
            if (!iResource.exists()) continue;
            iResource.setPersistentProperty(CacheUtil.RESOURCE_PROPERTY_HAS_DUPLICATE, Boolean.TRUE.toString());
            IMarker m3 = iResource.createMarker("com.stambia.resource.marker.duplicated");
            m3.setAttribute("severity", 0);
            m3.setAttribute("message", (Object)Messages.MarkerHelper_8);
            changedResources.add(iResource);
        }
        for (Map.Entry entry : mandatoryMissingResources.entrySet()) {
            if (!((URI)entry.getKey()).isPlatformResource() || !this.modelResolver.exists((URI)entry.getKey())) continue;
            IFile r9 = Util.convertEMFURIToFile((URI)((URI)entry.getKey()));
            m = r9.createMarker("com.stambia.resource.marker.brokenRequirement");
            m.setAttribute("severity", 2);
            m.setAttribute("message", mandatoryMissingResources.get(entry.getKey()));
            changedResources.add(r9);
        }
        for (Map.Entry<Object, Object> entry : inactiveResources.entrySet()) {
            if (!((IResource)entry.getKey()).exists()) continue;
            IMarker m4 = ((IResource)entry.getKey()).createMarker("com.stambia.resource.marker.inactive");
            m4.setAttribute("severity", 0);
            m4.setAttribute("message", (Object)((String[])entry.getValue())[0]);
            m4.getResource().setPersistentProperty(CacheUtil.RESOURCE_PROPERTY_ACTIVE_FILE_ID, ((String[])entry.getValue())[1]);
            changedResources.add((IResource)entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : featureNotFoundResources.entrySet()) {
            if (!((URI)entry.getKey()).isPlatformResource() || !this.modelResolver.exists((URI)entry.getKey())) continue;
            IFile r10 = Util.convertEMFURIToFile((URI)((URI)entry.getKey()));
            m = r10.createMarker("com.stambia.resource.marker.featureNotFound");
            m.setAttribute("severity", 1);
            m.setAttribute("message", featureNotFoundResources.get(entry.getKey()));
            changedResources.add(r10);
        }
        for (Map.Entry<Object, Object> entry : discardedByLicense.entrySet()) {
            if (!((URI)entry.getKey()).isPlatformResource() || !this.modelResolver.exists((URI)entry.getKey())) continue;
            IFile r11 = Util.convertEMFURIToFile((URI)((URI)entry.getKey()));
            m = r11.createMarker("com.semarchy.resource.marker.roleRequired");
            m.setAttribute("severity", 2);
            m.setAttribute("com.semarchy.resource.marker.roleRequired.role", (Object)((IComponentService.IComponent)entry.getValue()).getLabel());
            m.setAttribute("message", (Object)this.getRoleRequiredMessage((IComponentService.IComponent)entry.getValue()));
            changedResources.add(r11);
        }
        IResource[] iResourceArray = changedResources.toArray(new IResource[changedResources.size()]);
        for (CacheDecorator cd : CacheDecorator.cacheDecorator) {
            cd.fireProblemsChangedPublic(iResourceArray, true);
        }
        this.logger.info("Updated markers");
    }

    private String getRoleRequiredMessage(IComponentService.IComponent c) {
        return String.format(Messages.MarkerHelper_componentRoleMissing, c.getLabel());
    }

    private void updateInvalidModelMarker(IMarker marker, ICacheState.IUnparsedResourceInfo unparsedResourceInfo) throws CoreException {
        String oldLocation = (String)marker.getAttribute("location");
        int oldLine = (Integer)marker.getAttribute("lineNumber");
        int oldSeverity = (Integer)marker.getAttribute("severity");
        String oldMessage = (String)marker.getAttribute("message");
        Object newMessage = null;
        newMessage = unparsedResourceInfo.isWarning() ? unparsedResourceInfo.getMessage() : Messages.MarkerHelper_9 + unparsedResourceInfo.getMessage();
        if (!Constants.equals((Object)oldLocation, (Object)unparsedResourceInfo.getLocation())) {
            marker.setAttribute("location", (Object)unparsedResourceInfo.getLocation());
        }
        if (!Constants.equals((Object)oldLine, (Object)unparsedResourceInfo.getLine())) {
            marker.setAttribute("lineNumber", unparsedResourceInfo.getLine());
        }
        if (!Constants.equals((Object)oldSeverity, (Object)(unparsedResourceInfo.isWarning() ? 1 : 2))) {
            marker.setAttribute("severity", unparsedResourceInfo.isWarning() ? 1 : 2);
        }
        if (!Constants.equals((Object)oldMessage, (Object)newMessage)) {
            marker.setAttribute("message", newMessage);
        }
        if (!marker.getType().equals(unparsedResourceInfo.getMarkerType())) {
            marker.setAttribute("org.eclipse.core.resources.marker", (Object)unparsedResourceInfo.getMarkerType());
        }
    }

    private void updateCrossRefMarker(IMarker marker, ICacheService.MissingCrossReferenceInfo crossRefInfo) throws CoreException {
        String oldLocation = (String)marker.getAttribute("location");
        String oldId = (String)marker.getAttribute("com.indy.emf.uri.referenceId");
        String oldMessage = (String)marker.getAttribute("message");
        if (!Constants.equals((Object)oldLocation, (Object)crossRefInfo.getLocation())) {
            marker.setAttribute("location", (Object)crossRefInfo.getLocation());
        }
        if (!Constants.equals((Object)oldMessage, (Object)crossRefInfo.getMessage())) {
            marker.setAttribute("location", (Object)crossRefInfo.getMessage());
        }
        if (!Constants.equals((Object)oldId, (Object)crossRefInfo.getAttributeId())) {
            marker.setAttribute("com.indy.emf.uri.referenceId", (Object)crossRefInfo.getAttributeId());
        }
    }

    private class CacheInfo {
        Map<IResource, String[]> inactiveResource = new HashMap<IResource, String[]>();
        List<IResource> duplicateResource = new ArrayList<IResource>();
        List<IResource> duplicatedResource = new ArrayList<IResource>();

        CacheInfo() {
            ICacheService cache = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
            XDIModelURIResolver resolver = (XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class);
            for (URI u : cache.getAllResources()) {
                ICacheService.SourceState state = cache.getSourceState(u);
                String activeId = state.getRemark("com.indy.emf.uri.remark.udfActiveId");
                if (activeId != null && state.isSync() && resolver.exists(u)) {
                    URI currentActive = cache.findResourceURIByFileId(activeId);
                    Object message = "";
                    IFile f = null;
                    if (currentActive != null && currentActive.isPlatformResource()) {
                        f = Util.convertEMFURIToFile((URI)u);
                        message = Messages.MarkerHelper_1 + URIUtils.toPath((URI)currentActive).toString();
                    }
                    this.inactiveResource.put((IResource)f, new String[]{message, activeId});
                }
                IFile file = Util.convertEMFURIToFile((URI)u);
                if (state.hasDuplicate() && file != null && file.exists()) {
                    this.duplicatedResource.add((IResource)file);
                }
                if (!state.isDuplicate() || file == null || !file.exists()) continue;
                this.duplicateResource.add((IResource)file);
            }
        }
    }
}

