/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.internal;

import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={XDIModelURIResolver.class})
public class WorkspaceXDIModelURIResolver
implements XDIModelURIResolver {
    @Reference
    private IWorkspace workspace;
    private Logger logger = LogManager.getLogger(WorkspaceXDIModelURIResolver.class);

    File convertPlatformResourceUriToFile(URI uri) {
        Path path = new Path(uri.toPlatformString(true));
        if (path.segmentCount() == 1) {
            IProject p = (IProject)this.workspace.getRoot().findMember(path.toString());
            String filePath = p.getLocationURI().getPath();
            return new File(URI.decode((String)filePath));
        }
        IPath p = this.workspace.getRoot().getFile((IPath)path).getLocation();
        if (p != null) {
            String filePath = p.toFile().toURI().getPath();
            return new File(URI.decode((String)filePath));
        }
        return null;
    }

    URI normalizeUri(URI uri) {
        String fileID = CacheHelper.extractFileID((String)uri.fragment());
        if (fileID != null) {
            return ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(fileID);
        }
        return null;
    }

    public File resolve(URI uri) {
        File res = null;
        if (uri == null) {
            return null;
        }
        if (uri.isPlatformResource()) {
            res = this.convertPlatformResourceUriToFile(uri);
        } else {
            URI resolvedUri;
            if (uri.fragment() != null) {
                uri = this.normalizeUri(uri);
            }
            if (!(resolvedUri = CommonPlugin.resolve((URI)uri)).isHierarchical() || !"file".equals(resolvedUri.scheme())) {
                StringBuilder s = new StringBuilder();
                int i = 2;
                while (i < uri.segmentCount()) {
                    s.append("/");
                    s.append(URI.decode((String)uri.trimFragment().segment(i)));
                    ++i;
                }
                IPath p = Platform.getStateLocation((Bundle)Platform.getBundle((String)"com.semarchy.xdi.designer.index")).append("/internalResource").append("/" + s.toString());
                res = p.toFile();
            } else {
                StringBuilder s = new StringBuilder();
                if (resolvedUri.device() != null) {
                    s.append(resolvedUri.device());
                }
                s.append(Arrays.stream(resolvedUri.segments()).collect(Collectors.joining("/", "/", "")));
                res = new File(URI.decode((String)s.toString()));
            }
        }
        return res;
    }

    public List<URI> getAllModels() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            root.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            this.logger.error("unexpected error when refreshing workspace", (Throwable)e);
        }
        ArrayList<URI> res = new ArrayList<URI>();
        try {
            root.accept(r -> {
                switch (r.getType()) {
                    case 1: {
                        res.add(Util.convertIFileToEMFURI((IFile)((IFile)r)));
                        return true;
                    }
                    case 4: {
                        return r.getProject().isOpen();
                    }
                    case 2: {
                        return !"indy.diagram".equals(r.getName());
                    }
                }
                return true;
            });
        }
        catch (CoreException e) {
            this.logger.error("unexpected error when visiting workspace", (Throwable)e);
        }
        return res;
    }

    public ISchedulingRule createSchedulingRule(URI resourceURI) {
        IFile srcFile;
        if (resourceURI == null) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        IFile rule = srcFile = Util.convertEMFURIToFile((URI)resourceURI);
        if ("map".equals(resourceURI.fileExtension())) {
            URI procURI = URIUtils.getMappingBuiltProcFile((URI)resourceURI);
            IContainer buildFolder = Util.convertEMFURIToFile((URI)procURI).getParent();
            rule = MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)buildFolder);
            rule = MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)Util.convertEMFURIToFile((URI)resourceURI.trimFileExtension().appendFileExtension("map_ref")));
            IFolder projectBuildFolder = buildFolder.getProject().getFolder("indy.build");
            if (!(projectBuildFolder.exists() && projectBuildFolder.isLinked() && projectBuildFolder.getLocation().segment(0).equals(srcFile.getProject().getName()))) {
                rule = MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)projectBuildFolder.getProject());
            }
        }
        return rule;
    }

    public boolean exists(URI resourceURI) {
        File f = this.resolve(resourceURI);
        return f != null && f.isFile() && f.exists();
    }

    public void deleteResource(URI resourceURI) throws Exception {
        IFile f = Util.convertEMFURIToFile((URI)resourceURI);
        if (f.exists()) {
            f.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void refreshResurce(URI resourceURI) throws Exception {
        IFile f = Util.convertEMFURIToFile((URI)resourceURI);
        IFolder buildFolder = f.getProject().getFolder("indy.build");
        Path linkPath = new Path("WORKSPACE_LOC");
        linkPath = linkPath.append("/.indy.build");
        String projectName = f.getProject().getName();
        linkPath = linkPath.append(projectName);
        if (!(buildFolder.exists() && buildFolder.isLinked() && buildFolder.getLocation().lastSegment().equals(projectName))) {
            buildFolder.createLink((IPath)linkPath, 272, (IProgressMonitor)new NullProgressMonitor());
        }
        f.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
    }
}

