/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.internal.workspace;

import com.indy.emf.uri.internal.workspace.LinkedFileOperationBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

class DeleteOperation
implements LinkedFileOperationBuilder.Operation {
    private Logger logger = Logger.getLogger(DeleteOperation.class.getName());
    private Collection<IPath> allResources;
    private IWorkspace workspace;

    DeleteOperation(IWorkspace workspace, List<IPath> relatedFiles) {
        this.workspace = workspace;
        this.allResources = new ArrayList<IPath>(relatedFiles);
    }

    private void deleteFile(IFile f) {
        try {
            f.delete(true, null);
        }
        catch (CoreException e) {
            this.logger.log(Level.WARNING, e, () -> String.format("Failed to delete %s", f));
        }
    }

    @Override
    public void perform() {
        this.allResources.stream().map(p -> this.workspace.getRoot().getFile(p)).filter(f -> f != null && f.exists()).forEach(this::deleteFile);
    }

    @Override
    public ISchedulingRule getRule() {
        AtomicReference ruleRef = new AtomicReference();
        IResourceRuleFactory ruleFactory = this.workspace.getRuleFactory();
        this.allResources.stream().map(p -> this.workspace.getRoot().getFile(p)).forEach(f -> ruleRef.set(MultiRule.combine((ISchedulingRule)((ISchedulingRule)ruleRef.get()), (ISchedulingRule)ruleFactory.deleteRule((IResource)f))));
        return (ISchedulingRule)ruleRef.get();
    }
}

