/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.internal.workspace;

import com.indy.emf.uri.internal.workspace.LinkedFileOperationBuilder;
import com.indy.ui.custom.out.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

class MoveOperation
implements LinkedFileOperationBuilder.Operation {
    private Map<IPath, IPath> allResources = new TreeMap<IPath, IPath>((a, b) -> a.toString().compareTo(b.toString()));
    private IWorkspace workspace;
    private Logger logger = Logger.getLogger(MoveOperation.class.getName());

    MoveOperation(IWorkspace wksp, List<IPath> relatedFiles, IPath toPath) {
        this.workspace = wksp;
        for (IPath p : relatedFiles) {
            ArrayList<Object> segments = new ArrayList<Object>();
            int i = 0;
            while (i < toPath.segmentCount() - 1) {
                segments.add(toPath.segment(i));
                if (i == 0 && p.segment(i + 1).equals("indy.build")) {
                    segments.add("indy.build");
                }
                ++i;
            }
            if (p.getFileExtension().equals("map_diagram")) {
                segments.add("indy.diagram");
                segments.add("map");
            } else if (p.getFileExtension().equals("proc_diagram")) {
                segments.add("indy.diagram");
                segments.add("proc");
            }
            if (p.lastSegment().endsWith(".xdg.md")) {
                segments.add(toPath.removeFileExtension().lastSegment() + ".xdg.md");
            } else {
                segments.add(toPath.removeFileExtension().lastSegment() + "." + p.getFileExtension());
            }
            String pp = segments.stream().collect(Collectors.joining("/"));
            this.allResources.put(p, (IPath)new Path(pp));
        }
    }

    private void moveFile(IFile f, IPath destination) {
        if (f == null || !f.exists()) {
            return;
        }
        try {
            IFolder destinationFolder;
            if (destination.segment(1).equals("indy.build")) {
                Path buildFolder = new Path(destination.segment(0) + "/" + destination.segment(1));
                Util.checkLinkedBuildFolder((IFolder)this.workspace.getRoot().getFolder((IPath)buildFolder), null);
                IFolder destinationFolder2 = this.workspace.getRoot().getFolder(destination.removeLastSegments(1));
                if (!destinationFolder2.exists()) {
                    Util.mkDirRecursively((IPath)destinationFolder2.getFullPath(), (IProgressMonitor)new NullProgressMonitor());
                }
            }
            if (("map_diagram".equals(destination.getFileExtension()) || "proc_diagram".equals(destination.getFileExtension())) && !(destinationFolder = this.workspace.getRoot().getFolder(destination.removeLastSegments(1))).exists()) {
                Util.mkDirRecursively((IPath)destinationFolder.getFullPath(), (IProgressMonitor)new NullProgressMonitor());
            }
            f.move(destination, true, null);
        }
        catch (CoreException e) {
            this.logger.log(Level.WARNING, e, () -> String.format("Failed to move %s to %s", f, destination));
        }
    }

    @Override
    public void perform() {
        this.allResources.entrySet().stream().forEach(e -> this.moveFile(this.getFile((IPath)e.getKey()), this.getFile((IPath)e.getValue()).getFullPath()));
    }

    private IFile getFile(IPath p) {
        return this.workspace.getRoot().getFile(p);
    }

    @Override
    public ISchedulingRule getRule() {
        AtomicReference ruleRef = new AtomicReference();
        IResourceRuleFactory ruleFactory = this.workspace.getRuleFactory();
        this.allResources.entrySet().stream().filter(e -> this.getFile((IPath)e.getKey()).exists()).forEach(e -> ruleRef.set(MultiRule.combine((ISchedulingRule)((ISchedulingRule)ruleRef.get()), (ISchedulingRule)this.createMoveRule(ruleFactory, (IResource)this.getFile((IPath)e.getKey()), (IResource)this.getFile((IPath)e.getValue())))));
        return (ISchedulingRule)ruleRef.get();
    }

    private ISchedulingRule createMoveRule(IResourceRuleFactory ruleFactory, IResource source, IResource destination) {
        ISchedulingRule res = ruleFactory.moveRule(source, destination);
        if ("indy.build".equals(source.getFullPath().segment(1))) {
            res = MultiRule.combine((ISchedulingRule)res, (ISchedulingRule)ruleFactory.createRule((IResource)destination.getProject().getFolder("indy.build")));
        }
        return res;
    }
}

