/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.validation2;

import com.indy.emf.uri.CacheUtil;
import com.indy.emf.uri.Messages;
import com.indy.emf.uri.StatusListener;
import com.indy.emf.uri.ValidationStatus;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.preferences.license.HostInformation;
import com.semarchy.xdi.designer.preferences.license.License;
import com.semarchy.xdi.designer.preferences.license.LicenseOffline;
import com.semarchy.xdi.designer.preferences.license.LicenseServer;
import com.semarchy.xdi.designer.preferences.license.LicenseToleranceData;
import com.semarchy.xdi.designer.preferences.license.LicenseTrial;
import com.semarchy.xdi.designer.preferences.license.RegistryHelper;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;

public class Validation {
    public static final String ENV_XDI_DESIGNER_LICENSE_KEY = "XDI_DESIGNER_LICENSE_KEY";
    public static final String ENV_XDI_DESIGNER_LICENSE_SERVER_URL = "XDI_DESIGNER_LICENSE_SERVER_URL";
    public static final String ENV_XDI_DESIGNER_LICENSE_KEY_FILE = "XDI_DESIGNER_LICENSE_KEY_FILE";
    public static final String CENTRAL_LICENSE_SERVER_URL = "https://license-xdi.semarchy.com";
    public static Validation INSTANCE = new Validation();
    private static PrintStream printStream;
    private static MessageConsole precConsole;
    private HostInformation client = new HostInformation();
    private License license = null;
    private LicenseToleranceData toleranceData = new LicenseToleranceData();

    public HostInformation getClient() {
        return this.client;
    }

    public License getLicense() {
        return this.license;
    }

    public LicenseToleranceData getLicenseTimeData() {
        return this.toleranceData;
    }

    public Integer getRefreshDelay() {
        if (this.getLicense().getMode() == Mode.TRIAL) {
            return 18000000;
        }
        if (this.getLicense().getStatus() == ValidationStatus.TOLERANCE_END) {
            return 0;
        }
        return this.getLicenseTimeData().getRefreshDelay(this.getLicense().isInTolerance());
    }

    private void doCheckValitity() {
        License l = this.getLicense();
        ValidationStatus status = l.checkValidity(this.getLicenseTimeData());
        this.getLicenseTimeData().checkTolerance(l, status);
        RegistryHelper.INSTANCE.write(l);
        RegistryHelper.INSTANCE.write(this.getLicenseTimeData());
        this.getLicense().applyPermissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationStatus checkValidity() {
        this.doCheckValitity();
        ValidationStatus status = this.getLicense().getStatus();
        List<StatusListener> list = CacheUtil.getListeners();
        synchronized (list) {
            for (StatusListener listener : CacheUtil.getListeners()) {
                listener.statusChanged(status);
            }
        }
        return status;
    }

    public PrintStream getPrintStream() {
        MessageConsole console = Util.findConsole((String)"License Manager");
        if (precConsole != console && printStream != null) {
            printStream.close();
            printStream = null;
        }
        precConsole = console;
        if (printStream == null) {
            IOConsoleOutputStream out = null;
            out = console.newOutputStream();
            printStream = new PrintStream((OutputStream)out);
        }
        return printStream;
    }

    public void setEnv(Mode mode) {
        if (mode == null) {
            try {
                mode = Mode.valueOf(RegistryHelper.INSTANCE.read("LicenseMode"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mode == null) {
            mode = Mode.TRIAL;
            Mode modeFromEnvVariables = null;
            String licenseKey = System.getenv(ENV_XDI_DESIGNER_LICENSE_KEY);
            String licenseLocalServerURL = null;
            String licenseKeyFilePath = System.getenv(ENV_XDI_DESIGNER_LICENSE_KEY_FILE);
            if (licenseKey != null && !licenseKey.isEmpty()) {
                licenseLocalServerURL = System.getenv(ENV_XDI_DESIGNER_LICENSE_SERVER_URL);
                if (licenseLocalServerURL != null && !licenseLocalServerURL.isEmpty()) {
                    modeFromEnvVariables = Mode.LOCAL;
                } else {
                    licenseLocalServerURL = CENTRAL_LICENSE_SERVER_URL;
                    modeFromEnvVariables = Mode.ONLINE;
                }
            } else if (licenseKeyFilePath != null && !licenseKeyFilePath.isEmpty()) {
                modeFromEnvVariables = Mode.OFFLINE;
            }
            if (modeFromEnvVariables != null) {
                mode = modeFromEnvVariables;
            }
        }
        switch (mode) {
            case LOCAL: 
            case ONLINE: {
                this.license = new LicenseServer(mode);
                break;
            }
            case OFFLINE: {
                this.license = new LicenseOffline();
                break;
            }
            case TRIAL: {
                this.license = new LicenseTrial();
            }
        }
        this.toleranceData = new LicenseToleranceData();
    }

    public void restoreRegistryEnv() throws License.InvalidLicenseChecksumException {
        this.setEnv(null);
        if (this.license != null) {
            this.toleranceData.readFromRegistry();
            String checksum = this.license.readFromRegistry();
            this.license.validateChecksum(checksum, this.getLicenseTimeData());
            this.license.applyPermissions();
        }
    }

    public static enum Mode {
        OFFLINE(Messages.Validation_licenceModeLabel_offline),
        LOCAL(Messages.Validation_licenceModeLabel_local),
        ONLINE(Messages.Validation_licenceModeLabel_online),
        TRIAL(Messages.Validation_licenceModeLabel_trial);

        String label;

        private Mode(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

