/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.preferences.license;

import com.indy.emf.uri.Activator;
import com.indy.emf.uri.Messages;
import com.semarchy.xdi.designer.core.services.IDesignerVersionProvider;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class HostInformation {
    static boolean networkIssuesHasBeenLoged = false;
    private String hostName;
    private String hostAddress;
    private String macAdresses;
    private String jvm;
    private String os;
    private String version;

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    private void setListMacAddress() {
        StringBuilder list = new StringBuilder();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            int i = 1;
            while (interfaces.hasMoreElements()) {
                NetworkInterface interfaceN = null;
                try {
                    interfaceN = interfaces.nextElement();
                    byte[] b = interfaceN.getHardwareAddress();
                    StringBuilder result = new StringBuilder();
                    if (b != null) {
                        int j = 0;
                        while (j < b.length) {
                            result.append(String.format("%02X%s", b[j], j < b.length - 1 ? "-" : ""));
                            ++j;
                        }
                    }
                    if (result.length() == 17) {
                        list.append(result.toString());
                    }
                    ++i;
                }
                catch (Exception e1) {
                    String msg = interfaceN != null ? ", interface : " + interfaceN.getDisplayName() : "";
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.emf.uri", Messages.Validation_9 + msg, (Throwable)e1));
                }
            }
        }
        catch (SocketException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.emf.uri", Messages.Validation_10, (Throwable)e1));
        }
        this.macAdresses = list.toString();
    }

    public String getMacAdressesList() {
        return this.macAdresses;
    }

    public String getMacAddressesToDisplay() {
        return this.macAdresses.replaceAll("(.{17})", "$0 ").trim();
    }

    protected void setMacAddresses(String macAdrressesList) {
        this.macAdresses = macAdrressesList;
    }

    private boolean compareBytes(byte[] bytes1, byte[] bytes2) {
        if (bytes1 != null && bytes2 != null && bytes1.length == bytes2.length) {
            int i = 0;
            while (i < bytes1.length) {
                if (bytes1[i] != bytes2[i]) break;
                if (i == bytes1.length - 1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void refreshInformation() {
        this.setListMacAddress();
        IDesignerVersionProvider p = (IDesignerVersionProvider)E4InjectorHelper.getService(IDesignerVersionProvider.class);
        this.version = p.getInternalBuildVersion();
        this.setOs(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        this.setJvm(System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
    }

    public String findMacAdress(InetAddress inetAddress) throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        byte[] b = null;
        Object result = "";
        block0: while (interfaces.hasMoreElements()) {
            NetworkInterface interfaceN = interfaces.nextElement();
            Enumeration<InetAddress> en = interfaceN.getInetAddresses();
            while (en.hasMoreElements()) {
                InetAddress addr = en.nextElement();
                if (!this.compareBytes(addr.getAddress(), inetAddress.getAddress())) continue;
                b = interfaceN.getHardwareAddress();
                this.setLocalHostName(addr.getCanonicalHostName());
                this.setHostAddress(addr.getHostAddress());
                if (b == null) continue block0;
                int j = 0;
                while (j < b.length) {
                    result = (String)result + String.format("%02X%s", b[j], j < b.length - 1 ? "-" : "");
                    ++j;
                }
                continue block0;
            }
        }
        return result;
    }

    private void setJvm(String property) {
        this.jvm = property;
    }

    private void setOs(String string) {
        this.os = string;
    }

    public String getJvm() {
        return this.jvm;
    }

    public String getOs() {
        return this.os;
    }

    private void setLocalHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getVersion() {
        return this.version;
    }
}

