/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.json;

import com.indy.addons.json.JSONReverserUtils;
import com.stambia.md.Attribute;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdFactoryHelper;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;

public class JSONReverser {
    MdNode current = null;
    MdNode root = null;
    MdNode parent = null;
    int proof = 0;

    public MdNode reverse(InputStream is, String encoding) throws Exception {
        JSONReverserUtils.ReverseHandler rh = new JSONReverserUtils.ReverseHandler(){
            HashSet<MdNode> nullNodes = new HashSet();

            private boolean addNode(MdNode node, String name, boolean nullValue) throws Exception {
                node.setName(name);
                if (JSONReverser.this.current == null) {
                    if (JSONReverser.this.root != null) {
                        throw new Exception("Error root already exists");
                    }
                    ++JSONReverser.this.proof;
                    if (JSONReverser.this.parent.eContainer() == null) {
                        node.setSubstituteContainer((EObject)JSONReverser.this.parent);
                    } else {
                        node.setSubstituteContainer(JSONReverser.this.parent.eContainer());
                    }
                    JSONReverser.this.root = JSONReverser.this.current = node;
                    return false;
                }
                boolean exists = false;
                MdNode nullChildToReplace = null;
                for (MdNode child : JSONReverser.this.current.getNode()) {
                    if (!child.getName().equals(name)) continue;
                    if (nullValue) {
                        node = child;
                        exists = true;
                        break;
                    }
                    if (node.getDefType().equals(child.getDefType())) {
                        node = child;
                        exists = true;
                        break;
                    }
                    if (!this.nullNodes.contains(child)) continue;
                    exists = true;
                    nullChildToReplace = child;
                    break;
                }
                if (!exists) {
                    node.setPosition(BigInteger.valueOf(JSONReverser.this.current.getNode().size() + 1));
                    JSONReverser.this.current.getNode().add((Object)node);
                    if (nullValue) {
                        this.nullNodes.add(node);
                    }
                } else if (!nullValue && nullChildToReplace != null) {
                    node.setPosition(nullChildToReplace.getPosition());
                    int index = JSONReverser.this.current.getNode().indexOf(nullChildToReplace);
                    JSONReverser.this.current.getNode().set(index, (Object)node);
                    this.nullNodes.remove(nullChildToReplace);
                }
                JSONReverser.this.current = node;
                ++JSONReverser.this.proof;
                return exists;
            }

            @Override
            public boolean handleStartValue(String name, String type, int position) throws Exception {
                MdNode node = null;
                node = JSONReverser.this.current == null ? MdFactoryHelper.createMdNode((String)"com.stambia.json.rootValue") : MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
                boolean b = this.addNode(node, name, false);
                Attribute att = JSONReverser.this.current.getAttributeByShortCode("type");
                if (b && att == null || !b) {
                    if (att == null) {
                        att = MdFactory.eINSTANCE.createAttribute();
                        att.setDefType(node.getDefType() + ".type");
                        node.getAttribute().add((Object)att);
                    }
                    att.setValue(type);
                }
                return b;
            }

            @Override
            public boolean handleNullValue(String name, String type, int position) throws Exception {
                MdNode node = null;
                node = JSONReverser.this.current == null ? MdFactoryHelper.createMdNode((String)"com.stambia.json.rootValue") : MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
                boolean b = this.addNode(node, name, true);
                Attribute att = JSONReverser.this.current.getAttributeByShortCode("type");
                if (b && att == null || !b) {
                    if (att == null) {
                        att = MdFactory.eINSTANCE.createAttribute();
                        att.setDefType(node.getDefType() + ".type");
                        node.getAttribute().add((Object)att);
                    }
                    att.setValue(type);
                }
                return b;
            }

            @Override
            public boolean handleStartObject(String name, int position) throws Exception {
                MdNode node = null;
                node = JSONReverser.this.current == null ? MdFactoryHelper.createMdNode((String)"com.stambia.json.rootObject") : MdFactoryHelper.createMdNode((String)"com.stambia.json.object");
                return this.addNode(node, name, false);
            }

            @Override
            public boolean handleStartArray(String name, int position) throws Exception {
                MdNode node = null;
                node = JSONReverser.this.current == null ? MdFactoryHelper.createMdNode((String)"com.stambia.json.rootArray") : MdFactoryHelper.createMdNode((String)"com.stambia.json.array");
                return this.addNode(node, name, false);
            }

            @Override
            public void handleEndElement(String name) throws Exception {
                if (JSONReverser.this.current != null) {
                    if (!JSONReverser.this.current.getName().equals(name)) {
                        throw new Exception("close element: " + name + " doesn't match to current: " + JSONReverser.this.current.getName());
                    }
                    --JSONReverser.this.proof;
                } else {
                    throw new Exception("There is no node to close");
                }
                JSONReverser.this.current = (MdNode)JSONReverser.this.current.eContainer();
            }
        };
        JSONReverserUtils.reverseWithData(is, encoding, rh);
        return this.root;
    }

    public void setParentNode(MdNode node) {
        this.parent = node;
    }
}

