/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.json.actions;

import com.indy.addons.Messages;
import com.indy.addons.json.JSONReverser;
import com.indy.addons.json.JSONReverserUtils;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class ReverseJsonAction
implements IExecute {
    public static MdNode reverse(MdNode node, InputStream is, String encoding, boolean performIncrementalReverse, MdNode originalMdNode) throws Exception {
        JSONReverser jr = new JSONReverser();
        jr.setParentNode(node);
        MdNode _node = jr.reverse(is, encoding);
        if (!performIncrementalReverse) {
            return _node;
        }
        _node.setName(node.getName());
        if (node.getPosition() != null) {
            _node.setPosition(node.getPosition());
        }
        for (Attribute a : new ArrayList(node.copy(0).getAttribute())) {
            if (_node.getAttributeByFullCode(a.getDefType()) != null) continue;
            _node.getAttribute().add((Object)a);
        }
        HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
        reversedMap.put(_node, node);
        IncrementalReverser ir = new IncrementalReverser((EObject)originalMdNode, reversedMap, new ArrayList(), false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
        ir.reverse();
        if (node == null || _node == null || !node.getDefType().equals(_node.getDefType())) {
            if (TransactionUtil.getEditingDomain((EObject)node) != null) {
                node.setDefTypeWithTransaction(_node.getDefType());
            } else {
                node.setDefType(_node.getDefType());
            }
        }
        return _node;
    }

    public Object run(Object object, String configuration, Map<String, String> params) throws ExecuteException {
        MdNode node = (MdNode)object;
        ReverseJsonAction.reverse(node, 0, null, true);
        return null;
    }

    public static MdNode reverse(MdNode root, int mode, String data, boolean performIncrementalReverse) throws ExecuteException {
        return ReverseJsonAction.reverse(root, mode, data, performIncrementalReverse, root);
    }

    public static MdNode reverse(MdNode node, int mode, String data, boolean performIncrementalReverse, MdNode originalMdNode) throws ExecuteException {
        MdNode mdNode;
        block17: {
            String path = null;
            String urlPath = node.evaluate("@reverseURLPath");
            String filePath = node.evaluate("@reverseFilePath");
            if (mode == 0) {
                path = urlPath != null && !urlPath.isEmpty() ? urlPath : filePath;
                if (path == null || path.isEmpty()) {
                    throw new ExecuteException(Messages.ReverseJsonAction_2);
                }
            } else if (mode == 1) {
                path = urlPath;
                if (path == null || path.isEmpty()) {
                    throw new ExecuteException(Messages.ReverseJsonAction_3);
                }
            } else if (mode == 2 && ((path = filePath) == null || path.isEmpty())) {
                throw new ExecuteException(Messages.ReverseJsonAction_4);
            }
            if (mode != 3 && (path == null || path.isEmpty())) {
                throw new ExecuteException(Messages.ReverseJsonAction_5);
            }
            if (mode == 3 && (data == null || data.isEmpty())) {
                throw new ExecuteException(Messages.ReverseJsonAction_6);
            }
            String encoding = node.evaluateMdString("@encoding");
            if (encoding == null || encoding.isEmpty()) {
                encoding = "UTF-8";
            }
            InputStream is = null;
            try {
                is = mode == 3 ? new ByteArrayInputStream(data.getBytes()) : JSONReverserUtils.getInputStreamWithPath(path);
                mdNode = ReverseJsonAction.reverse(node, is, encoding, performIncrementalReverse, originalMdNode);
                if (is == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (e instanceof ExecuteException) {
                        throw (ExecuteException)e;
                    }
                    throw new ExecuteException(e);
                }
            }
            is.close();
        }
        return mdNode;
    }
}

