/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.xml;

import com.stambia.md.MdNode;
import com.stambia.md.util.MdFactoryHelper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.ecore.EObject;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlStreamReverser {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-DD");
    private final DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-DD hh:mm:ss");
    private final DateFormat timeFormat = new SimpleDateFormat("hh:mm:ss");
    private static final String DEF_ELEMENT = "com.stambia.xml.element";
    private static final String DEF_SEQUENCE = "com.stambia.xml.sequence";
    private static final String DEF_NAMESPACE = "com.stambia.xml.namespace";
    private static final String DEF_ATTRIBUTE = "com.stambia.xml.attribute";
    private static final String DEF_ROOT = "com.stambia.xml.root";
    private static final String PREFIX = "prefix";
    private static final String ORIGINAL_TYPE = "originalType";
    private static final String POSITION = "position";
    private static final String MIN_OCCURS = "minOccurs";
    private static final String MAX_OCCURS = "maxOccurs";
    private static final String TYPE = "type";
    DataType[][] MATRIX = new DataType[][]{{DataType.Boolean, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String}, {DataType.String, DataType.Date, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String}, {DataType.String, DataType.String, DataType.DateTime, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String}, {DataType.String, DataType.String, DataType.String, DataType.Time, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String}, {DataType.String, DataType.String, DataType.String, DataType.String, DataType.Byte, DataType.Integer, DataType.Long, DataType.Float, DataType.String}, {DataType.String, DataType.String, DataType.String, DataType.String, DataType.Integer, DataType.Integer, DataType.Long, DataType.Float, DataType.String}, {DataType.String, DataType.String, DataType.String, DataType.String, DataType.Long, DataType.Long, DataType.Long, DataType.Float, DataType.String}, {DataType.String, DataType.String, DataType.String, DataType.String, DataType.Float, DataType.Float, DataType.Float, DataType.Float, DataType.String}, {DataType.String, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String, DataType.String}};
    MdNode substiteContainer;
    private Map<String, String> namespacePrefix;

    public XmlStreamReverser(Map<String, String> namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public MdNode reverse(MdNode substiteContainer, InputStream xmlInputStream) throws Exception {
        this.substiteContainer = substiteContainer;
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        parserFactory.setFeature("http://xml.org/sax/features/validation", false);
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        XMLReader saxReader = parser.getXMLReader();
        SAXReverseContentHandler handler = new SAXReverseContentHandler();
        saxReader.setContentHandler(handler);
        BufferedReader reader = new BufferedReader(new InputStreamReader(xmlInputStream));
        InputSource source = new InputSource(reader);
        saxReader.parse(source);
        ((Reader)reader).close();
        handler.root.setSubstituteContainer(null);
        return handler.root;
    }

    static enum DataType {
        Boolean,
        Date,
        DateTime,
        Time,
        Byte,
        Integer,
        Long,
        Float,
        String;

    }

    private class SAXReverseContentHandler
    implements ContentHandler {
        private MdNode root;
        private Stack<MdNode> stack = new Stack();
        private MdNode current;

        private SAXReverseContentHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String nodePrefix;
            String nodeName = localName;
            String string = nodePrefix = qName.contains(":") ? qName.substring(0, qName.indexOf(":")) : null;
            if (nodePrefix != null) {
                nodeName = qName.substring(qName.indexOf(":") + 1);
            }
            MdNode node = null;
            if (this.root == null) {
                this.root = MdFactoryHelper.createMdNode((String)XmlStreamReverser.DEF_ROOT);
                this.root.setSubstituteContainer((EObject)XmlStreamReverser.this.substiteContainer);
                String prefix = this.handleNameSpace(uri, nodePrefix);
                if (!qName.isEmpty()) {
                    this.root.setAttribute(XmlStreamReverser.ORIGINAL_TYPE, (String)(prefix != null && !prefix.isEmpty() ? prefix + ":" + localName : localName), false);
                }
                this.root.setName(nodeName);
                node = this.root;
            } else {
                String prefix = this.handleNameSpace(uri, nodePrefix);
                MdNode currentContainer = this.current.getNodeByName(XmlStreamReverser.DEF_SEQUENCE, null);
                if (currentContainer == null) {
                    currentContainer = MdFactoryHelper.createMdNode((String)XmlStreamReverser.DEF_SEQUENCE);
                    this.current.getNode().add((Object)currentContainer);
                    currentContainer.setAttribute(XmlStreamReverser.POSITION, "0", false);
                }
                if ((node = currentContainer.getNodeByName(XmlStreamReverser.DEF_ELEMENT, nodeName)) != null) {
                    node.setAttribute(XmlStreamReverser.MAX_OCCURS, "-1", false);
                    this.handleAttributes(node, atts);
                } else {
                    node = MdFactoryHelper.createMdNode((String)XmlStreamReverser.DEF_ELEMENT);
                    node.setName(nodeName);
                    currentContainer.getNode().add((Object)node);
                    if (!qName.isEmpty()) {
                        node.setAttribute(XmlStreamReverser.ORIGINAL_TYPE, (String)(prefix != null && !prefix.isEmpty() ? prefix + ":" + localName : localName), false);
                    }
                    node.setAttribute(XmlStreamReverser.MIN_OCCURS, "0", false);
                    node.setAttribute(XmlStreamReverser.MAX_OCCURS, "1", false);
                    this.handleAttributes(node, atts);
                }
            }
            this.stack.push(node);
            this.current = node;
        }

        private void handleAttributes(MdNode node, Attributes atts) {
            int i = 0;
            while (i < atts.getLength()) {
                String aLocName = atts.getLocalName(i);
                String aPrefix = atts.getQName(i).contains(":") ? atts.getQName(i).substring(atts.getQName(i).indexOf(":") + 1) : null;
                String aURI = atts.getURI(i);
                if (aLocName.isEmpty()) {
                    aLocName = atts.getQName(i).substring(atts.getQName(i).indexOf(":") + 1);
                }
                String type = atts.getType(i);
                String value = atts.getValue(i);
                MdNode attribute = this.findAttribute(node, aLocName, aPrefix, aURI);
                if (attribute != null) {
                    this.updateAttributeType(attribute, type, value);
                } else {
                    attribute = MdFactoryHelper.createMdNode((String)XmlStreamReverser.DEF_ATTRIBUTE);
                    node.getNode().add((Object)attribute);
                    attribute.setName(aLocName);
                    attribute.setAttribute(XmlStreamReverser.TYPE, this.computeType(type, value), false);
                    int pos = node.getNodeByCode(XmlStreamReverser.DEF_ATTRIBUTE).size() - 1;
                    attribute.setAttribute(XmlStreamReverser.POSITION, "" + pos, false);
                }
                ++i;
            }
        }

        private void updateAttributeType(MdNode attribute, String type, String value) {
            String attType = this.computeType(type, value);
            DataType t1 = DataType.valueOf(attType.toUpperCase().charAt(0) + attType.substring(1));
            String s = attribute.getAttributeValueByShortCode(XmlStreamReverser.TYPE);
            DataType t2 = DataType.valueOf(s.toUpperCase().charAt(0) + s.substring(1));
            DataType converted = XmlStreamReverser.this.MATRIX[t1.ordinal()][t2.ordinal()];
            if (converted != t2) {
                attribute.setAttribute(XmlStreamReverser.TYPE, converted.name().toLowerCase().charAt(0) + converted.name().substring(1), false);
            }
        }

        private MdNode findAttribute(MdNode element, String name, String prefix, String uri) {
            return element.getNodeByName(XmlStreamReverser.DEF_ATTRIBUTE, name);
        }

        private String computeType(String type, String value) {
            if (type.equals("ID") || type.equals("IDREF") || type.equals("IDREFS") || type.equals("NOTATION")) {
                return type;
            }
            if (value.equals("true") || value.equals("false")) {
                return "boolean";
            }
            try {
                XmlStreamReverser.this.dateFormat.parse(value);
                return "date";
            }
            catch (Exception exception) {
                try {
                    XmlStreamReverser.this.dateTimeFormat.parse(value);
                    return "dateTime";
                }
                catch (Exception exception2) {
                    try {
                        XmlStreamReverser.this.timeFormat.parse(value);
                        return "time";
                    }
                    catch (Exception exception3) {
                        try {
                            Byte.parseByte(value);
                            return "byte";
                        }
                        catch (Exception exception4) {
                            try {
                                Integer.parseInt(value);
                                return "integer";
                            }
                            catch (Exception exception5) {
                                try {
                                    Long.parseLong(value);
                                    return "long";
                                }
                                catch (Exception exception6) {
                                    try {
                                        Float.parseFloat(value);
                                        return "float";
                                    }
                                    catch (Exception exception7) {
                                        return "string";
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        private String handleNameSpace(String aURI, String prefix) {
            String registeredPrefix;
            if (aURI.isEmpty()) {
                return null;
            }
            MdNode n = this.root.getNodeByName(XmlStreamReverser.DEF_NAMESPACE, aURI);
            if (n == null) {
                n = MdFactoryHelper.createMdNode((String)XmlStreamReverser.DEF_NAMESPACE);
                this.root.getNode().add((Object)n);
                n.setName(aURI);
            }
            if ((registeredPrefix = XmlStreamReverser.this.namespacePrefix.get(aURI)) == null) {
                String p = n.getAttributeValueByShortCode(XmlStreamReverser.PREFIX);
                if (p == null || p.isEmpty()) {
                    registeredPrefix = prefix;
                    n.setAttribute(XmlStreamReverser.PREFIX, registeredPrefix, false);
                } else {
                    registeredPrefix = p;
                }
            } else {
                n.setAttribute(XmlStreamReverser.PREFIX, registeredPrefix, false);
            }
            return registeredPrefix;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            MdNode n = this.stack.pop();
            this.current = n != this.root ? (MdNode)n.eContainer().eContainer() : null;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String value = new String(ch, start, length);
            if (!value.matches("\\s*")) {
                String type = this.computeType("", value);
                this.current.setAttribute(XmlStreamReverser.TYPE, type, false);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }
}

