/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.xml.wizard;

import com.indy.addons.xml.XmlUtil;
import com.indy.addons.xml.wizard.Messages;
import com.indy.addons.xml.wizard.XmlWizardControler;
import com.indy.md.ui.editor.ui.MdWizard;
import com.indy.runtime.json.JsonXmlEventReader;
import com.indy.ui.custom.out.patch.FileDialogPatch;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdAttributeNativeEvaluator;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public class XsdFromXmlWizard
extends MdWizard {
    private XmlWizardControler controler;
    private Button generateXsd;

    public void setNode(MdNode node) {
        this.controler = new XmlWizardControler(node);
    }

    public MdNode getNode() {
        return this.controler.getReversedMd();
    }

    public void addPages() {
        WizardPage page = null;
        page = new WizardPage("Xsd from xml"){

            public void setErrorMessage(String newMessage) {
                super.setErrorMessage(newMessage);
                XsdFromXmlWizard.this.generateXsd.setEnabled(newMessage == null);
            }

            private void updateErrorMessage() {
                if (XsdFromXmlWizard.this.controler.getBean().getXmlPath() == null || XsdFromXmlWizard.this.controler.getBean().getXmlPath().isEmpty()) {
                    this.setErrorMessage(Messages.XsdFromXmlWizard_1);
                } else if (XsdFromXmlWizard.this.controler.getBean().getXsdPath() == null || XsdFromXmlWizard.this.controler.getBean().getXsdPath().isEmpty()) {
                    this.setErrorMessage(Messages.XsdFromXmlWizard_2);
                } else {
                    File xmlFile = null;
                    try {
                        xmlFile = XsdFromXmlWizard.this.controler.getXMLFile();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (xmlFile == null || !xmlFile.exists() || !xmlFile.isFile()) {
                        this.setErrorMessage(Messages.XsdFromXmlWizard_3);
                    } else {
                        this.setErrorMessage(null);
                    }
                }
            }

            public void createControl(Composite parent) {
                Composite main = new Composite(parent, 0);
                main.setLayout((Layout)new GridLayout());
                Label l = new Label(main, 64);
                l.setLayoutData((Object)new GridData(4, 1, true, false));
                l.setText(Messages.XsdFromXmlWizard_4);
                Composite c = new Composite(main, 0);
                c.setLayoutData((Object)new GridData(4, 1, true, false));
                c.setLayout((Layout)new GridLayout(3, false));
                l = new Label(c, 0);
                l.setLayoutData((Object)new GridData());
                l.setText(Messages.XsdFromXmlWizard_5);
                final Text xmlPath = new Text(c, 2048);
                xmlPath.setLayoutData((Object)new GridData(4, 1, true, false));
                xmlPath.setToolTipText(Messages.XsdFromXmlWizard_6);
                Button browse = new Button(c, 8);
                browse.setLayoutData((Object)new GridData(3, 1, false, false));
                browse.setText("...");
                browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String file;
                        FileDialog fdlg = new FileDialog(this.getShell(), 4096);
                        fdlg.setFilterExtensions(new String[]{"*.xml", "*.*"});
                        String path = null;
                        try {
                            File f = (this).XsdFromXmlWizard.this.controler.getXMLFile();
                            if (f != null && f.getParentFile() != null) {
                                path = f.getParentFile().getAbsolutePath();
                            }
                        }
                        catch (Exception ex) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", Messages.XsdFromXmlWizard_8, (Throwable)ex), 5);
                            return;
                        }
                        if (path != null) {
                            fdlg.setFilterPath(path);
                        }
                        if ((file = fdlg.open()) != null) {
                            File xmlFile = new File(file);
                            try {
                                xmlPath.setText(MdAttributeNativeEvaluator.preserveNatuveEvaluationBlock((Configuration)XsdFromXmlWizard.this.getNode(), (String)(this).XsdFromXmlWizard.this.controler.getBean().getXmlPath(), (String)xmlFile.getAbsolutePath()));
                            }
                            catch (Exception ex) {
                                xmlPath.setText(xmlFile.getAbsolutePath());
                            }
                        }
                    }
                });
                l = new Label(c, 0);
                l.setLayoutData((Object)new GridData());
                l.setText(Messages.XsdFromXmlWizard_9);
                final Text xsdPath = new Text(c, 2048);
                xsdPath.setLayoutData((Object)new GridData(4, 1, true, false));
                xsdPath.setToolTipText(Messages.XsdFromXmlWizard_10);
                browse = new Button(c, 8);
                browse.setLayoutData((Object)new GridData(3, 1, false, false));
                browse.setText("...");
                browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FileDialog fdlg = new FileDialog(this.getShell(), 8192);
                        fdlg.setFilterExtensions(new String[]{"*.xsd", "*.*"});
                        String path = null;
                        try {
                            File f = (this).XsdFromXmlWizard.this.controler.getXSDFile();
                            if (f != null) {
                                path = f.getParentFile().getAbsolutePath();
                            }
                        }
                        catch (Exception ex) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", Messages.XsdFromXmlWizard_12, (Throwable)ex), 5);
                            return;
                        }
                        if (path != null) {
                            fdlg.setFilterPath(path);
                        }
                        String file = fdlg.open();
                        if ((file = FileDialogPatch.addFileExtensionIfRequired((String)file, (FileDialog)fdlg)) != null) {
                            File xsdFile = new File(file);
                            try {
                                xsdPath.setText(MdAttributeNativeEvaluator.preserveNatuveEvaluationBlock((Configuration)XsdFromXmlWizard.this.getNode(), (String)(this).XsdFromXmlWizard.this.controler.getBean().getXmlPath(), (String)xsdFile.getAbsolutePath()));
                            }
                            catch (Exception ex) {
                                xsdPath.setText(xsdFile.getAbsolutePath());
                            }
                        }
                    }
                });
                XsdFromXmlWizard.this.generateXsd = new Button(main, 8);
                XsdFromXmlWizard.this.generateXsd.setLayoutData((Object)new GridData(2, 3, true, false));
                XsdFromXmlWizard.this.generateXsd.setText(Messages.XsdFromXmlWizard_13);
                final Label l1 = new Label(main, 64);
                l1.setLayoutData((Object)new GridData(4, 3, true, false));
                XsdFromXmlWizard.this.generateXsd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            File xsdFile = (this).XsdFromXmlWizard.this.controler.getXSDFile();
                            if (xsdFile == null) {
                                throw new Exception(Messages.XsdFromXmlWizard_14);
                            }
                            File xmlFile = (this).XsdFromXmlWizard.this.controler.getXMLFile();
                            if (xsdFile.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.XsdFromXmlWizard_15, (String)Messages.XsdFromXmlWizard_16)) {
                                l1.setText("");
                                return;
                            }
                            XmlUtil.xmlToXsd(xmlFile.getAbsolutePath(), xsdFile.getAbsolutePath(), null, (this).XsdFromXmlWizard.this.controler.getBean().isUseJsonFormat(), JsonXmlEventReader.ArrayMode.ARRAY_ITEM_TAG);
                            l1.setVisible(true);
                            l1.setText(Messages.XsdFromXmlWizard_18 + xsdFile.getAbsolutePath());
                        }
                        catch (Exception ex) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", Messages.XsdFromXmlWizard_19, (Throwable)ex), 5);
                            l1.setText("");
                        }
                    }
                });
                this.setControl((Control)main);
                xsdPath.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        (this).XsdFromXmlWizard.this.controler.getBean().setXsdPath(xsdPath.getText());
                        this.updateErrorMessage();
                    }
                });
                xmlPath.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        (this).XsdFromXmlWizard.this.controler.getBean().setXmlPath(xmlPath.getText());
                        this.updateErrorMessage();
                    }
                });
                xmlPath.setText(XsdFromXmlWizard.this.controler.getBean().getXmlPath());
                xsdPath.setText(XsdFromXmlWizard.this.controler.getBean().getXsdPath());
            }
        };
        this.addPage((IWizardPage)page);
        page.setTitle(Messages.XsdFromXmlWizard_21);
        this.setWindowTitle(Messages.XsdFromXmlWizard_22);
    }

    public boolean performFinish() {
        return true;
    }
}

