/*
 * Decompiled with CFR 0.152.
 */
package com.indy.jdbc.editor.connection;

import com.indy.addons.Messages;
import com.indy.engine.core.module.IModuleService;
import com.indy.jdbc.editor.connection.ConnectionBean;
import com.indy.jdbc.editor.connection.ConnectionController;
import com.indy.libraries.management.ui.wizard.ModuleWizard;
import com.stambia.md.MdNode;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class ConnectionDialog
extends TitleAreaDialog {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private String title;
    private String message;
    ConnectionController linker;
    private Text name;
    private Text login;
    private Text password;
    private Composite authentificationComposite;
    private CCombo module;
    private CCombo driver;
    private CCombo url;
    private Button autoCommit;
    private Label connectedStatus;
    private Button connect;
    private Button disconnect;

    public ConnectionDialog(Shell parentShell, String title, String message, MdNode mdNode) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.linker = new ConnectionController(mdNode);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.title != null) {
            this.setTitle(this.title);
        }
        if (this.message != null) {
            this.setMessage(this.message);
        }
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionDialog.this.linker.applyChanges();
            }
        });
    }

    public Control createDialog(Composite parent) {
        return this.createDialogArea(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Composite nameGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 10;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        nameGroup.setLayoutData((Object)data);
        Label label = new Label(nameGroup, 64);
        label.setText(Messages.ConnectionDialog_0);
        this.name = new Text(nameGroup, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.name.setLayoutData((Object)data);
        Label label3 = new Label(nameGroup, 64);
        label3.setText(Messages.ConnectionDialog_1);
        this.module = new CCombo(nameGroup, 2048);
        List<String> l = this.linker.getModuleNames();
        this.module.setItems(l.toArray(new String[l.size()]));
        data = new GridData(4, 1, true, false);
        this.module.setLayoutData((Object)data);
        Button create = new Button(nameGroup, 8);
        create.setText(Messages.ConnectionDialog_2);
        create.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String module = ConnectionDialog.this.linker.getBean().getModule();
                IModuleService.IModule m = null;
                try {
                    m = ((IModuleService)PlatformUI.getWorkbench().getService(IModuleService.class)).getModule(module);
                }
                catch (Exception ex) {
                    LogManager.getLogger(((Object)((Object)this)).getClass()).warn("Error while getting module {}", (Object)module, (Object)ex);
                }
                ModuleWizard z = new ModuleWizard(ConnectionDialog.this.linker.getBean().getModuleFilters(), m == null ? null : m.getDescriptor(), false, false);
                WizardDialog d = new WizardDialog(ConnectionDialog.this.getShell(), (IWizard)z);
                d.setPageSize(800, 600);
                if (d.open() == 0) {
                    try {
                        List<String> l = ConnectionDialog.this.linker.getModuleNames();
                        ConnectionDialog.this.module.setItems(l.toArray(new String[l.size()]));
                        ConnectionDialog.this.module.setText(z.getResult().getName());
                        ConnectionDialog.this.linker.getBean().setModule(z.getResult().getName());
                        ConnectionDialog.this.module.notifyListeners(13, new Event());
                        ConnectionDialog.this.handleChange();
                    }
                    catch (Exception ex) {
                        MessageDialog.openError((Shell)ConnectionDialog.this.getShell(), (String)"Create Module", (String)("Failed to create the modole : " + ex.getMessage()));
                    }
                }
            }
        });
        Label label2 = new Label(nameGroup, 64);
        label2.setText(Messages.ConnectionDialog_3);
        this.driver = new CCombo(nameGroup, 2052);
        GridData gd_driver = new GridData(4, 1, true, false, 2, 1);
        gd_driver.widthHint = 250;
        this.driver.setLayoutData((Object)gd_driver);
        label3 = new Label(nameGroup, 64);
        label3.setText(Messages.ConnectionDialog_4);
        this.url = new CCombo(nameGroup, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.url.setLayoutData((Object)data);
        new Label(nameGroup, 0);
        Composite connectionPropertiesComposite = new Composite(nameGroup, 0);
        connectionPropertiesComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        connectionPropertiesComposite.setLayout((Layout)gridLayout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        connectionPropertiesComposite.setLayoutData((Object)data);
        this.authentificationComposite = new Composite(nameGroup, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.authentificationComposite.setLayout((Layout)gridLayout);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        this.authentificationComposite.setLayoutData((Object)data);
        Label label4 = new Label(this.authentificationComposite, 64);
        label4.setText(Messages.ConnectionDialog_5);
        this.login = new Text(this.authentificationComposite, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.login.setLayoutData((Object)data);
        Label label5 = new Label(this.authentificationComposite, 64);
        label5.setText(Messages.ConnectionDialog_6);
        this.password = new Text(this.authentificationComposite, 2048);
        this.password.setEchoChar('*');
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 250;
        this.password.setLayoutData((Object)data);
        new Label(nameGroup, 0);
        connectionPropertiesComposite = new Composite(nameGroup, 0);
        connectionPropertiesComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        connectionPropertiesComposite.setLayout((Layout)gridLayout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        connectionPropertiesComposite.setLayoutData((Object)data);
        this.autoCommit = new Button(connectionPropertiesComposite, 32);
        this.autoCommit.setToolTipText(Messages.ConnectionDialog_7);
        this.autoCommit.setText(Messages.ConnectionDialog_8);
        data = new GridData(158, -1);
        this.autoCommit.setLayoutData((Object)data);
        Composite connectionGroup = new Composite(parentComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 250;
        connectionGroup.setLayout((Layout)layout);
        data = new GridData(4, 0x1000000, true, false);
        connectionGroup.setLayoutData((Object)data);
        this.connectedStatus = new Label(connectionGroup, 0);
        this.connectedStatus.setText(Messages.CreateAliasDlg2_0);
        this.connect = new Button(connectionGroup, 0);
        data = new GridData(158, -1);
        this.connect.setLayoutData((Object)data);
        this.connect.setText(Messages.CreateAliasDlg2_1);
        this.disconnect = new Button(connectionGroup, 0);
        data = new GridData(158, -1);
        this.disconnect.setLayoutData((Object)data);
        this.disconnect.setText(Messages.CreateAliasDlg2_2);
        this.disconnect.setEnabled(false);
        this.hookListeners();
        return composite;
    }

    private void hookListeners() {
        List<String> l = this.linker.getDriverNames();
        if (l.isEmpty()) {
            l.add(this.linker.getBean().getDefaultProductDriver());
        }
        this.driver.setItems(l.toArray(new String[l.size()]));
        DataBindingContext ctx = new DataBindingContext();
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)this.name);
        IObservableValue model = PojoProperties.value(ConnectionBean.class, (String)"name").observe((Object)this.linker.getBean());
        ctx.bindValue((IObservableValue)target, model);
        target = WidgetProperties.buttonSelection().observe((Widget)this.autoCommit);
        model = PojoProperties.value(ConnectionBean.class, (String)"autoCommit").observe((Object)this.linker.getBean());
        ctx.bindValue((IObservableValue)target, model);
        target = WidgetProperties.text().observe((Widget)this.module);
        model = PojoProperties.value(ConnectionBean.class, (String)"module").observe((Object)this.linker.getBean());
        ctx.bindValue((IObservableValue)target, model);
        target = WidgetProperties.ccomboSelection().observe((Widget)this.module);
        model = PojoProperties.value(ConnectionBean.class, (String)"module").observe((Object)this.linker.getBean());
        ctx.bindValue((IObservableValue)target, model);
        target = WidgetProperties.text().observe((Widget)this.driver);
        model = PojoProperties.value(ConnectionBean.class, (String)"driver").observe((Object)this.linker.getBean());
        ctx.bindValue((IObservableValue)target, model);
        this.module.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<String> l = ConnectionDialog.this.linker.getDriverNames();
                if (l.isEmpty()) {
                    l.add(ConnectionDialog.this.linker.getBean().getDefaultProductDriver());
                }
                ConnectionDialog.this.driver.setItems(l.toArray(new String[l.size()]));
                ConnectionDialog.this.driver.select(0);
            }
        });
        SelectionAdapter refreshURLListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionDialog.this.url.removeAll();
                List<String> l = ConnectionDialog.this.linker.getSampleURL(ConnectionDialog.this.module.getText(), ConnectionDialog.this.driver.getText());
                if (l.isEmpty()) {
                    l.add(ConnectionDialog.this.linker.getBean().getDefaultProductUrl());
                }
                ConnectionDialog.this.url.setItems(l.toArray(new String[l.size()]));
                ConnectionDialog.this.url.select(0);
            }
        };
        this.driver.addSelectionListener((SelectionListener)refreshURLListener);
        this.module.addSelectionListener((SelectionListener)refreshURLListener);
        target = WidgetProperties.ccomboSelection().observe((Widget)this.driver);
        model = PojoProperties.value(ConnectionBean.class, (String)"driver").observe((Object)this.linker.getBean());
        ctx.bindValue((IObservableValue)target, model);
        target = WidgetProperties.text((int)24).observe((Widget)this.login);
        model = PojoProperties.value(ConnectionBean.class, (String)"login").observe((Object)this.linker.getBean());
        ctx.bindValue((IObservableValue)target, model);
        target = WidgetProperties.text((int)24).observe((Widget)this.password);
        model = PojoProperties.value(ConnectionBean.class, (String)"password").observe((Object)this.linker.getBean());
        ctx.bindValue((IObservableValue)target, model);
        target = WidgetProperties.text().observe((Widget)this.url);
        model = PojoProperties.value(ConnectionBean.class, (String)"url").observe((Object)this.linker.getBean());
        ctx.bindValue((IObservableValue)target, model);
        target = WidgetProperties.ccomboSelection().observe((Widget)this.url);
        model = PojoProperties.value(ConnectionBean.class, (String)"url").observe((Object)this.linker.getBean());
        ctx.bindValue((IObservableValue)target, model);
        this.connect.addSelectionListener((SelectionListener)new SelectionAdapter(){
            int state = 0;
            Throwable exception = null;

            public void widgetSelected(SelectionEvent e) {
                this.state = 0;
                this.exception = null;
                try {
                    new ProgressMonitorDialog(ConnectionDialog.this.getShell()).run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                (this).ConnectionDialog.this.linker.connect();
                                state = 1;
                            }
                            catch (Exception e1) {
                                exception = e1;
                                state = -1;
                            }
                        }
                    });
                }
                catch (Exception e1) {
                    if (e1 instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.state = -1;
                    this.exception = e1;
                }
                if (this.state == 1) {
                    ConnectionDialog.this.handleConnectionOk();
                    ConnectionDialog.this.connectedStatus.setText(Messages.CreateAliasDlg2_7);
                    ConnectionDialog.this.disconnect.setEnabled(true);
                    ConnectionDialog.this.connect.setEnabled(false);
                } else if (this.state == -1) {
                    ConnectionDialog.this.connectedStatus.setText(Messages.CreateAliasDlg2_8);
                    StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", this.exception.getMessage(), this.exception.getCause() == null ? this.exception : this.exception.getCause()), 7);
                }
            }
        });
        this.disconnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Connection connection = ConnectionDialog.this.getController().getConnection();
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    ConnectionDialog.this.connectedStatus.setText(Messages.CreateAliasDlg2_3);
                    ConnectionDialog.this.disconnect.setEnabled(false);
                    ConnectionDialog.this.connect.setEnabled(true);
                    ConnectionDialog.this.handleDisconnectionOk();
                }
                catch (Exception e1) {
                    ConnectionDialog.this.connectedStatus.setText(Messages.CreateAliasDlg2_4);
                    StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", Messages.ConnectionDialog_19, (Throwable)e1), 7);
                }
            }
        });
        IChangeListener changeListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                ConnectionDialog.this.handleChange();
            }
        };
        for (Binding b : ctx.getBindings()) {
            b.getModel().addChangeListener(changeListener);
        }
        changeListener.handleChange(new ChangeEvent((IObservable)model));
    }

    private void handleChange() {
        try {
            this.linker.validate();
            this.setErrorMessage(null);
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.getMessage());
        }
    }

    public boolean close() {
        this.linker.dispose();
        return super.close();
    }

    public ConnectionController getController() {
        return this.linker;
    }

    protected void handleConnectionOk() {
    }

    protected void handleDisconnectionOk() {
    }

    public void hideAuthentificationArea() {
        this.authentificationComposite.setVisible(false);
        ((GridData)this.authentificationComposite.getLayoutData()).exclude = true;
    }

    public void resetUrl(String rawUrl, String evaluatedUrl) {
        if (this.url != null) {
            this.url.removeAll();
            this.url.add(rawUrl);
            this.url.select(0);
            this.linker.getBean().setUrl(evaluatedUrl);
        }
    }
}

