/*
 * Decompiled with CFR 0.152.
 */
package com.indy.jdbc.wizard;

import com.indy.addons.Messages;
import com.indy.addons.ScrolledCompositeWizardHelper;
import com.indy.jdbc.MdReverserNode;
import com.indy.jdbc.composite.SchemaDatastoreReverserComposite;
import com.indy.jdbc.composite.SchemaProperties1Composite;
import com.indy.jdbc.editor.JDBCHelper;
import com.indy.jdbc.wizard.MessageConsoleReverseListener;
import com.indy.jdbc.wizard.SelectiveWizardPage;
import com.indy.md.ui.editor.reverse.MdDiffNodeUI;
import com.indy.md.ui.editor.ui.MdWizard;
import com.indy.md.ui.editor.ui.MdWizardPage;
import com.indy.ui.custom.out.Util;
import com.stambia.md.MdNode;
import com.stambia.md.MdRootNode;
import com.stambia.md.custom.AttributeRefResolver;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.ReverseEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.MessageConsole;

public class SchemaWizard
extends MdWizard {
    private SchemaDatastoreReverserComposite compositeDataStore;
    private SchemaProperties1Composite composite;
    private IWizardPage schemaDatastorePage;
    private SelectiveWizardPage selectivePage;
    private Connection conn;
    private Map<String, Boolean> reverseOptions = new HashMap<String, Boolean>();
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public void addPages() {
        this.reverseOptions.put("com.stambia.rdbms.datastore", true);
        this.setWindowTitle(Messages.SchemaWizard_0);
        this.setNeedsProgressMonitor(true);
        MdWizardPage page1 = new MdWizardPage(Messages.SchemaWizard_1, this.getNode()){

            public void createControl(Composite parent) {
                ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite(parent);
                SchemaWizard.this.composite = new SchemaProperties1Composite((Composite)scrolled, 0, true){

                    @Override
                    public Connection getConnection() {
                        if ((this).SchemaWizard.this.conn == null) {
                            try {
                                (this).SchemaWizard.this.conn = JDBCHelper.INSTANCE.createJDBCConnection(this.getNode());
                                this.handleConnectionChanged();
                            }
                            catch (Exception e) {
                                (this).SchemaWizard.this.logger.warn("unexpected", (Throwable)e);
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.SchemaWizard_2, (String)e.getMessage());
                            }
                        }
                        return (this).SchemaWizard.this.conn;
                    }

                    @Override
                    public MdNode getSchema() {
                        return this.getNode();
                    }

                    @Override
                    public void handleIsComplete(boolean complete) {
                        this.setPageComplete(complete);
                    }

                    @Override
                    public void handleConnectionChanged() {
                        (this).SchemaWizard.this.compositeDataStore.createReverseOptionsControls();
                    }
                };
                ScrolledCompositeWizardHelper.adaptToContent(scrolled, SchemaWizard.this.composite);
                this.setControl((Control)scrolled);
            }
        };
        page1.setTitle(Messages.SchemaWizard_3);
        page1.setDescription(Messages.SchemaWizard_4);
        this.addPage((IWizardPage)page1);
        this.schemaDatastorePage = new MdWizardPage(Messages.SchemaWizard_5, this.getNode()){

            public void createControl(Composite parent) {
                ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite(parent);
                SchemaWizard.this.compositeDataStore = new SchemaDatastoreReverserComposite((Composite)scrolled, 0){

                    @Override
                    public Connection getConnection() {
                        return (this).SchemaWizard.this.composite.getConnection();
                    }

                    @Override
                    public MdNode getSchema() {
                        return (this).SchemaWizard.this.composite.getSchema();
                    }

                    @Override
                    protected MdNode getServer() {
                        return this.getNode();
                    }

                    @Override
                    public void handePageComplete(boolean b) {
                        (this).SchemaWizard.this.compositeDataStore.setRefreshButtonAlreadyClicked(false);
                    }

                    @Override
                    public void handleEvent() {
                    }
                };
                ScrolledCompositeWizardHelper.adaptToContent(scrolled, SchemaWizard.this.compositeDataStore);
                this.setControl((Control)scrolled);
                SchemaWizard.this.selectivePage.setCompositeDataStore(SchemaWizard.this.compositeDataStore);
            }
        };
        this.schemaDatastorePage.setTitle(Messages.SchemaWizard_6);
        this.schemaDatastorePage.setDescription(Messages.SchemaWizard_7);
        this.addPage(this.schemaDatastorePage);
        this.selectivePage = new SelectiveWizardPage(Messages.MDWizard_1, this.getNode());
        this.selectivePage.setDescription(Messages.MDWizard_1);
        this.selectivePage.setTitle(Messages.MDWizard_2);
        this.addPage((IWizardPage)this.selectivePage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        MessageConsole console = Util.findConsole((String)"Reverse");
        console.activate();
        MessageConsoleReverseListener listener = new MessageConsoleReverseListener(console){

            @Override
            public String getMessage(ReverseEvent event) {
                return "Reverse " + event.objectType + " : " + String.valueOf(event.data);
            }
        };
        try {
            if (this.selectivePage != this.getContainer().getCurrentPage()) {
                if (this.schemaDatastorePage != this.getContainer().getCurrentPage()) return true;
                final MdReverserNode reverser = this.compositeDataStore.reverse(listener);
                MdReverserNode.ReverseJob job = new MdReverserNode.ReverseJob(null){

                    protected IStatus run(IProgressMonitor monitor) {
                        this.startJob();
                        try {
                            try {
                                reverser.performReverse(monitor);
                            }
                            catch (Exception ex) {
                                Status status = new Status(4, "com.indy.addons", Messages.SchemaWizard_14 + SchemaWizard.this.getNode().getFullPath(false), (Throwable)ex);
                                SchemaWizard.this.closeConnection();
                                this.stopJob();
                                return status;
                            }
                        }
                        finally {
                            SchemaWizard.this.closeConnection();
                            this.stopJob();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
                return true;
            }
            if (!this.handleDiffViewerCheckState()) {
                return false;
            }
            MdNode originalServiceNode = this.getNode();
            while (!(originalServiceNode instanceof MdRootNode)) {
                originalServiceNode = (MdNode)originalServiceNode.eContainer();
            }
            ArrayList<String> toDelete = new ArrayList<String>();
            for (Map.Entry<String, Boolean> e : this.reverseOptions.entrySet()) {
                if (e.getValue() != Boolean.TRUE) continue;
                toDelete.add(e.getKey());
            }
            HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
            MdDiffNodeUI.DiffState diffState = this.selectivePage.computeDiffState(null, toDelete);
            MdNode newNode = diffState.getResultingMdNode();
            if (newNode != null) {
                reversedMap.put(newNode, this.getNode());
            }
            AttributeRefResolver attributeRefResolver = this.selectivePage.getAttributeRefResolver();
            HashMap reverseModes = new HashMap();
            IncrementalReverser ir = new IncrementalReverser((EObject)originalServiceNode, reversedMap, Collections.emptyList(), true, attributeRefResolver, this.reverseOptions, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, reverseModes, this.isCreation());
            ir.reverse();
            return true;
        }
        catch (Exception e) {
            this.logger.warn("Unexpected", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SchemaWizard_13, (String)e.getMessage());
            return false;
        }
    }

    protected boolean handleDiffViewerCheckState() {
        MessageDialog dialog;
        return this.selectivePage.getCheckedElementsCount() != 0 || (dialog = new MessageDialog(this.getShell(), Messages.SchemaWizard_0, null, Messages.SchemaWizard_8, 5, new String[]{Messages.SchemaWizard_9, Messages.SchemaWizard_10}, 0)).open() != 1;
    }

    public boolean performCancel() {
        this.closeConnection();
        return super.performCancel();
    }

    private void closeConnection() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                this.logger.warn("Exception while closing connection", (Throwable)e);
            }
        }
    }
}

