/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.rdbms;

import com.indy.libraries.build.parser.sql.RemoveAndRestoreVarTags;
import com.indy.libraries.build.utils.ParsingUtils;
import com.indy.libraries.build.utils.StringUtils;
import com.stambia.md.Configuration;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class PatternUtil {
    private static final Logger logger = LogManager.getLogger(PatternUtil.class);

    private PatternUtil() {
    }

    public static String pattern(Configuration node, String pattern) {
        return PatternUtil.pattern(pattern, p -> {
            String[] list;
            String[] stringArray = list = StringUtils.motifList((String)p, (String)"\\{[^}]*\\}");
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                String evaluatedValue = null;
                try {
                    evaluatedValue = node.evaluateMdString(code);
                }
                catch (XPathExpressionException e) {
                    logger.error("Failed to evaluate pattern {}", (Object)code, (Object)e);
                }
                String value = evaluatedValue != null ? evaluatedValue : "";
                String tmp = value.toString();
                p = StringUtils.replaceAll((String)p, (String)("\\{" + ParsingUtils.replaceRegexpString((String)code) + "\\}"), (String)tmp);
                ++n2;
            }
            return p;
        });
    }

    private static String pattern(String pattern, UnaryOperator<String> patternFunction) {
        if (pattern == null || pattern.isEmpty()) {
            return pattern;
        }
        RemoveAndRestoreVarTags rarsc = new RemoveAndRestoreVarTags(pattern);
        pattern = rarsc.remove();
        String startAcc = "\u00a4\u20ac\u20ac\u00a4";
        String endAcc = "\u00a4\u00a3\u00a3\u00a4";
        pattern = pattern.replace("{{", startAcc);
        pattern = pattern.replace("}}", endAcc);
        pattern = (String)patternFunction.apply(pattern);
        pattern = rarsc.restore(pattern);
        pattern = pattern.replace(startAcc, "{");
        pattern = pattern.replace(endAcc, "}");
        return pattern;
    }

    public static String pattern2(String pattern, List<String> codes) {
        return PatternUtil.pattern(pattern, p -> {
            String[] list2;
            String[] stringArray = list2 = StringUtils.motifList((String)p, (String)":\\{[^}]*\\}:");
            int n = list2.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                codes.add(code.substring(1, code.length() - 1));
                ++n2;
            }
            for (String code : codes) {
                p = StringUtils.replaceAll((String)p, (String)String.format(":\\{%s\\}:", ParsingUtils.replaceRegexpString((String)code)), (String)"?");
            }
            return p;
        });
    }
}

