/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.rdbms;

import com.indy.engine.common.scripting.StbScriptEngineManager;
import com.indy.md.rdbms.Messages;
import com.indy.md.rdbms.Xml2MdConverter;
import com.stambia.md.Attribute;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.custom.Util;
import com.stambia.md.presentation.MdEditorPlugin;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.ecore.EObject;

class ScriptEngineReverseAPI {
    public void reverseWithScript(List<ReverseScript> queryScript, List<MdNode> result) throws Exception {
        try {
            if (!queryScript.isEmpty()) {
                for (MdNode node : result) {
                    this.visitMdNodeForScriptReverse(node, queryScript);
                }
            }
        }
        catch (ScriptException e) {
            MdEditorPlugin.getPlugin().getLog().warn(Messages.ScriptEngineReverseAPI_4, (Throwable)e);
        }
    }

    private void visitMdNodeForScriptReverse(MdNode current, List<ReverseScript> queryScript) throws Exception {
        for (ReverseScript rs : queryScript) {
            if (!rs.levels.contains(current.getDefType())) continue;
            rs.execute(current);
        }
        for (MdNode child : current.getNode()) {
            this.visitMdNodeForScriptReverse(child, queryScript);
        }
    }

    static enum ATTRIBUTE_MATCH_MODE {
        ADD_ATTRIBUTE_REVERSE_MODE,
        ADD_ATTRIBUTE_CODE_MODE,
        ADD_ATTRIBUTE_DISPLAY_MODE,
        ADD_ATTRIBUTE_XML_NAME_MODE;

    }

    public static final class NodeWrapper {
        MdNode node;
        MdNode realNode;

        public NodeWrapper(MdNode realNode2) {
            this.realNode = realNode2;
        }

        public NodeWrapper setAttributeValue(String code, String value) {
            this.addStringAttribute(this.node, value, code, ATTRIBUTE_MATCH_MODE.ADD_ATTRIBUTE_XML_NAME_MODE);
            return this;
        }

        public void copyAttributes() {
            for (Attribute a : this.realNode.getAttribute()) {
                this.addStringAttribute(this.node, a.getValue(), a.getDefType(), ATTRIBUTE_MATCH_MODE.ADD_ATTRIBUTE_CODE_MODE);
            }
        }

        public String evaluateXpath(String expression) throws XPathExpressionException {
            String string;
            EObject oldSubstitute = null;
            try {
                if (this.node.eContainer() == null) {
                    oldSubstitute = this.node.getSubstituteContainer();
                    this.node.setSubstituteContainer(this.realNode.eContainer());
                }
                string = this.node.evaluate(expression);
            }
            catch (Throwable throwable) {
                this.node.setSubstituteContainer(oldSubstitute);
                throw throwable;
            }
            this.node.setSubstituteContainer(oldSubstitute);
            return string;
        }

        public String evaluateXpathOnRealNode(String expression) throws XPathExpressionException {
            return this.realNode.evaluate(expression);
        }

        public NodeWrapper reverseWithXml(InputStream xmlStream) throws Exception {
            Xml2MdConverter xm = new Xml2MdConverter();
            xm.convert(xmlStream, this.node, this.node.getLevel());
            return this;
        }

        public NodeWrapper getParent() {
            NodeWrapper nw = new NodeWrapper(this.realNode);
            nw.node = (MdNode)this.node.eContainer();
            return nw;
        }

        public NodeWrapper createNode(String level, String name) {
            MdNode mdnode = MdFactoryHelper.createMdNode((String)level);
            this.node.getNode().add((Object)mdnode);
            mdnode.setName(name);
            NodeWrapper nw = new NodeWrapper(this.realNode);
            nw.node = mdnode;
            return nw;
        }

        private void addStringAttribute(MdNode paramNode, String value, String type, ATTRIBUTE_MATCH_MODE mode) {
            if (paramNode != null) {
                Level internalLevel = paramNode.getLevel(this.realNode.getSubstituteResource());
                if (value != null && type != null) {
                    List<Property> props = null;
                    Property property = null;
                    if (internalLevel != null) {
                        switch (mode) {
                            case ADD_ATTRIBUTE_REVERSE_MODE: {
                                props = Util.getPropertyByReverseCode((Level)internalLevel, (String)type);
                                break;
                            }
                            case ADD_ATTRIBUTE_CODE_MODE: {
                                property = Util.getPropertyByCode((Level)internalLevel, (String)type);
                                break;
                            }
                            case ADD_ATTRIBUTE_DISPLAY_MODE: {
                                property = Util.getPropertyByDisplayName((Level)internalLevel, (String)type);
                                break;
                            }
                            case ADD_ATTRIBUTE_XML_NAME_MODE: {
                                property = Util.getPropertyByXmlName((Level)internalLevel, (String)type);
                            }
                        }
                    }
                    if (props == null) {
                        props = new ArrayList();
                        if (property != null) {
                            props.add(property);
                        }
                    }
                    for (Property prop : props) {
                        Attribute attr = paramNode.getAttributeByFullCode(prop.getFullCode());
                        if (attr == null) {
                            attr = MdFactory.eINSTANCE.createAttribute();
                            attr.setDefType(prop.getFullCode());
                            paramNode.getAttribute().add((Object)attr);
                        }
                        if (prop.isUnbounded()) {
                            attr.getValues().add((Object)value);
                            continue;
                        }
                        attr.setValue(value);
                    }
                }
            }
        }
    }

    public static final class ReverseScript {
        public List<String> levels = new ArrayList<String>();
        public String language;
        public String script;
        MdNode realNode;
        Connection jdbcConnection;
        ScriptEngine engine;

        public ReverseScript(MdNode realNode, Connection jdbcConnection) {
            this.realNode = realNode;
            this.jdbcConnection = jdbcConnection;
        }

        void init(MdNode node) {
            if (this.engine == null) {
                StbScriptEngineManager sem = new StbScriptEngineManager(ScriptEngineReverseAPI.class.getClassLoader());
                this.engine = sem.getEngineByName(this.language);
            }
            Bindings bindings = this.engine.getContext().getBindings(100);
            NodeWrapper nw = new NodeWrapper(this.realNode);
            nw.node = node;
            bindings.put("__node__", (Object)nw);
            bindings.put("__connection__", (Object)this.jdbcConnection);
        }

        void execute(MdNode node) throws ScriptException {
            this.init(node);
            this.engine.eval(this.script);
        }
    }
}

