/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command.impl;

import com.indy.engine.command.impl.InternalEngineCommandsI;
import com.indy.engine.command.impl.Messages;
import com.indy.engine.command.impl.RuntimeCommand;
import com.indy.engine.common.command.parser.CommandLine;
import com.indy.engine.common.command.parser.CommandLineParser;
import com.indy.engine.common.command.parser.CommandParameter;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.ParameterType;
import com.indy.engine.core.delivery.IDeliveryExecutor;
import com.indy.engine.core.delivery.impl.DeliveryCommandLineExecutor;
import java.io.PrintStream;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;

@CommandLine(startWith="execute delivery", removeString="execute", usage="execute delivery <delivery>  [var <path> <value>] [var ...] [configuration <configuration>] [sessionName <sessionName>] [synch [format %<columnName>[,<%columnName2>...]]] [repository <repository>] [logLevel <logLevel>] [returnCodePath <returnCodePath>] [standalone]", description="execute the given delivery")
public class ExecuteDeliveryCommand
implements RuntimeCommand {
    @CommandParameter(name="delivery", required=true)
    public String delivery;
    @CommandParameter(name="synch")
    public Boolean synch;
    @CommandParameter(name="format")
    public String format;
    @CommandParameter(name="var", parameters={"name", "value"})
    public List<Map<String, String>> vars;
    @CommandParameter(name="configuration", valueSample="DEV", usage="Configuration code")
    public String configuration;
    @CommandParameter(name="sessionName")
    public String sessName;
    @CommandParameter(name="repository")
    public String repository;
    @CommandParameter(name="logLevel")
    public String logLevel;
    @CommandParameter(name="mode")
    public ExecutionMode executionMode;
    @CommandParameter(name="returnCodePath")
    public String returnCodePath;

    public String toString() {
        return "ExecuteDeliveryCommand [delivery=" + this.delivery + ", synch=" + String.valueOf(this.synch) + ", vars=" + String.valueOf(this.vars) + ", sessionName=" + this.sessName + ", repository=" + this.repository + ", logLevel=" + this.logLevel + " , executionMode=" + String.valueOf((Object)this.executionMode) + ", returnCodePath=" + this.returnCodePath + "]";
    }

    @Override
    public void execute(IEngineClient engineAPI, PrintStream out, Map<String, Object> ctx) throws Exception {
        block17: {
            if (this.executionMode == ExecutionMode.standalone) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", this.delivery);
                map.put("dir", this.repository);
                if (engineAPI.existDelivery(map)) {
                    this.executeCL(engineAPI, out, ctx);
                } else {
                    out.println(Messages.getString("ExecuteDeliveryCommand.0") + this.delivery + Messages.getString("ExecuteDeliveryCommand.1"));
                    ctx.put("returnCode", -1);
                }
                return;
            }
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", this.delivery);
                map.put("dir", this.repository);
                if (engineAPI.existDelivery(map)) {
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("launchMode", "ENGINE_COMMAND");
                    parameters.put("executionMode", "MEMORY");
                    parameters.put("guestHost", InetAddress.getLocalHost().getHostName());
                    parameters.put("synch", this.isSynch());
                    parameters.put("sessName", this.sessName);
                    parameters.put("repository", this.repository);
                    parameters.put("logLevel", this.logLevel);
                    if (this.vars != null) {
                        HashMap<String, String> variables = new HashMap<String, String>();
                        for (Map<String, String> var : this.vars) {
                            variables.put(var.get("name"), var.get("value"));
                        }
                        parameters.put("variables", variables);
                    }
                    if (this.configuration != null) {
                        parameters.put(ParameterType.configuration.name(), this.configuration);
                    }
                    String id = engineAPI.executeDelivery(this.delivery, parameters);
                    if (this.isSynch()) {
                        try {
                            HashMap<String, String> parameters2 = new HashMap<String, String>();
                            parameters2.put("sessionId", id);
                            parameters2.put("returnCodePath", this.returnCodePath);
                            parameters2.put("deliveryName", this.delivery);
                            Map ret = engineAPI.waitSession(parameters2);
                            if (ctx != null) {
                                ctx.put("lastExecutionDeliveryReturnCode", ret.get("returnCode"));
                            }
                            if (this.format != null) {
                                this.format(id, engineAPI, out);
                                break block17;
                            }
                            out.println(ret.get("returnCode"));
                        }
                        catch (Exception e) {
                            out.println(Messages.getString("ExecuteDeliveryCommand.6") + this.delivery + Messages.getString("ExecuteDeliveryCommand.5") + id + " " + e.getMessage());
                            LogManager.getLogger(this.getClass());
                        }
                        break block17;
                    }
                    if (this.format != null) {
                        this.format(id, engineAPI, out);
                    } else {
                        out.println(id);
                    }
                    break block17;
                }
                out.println(Messages.getString("ExecuteDeliveryCommand.4") + this.delivery + Messages.getString("ExecuteDeliveryCommand.3"));
                ctx.put("returnCode", -1);
            }
            catch (Exception e) {
                if (ctx != null) {
                    ctx.put("returnCode", -1);
                }
                throw new Exception(String.format(Messages.getString("ExecuteDeliveryCommand.2"), this.delivery, e.getMessage()), e);
            }
        }
    }

    protected void format(String id, IEngineClient engineAPI, PrintStream out) throws Exception {
        Map session = engineAPI.getSessionInfo(id);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Map<String, InternalEngineCommandsI.Column> columns = InternalEngineCommandsI.createSessionsColumns(this.format != null && this.format.contains("errormessage"));
        InternalEngineCommandsI.fillSessionsColumns(columns, session, sdf, engineAPI);
        out.println(InternalEngineCommandsI.formatList2(columns, this.format));
    }

    protected boolean isSynch() {
        return this.synch != null && this.synch != false;
    }

    public static void main(String[] args) throws Exception {
        CommandLineParser parser = new CommandLineParser();
        Object o = parser.parse("execute delivery main var key1 value1 synch var key2 value2");
        if (o instanceof RuntimeCommand) {
            ((RuntimeCommand)o).execute(null, System.out, null);
        }
    }

    private void executeCL(IEngineClient engineAPI, PrintStream out, Map<String, Object> ctx) throws Exception {
        DeliveryCommandLineExecutor dcle = new DeliveryCommandLineExecutor();
        IDeliveryExecutor.IConfiguration conf = IDeliveryExecutor.createConfiguration();
        conf.setConfiguration(this.configuration);
        conf.setDeliveryName(this.delivery);
        conf.setRepository(this.repository);
        conf.setSessionName(this.sessName);
        conf.setLaunchMode("ENGINE_COMMAND");
        conf.setSynch(this.isSynch());
        if (this.vars != null) {
            for (Map<String, String> var : this.vars) {
                conf.addVariable(var.get("name"), var.get("value"));
            }
        }
        IDeliveryExecutor.IResponse response = dcle.execute(conf);
        if (this.format != null) {
            Map session = null;
            int total = 0;
            do {
                session = engineAPI.getSessionInfo(response.getSessionId());
                Thread.sleep(100L);
            } while (session == null && (total += 100) < 10000);
            if (session == null) {
                out.println(Messages.getString("ExecuteDeliveryCommand.7") + response.getSessionId());
            } else {
                this.format(response.getSessionId(), engineAPI, out);
            }
        } else if (this.isSynch()) {
            out.println(response.getRetCode());
        } else {
            out.println(response.getSessionId());
        }
    }

    public static enum ExecutionMode {
        standalone,
        memory;

    }
}

