/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command.impl;

import com.indy.engine.command.impl.InternalEngineCommandsI;
import com.indy.engine.command.impl.RuntimeCommand;
import com.indy.engine.common.command.parser.CommandLine;
import com.indy.engine.common.command.parser.CommandParameter;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.objects2.EngineScheduleDetail;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CommandLine(startWith="get schedules", removeString="get schedules", usage="get schedules [name <name1,name2,namen>] [format <format>]", description="Get list of schedules on scheduler")
public class GetSchedules
implements RuntimeCommand {
    @CommandParameter(name="name", valueSample="scheduleName", usage="Schedule name")
    public String name;
    @CommandParameter(name="format", valueSample="format", usage="format")
    public String format;

    @Override
    public void execute(IEngineClient engineAPI, PrintStream out, Map<String, Object> ctx) throws Exception {
        List<String> names = this.name != null ? Arrays.asList(this.name.split(",")) : Collections.EMPTY_LIST;
        HashMap<String, InternalEngineCommandsI.Column> columns = new HashMap<String, InternalEngineCommandsI.Column>();
        int position = 0;
        columns.put("scheduleName", new InternalEngineCommandsI.Column(position++, "Schedule Name", 0));
        columns.put("name", new InternalEngineCommandsI.Column(position++, "Trigger Name", 0));
        columns.put("deliveryname", new InternalEngineCommandsI.Column(position++, "Delivery Name", 0));
        columns.put("cronexpression", new InternalEngineCommandsI.Column(position++, "Cron Expression", 0));
        columns.put("executiontype", new InternalEngineCommandsI.Column(position++, "Execution Type", 0));
        columns.put("starttime", new InternalEngineCommandsI.Column(position++, "Start Time", 0));
        columns.put("endtime", new InternalEngineCommandsI.Column(position++, "End Time", 0));
        columns.put("nextexecution", new InternalEngineCommandsI.Column(position++, "Next Execution Time", 0));
        columns.put("purgesize", new InternalEngineCommandsI.Column(position++, "Purge Size", 0));
        columns.put("purgeunit", new InternalEngineCommandsI.Column(position++, "Purge Unit", 0));
        columns.put("jobname", new InternalEngineCommandsI.Column(position++, "Job Name", 0));
        columns.put("triggerstate", new InternalEngineCommandsI.Column(position++, "State", 0));
        columns.put("logLevel", new InternalEngineCommandsI.Column(position++, "Log Level", 0));
        List schedules = engineAPI.getLstSchedules(null);
        for (Map scheduleMap : schedules) {
            EngineScheduleDetail esd = new EngineScheduleDetail(scheduleMap);
            if (this.name != null && !this.name.isEmpty()) {
                if ((esd.getScheduleName() == null || !names.contains(esd.getScheduleName())) && !names.contains(esd.getTriggerName())) continue;
                this.addRow(columns, esd);
                continue;
            }
            this.addRow(columns, esd);
        }
        out.println(InternalEngineCommandsI.formatList2(columns, this.format));
    }

    private void addRow(Map<String, InternalEngineCommandsI.Column> columns, EngineScheduleDetail detail) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        columns.get((Object)"jobname").datas.add(detail.getJobName());
        columns.get((Object)"name").datas.add(detail.getTriggerName());
        columns.get((Object)"scheduleName").datas.add(detail.getScheduleName());
        columns.get((Object)"deliveryname").datas.add(detail.getDeliveryName());
        columns.get((Object)"cronexpression").datas.add(detail.getCronExpression());
        columns.get((Object)"executiontype").datas.add(String.valueOf(detail.getExecutionType()));
        if (detail.getStartTime() != null) {
            columns.get((Object)"starttime").datas.add(sdf.format(detail.getStartTime()));
        } else {
            columns.get((Object)"starttime").datas.add("");
        }
        if (detail.getEndTime() != null) {
            columns.get((Object)"endtime").datas.add(sdf.format(detail.getEndTime()));
        } else {
            columns.get((Object)"endtime").datas.add("");
        }
        if (detail.getNextExecution() != null) {
            columns.get((Object)"nextexecution").datas.add(sdf.format(detail.getNextExecution()));
        } else {
            columns.get((Object)"nextexecution").datas.add("");
        }
        columns.get((Object)"triggerstate").datas.add(detail.getTriggerState());
        columns.get((Object)"purgesize").datas.add(detail.getPurgeSize());
        columns.get((Object)"purgeunit").datas.add(detail.getPurgeUnit());
        columns.get((Object)"logLevel").datas.add(detail.getLogLevel());
    }
}

