/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command.impl;

import com.indy.engine.command.impl.InternalEngineCommandsI;
import com.indy.engine.command.impl.Messages;
import com.indy.engine.command.impl.RuntimeCommand;
import com.indy.engine.common.command.parser.CommandLine;
import com.indy.engine.common.command.parser.CommandParameter;
import com.indy.engine.core.IEngineClient;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

@CommandLine(startWith="wait session", removeString="wait", usage="wait session <id> [format %<columnName>[,<%columnName2>...]]", description="Wait until the running session <id> returns")
public class WaitSessionCommand
implements RuntimeCommand {
    @CommandParameter(name="session", valueSample="sessionId", usage="Session ID")
    public String sessId;
    @CommandParameter(name="format")
    public String format;

    @Override
    public void execute(IEngineClient engineAPI, PrintStream out, Map<String, Object> ctx) throws Exception {
        try {
            HashMap<String, String> quest = new HashMap<String, String>();
            quest.put("sessionId", this.sessId);
            Map ret = engineAPI.waitSession(quest);
            if (this.format != null) {
                this.format(this.sessId, engineAPI, out);
            } else {
                out.println(ret.get("returnCode"));
            }
        }
        catch (Exception e) {
            throw new Exception(String.format(Messages.getString("WaitSessionCommand.0"), this.sessId, e.getMessage()), e);
        }
    }

    private void format(String id, IEngineClient engineAPI, PrintStream out) throws Exception {
        Map session = engineAPI.getSessionInfo(id);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Map<String, InternalEngineCommandsI.Column> columns = InternalEngineCommandsI.createSessionsColumns(this.format != null && (this.format.contains("errormessage") || this.format.contains("exception")));
        InternalEngineCommandsI.fillSessionsColumns(columns, session, sdf, engineAPI);
        out.println(InternalEngineCommandsI.formatList2(columns, this.format));
    }
}

