/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.connections;

import com.indy.engine.Global;
import com.indy.engine.core.main.connections.ConnectionManagerI;
import com.indy.engine.core.main.connections.RuntimeConnection;
import com.indy.engine.core.manager.IActionContext;
import com.indy.engine.main.connections.JdbcRuntimeConnection;
import com.indy.engine.main.connections.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.semarchy.xdi.runtime.connection.jdbc.DataSourceConfiguration;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JdbcRuntimeConnectionCreateFunction
implements Function<String, RuntimeConnection<Connection>> {
    private final DataSourceConfiguration dataSourceConfiguration;
    private final Logger logger = LogManager.getLogger(JdbcRuntimeConnectionCreateFunction.class);

    public JdbcRuntimeConnectionCreateFunction(IActionContext callingAction, ConnectionManagerI connectionManager) throws EngineExceptionI {
        this.dataSourceConfiguration = this.createDataSourceConfiguration(callingAction, connectionManager);
    }

    private DataSourceConfiguration createDataSourceConfiguration(IActionContext callingAction, ConnectionManagerI connManager) throws EngineExceptionI {
        DataSourceConfiguration config = new DataSourceConfiguration();
        try {
            String jdbcDriver = null;
            jdbcDriver = connManager.getConnectionParameter(callingAction, "JDBC.DRIVER");
            String moduleName = connManager.getConnectionParameter(callingAction, "JDBC.MODULE");
            config.jdbcParameters().moduleName(moduleName);
            if (jdbcDriver != null) {
                String jdbcUrl;
                block47: {
                    block46: {
                        block45: {
                            block44: {
                                block43: {
                                    block42: {
                                        block41: {
                                            int sqlConnectionTimeout;
                                            config.jdbcParameters().driver(jdbcDriver);
                                            config.jdbcParameters().username(connManager.getConnectionParameter(callingAction, "JDBC.USER"));
                                            String encryptedPassword = connManager.getConnectionParameterWithoutTransfo("JDBC.PASSWORD");
                                            String pass = null;
                                            if (encryptedPassword == null || !encryptedPassword.startsWith("%ext{")) {
                                                encryptedPassword = connManager.getConnectionParameter(callingAction, "JDBC.PASSWORD");
                                            }
                                            if (encryptedPassword != null) {
                                                pass = callingAction.decryptString(encryptedPassword);
                                            }
                                            config.jdbcParameters().password(pass);
                                            try {
                                                sqlConnectionTimeout = Integer.valueOf(connManager.getConnectionParameter(callingAction, "JDBC.CONNECTION_TIMEOUT"));
                                            }
                                            catch (EngineExceptionI e) {
                                                throw e;
                                            }
                                            catch (Exception e) {
                                                if (this.logger.isTraceEnabled()) {
                                                    this.logger.trace("JDBC.CONNECTION_TIMEOUT not found, using default value");
                                                }
                                                sqlConnectionTimeout = Global.DEFAULT_JDBC_CONN_TIMEOUT;
                                            }
                                            config.jdbcParameters().connectionTimeout(sqlConnectionTimeout * 1000);
                                            try {
                                                config.jdbcParameters().maximumPoolSize(Integer.parseInt(connManager.getConnectionParameter(callingAction, "JDBC.CONNECTION_POOL_MAX_SIZE")));
                                            }
                                            catch (EngineExceptionI e) {
                                                throw e;
                                            }
                                            catch (Exception e) {
                                                if (!this.logger.isTraceEnabled()) break block41;
                                                this.logger.trace("JDBC.CONNECTION_POOL_MAX_SIZE not found, using default value");
                                            }
                                        }
                                        try {
                                            config.jdbcParameters().idleTimeout(Integer.parseInt(connManager.getConnectionParameter(callingAction, "JDBC.CONNECTION_POOL_IDLE_TIMEOUT")));
                                        }
                                        catch (EngineExceptionI e) {
                                            throw e;
                                        }
                                        catch (Exception e) {
                                            if (!this.logger.isTraceEnabled()) break block42;
                                            this.logger.trace("JDBC.CONNECTION_POOL_IDLE_TIMEOUT not found, using default value");
                                        }
                                    }
                                    try {
                                        config.jdbcParameters().maxLifetime(Integer.parseInt(connManager.getConnectionParameter(callingAction, "JDBC.CONNECTION_POOL_MAX_LIFETIME")));
                                    }
                                    catch (EngineExceptionI e) {
                                        throw e;
                                    }
                                    catch (Exception e) {
                                        if (!this.logger.isTraceEnabled()) break block43;
                                        this.logger.trace("JDBC.CONNECTION_POOL_MAX_LIFETIME not found, using default value");
                                    }
                                }
                                try {
                                    config.jdbcParameters().minimumIdle(Integer.parseInt(connManager.getConnectionParameter(callingAction, "JDBC.CONNECTION_POOL_MIN_IDLE")));
                                }
                                catch (EngineExceptionI e) {
                                    throw e;
                                }
                                catch (Exception e) {
                                    if (!this.logger.isTraceEnabled()) break block44;
                                    this.logger.trace("JDBC.CONNECTION_POOL_MIN_IDLE not found, using default value");
                                }
                            }
                            try {
                                config.jdbcParameters().validationTimeout(Integer.parseInt(connManager.getConnectionParameter(callingAction, "JDBC.CONNECTION_POOL_VALIDATION_TIMEOUT")));
                            }
                            catch (EngineExceptionI e) {
                                throw e;
                            }
                            catch (Exception e) {
                                if (!this.logger.isTraceEnabled()) break block45;
                                this.logger.trace("JDBC.CONNECTION_POOL_VALIDATION_TIMEOUT not found, using default value");
                            }
                        }
                        try {
                            config.jdbcParameters().keepAliveTime(Integer.parseInt(connManager.getConnectionParameter(callingAction, "JDBC.CONNECTION_POOL_KEEP_ALIVE")));
                        }
                        catch (EngineExceptionI e) {
                            throw e;
                        }
                        catch (Exception e) {
                            if (!this.logger.isTraceEnabled()) break block46;
                            this.logger.trace("JDBC.CONNECTION_POOL_KEEP_ALIVE not found, using default value");
                        }
                    }
                    try {
                        String pval = connManager.getConnectionParameter(callingAction, "JDBC.CONNECTION_POOL_ENABLED");
                        if (pval != null) {
                            config.enablePool(Boolean.valueOf(pval).booleanValue());
                        }
                    }
                    catch (EngineExceptionI e) {
                        throw e;
                    }
                    catch (Exception e) {
                        if (!this.logger.isTraceEnabled()) break block47;
                        this.logger.trace("JDBC.CONNECTION_POOL_ENABLED not found, using default value");
                    }
                }
                if ((jdbcUrl = connManager.getConnectionParameter(callingAction, "JDBC.URL")) == null) {
                    throw new EngineExceptionI(Messages.getString("JDBCConnectionContainerI.4"));
                }
                config.jdbcParameters().url(jdbcUrl);
                Iterator it = connManager.getParameterListIterator();
                HashMap<Integer, String> initSqls = new HashMap<Integer, String>();
                if (it != null) {
                    while (it.hasNext()) {
                        int index;
                        String key = (String)it.next();
                        if (key.startsWith("JDBC.PROPERTY.")) {
                            config.jdbcParameters().addProperty(key.substring("JDBC.PROPERTY.".length()), connManager.getConnectionParameter(callingAction, key));
                            continue;
                        }
                        if (!key.startsWith("JDBC.CONNECTION_INIT_SQLS")) continue;
                        int l = "JDBC.CONNECTION_INIT_SQLS.".length();
                        if (key.length() > l) {
                            String currentIndex = key.substring(l);
                            index = Integer.valueOf(currentIndex);
                        } else {
                            index = 1;
                        }
                        initSqls.put(index, connManager.getConnectionParameter(callingAction, key));
                    }
                }
                if (initSqls.size() > 0) {
                    ArrayList<String> list = new ArrayList<String>();
                    int i = 1;
                    while (i <= initSqls.size()) {
                        list.add((String)initSqls.get(i));
                        ++i;
                    }
                    config.jdbcParameters().connectionInitSqls(list);
                }
            } else {
                throw new EngineExceptionI(Messages.getString("JDBCConnectionContainerI.5"));
            }
            config.jdbcParameters().autocommit(true);
            return config;
        }
        catch (EngineExceptionI e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    @Override
    public JdbcRuntimeConnection apply(String t) {
        return new JdbcRuntimeConnection(this.dataSourceConfiguration);
    }
}

