/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.scheduler;

import com.indy.engine.Global;
import com.indy.engine.InternalDatabase;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.objects2.EngineScheduleDetail;
import com.indy.engine.core.common.objects2.IEngineScheduleDetail;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.scheduler.Messages;
import com.indy.engine.scheduler.SchedulerConfiguration;
import com.indy.engine.scheduler.impl.jobs.CommandLineDeliveryExecutionJob;
import com.indy.engine.scheduler.impl.jobs.PurgeLogJob;
import com.indy.engine.scheduler.impl.jobs.RemoteDeliveryExecutionJob;
import com.indy.engine.service.Service;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class EngineSchedulerI
extends Service {
    private static final String QUARTZ_DATASOURCE_GROUP_KEY = "org.quartz.dataSource";
    private static final String INTERNAL_JDBC_DRIVER = "org.hsqldb.jdbcDriver";
    private static final String INTERNAL_DATASOURCE_NAME = "internal";
    public static final String GROUP_ENGINE_SYSTEM = "system";
    boolean endBeforeStopping = false;
    SchedulerFactory sdiSchedFactory = null;
    Scheduler sdiScheduler = null;
    Log sdiSchedulerLog = null;
    private SchedulerConfiguration schedulerConfiguration;
    private final Logger logger = LogManager.getLogger(this.getClass());
    protected String dataSourceName;

    public EngineSchedulerI() {
        this.sdiSchedulerLog = LogFactory.getLog(EngineSchedulerI.class);
    }

    private void prepare() throws EngineExceptionI {
        if (this.schedulerConfiguration == null) {
            this.schedulerConfiguration = new SchedulerConfiguration(Global.XML_ENGINE_REPOSITORY);
        }
        try {
            this.dataSourceName = this.schedulerConfiguration.getMandatoryConfigurationProperty("org.quartz.jobStore.dataSource");
            String driver = this.schedulerConfiguration.getMandatoryConfigurationProperty("org.quartz.dataSource." + this.dataSourceName + ".driver");
            String url = this.schedulerConfiguration.getMandatoryConfigurationProperty("org.quartz.dataSource." + this.dataSourceName + ".URL");
            boolean internalDatasource = INTERNAL_DATASOURCE_NAME.equals(this.dataSourceName) && INTERNAL_JDBC_DRIVER.equals(driver) && url.endsWith("internalDb/scheduler/scheduler");
            ClassLoaderServiceProvider.instance().getClassLoader(this.schedulerConfiguration.getMandatoryConfigurationProperty("org.quartz.dataSource." + this.dataSourceName + ".module"), driver);
            if (internalDatasource) {
                InternalDatabase.prepareSystemSchedulerDatabase(url, this.schedulerConfiguration.getMandatoryConfigurationProperty("org.quartz.dataSource." + this.dataSourceName + ".user"), this.schedulerConfiguration.getProperty("org.quartz.dataSource." + this.dataSourceName + ".password", ""));
            }
        }
        catch (EngineExceptionI e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public void startSchedulerThread() throws Exception {
        this.sdiSchedFactory = this.schedulerConfiguration != null ? new StdSchedulerFactory(this.schedulerConfiguration.getProperties()) : new StdSchedulerFactory();
        this.sdiScheduler = this.sdiSchedFactory.getScheduler();
        this.sdiScheduler.standby();
        IDeliveryRepository repo = Global.getRepository(null);
        for (String jobGroupName : this.sdiScheduler.getJobGroupNames()) {
            for (JobKey jobKey : this.sdiScheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)jobGroupName))) {
                JobDetail jd = this.sdiScheduler.getJobDetail(jobKey);
                ArrayList<Trigger> triggerToPause = new ArrayList<Trigger>();
                for (Trigger trigger : this.sdiScheduler.getTriggersOfJob(jobKey)) {
                    if (this.sdiScheduler.getTriggerState(trigger.getKey()) == Trigger.TriggerState.PAUSED) {
                        triggerToPause.add(trigger);
                        continue;
                    }
                    if (!jobGroupName.equals("Deliveries")) continue;
                    String deliveryName = null;
                    JobDataMap data = jd.getJobDataMap();
                    Map parameters = (Map)data.get((Object)trigger.getKey().getName());
                    if (parameters != null) {
                        deliveryName = (String)parameters.get("deliveryName");
                    }
                    if (deliveryName == null) {
                        deliveryName = data.getString("deliveryName");
                    }
                    if (repo.exists(deliveryName)) continue;
                    triggerToPause.add(trigger);
                }
                this.sdiScheduler.pauseJob(jobKey);
                this.sdiScheduler.resumeJob(jobKey);
                if (triggerToPause.isEmpty()) continue;
                for (Trigger trigger : triggerToPause) {
                    this.sdiScheduler.pauseTrigger(trigger.getKey());
                }
            }
        }
        this.sdiScheduler.start();
        Global.getConsoleLogger().info(Messages.getString("EngineSchedulerI.0"));
    }

    public synchronized void shutdown() throws SchedulerException {
        this.sdiScheduler.shutdown(this.endBeforeStopping);
        Global.getConsoleLogger().info(Messages.getString("EngineSchedulerI.1"));
    }

    public void setEndBeforeStopping(boolean b) {
        this.endBeforeStopping = b;
    }

    public List<String> getLstTriggers() {
        if (this.sdiScheduler != null) {
            try {
                Set lstSimpleTrig = this.sdiScheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"Simple Trigger"));
                Set lstCronTrig = this.sdiScheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"Cron Expression"));
                ArrayList<String> list = new ArrayList<String>(lstSimpleTrig.stream().map(t -> t.getName()).collect(Collectors.toList()));
                list.addAll(lstCronTrig.stream().map(t -> t.getName()).collect(Collectors.toList()));
                return list;
            }
            catch (SchedulerException e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private static String getQuartzTriggerState(Trigger.TriggerState triggerState) {
        switch (triggerState) {
            case NONE: {
                return "None";
            }
            case NORMAL: {
                return "Normal";
            }
            case PAUSED: {
                return "Paused";
            }
            case COMPLETE: {
                return "Complete";
            }
            case ERROR: {
                return "Error";
            }
            case BLOCKED: {
                return "Blocked";
            }
        }
        return null;
    }

    public static String getTriggerNameFromScheduleOrTriggerName(IEngineClient engineAPI, String name) throws Exception {
        if (name.startsWith("CRON")) {
            return name;
        }
        for (Map schedules : engineAPI.getLstSchedules(null)) {
            if (!schedules.containsKey("scheduleName") || !schedules.get("scheduleName").equals(name)) continue;
            return (String)schedules.get("triggerName");
        }
        return null;
    }

    private EngineScheduleDetail initEngineScheduleDetail(int pExecutionType, Trigger trigger) {
        EngineScheduleDetail esd = new EngineScheduleDetail(pExecutionType);
        esd.setStartTime(trigger.getStartTime());
        esd.setEndTime(trigger.getEndTime());
        esd.setJobName(trigger.getJobKey().getName());
        esd.setTriggerName(trigger.getKey().getName());
        esd.setLastExecution(trigger.getPreviousFireTime());
        esd.setNextExecution(trigger.getNextFireTime());
        try {
            esd.setTriggerState(EngineSchedulerI.getQuartzTriggerState(this.sdiScheduler.getTriggerState(trigger.getKey())));
        }
        catch (SchedulerException e) {
            this.sdiSchedulerLog.warn((Object)Messages.getString("EngineSchedulerI.37"), (Throwable)e);
        }
        if (trigger instanceof SimpleTrigger) {
            SimpleTrigger simpleTrigger = (SimpleTrigger)trigger;
            esd.setRepeatCount(simpleTrigger.getRepeatCount());
            esd.setRepeatInterval((long)simpleTrigger.getRepeatCount());
        } else if (trigger instanceof CronTrigger) {
            CronTrigger cronTrigger = (CronTrigger)trigger;
            esd.setCronExpression(cronTrigger.getCronExpression());
        }
        try {
            JobDetail jd = this.sdiScheduler.getJobDetail(new JobKey(trigger.getJobKey().getName(), "Deliveries"));
            if (jd != null) {
                if (jd.getJobClass() == RemoteDeliveryExecutionJob.class) {
                    esd.setExecutionType(1);
                } else if (jd.getJobClass() == CommandLineDeliveryExecutionJob.class) {
                    esd.setExecutionType(2);
                }
                JobDataMap data = jd.getJobDataMap();
                if (data != null) {
                    Map mapJob = (Map)data.get((Object)trigger.getKey().getName());
                    String deliveryName = (String)mapJob.get("deliveryName");
                    if (deliveryName == null) {
                        deliveryName = data.getString("deliveryName");
                    }
                    esd.setDeliveryName(deliveryName);
                    esd.setSessionName((String)mapJob.get("sessName"));
                    esd.setScheduleName((String)mapJob.get("scheduleName"));
                    esd.setConfiguration((String)mapJob.get("configuration"));
                    esd.setHost((String)mapJob.get("httpHost"));
                    esd.setPort((Integer)mapJob.get("httpPort"));
                    esd.setLogLevel(mapJob.getOrDefault("logLevel", "").toString());
                    Map mapParam = (Map)mapJob.get("variables");
                    esd.setMapParameters(mapParam);
                }
            }
        }
        catch (SchedulerException e) {
            this.sdiSchedulerLog.warn((Object)Messages.getString("EngineSchedulerI.37"), (Throwable)e);
        }
        return esd;
    }

    public IEngineScheduleDetail getTriggerDetail(String triggerName) {
        EngineScheduleDetail esd = null;
        try {
            SimpleTrigger sTrig = null;
            sTrig = (SimpleTrigger)this.sdiScheduler.getTrigger(new TriggerKey(triggerName, "Simple Trigger"));
            if (sTrig != null) {
                if (sTrig.getJobKey().getGroup().equals("Deliveries")) {
                    esd = this.initEngineScheduleDetail(2, (Trigger)sTrig);
                }
            } else {
                CronTrigger sCron = null;
                sCron = (CronTrigger)this.sdiScheduler.getTrigger(new TriggerKey(triggerName, "Cron Expression"));
                if (sCron != null && (sCron.getJobKey().getGroup().equals("Deliveries") || sCron.getJobKey().getGroup().equals("Purge"))) {
                    esd = this.initEngineScheduleDetail(1, (Trigger)sCron);
                    if (sCron.getJobKey().getGroup().equals("Purge")) {
                        JobDetail job = this.sdiScheduler.getJobDetail(sCron.getJobKey());
                        JobDataMap data = job.getJobDataMap();
                        esd.setPurgeSize(data.getString("size"));
                        esd.setPurgeUnit(data.getString("unit"));
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        HashMap<String, Integer> statusList = new HashMap<String, Integer>();
                        List list = (List)data.get((Object)"purgeStatusList");
                        if (list != null) {
                            int i = 0;
                            for (Integer k : list) {
                                statusList.put(String.valueOf(i++), k);
                            }
                        }
                        map.put("purgeStatusList", statusList);
                        map.put("purgeSessionName", data.get((Object)"purgeSessionName"));
                        esd.setMapParameters(map);
                    }
                }
            }
        }
        catch (SchedulerException e) {
            this.sdiSchedulerLog.warn((Object)Messages.getString("EngineSchedulerI.37"), (Throwable)e);
        }
        return esd;
    }

    public List<IEngineScheduleDetail> getLstSchedules(String jobName) {
        ArrayList<IEngineScheduleDetail> lst = new ArrayList<IEngineScheduleDetail>();
        if (this.sdiScheduler != null) {
            try {
                EngineScheduleDetail esd;
                SimpleTrigger sTrig;
                Set lstTrigs = this.sdiScheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"Simple Trigger"));
                for (TriggerKey triggerKey : lstTrigs) {
                    sTrig = (SimpleTrigger)this.sdiScheduler.getTrigger(triggerKey);
                    if (!sTrig.getJobKey().getGroup().equals("Deliveries")) continue;
                    esd = this.initEngineScheduleDetail(2, (Trigger)sTrig);
                    if (jobName != null && !esd.getDeliveryName().equals(jobName)) continue;
                    lst.add((IEngineScheduleDetail)esd);
                }
                lstTrigs = this.sdiScheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"Cron Expression"));
                for (TriggerKey triggerKey : lstTrigs) {
                    sTrig = (CronTrigger)this.sdiScheduler.getTrigger(triggerKey);
                    if (!sTrig.getJobKey().getGroup().equals("Deliveries")) continue;
                    esd = this.initEngineScheduleDetail(1, (Trigger)sTrig);
                    if (jobName != null && !esd.getDeliveryName().equals(jobName)) continue;
                    lst.add((IEngineScheduleDetail)esd);
                }
            }
            catch (SchedulerException e) {
                return null;
            }
        }
        return lst;
    }

    public int removeJobTrigger(String triggerName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            if (triggerName.startsWith("SMPL_")) {
                this.removeSimpleJobTrigger(triggerName);
            } else if (triggerName.startsWith("CRON_")) {
                this.removeCronJobTrigger(triggerName);
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public int removeCronJobTrigger(String triggerName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            try {
                String jobName = this.sdiScheduler.getTrigger(new TriggerKey(triggerName, "Cron Expression")).getJobKey().getName();
                String jobGroup = this.sdiScheduler.getTrigger(new TriggerKey(triggerName, "Cron Expression")).getJobKey().getGroup();
                JobDetail job = this.sdiScheduler.getJobDetail(new JobKey(jobName, jobGroup));
                job.getJobDataMap().remove((Object)triggerName);
                this.sdiScheduler.unscheduleJob(new TriggerKey(triggerName, "Cron Expression"));
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.warn((Object)Messages.getString("EngineSchedulerI.37"), (Throwable)e);
                ret = -10;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public int removeSimpleJobTrigger(String triggerName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            try {
                this.sdiScheduler.unscheduleJob(new TriggerKey(triggerName, "Simple Trigger"));
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.warn((Object)Messages.getString("EngineSchedulerI.37"), (Throwable)e);
                ret = -10;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public int removeJobAndTriggers(String jobName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            try {
                this.sdiScheduler.deleteJob(new JobKey(jobName, "Deliveries"));
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.warn((Object)Messages.getString("EngineSchedulerI.37"), (Throwable)e);
                ret = -10;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public IEngineScheduleDetail scheduleDelivery(String jobName, String pDeliveryName, int executionMode, List<Map<String, Object>> pScheduleList) throws Exception {
        return this.scheduleDelivery(jobName, pDeliveryName, executionMode, null, -1, pScheduleList);
    }

    public IEngineScheduleDetail schedulePurgeLog(String triggerName, List<Map<String, Object>> pScheduleList, Map<String, Object> rules) throws Exception {
        if (pScheduleList == null || pScheduleList.isEmpty()) {
            throw new EngineExceptionI("Schedule List is Empty");
        }
        if (this.sdiScheduler != null) {
            Object delivJob = null;
            Object pJobName = null;
            try {
                boolean existTrigger = false;
                if (triggerName != null) {
                    Set triggersCron = this.sdiScheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"Cron Expression"));
                    Set triggersSimple = this.sdiScheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)"Simple Trigger"));
                    for (TriggerKey triggerKey : triggersCron) {
                        if (!triggerKey.getName().equals(triggerName)) continue;
                        existTrigger = true;
                        pJobName = triggerName;
                        break;
                    }
                    if (!existTrigger) {
                        for (TriggerKey triggerKey : triggersSimple) {
                            if (!triggerKey.getName().equals(triggerName)) continue;
                            existTrigger = true;
                            break;
                        }
                    }
                    if (!existTrigger) {
                        pJobName = "CRON_SystemPurgeOperation." + System.currentTimeMillis();
                    }
                } else {
                    pJobName = "CRON_SystemPurgeOperation." + System.currentTimeMillis();
                }
                triggerName = pJobName;
                String jobName = pJobName;
                Set jobKeys = this.sdiScheduler.getJobKeys(GroupMatcher.groupEquals((String)"Purge"));
                Optional<JobKey> optionalJobKey = jobKeys.stream().filter(j -> jobName.equals(j.getName())).findFirst();
                delivJob = !optionalJobKey.isPresent() ? new JobDetailImpl((String)pJobName, "Purge", PurgeLogJob.class) : this.sdiScheduler.getJobDetail(optionalJobKey.get());
                delivJob.getJobDataMap().putAll(rules);
                this.sdiScheduler.addJob((JobDetail)delivJob, true, true);
                this.addTrigger((String)triggerName, "Purge", (JobDetail)delivJob, pScheduleList);
                return this.getTriggerDetail((String)triggerName);
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.warn((Object)Messages.getString("EngineSchedulerI.37"), (Throwable)e);
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.2"), (Throwable)e);
            }
            catch (Exception e) {
                this.sdiSchedulerLog.warn((Object)Messages.getString("EngineSchedulerI.37"), (Throwable)e);
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.3"), (Throwable)e);
            }
        }
        throw new EngineExceptionI(Messages.getString("EngineSchedulerI.4"));
    }

    public JobDetail getJobDetail(String jobName, String group) throws SchedulerException {
        return this.sdiScheduler.getJobDetail(new JobKey(jobName, group));
    }

    private int addTrigger(String pJobName, String type, JobDetail delivJob, List<Map<String, Object>> pScheduleList) throws Exception {
        Iterator<Map<String, Object>> it = pScheduleList.iterator();
        if (!it.hasNext()) {
            return -3;
        }
        IEngineScheduleDetail esd = null;
        int i = 0;
        while (it.hasNext()) {
            boolean isCronType;
            esd = EngineScheduleDetail.getEngineScheduleDetail(it.next());
            boolean bl = isCronType = esd.getCronExpression() != null;
            if (!isCronType) {
                SimpleTriggerImpl simpleTrigger = null;
                if (esd.getStartTime() != null) {
                    if (esd.getEndTime() == null) {
                        Date endDt = new Date();
                        endDt.setTime(0x7FFFFFFFFFFFFFFEL);
                        simpleTrigger = new SimpleTriggerImpl(pJobName, "Simple Trigger", esd.getStartTime(), endDt, esd.getRepeatCount(), esd.getRepeatInterval());
                    } else {
                        simpleTrigger = new SimpleTriggerImpl(pJobName, "Simple Trigger", esd.getStartTime(), esd.getEndTime(), esd.getRepeatCount(), esd.getRepeatInterval());
                    }
                    this.sdiScheduler.scheduleJob(delivJob, (Trigger)simpleTrigger);
                }
            } else {
                if (esd.getCronExpression().isEmpty()) {
                    return -4;
                }
                Trigger cronTrigger = null;
                CronScheduleBuilder schedule = null;
                boolean update = esd.getTriggerName() != null;
                String triggerName = pJobName;
                try {
                    schedule = CronScheduleBuilder.cronScheduleNonvalidatedExpression((String)esd.getCronExpression()).withMisfireHandlingInstructionDoNothing();
                    if (esd.getStartTime() != null) {
                        if (esd.getEndTime() == null) {
                            Date endDt = new Date();
                            endDt.setTime(0x7FFFFFFFFFFFFFFEL);
                            cronTrigger = TriggerBuilder.newTrigger().withIdentity(triggerName, "Cron Expression").withSchedule((ScheduleBuilder)schedule).startAt(esd.getStartTime()).forJob(pJobName, type).endAt(endDt).build();
                        } else {
                            cronTrigger = TriggerBuilder.newTrigger().withIdentity(triggerName, "Cron Expression").withSchedule((ScheduleBuilder)schedule).startAt(esd.getStartTime()).forJob(pJobName, type).endAt(esd.getEndTime()).build();
                        }
                    } else {
                        cronTrigger = TriggerBuilder.newTrigger().withIdentity(triggerName, "Cron Expression").withSchedule((ScheduleBuilder)schedule).forJob(pJobName, type).build();
                    }
                    if (update) {
                        this.sdiScheduler.rescheduleJob(new TriggerKey(triggerName, cronTrigger.getKey().getGroup()), cronTrigger);
                    } else {
                        this.sdiScheduler.scheduleJob(cronTrigger);
                    }
                }
                catch (ParseException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            ++i;
        }
        return i;
    }

    public IEngineScheduleDetail scheduleDelivery(String pJobName, String pDeliveryName, int executionMode, String httpHost, int httpPort, List<Map<String, Object>> pScheduleList) throws Exception {
        return this.scheduleDelivery(pJobName, pDeliveryName, executionMode, httpHost, httpPort, pScheduleList, null);
    }

    public IEngineScheduleDetail scheduleDelivery(String pJobName, String pDeliveryName, int executionMode, String httpHost, int httpPort, List<Map<String, Object>> pScheduleList, Map<String, Object> parameters) throws Exception {
        return this.scheduleDelivery(pJobName, pDeliveryName, executionMode, httpHost, httpPort, pScheduleList, parameters, null);
    }

    public IEngineScheduleDetail scheduleDelivery(String pJobName, String pDeliveryName, int executionMode, String httpHost, int httpPort, List<Map<String, Object>> pScheduleList, Map<String, Object> parameters, Integer logLevel) throws Exception {
        if (pScheduleList == null || pScheduleList.isEmpty()) {
            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.5"));
        }
        try {
            if (!Global.engineServer.existDelivery(pDeliveryName, null)) {
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.6"));
            }
        }
        catch (Exception e1) {
            throw new EngineExceptionI((Throwable)e1);
        }
        if (this.sdiScheduler != null) {
            Object delivJob = null;
            try {
                Set jobKeys = this.sdiScheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)"Deliveries"));
                Optional<JobKey> optionalJobKey = jobKeys.stream().filter(j -> pJobName.equals(j.getName())).findFirst();
                delivJob = !optionalJobKey.isPresent() ? (executionMode == 1 ? new JobDetailImpl(pJobName, "Deliveries", RemoteDeliveryExecutionJob.class) : new JobDetailImpl(pJobName, "Deliveries", CommandLineDeliveryExecutionJob.class)) : this.sdiScheduler.getJobDetail(optionalJobKey.get());
                delivJob.getJobDataMap().put("deliveryName", pDeliveryName);
                Iterator<Map<String, Object>> it = pScheduleList.iterator();
                IEngineScheduleDetail esd = null;
                List lstSimpleTrig = this.sdiScheduler.getTriggersOfJob(new JobKey(pJobName, "Deliveries"));
                int last = lstSimpleTrig.stream().mapToInt(t -> {
                    int index = t.getKey().getName().lastIndexOf("-");
                    if (index > -1) {
                        String num = t.getKey().getName().substring(index + 1);
                        return Integer.parseInt(num);
                    }
                    return -1;
                }).max().orElse(-1);
                int i = last + 1;
                while (it.hasNext()) {
                    boolean isCronType;
                    esd = EngineScheduleDetail.getEngineScheduleDetail(it.next());
                    String triggerName = esd.getTriggerName();
                    boolean update = triggerName != null;
                    boolean bl = isCronType = esd.getCronExpression() != null;
                    if (!isCronType) {
                        triggerName = !update ? "SMPL_" + pJobName + "-" + i : triggerName;
                        SimpleTriggerImpl simpleTrigger = null;
                        if (esd.getStartTime() != null) {
                            simpleTrigger = esd.getEndTime() == null ? new SimpleTriggerImpl(triggerName, "Simple Trigger", esd.getStartTime(), null, esd.getRepeatCount(), esd.getRepeatInterval()) : new SimpleTriggerImpl(triggerName, "Simple Trigger", esd.getStartTime(), esd.getEndTime(), esd.getRepeatCount(), esd.getRepeatInterval());
                            if (parameters != null) {
                                parameters.put("configuration", esd.getConfiguration());
                                parameters.put("sessName", esd.getSessionName());
                                parameters.put("scheduleName", esd.getScheduleName());
                                delivJob.getJobDataMap().put(simpleTrigger.getKey().getName(), parameters);
                            }
                            this.sdiScheduler.addJob(delivJob, true, true);
                            this.sdiScheduler.scheduleJob(delivJob, (Trigger)simpleTrigger);
                        }
                    } else {
                        String string = triggerName = !update ? "CRON_" + pJobName + "-" + String.valueOf(i) : triggerName;
                        if (esd.getCronExpression().isEmpty()) {
                            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.7"));
                        }
                        Trigger cronTrigger = null;
                        CronScheduleBuilder schedule = null;
                        try {
                            schedule = CronScheduleBuilder.cronScheduleNonvalidatedExpression((String)esd.getCronExpression()).withMisfireHandlingInstructionDoNothing();
                            cronTrigger = esd.getStartTime() != null ? (esd.getEndTime() == null ? TriggerBuilder.newTrigger().withIdentity(triggerName, "Cron Expression").withSchedule((ScheduleBuilder)schedule).startAt(esd.getStartTime()).forJob(pJobName, "Deliveries").build() : TriggerBuilder.newTrigger().withIdentity(triggerName, "Cron Expression").withSchedule((ScheduleBuilder)schedule).startAt(esd.getStartTime()).forJob(pJobName, "Deliveries").endAt(esd.getEndTime()).build()) : TriggerBuilder.newTrigger().withIdentity(triggerName, "Cron Expression").withSchedule((ScheduleBuilder)schedule).forJob(pJobName, "Deliveries").endAt(esd.getEndTime()).build();
                            if (parameters != null) {
                                parameters.put("configuration", esd.getConfiguration());
                                parameters.put("sessName", esd.getSessionName());
                                parameters.put("scheduleName", esd.getScheduleName());
                                if (executionMode == 1) {
                                    if (httpHost != null) {
                                        parameters.put("httpHost", httpHost);
                                    } else {
                                        parameters.remove("httpHost");
                                    }
                                    if (httpPort > -1) {
                                        parameters.put("httpPort", httpPort);
                                    } else {
                                        parameters.remove("httpPort");
                                    }
                                }
                                if (logLevel != null) {
                                    parameters.put("logLevel", logLevel);
                                }
                                parameters.put("deliveryName", pDeliveryName);
                                delivJob.getJobDataMap().put(cronTrigger.getKey().getName(), parameters);
                            }
                            this.sdiScheduler.addJob(delivJob, true, true);
                            if (update) {
                                this.sdiScheduler.rescheduleJob(new TriggerKey(triggerName, cronTrigger.getKey().getGroup()), cronTrigger);
                            } else {
                                this.sdiScheduler.scheduleJob(cronTrigger);
                            }
                            return this.getTriggerDetail(triggerName);
                        }
                        catch (Exception e) {
                            throw new EngineExceptionI((Throwable)e);
                        }
                    }
                    ++i;
                }
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.error((Object)Messages.getString("EngineSchedulerI.8"), (Throwable)e);
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.8"), (Throwable)e);
            }
            catch (Exception e) {
                this.sdiSchedulerLog.error((Object)Messages.getString("EngineSchedulerI.9"), (Throwable)e);
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.9"), (Throwable)e);
            }
        } else {
            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.10"));
        }
        return null;
    }

    public IEngineScheduleDetail scheduleSystemJob(String pJobName, List<IEngineScheduleDetail> pScheduleList, Class jobClass, Map<String, Object> lstParams) throws Exception {
        if (pScheduleList == null || pScheduleList.isEmpty()) {
            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.11"));
        }
        if (this.sdiScheduler != null) {
            this.sdiSchedulerLog.debug((Object)Messages.getString("EngineSchedulerI.12"));
            JobDetail job = null;
            try {
                Set jobKeys = this.sdiScheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)GROUP_ENGINE_SYSTEM));
                Optional<JobKey> optionalJobKey = jobKeys.stream().filter(j -> pJobName.equals(j.getName())).findFirst();
                if (!optionalJobKey.isPresent()) {
                    this.sdiSchedulerLog.debug((Object)(Messages.getString("EngineSchedulerI.13") + pJobName));
                    job = new JobDetailImpl(pJobName, GROUP_ENGINE_SYSTEM, jobClass);
                } else {
                    JobKey jobKey = optionalJobKey.get();
                    job = this.sdiScheduler.getJobDetail(jobKey);
                }
                this.sdiSchedulerLog.debug((Object)Messages.getString("EngineSchedulerI.14"));
                JobDataMap jobMap = job.getJobDataMap();
                for (String pName : lstParams.keySet()) {
                    jobMap.put(pName, lstParams.get(pName));
                }
                this.sdiScheduler.addJob(job, true);
                Iterator<IEngineScheduleDetail> it = pScheduleList.iterator();
                IEngineScheduleDetail esd = null;
                List lstSimpleTrig = this.sdiScheduler.getTriggersOfJob(new JobKey(pJobName, GROUP_ENGINE_SYSTEM));
                int i = lstSimpleTrig == null ? 0 : lstSimpleTrig.size();
                this.sdiSchedulerLog.debug((Object)Messages.getString("EngineSchedulerI.15"));
                while (it.hasNext()) {
                    boolean isCronType;
                    esd = it.next();
                    boolean bl = isCronType = esd.getCronExpression() != null;
                    if (!isCronType) {
                        SimpleTriggerImpl simpleTrigger = null;
                        if (esd.getStartTime() != null) {
                            if (esd.getEndTime() == null) {
                                Date endDt = new Date();
                                endDt.setTime(0x7FFFFFFFFFFFFFFEL);
                                simpleTrigger = new SimpleTriggerImpl("SMPL_" + pJobName + "-" + String.valueOf(i), "Simple Trigger", esd.getStartTime(), endDt, esd.getRepeatCount(), esd.getRepeatInterval());
                            } else {
                                simpleTrigger = new SimpleTriggerImpl("SMPL_" + pJobName + "-" + String.valueOf(i), "Simple Trigger", esd.getStartTime(), esd.getEndTime(), esd.getRepeatCount(), esd.getRepeatInterval());
                            }
                            this.sdiSchedulerLog.debug((Object)(Messages.getString("EngineSchedulerI.22") + job.getKey().getName()));
                            this.sdiScheduler.scheduleJob(job, (Trigger)simpleTrigger);
                        }
                    } else {
                        if (esd.getCronExpression().isEmpty()) {
                            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.25"));
                        }
                        Trigger cronTrigger = null;
                        CronScheduleBuilder schedule = null;
                        try {
                            schedule = CronScheduleBuilder.cronScheduleNonvalidatedExpression((String)esd.getCronExpression());
                            if (esd.getStartTime() != null) {
                                if (esd.getEndTime() == null) {
                                    Date endDt = new Date();
                                    endDt.setTime(0x7FFFFFFFFFFFFFFEL);
                                    cronTrigger = TriggerBuilder.newTrigger().withIdentity("CRON_" + pJobName + "-" + String.valueOf(i), "Cron Expression").withSchedule((ScheduleBuilder)schedule).startAt(esd.getStartTime()).endAt(endDt).forJob(pJobName, GROUP_ENGINE_SYSTEM).build();
                                } else {
                                    cronTrigger = TriggerBuilder.newTrigger().withIdentity("CRON_" + pJobName + "-" + String.valueOf(i), "Cron Expression").withSchedule((ScheduleBuilder)schedule).startAt(esd.getStartTime()).endAt(esd.getEndTime()).forJob(pJobName, GROUP_ENGINE_SYSTEM).build();
                                }
                            } else {
                                cronTrigger = TriggerBuilder.newTrigger().withIdentity("CRON_" + pJobName + "-" + String.valueOf(i), "Cron Expression").withSchedule((ScheduleBuilder)schedule).forJob(pJobName, GROUP_ENGINE_SYSTEM).build();
                            }
                            this.sdiScheduler.scheduleJob(cronTrigger);
                        }
                        catch (ParseException e) {
                            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.16"), (Throwable)e);
                        }
                    }
                    ++i;
                }
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.error((Object)Messages.getString("EngineSchedulerI.17"), (Throwable)e);
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.17"), (Throwable)e);
            }
            catch (Exception e) {
                this.sdiSchedulerLog.error((Object)Messages.getString("EngineSchedulerI.17"), (Throwable)e);
                throw new EngineExceptionI(Messages.getString("EngineSchedulerI.18"), (Throwable)e);
            }
        }
        throw new EngineExceptionI(Messages.getString("EngineSchedulerI.19"));
        return null;
    }

    public int removeSystemJobTrigger(String triggerName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            if (triggerName.startsWith("SMPL_")) {
                this.removeSystemSimpleJobTrigger(triggerName);
            } else if (triggerName.startsWith("CRON_")) {
                this.removeSystemCronJobTrigger(triggerName);
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public int removeSystemCronJobTrigger(String triggerName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            try {
                this.sdiScheduler.unscheduleJob(new TriggerKey(triggerName, "Cron Expression"));
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.warn((Object)Messages.getString("EngineSchedulerI.37"), (Throwable)e);
                ret = -10;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public int removeSystemSimpleJobTrigger(String triggerName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            try {
                this.sdiScheduler.unscheduleJob(new TriggerKey(triggerName, "Simple Trigger"));
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.error((Object)(Messages.getString("EngineSchedulerI.24") + triggerName), (Throwable)e);
                ret = -10;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public int removeSystemJobAndTriggers(String jobName) {
        int ret = 1;
        if (this.sdiScheduler != null) {
            try {
                this.sdiScheduler.deleteJob(new JobKey(jobName, GROUP_ENGINE_SYSTEM));
            }
            catch (SchedulerException e) {
                this.sdiSchedulerLog.error((Object)(Messages.getString("EngineSchedulerI.23") + jobName), (Throwable)e);
                ret = -10;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    @Override
    protected void doStart() throws Exception {
        Global.dLog.write("EngineServerI()", Messages.getString("EngineSchedulerI.20"), 0, 0, "INFO");
        this.prepare();
        this.startSchedulerThread();
        Global.dLog.write("EngineServerI()", Messages.getString("EngineSchedulerI.21"), 0, 0, "INFO");
    }

    @Override
    protected void doStop() throws Exception {
        this.shutdown();
    }

    @Override
    public String getName() {
        return "scheduler";
    }

    public void pauseTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        this.sdiScheduler.pauseTrigger(new TriggerKey(triggerName, triggerGroup));
    }

    public void resumeTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        this.sdiScheduler.resumeTrigger(new TriggerKey(triggerName, triggerGroup));
    }

    public Scheduler getScheduler() {
        return this.sdiScheduler;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }
}

