/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.scheduler;

import com.indy.engine.core.common.XPathAPI;
import com.indy.engine.scheduler.Messages;
import com.indy.engine.shared.configuration.VariableHandler;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SchedulerConfiguration {
    private Properties properties = new Properties(){

        @Override
        public synchronized void load(InputStream inStream) throws IOException {
            super.load(inStream);
            for (Map.Entry<Object, Object> item : SchedulerConfiguration.this.properties.entrySet()) {
                try {
                    String key = item.getKey().toString();
                    String value = VariableHandler.updateString((String)item.getValue().toString());
                    SchedulerConfiguration.this.properties.replace(key, value);
                }
                catch (VariableHandler.VariableResolutionException e) {
                    SchedulerConfiguration.this.logger.error(e.getMessage());
                }
            }
        }
    };
    private final Logger logger = LogManager.getLogger(this.getClass());
    static final String XML_ENGINE_CONF_FILE = "properties/engineParameters.xml";

    public SchedulerConfiguration(String confFilePath) throws EngineExceptionI {
        this.properties = this.loadProperties(confFilePath, "/*/scheduler");
        if (this.properties.isEmpty()) {
            this.properties = this.loadPropertiesFromLegacyFile();
        }
    }

    private Document createDocument(InputStream is) throws IOException, ParserConfigurationException, SAXException {
        Document doc = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        doc = docBuilder.parse(is);
        doc.getDocumentElement().normalize();
        return doc;
    }

    private Properties loadProperties(String filePath, String nodeExpression) throws EngineExceptionI {
        File configurationFile = new File(filePath);
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try (FileInputStream is = new FileInputStream(configurationFile);){
                Document doc = this.createDocument(is);
                NodeList nl = XPathAPI.selectNodeList((Node)doc, (String)nodeExpression);
                NodeList parameters = XPathAPI.selectNodeList((Node)doc, (String)(nodeExpression + "/parameter"));
                if (nl.getLength() > 0) {
                    if (parameters.getLength() > 0) {
                        int i = 0;
                        while (i < parameters.getLength()) {
                            Node item = parameters.item(i);
                            if (item.getNodeName().equals("parameter")) {
                                NamedNodeMap quartzProps = item.getAttributes();
                                String parameterName = quartzProps.getNamedItem("name").getNodeValue();
                                String parameterValue = VariableHandler.updateString((String)quartzProps.getNamedItem("value").getNodeValue());
                                this.properties.setProperty(parameterName, parameterValue);
                            }
                            ++i;
                        }
                    } else {
                        Node fileAttr = nl.item(0).getAttributes().getNamedItem("file");
                        File propertiesFolder = configurationFile.getParentFile();
                        Path path = Paths.get(propertiesFolder.getPath(), fileAttr.getNodeValue());
                        this.properties = this.loadProperties(path.normalize().toString(), "/scheduler");
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.35"));
        }
        catch (XPathExpressionException | XPathFactoryConfigurationException e) {
            throw new EngineExceptionI(Messages.getString("EngineSchedulerI.36"));
        }
        catch (VariableHandler.VariableResolutionException | ParserConfigurationException | DOMException | SAXException e) {
            throw new EngineExceptionI(e);
        }
        return this.properties;
    }

    private Properties loadPropertiesFromLegacyFile() throws EngineExceptionI {
        this.logger.info(Messages.getString("EngineSchedulerI.26"));
        File file = new File(System.getProperty("org.quartz.properties"));
        if (file.exists()) {
            this.loadPropertiesFromFile(file);
        } else {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream resource = this.getClass().getClassLoader().getResourceAsStream("fallbackEngineScheduler.properties");){
                    this.properties.load(resource);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        return this.properties;
    }

    private void loadPropertiesFromFile(File file) throws EngineExceptionI {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream is = new FileInputStream(file);){
                this.properties.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    String getMandatoryConfigurationProperty(String key) {
        if (!this.containsKey(key)) {
            throw new IllegalStateException("Scheduler configuration is missing property " + key);
        }
        return this.getProperty(key);
    }

    boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }
}

