/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog;

import com.indy.engine.core.common.CommonUtils;
import com.indy.engine.userLog.Messages;
import com.indy.engine.userLog.RdbmsUserLog;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class UpdateDatabase {
    public static final UpdateDatabase INSTANCE = new UpdateDatabase();
    List<AlterDatabase> allAterDatabase = new ArrayList<AlterDatabase>();
    CreateTable initCreateTable = new CreateTable(Version.V1700, TableName.VERSION_HIST_VHS, ColumnName.V_VERSION, ColumnName.VHS_NUM, ColumnName.VHS_SQL, ColumnName.VHS_USER_SQL, ColumnName.VHS_STK_TRACE, ColumnName.VHS_UPD_DATE, ColumnName.VHS_STATUS);
    ColList insertSACT;
    ColList insertSACP;
    ColList insertALTID;
    ColList insertAST;
    ColList insertPST;
    ColList insertSST;

    private UpdateDatabase() {
        new CreateTable(Version.V1700, TableName.ACTION_SPROP_ASP, ColumnName.DLV_ID, ColumnName.ACT_ID, ColumnName.ACP_SHORT_NAME, ColumnName.ASP_SRC_VAR, ColumnName.ASP_SRC_CLO, ColumnName.ASP_SRC_BLO, ColumnName.ASP_SRC_FORMAT, ColumnName.PTY_TYPE_N);
        new CreateTable(Version.V1700, TableName.ACTION_S_ACT, ColumnName.DLV_ID, ColumnName.ACT_ID, ColumnName.ACT_PARENT_ID, ColumnName.ACT_TECH, ColumnName.ACT_PARENT_PATH, ColumnName.ACT_SHORT_NAME, ColumnName.ACT_TYPE, ColumnName.ACT_ERROR_ACCEPTED, ColumnName.ACT_IS_BEGIN, ColumnName.ACT_NB_CYCLE, ColumnName.ACT_RESTART_MODE, ColumnName.ACT_HAS_DYN_NAME);
        new CreateTable(Version.V1700, TableName.ACTION_ALTID_AAI, ColumnName.DLV_ID, ColumnName.ACT_ID, ColumnName.AAI_ORIGIN, ColumnName.AAI_ID);
        new CreateTable(Version.V1700, TableName.ACTION_STAT_AST, ColumnName.SESS_ID, ColumnName.SESS_ITER, ColumnName.ACT_ID, ColumnName.ACT_ITER, ColumnName.ACP_SHORT_NAME, ColumnName.AST_STAT_SUM, ColumnName.AST_STAT_REJ, ColumnName.AST_NUM);
        new CreateTable(Version.V1700, TableName.PROCESS_STAT_PST, ColumnName.SESS_ID, ColumnName.SESS_ITER, ColumnName.ACT_ID, ColumnName.ACT_ITER, ColumnName.ACP_SHORT_NAME, ColumnName.PST_STAT_SUM, ColumnName.PST_STAT_REJ, ColumnName.PST_STAT_MIN, ColumnName.PST_STAT_MAX, ColumnName.PST_STAT_COUNT, ColumnName.PST_NUM);
        new CreateTable(Version.V1700, TableName.SESSION_STAT_SST, ColumnName.SESS_ID, ColumnName.SESS_ITER, ColumnName.ACP_SHORT_NAME, ColumnName.SST_STAT_SUM, ColumnName.SST_STAT_REJ, ColumnName.SST_STAT_MIN, ColumnName.SST_STAT_MAX, ColumnName.SST_STAT_COUNT);
        new AddColumnToTable(Version.V1700, TableName.VERSION_V, ColumnName.V_UPD_DATE);
        new AddColumnToTable(Version.V1700, TableName.VERSION_V, ColumnName.V_TSTAMP_SQL);
        new AddColumnToTable(Version.V1700, TableName.SESSION_SESS, ColumnName.V_VERSION);
        new AddColumnToTable(Version.V1700, TableName.SESSION_SESS, ColumnName.SESS_PARENT_ITER);
        new AddColumnToTable(Version.V1700, TableName.SESSION_SESS, ColumnName.SESS_ACT_ROOT_ID);
        new AddColumnToTable(Version.V1700, TableName.SESSION_SESS, ColumnName.SESS_BEGIN_TSTAMP);
        new AddColumnToTable(Version.V1700, TableName.SESSION_SESS, ColumnName.SESS_DURATION);
        new AddColumnToTable(Version.V1700, TableName.SESSION_SESS, ColumnName.SESS_TSTAMP_OFFSET);
        new AddColumnToTable(Version.V1740, TableName.SESSION_SESS, ColumnName.SESS_LAUNCH_USER);
        new AddColumnToTable(Version.V1700, TableName.SESSION_CHILDS_CSES, ColumnName.ACT_ITER);
        new AddColumnToTable(Version.V1700, TableName.SESSION_CHILDS_CSES, ColumnName.CSES_ITER);
        new AddColumnToTable(Version.V1700, TableName.DELIVERY_DLV, ColumnName.DLV_TSTAMP);
        new AddColumnToTable(Version.V1700, TableName.DELIVERY_DLV, ColumnName.DLV_VERSION);
        new AddColumnToTable(Version.V1700, TableName.DELIVERY_DLV, ColumnName.DLV_USER);
        new AddColumnToTable(Version.V1700, TableName.DELIVERY_DLV, ColumnName.DLV_COMMENT);
        new AddColumnToTable(Version.V1700, TableName.ACTION_PROP_ACP, ColumnName.PTY_TYPE_N);
        new AddColumnToTable(Version.V1700, TableName.ACTION_PROP_ACP, ColumnName.PCA_TYPE_N);
        new AddColumnToTable(Version.V1700, TableName.ACTION_PROP_ACP, ColumnName.ACP_NUM);
        new AddColumnToTable(Version.V1700, TableName.ACTION_PROP_ACP, ColumnName.ACP_BND_VAR);
        new AddColumnToTable(Version.V1700, TableName.ACTION_PROP_ACP, ColumnName.ACP_BND_CLO);
        new AddColumnToTable(Version.V1700, TableName.ACTION_PROP_ACP, ColumnName.ACP_BND_BLO);
        new AddColumnToTable(Version.V1700, TableName.ACTION_PROP_ACP, ColumnName.ACP_BND_FORMAT);
        new AddColumnToTable(Version.V1700, TableName.ACTION_ACT, ColumnName.ACT_PARENT_ITER);
        new AddColumnToTable(Version.V1700, TableName.ACTION_ACT, ColumnName.ACT_REAL_NAME);
        new AddColumnToTable(Version.V1700, TableName.ACTION_ACT, ColumnName.ACT_NB_EXE);
        new AddColumnToTable(Version.V1700, TableName.ACTION_ACT, ColumnName.ACT_NB_BND_EXE);
        new AddColumnToTable(Version.V1700, TableName.ACTION_ACT, ColumnName.ACT_IS_BEGIN);
        new AddColumnToTable(Version.V1700, TableName.ACTION_ACT, ColumnName.ACT_NUM);
        new CreateIndex(Version.V1700, TableName.ACTION_PROP_ACP, "01", false, ColumnName.SESS_ID);
        new CreateIndex(Version.V1700, TableName.ACTION_SPROP_ASP, "01", false, ColumnName.DLV_ID);
        new CreateIndex(Version.V1700, TableName.ACTION_SPROP_ASP, "02", false, ColumnName.ACT_ID);
        new CreateIndex(Version.V1700, TableName.ACTION_ACT, "01", false, ColumnName.SESS_ID);
        new CreateIndex(Version.V1700, TableName.ACTION_ACT, "02", false, ColumnName.ACT_ID);
        new CreateIndex(Version.V1700, TableName.ACTION_S_ACT, "01", false, ColumnName.DLV_ID);
        new CreateIndex(Version.V1700, TableName.ACTION_S_ACT, "02", false, ColumnName.ACT_ID);
        new CreateIndex(Version.V1700, TableName.ACTION_STAT_AST, "01", false, ColumnName.SESS_ID);
        new CreateIndex(Version.V1700, TableName.PROCESS_STAT_PST, "01", false, ColumnName.SESS_ID);
        new CreateIndex(Version.V1700, TableName.SESSION_STAT_SST, "01", false, ColumnName.SESS_ID);
        new CreateIndex(Version.V1700, TableName.SESSION_SESS, "03", false, ColumnName.SESS_ID);
        new AddColumnToTable(Version.V1700, TableName.SESSION_SESS, ColumnName.SESS_LAST_TSTAMP);
        new AddColumnToTable(Version.V1700, TableName.SESSION_SESS, ColumnName.SESS_INACT_TIMEOUT);
        new CreateIndex(Version.V1708, TableName.LINK_LNK, "01", false, ColumnName.SESS_ID);
        new CreateIndex(Version.V1708, TableName.ACTION_ALTID_AAI, "01", false, ColumnName.DLV_ID);
        new CreateIndex(Version.V1708, TableName.SESSION_CHILDS_CSES, "01", false, ColumnName.SESS_ID);
        new CreateIndex(Version.V1708, TableName.SESSION_CHILDS_CSES, "02", false, ColumnName.CSES_ID);
        new AddColumnToTable(Version.V1709, TableName.DELIVERY_DLV, ColumnName.PCK_ID);
        new AddColumnToTable(Version.V1770, TableName.DELIVERY_DLV, ColumnName.CHECKSUM);
        this.insertSACT = new ColList();
        this.insertSACT.add(ColumnName.DLV_ID);
        this.insertSACT.add(ColumnName.ACT_ID);
        this.insertSACT.add(ColumnName.ACT_PARENT_ID);
        this.insertSACT.add(ColumnName.ACT_TECH);
        this.insertSACT.add(ColumnName.ACT_SHORT_NAME);
        this.insertSACT.add(ColumnName.ACT_TYPE);
        this.insertSACT.add(ColumnName.ACT_ERROR_ACCEPTED);
        this.insertSACT.add(ColumnName.ACT_IS_BEGIN);
        this.insertSACT.add(ColumnName.ACT_NB_CYCLE);
        this.insertSACT.add(ColumnName.ACT_RESTART_MODE);
        this.insertSACT.add(ColumnName.ACT_HAS_DYN_NAME);
        this.insertSACT.add(ColumnName.ACT_PARENT_PATH);
        this.insertSACP = new ColList();
        this.insertSACP.add(ColumnName.DLV_ID);
        this.insertSACP.add(ColumnName.ACT_ID);
        this.insertSACP.add(ColumnName.ACP_SHORT_NAME);
        this.insertSACP.add(ColumnName.ASP_SRC_VAR);
        this.insertSACP.add(ColumnName.ASP_SRC_CLO);
        this.insertSACP.add(ColumnName.ASP_SRC_BLO);
        this.insertSACP.add(ColumnName.ASP_SRC_FORMAT);
        this.insertSACP.add(ColumnName.PTY_TYPE_N);
        this.insertALTID = new ColList();
        this.insertALTID.add(ColumnName.DLV_ID);
        this.insertALTID.add(ColumnName.ACT_ID);
        this.insertALTID.add(ColumnName.AAI_ID);
        this.insertALTID.add(ColumnName.AAI_ORIGIN);
        this.insertAST = new ColList();
        this.insertAST.add(ColumnName.SESS_ID);
        this.insertAST.add(ColumnName.SESS_ITER);
        this.insertAST.add(ColumnName.ACT_ID);
        this.insertAST.add(ColumnName.ACT_ITER);
        this.insertAST.add(ColumnName.ACP_SHORT_NAME);
        this.insertAST.add(ColumnName.AST_STAT_SUM);
        this.insertPST = new ColList();
        this.insertPST.add(ColumnName.SESS_ID);
        this.insertPST.add(ColumnName.SESS_ITER);
        this.insertPST.add(ColumnName.ACT_ID);
        this.insertPST.add(ColumnName.ACT_ITER);
        this.insertPST.add(ColumnName.ACP_SHORT_NAME);
        this.insertPST.add(ColumnName.PST_STAT_SUM);
        this.insertPST.add(ColumnName.PST_STAT_MIN);
        this.insertPST.add(ColumnName.PST_STAT_MAX);
        this.insertPST.add(ColumnName.PST_STAT_COUNT);
        this.insertSST = new ColList();
        this.insertSST.add(ColumnName.SESS_ID);
        this.insertSST.add(ColumnName.SESS_ITER);
        this.insertSST.add(ColumnName.ACP_SHORT_NAME);
        this.insertSST.add(ColumnName.SST_STAT_SUM);
        this.insertSST.add(ColumnName.SST_STAT_MIN);
        this.insertSST.add(ColumnName.SST_STAT_MAX);
        this.insertSST.add(ColumnName.SST_STAT_COUNT);
    }

    void dropTable(Statement DMLStatement, String tableName) {
        String query = "DROP TABLE " + tableName;
        try {
            DMLStatement.execute(query);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void alterTablesToXXX(RdbmsUserLog log) throws EngineExceptionI {
        AlterDatabase alter;
        Connection conn;
        Statement st;
        block41: {
            st = null;
            conn = log.getConnection(true, true);
            if (conn != null) {
                if (!CommonUtils.existsTable((Connection)conn, (String)TableName.VERSION_HIST_VHS.getFullName(log))) {
                    String script = null;
                    try {
                        try {
                            st = conn.createStatement();
                            script = this.initCreateTable.getCreateScript(log);
                            log.info(script);
                            st.execute(script);
                            this.initCreateTable.setState(1);
                            break block41;
                        }
                        catch (Exception e) {
                            log.error(script, e);
                            throw new EngineExceptionI((Throwable)e);
                        }
                    }
                    finally {
                        log.releaseConnection(conn, null, st);
                    }
                }
                this.initCreateTable.setState(1);
            }
        }
        ArrayList<AlterDatabase> list = new ArrayList<AlterDatabase>();
        list.addAll(Version.V1700.list);
        list.addAll(Version.V1708.list);
        list.addAll(Version.V1709.list);
        list.addAll(Version.V1740.list);
        list.addAll(Version.V1770.list);
        HashMap<String, AlterDatabase> map = new HashMap<String, AlterDatabase>();
        for (AlterDatabase alter2 : list) {
            map.put(alter2.getUniqueId(), alter2);
        }
        map.remove(this.initCreateTable.getUniqueId());
        st = null;
        HashSet set = new HashSet();
        set.addAll(map.keySet());
        conn = log.getConnection(true, true);
        if (conn != null) {
            try {
                try {
                    st = conn.createStatement();
                    String query = "select * from " + TableName.VERSION_HIST_VHS.getFullName(log);
                    ResultSet rs = st.executeQuery(query);
                    while (rs.next()) {
                        int num;
                        String ver = rs.getString(ColumnName.V_VERSION.getName());
                        String key = ver + "|" + String.format("%1$10s", num = rs.getInt(ColumnName.VHS_NUM.getName()));
                        alter = (AlterDatabase)map.get(key);
                        if (alter == null) continue;
                        String userSql = rs.getString(ColumnName.VHS_USER_SQL.getName());
                        if (userSql != null && !userSql.isEmpty()) {
                            alter.setUserScript(userSql);
                        }
                        alter.setState(rs.getInt(ColumnName.VHS_STATUS.getName()));
                        set.remove(alter.getUniqueId());
                    }
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            finally {
                log.releaseConnection(conn, null, st);
            }
        }
        if ((conn = log.getConnection(true, true)) != null) {
            try {
                try {
                    st = null;
                    ColList _list = new ColList();
                    _list.add(ColumnName.V_VERSION);
                    _list.add(ColumnName.VHS_NUM);
                    _list.add(ColumnName.VHS_SQL);
                    _list.add(ColumnName.VHS_STATUS);
                    String script = _list.createInsertIntoScript(log, TableName.VERSION_HIST_VHS, null);
                    PreparedStatement ps = conn.prepareStatement(script);
                    st = ps;
                    for (String num : set) {
                        alter = (AlterDatabase)map.get(num);
                        ps.setString(_list.index(ColumnName.V_VERSION), alter.ver.toString());
                        ps.setInt(_list.index(ColumnName.VHS_NUM), alter.num);
                        String _script = alter.getCreateScript(log);
                        ps.setString(_list.index(ColumnName.VHS_SQL), _script);
                        ps.setInt(_list.index(ColumnName.VHS_STATUS), alter.state);
                        log.info(Messages.getString("UpdateDatabase.0") + alter.state + "):" + _script);
                        ps.execute();
                    }
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            finally {
                log.releaseConnection(conn, null, st);
            }
        }
        ArrayList<String> toDo = new ArrayList<String>();
        for (AlterDatabase alter3 : map.values()) {
            if (alter3.state == 1) continue;
            toDo.add(alter3.getUniqueId());
        }
        if (toDo.size() > 0) {
            st = null;
            conn = log.getConnection(true, true);
            Collections.sort(toDo);
            if (conn != null) {
                try {
                    try {
                        for (String str : toDo) {
                            Exception e;
                            AlterDatabase alter4;
                            block45: {
                                st = conn.createStatement();
                                alter4 = (AlterDatabase)map.get(str);
                                String script = alter4.userSql != null && !alter4.userSql.isEmpty() ? alter4.userSql : alter4.getCreateScript(log);
                                e = null;
                                try {
                                    try {
                                        log.info(script);
                                        st.execute(script);
                                    }
                                    catch (Exception e1) {
                                        log.error(script, e1);
                                        e = e1;
                                        st.close();
                                        break block45;
                                    }
                                }
                                catch (Throwable throwable) {
                                    st.close();
                                    throw throwable;
                                }
                                st.close();
                            }
                            if (e == null) {
                                alter4.setState(1);
                            } else {
                                alter4.setState(-1);
                            }
                            ColList _list = new ColList();
                            _list.add(ColumnName.VHS_STK_TRACE);
                            _list.add(ColumnName.VHS_STATUS);
                            _list.add(ColumnName.VHS_UPD_DATE);
                            _list.addKey(ColumnName.V_VERSION);
                            _list.addKey(ColumnName.VHS_NUM);
                            String query = "UPDATE " + TableName.VERSION_HIST_VHS.getFullName(log) + " set " + _list.setList() + " where " + _list.whereList();
                            PreparedStatement ps = conn.prepareStatement(query);
                            st = ps;
                            if (e != null) {
                                ps.setString(_list.index(ColumnName.VHS_STK_TRACE), e.getMessage());
                            } else {
                                ps.setString(_list.index(ColumnName.VHS_STK_TRACE), null);
                            }
                            ps.setInt(_list.index(ColumnName.VHS_STATUS), alter4.state);
                            ps.setString(_list.index(ColumnName.VHS_UPD_DATE), log.dateFormat.format(new Date()));
                            ps.setInt(_list.index(ColumnName.VHS_NUM), alter4.num);
                            ps.setString(_list.index(ColumnName.V_VERSION), alter4.ver.toString());
                            ps.execute();
                            st.close();
                            if (e != null) {
                                throw e;
                            }
                            if (alter4.ver.size() != alter4.num || alter4.ver.version.compareTo(log.version) <= 0) continue;
                            st = conn.createStatement();
                            log.ddl.updateVersion(st, alter4.ver.toString());
                        }
                    }
                    catch (Exception e) {
                        throw new EngineExceptionI((Throwable)e);
                    }
                }
                finally {
                    log.releaseConnection(conn, null, st);
                }
            }
        }
    }

    String columMask(String columnName, String type, Integer size) {
        return this.columMask(columnName, type, size, null, false);
    }

    String columMask(String columnName, String type, Integer size, Integer precision, boolean MANDATORY) {
        Object tmp = size != null ? size.toString() : "";
        tmp = (String)tmp + (String)(precision != null && size != null ? "," + String.valueOf(precision) : "");
        tmp = !((String)tmp).isEmpty() ? "(" + (String)tmp + ")" : "";
        return columnName + "\t" + type + (String)tmp;
    }

    class AddColumnToTable
    extends Table {
        ColumnName col;

        public AddColumnToTable(Version ver, TableName name, ColumnName col) {
            super(ver, name);
            this.col = col;
        }

        @Override
        public String getCreateScript(RdbmsUserLog log) {
            return "ALTER TABLE " + this.getFullName(log) + " ADD " + this.col.create(log);
        }
    }

    abstract class AlterDatabase
    implements Comparable<AlterDatabase> {
        int num;
        private String userSql;
        private int state = 0;
        Version ver;

        private AlterDatabase(Version ver) {
            this.ver = ver;
            ver.add(this);
        }

        @Override
        public int compareTo(AlterDatabase o) {
            int comp = this.ver.version.compareTo(o.ver.version);
            if (comp == 0) {
                return Integer.valueOf(this.num).compareTo(o.num);
            }
            return comp;
        }

        public void setUserScript(String userSql) {
            this.userSql = userSql;
        }

        public void setState(int state) {
            this.state = state;
        }

        public abstract String getCreateScript(RdbmsUserLog var1);

        public String getUniqueId() {
            return this.ver.toString() + "|" + String.format("%1$10s", this.num);
        }
    }

    class ColList {
        List<ColumnName> list = new ArrayList<ColumnName>();
        List<ColumnName> keys = new ArrayList<ColumnName>();

        ColList() {
        }

        ColList copy(ColumnName ... excludes) {
            ColList copy = new ColList();
            copy.list.addAll(this.list);
            copy.keys.addAll(this.keys);
            copy.list.removeAll(Arrays.asList(excludes));
            copy.keys.removeAll(Arrays.asList(excludes));
            return copy;
        }

        void add(ColumnName col) {
            this.list.add(col);
        }

        int index(ColumnName col) {
            Integer index = this.keys.indexOf((Object)col);
            if (index != null && index != -1) {
                return index + 1 + this.list.size();
            }
            return this.list.indexOf((Object)col) + 1;
        }

        String colList(ColumnName[] excludes) {
            Object tmp = "";
            int i = 1;
            while (i <= this.list.size()) {
                ColumnName col = this.list.get(i - 1);
                boolean toDo = true;
                if (excludes != null) {
                    ColumnName[] columnNameArray = excludes;
                    int n = excludes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ColumnName col2 = columnNameArray[n2];
                        if (col == col2) {
                            toDo = false;
                        }
                        ++n2;
                    }
                }
                if (toDo) {
                    if (((String)tmp).length() > 0) {
                        tmp = (String)tmp + ", ";
                    }
                    tmp = (String)tmp + String.valueOf((Object)col);
                }
                ++i;
            }
            return tmp;
        }

        String colValuesList(ColumnName[] excludes) {
            Object tmp = "";
            for (ColumnName col : this.list) {
                boolean toDo = true;
                if (excludes != null) {
                    ColumnName[] columnNameArray = excludes;
                    int n = excludes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ColumnName col2 = columnNameArray[n2];
                        if (col == col2) {
                            toDo = false;
                        }
                        ++n2;
                    }
                }
                if (!toDo) continue;
                if (((String)tmp).length() > 0) {
                    tmp = (String)tmp + ", ";
                }
                tmp = (String)tmp + "?";
            }
            return tmp;
        }

        String setList() {
            Object tmp = "";
            int i = 1;
            while (i < this.list.size() + 1) {
                if (i > 1) {
                    tmp = (String)tmp + ", ";
                }
                tmp = (String)tmp + this.list.get(i - 1).getName() + "=?";
                ++i;
            }
            return tmp;
        }

        String whereList() {
            Object tmp = "";
            int i = 1;
            while (i <= this.keys.size()) {
                if (i > 1) {
                    tmp = (String)tmp + " AND ";
                }
                tmp = (String)tmp + this.keys.get(i - 1).getName() + "=?";
                ++i;
            }
            return tmp;
        }

        public void addKey(ColumnName col) {
            this.keys.add(col);
        }

        public String createInsertIntoScript(RdbmsUserLog log, TableName table, ColumnName ... excludes) {
            return "INSERT INTO " + table.getFullName(log) + "(" + this.colList(excludes) + ") values(" + this.colValuesList(excludes) + ") ";
        }
    }

    static enum ColumnName {
        VHS_NUM(ColumnType.NUMERIC, 10),
        VHS_UPD_COUNT(ColumnType.NUMERIC, 10),
        VHS_SQL(ColumnType.VARCHAR, -1),
        VHS_USER_SQL(ColumnType.VARCHAR, -1),
        VHS_STK_TRACE(ColumnType.VARCHAR, -1),
        VHS_UPD_DATE(ColumnType.VARCHAR, 25),
        VHS_STATUS(ColumnType.NUMERIC, 1),
        DLV_ID(ColumnType.VARCHAR, 50),
        ASP_SRC_VAR(ColumnType.VARCHAR, -1),
        ASP_SRC_CLO(ColumnType.CLOB),
        ASP_SRC_BLO(ColumnType.BLOB),
        ASP_SRC_FORMAT(ColumnType.VARCHAR, 50),
        PTY_TYPE_N(ColumnType.NUMERIC, 2),
        PCA_TYPE_N(ColumnType.NUMERIC, 2),
        V_VERSION(ColumnType.VARCHAR, 10),
        V_UPD_DATE(ColumnType.VARCHAR, 25),
        V_TSTAMP_SQL(ColumnType.VARCHAR, -1),
        ACT_ID(ColumnType.VARCHAR, 50),
        ACT_PARENT_ID(ColumnType.VARCHAR, 50),
        ACT_PARENT_PATH(ColumnType.VARCHAR, -1),
        ACT_SHORT_NAME(ColumnType.VARCHAR, 255),
        ACT_TECH(ColumnType.VARCHAR, 255),
        ACT_TYPE(ColumnType.NUMERIC, 1),
        ACT_REAL_NAME(ColumnType.VARCHAR, 255),
        ACT_ERROR_ACCEPTED(ColumnType.NUMERIC, 1),
        ACT_IS_BEGIN(ColumnType.NUMERIC, 1),
        ACT_RESTART_MODE(ColumnType.NUMERIC, 1),
        ACT_NB_CYCLE(ColumnType.NUMERIC, 20),
        ACT_ITER(ColumnType.NUMERIC, 10),
        ACT_HAS_DYN_NAME(ColumnType.NUMERIC, 1),
        ACT_NUM(ColumnType.NUMERIC, 10),
        AAI_ID(ColumnType.VARCHAR, 255),
        AAI_ORIGIN(ColumnType.VARCHAR, 100),
        SESS_ID(ColumnType.VARCHAR, 50),
        SESS_ITER(ColumnType.NUMERIC, 10),
        ACP_SHORT_NAME(ColumnType.VARCHAR, 255),
        AST_STAT_SUM(ColumnType.NUMERIC, 20),
        AST_STAT_REJ(ColumnType.VARCHAR, 255),
        AST_NUM(ColumnType.NUMERIC, 10),
        PST_STAT_REJ(ColumnType.VARCHAR, 255),
        PST_STAT_MAX(ColumnType.NUMERIC, 20),
        PST_STAT_COUNT(ColumnType.NUMERIC, 10),
        PST_STAT_SUM(ColumnType.NUMERIC, 20),
        PST_STAT_MIN(ColumnType.NUMERIC, 20),
        PST_NUM(ColumnType.NUMERIC, 10),
        SST_STAT_REJ(ColumnType.VARCHAR, 255),
        SST_STAT_MAX(ColumnType.NUMERIC, 20),
        SST_STAT_COUNT(ColumnType.NUMERIC, 10),
        SST_STAT_SUM(ColumnType.NUMERIC, 20),
        SST_STAT_MIN(ColumnType.NUMERIC, 20),
        SESS_PARENT_ITER(SESS_ITER),
        SESS_BEGIN_TSTAMP(ColumnType.NUMERIC, 20),
        SESS_DURATION(ColumnType.NUMERIC, 12),
        SESS_TSTAMP_OFFSET(ColumnType.NUMERIC, 10),
        SESS_ACT_ROOT_ID(ACT_ID),
        SESS_LAUNCH_USER(ColumnType.VARCHAR, 255),
        SESS_LAST_TSTAMP(ColumnType.NUMERIC, 20),
        SESS_INACT_TIMEOUT(ColumnType.NUMERIC, 8),
        CSES_ITER(SESS_ITER),
        DLV_TSTAMP(ColumnType.NUMERIC, 20),
        DLV_VERSION(ColumnType.VARCHAR, 255),
        DLV_USER(ColumnType.VARCHAR, 255),
        DLV_COMMENT(ColumnType.VARCHAR, -1),
        CHECKSUM(ColumnType.VARCHAR, 255),
        ACP_NUM(AST_NUM),
        ACP_BND_VAR(ASP_SRC_VAR),
        ACP_BND_CLO(ASP_SRC_CLO),
        ACP_BND_BLO(ASP_SRC_CLO),
        ACP_BND_FORMAT(ASP_SRC_FORMAT),
        ACT_PARENT_ITER(ACT_ITER),
        ACT_NB_EXE(ColumnType.NUMERIC, 10),
        ACT_NB_BND_EXE(ColumnType.NUMERIC, 20),
        ACT_RET_CODE(ColumnType.NUMERIC, 10),
        ACT_END_DATE(ColumnType.VARCHAR, 25),
        ACT_BEGIN_DATE(ColumnType.VARCHAR, 25),
        CSES_ID(ColumnType.VARCHAR, 50),
        PCK_ID(ColumnType.VARCHAR, 50);

        ColumnType type;
        int size = -1;
        boolean mandatory = false;

        String create(RdbmsUserLog r) {
            return this.create(this.toString(), this.getCreateType(r), this.getSize(r), null, this.mandatory);
        }

        String getCreateType(RdbmsUserLog r) {
            if (this.type == ColumnType.VARCHAR) {
                return r.userLogRdbmsVarcharType;
            }
            if (this.type == ColumnType.NUMERIC) {
                return r.userLogRdbmsNumericType;
            }
            if (this.type == ColumnType.BLOB) {
                return r.userLogRdbmsBlobType;
            }
            if (this.type == ColumnType.CLOB) {
                return r.userLogRdbmsClobType;
            }
            return null;
        }

        private String create(String columnName, String type, Integer size, Integer precision, boolean mandatory) {
            Object tmp = size != null ? size.toString() : "";
            tmp = (String)tmp + (String)(precision != null && size != null ? "," + String.valueOf(precision) : "");
            tmp = !((String)tmp).isEmpty() ? "(" + (String)tmp + ")" : "";
            return columnName + "\t" + type + (String)tmp;
        }

        Integer getSize(RdbmsUserLog r) {
            if (this.size == -1 && this.type == ColumnType.VARCHAR) {
                return Integer.valueOf(r.userLogRdbmsVarcharMaxSize);
            }
            if (this.size == -1) {
                return null;
            }
            return this.size;
        }

        private ColumnName(ColumnType type) {
            this.type = type;
        }

        private ColumnName(ColumnName col) {
            this.type = col.type;
            this.size = col.size;
            this.mandatory = col.mandatory;
        }

        private ColumnName(ColumnType type, int size) {
            this.type = type;
            this.size = size;
        }

        private ColumnName(ColumnType type, boolean mandatory) {
            this.type = type;
            this.mandatory = mandatory;
        }

        private ColumnName(ColumnType type, int size, boolean mandatory) {
            this.type = type;
            this.size = size;
            this.mandatory = mandatory;
        }

        String getName() {
            return this.toString();
        }
    }

    abstract class ColumnSet
    extends AlterDatabase {
        List<ColumnName> list;

        private ColumnSet(Version ver) {
            super(ver);
            this.list = new ArrayList<ColumnName>();
        }

        void add(ColumnName ... cols) {
            this.list.addAll(Arrays.asList(cols));
        }
    }

    static enum ColumnType {
        VARCHAR,
        BLOB,
        CLOB,
        NUMERIC;

    }

    class CreateIndex
    extends Table {
        boolean unique;
        String indexName;

        public CreateIndex(Version ver, TableName name, String suffix, boolean unique, ColumnName ... cols) {
            super(ver, name);
            this.add(cols);
            this.unique = unique;
            this.indexName = "IDX_" + name.alias + "_" + suffix;
        }

        @Override
        public String getCreateScript(RdbmsUserLog log) {
            Object tmp = "";
            int i = 0;
            for (ColumnName col : this.list) {
                if (i > 0) {
                    tmp = (String)tmp + ", ";
                }
                tmp = (String)tmp + col.name() + "\n";
                ++i;
            }
            if (log.userLogRdbmsUseSchemaNameForIndexCreation) {
                return "CREATE " + (this.unique ? "UNIQUE " : "") + "INDEX " + log.userLogRdbmsSchemaName + this.indexName + "0 ON " + this.getFullName(log) + " (" + (String)tmp + ")" + log.userLogRdbmsIndexCreationOption;
            }
            return "CREATE " + (this.unique ? "UNIQUE " : "") + "INDEX " + this.indexName + "0 ON " + this.getFullName(log) + " (" + (String)tmp + ")" + log.userLogRdbmsIndexCreationOption;
        }
    }

    class CreateTable
    extends Table {
        public CreateTable(Version ver, TableName name, ColumnName ... cols) {
            super(ver, name);
            this.add(cols);
        }

        @Override
        public String getCreateScript(RdbmsUserLog log) {
            Object tmp = "";
            int i = 0;
            for (ColumnName col : this.list) {
                if (i > 0) {
                    tmp = (String)tmp + ",";
                }
                tmp = (String)tmp + col.create(log) + "\n";
                ++i;
            }
            return "CREATE TABLE " + this.getFullName(log) + "(\n" + (String)tmp + "\n)" + log.userLogRdbmsTableCreationOption;
        }
    }

    class DropColumnFromTable
    extends Table {
        ColumnName col;

        public DropColumnFromTable(Version ver, TableName name, ColumnName col) {
            super(ver, name);
            this.col = col;
        }

        @Override
        public String getCreateScript(RdbmsUserLog log) {
            return "ALTER TABLE " + this.getFullName(log) + " DROP " + this.col.getName();
        }
    }

    abstract class Table
    extends ColumnSet {
        TableName name;

        public Table(Version ver, TableName name) {
            super(ver);
            this.name = name;
        }

        public String getDropScript() {
            return "DROP TABLE " + String.valueOf((Object)this.name);
        }

        String getFullName(RdbmsUserLog log) {
            return this.name.getFullName(log);
        }
    }

    static enum TableName {
        VERSION_V("VERSION"),
        VERSION_HIST_VHS("VHS"),
        SESSION_SESS("SESS"),
        SESSION_CHILDS_CSES("CSES"),
        LINK_LNK("LNK"),
        DELIVERY_DLV("DLV"),
        ACTION_PROP_ACP("ACP"),
        ACTION_SPROP_ASP("ASP"),
        ACTION_ALTID_AAI("AAI"),
        ACTION_ACT("ACT"),
        ACTION_STAT_AST("AST"),
        PROCESS_STAT_PST("PST"),
        SESSION_STAT_SST("SST"),
        SESSION_TSTAMP_STP("STP"),
        USER_ACTION_LOG_UAL("UAL"),
        TECH_ACTION_LOG_TAL("TAL"),
        ACTION_S_ACT("S_ACT");

        String alias;

        private TableName(String alias) {
            this.alias = alias;
        }

        String getFullName(RdbmsUserLog log) {
            return log.userLogRdbmsSchemaName + log.userLogRdbmsTablePrefix + String.valueOf((Object)this);
        }

        String getShortName(RdbmsUserLog log) {
            return log.userLogRdbmsTablePrefix + String.valueOf((Object)this);
        }

        String getName() {
            return this.toString();
        }
    }

    public static enum Version implements Comparable<Version>
    {
        V1700("1.7.0.0"),
        V1708("1.7.0.8"),
        V1709("1.7.0.9"),
        V1740("1.7.4.0"),
        V1770("1.7.5.8");

        String version;
        List<AlterDatabase> list = new ArrayList<AlterDatabase>();
        private Integer num = -1;

        private Version(String version) {
            this.version = version;
        }

        public String toString() {
            return this.version;
        }

        public void add(AlterDatabase alter) {
            this.list.add(alter);
            alter.num = this.list.size();
        }

        public int size() {
            return this.list.size();
        }

        public int num() {
            if (this.num == -1) {
                this.num = Integer.valueOf(this.name().substring(1, this.name().length() - 1));
            }
            return this.num;
        }
    }
}

