/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog.reportLog;

import com.indy.engine.Global;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.objects.LinkDataExchangeI;
import com.indy.engine.core.common.objects2.IActionDataExchange;
import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.engine.core.common.objects2.IVariable;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.main.ActionGraphLinkI;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.action.IAction;
import com.indy.engine.main.repository.IMemoryDelivery;
import com.indy.engine.manager.Action;
import com.indy.engine.manager.ActionCode;
import com.indy.engine.userLog.UpdateDatabase;
import com.indy.engine.userLog.reportLog.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MemorySessionReportLogI {
    int reportStatus = 0;
    Date lastAccess = null;
    Date lastRefresh = null;
    Date lastBeginDate = null;
    Date lastEndDate = null;
    int lastEngineStatus = -99;
    String sessionID = null;
    MainEngineI mainEngine;
    private final Logger logger = LogManager.getLogger(MemorySessionReportLogI.class);
    Logger memoryLogger = LogManager.getLogger((String)"com.indy.engine.memory");

    public void clear() {
        this.lastAccess = null;
        this.lastRefresh = null;
        if (this.mainEngine != null) {
            try {
                this.mainEngine.clear();
            }
            catch (Exception e) {
                this.logger.warn("Exception while clearing mainEngine", (Throwable)e);
            }
        }
        this.mainEngine = null;
    }

    public MemorySessionReportLogI(String sID) {
        this.sessionID = sID;
    }

    public MainEngineI getMainEngine() {
        return this.mainEngine;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public void setLastRefresh(Date lRefresh) {
        this.lastRefresh = lRefresh;
    }

    public void setLastAccess(Date lAccess) {
        this.lastAccess = lAccess;
    }

    public int getLastEngineStatus() {
        return this.lastEngineStatus;
    }

    public int getStatus() {
        return this.reportStatus;
    }

    public void setStatus(int s) {
        this.reportStatus = s;
    }

    public void setMainEngine(MainEngineI mEngine) {
        this.mainEngine = mEngine;
    }

    public int refreshSession(String sessionId) throws EngineExceptionI {
        int ret = 0;
        this.getMemoryLogger().info(this.getSessionID() + " Refesh Session Start");
        if (this.getStatus() != 1) {
            try {
                boolean toLoad = true;
                String str = "";
                this.updateSession(this.mainEngine.uLog.getSession());
                this.lastEngineStatus = this.mainEngine.getSessionStatus();
                int sessIter = this.mainEngine.getSessionIter();
                if (this.lastRefresh == null) {
                    this.lastBeginDate = this.mainEngine.getBeginDate();
                    this.lastEndDate = this.mainEngine.getEndDate();
                } else if (this.lastEndDate != null && this.lastEndDate.getTime() == this.mainEngine.getEndDate().getTime()) {
                    toLoad = false;
                }
                if (toLoad) {
                    Global.dLog.write(this.mainEngine.getSessionName(), "MemorySessionReportLogI->refreshSession", Messages.getString("MemorySessionReportLogI.0") + sessionId, 2, 2, "DEBUG");
                    HashMap<String, Variable> lstLogVar = new HashMap<String, Variable>();
                    this.getMemoryLogger().info(this.getSessionID() + Messages.getString("MemorySessionReportLogI.1"));
                    int _lastvarNum = this.mainEngine.uLog.getLstProperties(lstLogVar);
                    Variable var = (Variable)lstLogVar.get("CORE_SESSION_FAILURE_CAUSE_ACTION_ID");
                    if (var != null) {
                        this.mainEngine.setfailureCauseActionId(var.getValue());
                    }
                    if (_lastvarNum > 0) {
                        this.mainEngine.setNumVar(_lastvarNum);
                    }
                    this.getMemoryLogger().info(this.getSessionID() + Messages.getString("MemorySessionReportLogI.2"));
                    this.getMemoryLogger().info(this.getSessionID() + Messages.getString("MemorySessionReportLogI.3"));
                    Global.dLog.write(this.mainEngine.getSessionName(), "MemorySessionReportLogI->refreshSession", Messages.getString("MemorySessionReportLogI.4") + sessionId, 6, 2, "DEBUG");
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.S");
                    this.getMemoryLogger().info("MemorySessionReport " + this.mainEngine.getSessionName() + " addAllVariable start");
                    for (Variable variable : lstLogVar.values()) {
                        Action action;
                        this.mainEngine.getEngineContext().addVariable(variable);
                        if (!variable.getShortName().equals(VariableType.CORE_ACTION_TXT.getName()) || !((action = this.getMainEngine().getLstActions().get(variable.getActionName())) instanceof ActionCode)) continue;
                        Variable executed = action.getVariablePublisher().publishVariable(VariableType.CORE_ACTION_EXECUTED_TXT, (Object)variable.getValue());
                        ((ActionCode)action).setExectuedCodeVariable((IVariable)executed);
                    }
                    this.getMemoryLogger().info("MemorySessionReport " + this.mainEngine.getSessionName() + " addAllVariable end");
                    Global.dLog.write(this.mainEngine.getSessionName(), "MemorySessionReportLogI->refreshSession", "OK", 2, 2, "DEBUG");
                    Global.dLog.write(this.mainEngine.getSessionName(), "MemorySessionReportLogI->refreshSession", Messages.getString("MemorySessionReportLogI.5") + sessionId + Messages.getString("MemorySessionReportLogI.6") + this.mainEngine.lstActions.size(), 6, 2, "DEBUG");
                    if (this.mainEngine.getVersion() == null) {
                        this.getMemoryLogger().info(this.getSessionID() + Messages.getString("MemorySessionReportLogI.7"));
                        Iterator<Action> it = this.mainEngine.lstActions.values().iterator();
                        IAction act = null;
                        while (it.hasNext()) {
                            try {
                                act = it.next();
                                Global.dLog.write(this.mainEngine.getSessionName(), "MemorySessionReportLogI->refreshSession", Messages.getString("MemorySessionReportLogI.8") + act.getActionName(), 6, 3, "DEBUG");
                                try {
                                    act.setBeginDate(dateFormat.parse(((IVariable)lstLogVar.get(Global.VAR_PREFIXE + act.getActionName() + "/" + VariableType.CORE_BEGIN_DATE.getName())).getValue()));
                                }
                                catch (NullPointerException e) {
                                    act.setBeginDate(null);
                                }
                                try {
                                    act.setActionRuntimeName(((IVariable)lstLogVar.get(Global.VAR_PREFIXE + act.getActionName() + "/" + VariableType.CORE_DYNAMIC_NAME.getName())).getValue());
                                }
                                catch (NullPointerException e) {
                                    act.setActionRuntimeName(null);
                                }
                                if (act.getBeginDate() == null) continue;
                                try {
                                    act.setEndDate(dateFormat.parse(((IVariable)lstLogVar.get(Global.VAR_PREFIXE + act.getActionName() + "/" + VariableType.CORE_END_DATE.getName())).getValue()));
                                }
                                catch (NullPointerException e) {
                                    act.setEndDate(null);
                                }
                                if (act.getEndDate() != null) {
                                    try {
                                        Global.dLog.write(this.mainEngine.getSessionName(), "MemorySessionReportLogI->refreshSession", Messages.getString("MemorySessionReportLogI.9"), 6, 4, "DEBUG");
                                        int status = Integer.valueOf(((IVariable)lstLogVar.get(Global.VAR_PREFIXE + act.getActionName() + "/" + VariableType.CORE_RET_CODE.getName())).getValue());
                                        if (act.getBeginDate().compareTo(act.getEndDate()) > 0) {
                                            act.setActionState(2);
                                        } else {
                                            act.setActionState(status == 0 ? 1 : status);
                                        }
                                        act.setNbExecution(Integer.valueOf(((IVariable)lstLogVar.get(Global.VAR_PREFIXE + act.getActionName() + "/" + VariableType.CORE_NB_EXECUTIONS.getName())).getValue()));
                                        try {
                                            act.setBeginAction(Boolean.valueOf(((IVariable)lstLogVar.get(Global.VAR_PREFIXE + act.getActionName() + "/" + VariableType.CORE_BEGIN_ACTION.getName())).getValue()));
                                        }
                                        catch (NullPointerException e) {
                                            Global.dLog.write("ReportEngineServer", "MemorySessionReportLogI->refreshSession", Messages.getString("MemorySessionReportLogI.11") + e.getMessage(), 6, 4, "DEBUG");
                                        }
                                    }
                                    catch (NullPointerException e) {
                                        Global.dLog.write(this.mainEngine.getSessionName(), "MemorySessionReportLogI->refreshSession", Messages.getString("MemorySessionReportLogI.12") + e.getMessage(), 6, 4, "DEBUG");
                                    }
                                    continue;
                                }
                                act.setActionState(2);
                            }
                            catch (ParseException e) {
                                Global.dLog.write(this.mainEngine.getSessionName(), "MemorySessionReportLogI->refreshSession", Messages.getString("MemorySessionReportLogI.13") + e.getMessage(), 0, 0, "ERROR");
                                this.reportStatus = -1;
                                throw new EngineExceptionI(Messages.getString("MemorySessionReportLogI.14") + sessionId + Messages.getString("MemorySessionReportLogI.15") + act.getActionName(), (Throwable)e);
                            }
                            catch (Exception e) {
                                Global.dLog.write(this.mainEngine.getSessionName(), "MemorySessionReportLogI->refreshSession", Messages.getString("MemorySessionReportLogI.16") + e.getMessage(), 0, 0, "ERROR");
                                this.reportStatus = -1;
                                throw new EngineExceptionI(Messages.getString("MemorySessionReportLogI.17") + sessionId + Messages.getString("MemorySessionReportLogI.18") + act.getActionName(), (Throwable)e);
                            }
                        }
                    } else if (this.mainEngine.getVersion().compareTo(UpdateDatabase.Version.V1700.toString()) >= 0) {
                        HashMap<String, IActionDataExchange> lstAct = new HashMap<String, IActionDataExchange>();
                        this.getMemoryLogger().info(this.getSessionID() + Messages.getString("MemorySessionReportLogI.19"));
                        int _lastActNum = this.mainEngine.uLog.getActions(sessionId, sessIter, this.mainEngine.getNumAction(), lstAct);
                        if (_lastActNum > 0) {
                            this.mainEngine.setNumAction(_lastActNum);
                        }
                        for (IActionDataExchange acte : lstAct.values()) {
                            Action act = this.mainEngine.lstActionsId.get(acte.getId());
                            if (act == null) continue;
                            act.setBeginDate(acte.getBeginDate());
                            act.setEndDate(acte.getEndDate());
                            act.setActionState(acte.getState());
                            act.setNbExecution(acte.getNbExecution());
                            act.setBeginAction(acte.isBeginAction());
                            act.setIteration(acte.getIteration());
                        }
                        this.getMemoryLogger().info(this.getSessionID() + Messages.getString("MemorySessionReportLogI.20"));
                        lstLogVar.clear();
                        lstLogVar = null;
                    }
                    this.getMemoryLogger().info(this.getSessionID() + Messages.getString("MemorySessionReportLogI.21"));
                    this.updateLinks(this.mainEngine);
                    this.getMemoryLogger().info(this.getSessionID() + Messages.getString("MemorySessionReportLogI.22"));
                    this.getMemoryLogger().info(this.getSessionID() + Messages.getString("MemorySessionReportLogI.23"));
                    this.updateChildSessions(this.mainEngine);
                    this.getMemoryLogger().info(this.getSessionID() + Messages.getString("MemorySessionReportLogI.24"));
                }
                this.lastRefresh = new Date();
                this.lastAccess = new Date();
            }
            catch (EngineExceptionI e) {
                Global.dLog.write(this.mainEngine.getSessionName(), "MemorySessionReportLogI->refreshSession", "EngineExceptionI : " + e.getMessage(), 0, 0, "ERROR");
                this.reportStatus = -1;
                throw new EngineExceptionI(Messages.getString("MemorySessionReportLogI.25") + sessionId, (Throwable)e);
            }
            catch (Exception e) {
                Global.dLog.write(this.mainEngine.getSessionName(), "MemorySessionReportLogI->refreshSession", "Exception : " + e.getMessage(), 0, 0, "ERROR");
                this.reportStatus = -1;
                throw new EngineExceptionI(Messages.getString("MemorySessionReportLogI.26") + sessionId, (Throwable)e);
            }
            this.getMemoryLogger().info(this.getSessionID() + Messages.getString("MemorySessionReportLogI.27"));
        }
        return ret;
    }

    private Logger getMemoryLogger() {
        return this.memoryLogger;
    }

    public MainEngineI loadSession(String sessionId, String pLogName, String sessionName) throws EngineExceptionI {
        IMemoryDelivery deliv;
        MainEngineI mEngine;
        block4: {
            this.getMemoryLogger().info(sessionId + Messages.getString("MemorySessionReportLogI.28"));
            mEngine = null;
            this.reportStatus = 2;
            Global.dLog.write("ReportEngineServer", "MemorySessionReportLogI->loadSession", Messages.getString("MemorySessionReportLogI.29") + sessionId, 2, 1, "DEBUG");
            this.mainEngine = mEngine = new MainEngineI(0, pLogName, false, sessionName, sessionId);
            deliv = mEngine.uLog.getSessionDelivery();
            if (deliv != null) break block4;
            return null;
        }
        try {
            this.mainEngine.initSession(deliv, sessionId, true);
        }
        catch (EngineExceptionI e) {
            Global.dLog.write("ReportEngineServer", "MemorySessionReportLogI->loadSession", "EngineExceptionI : " + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("MemorySessionReportLogI.30") + sessionId, (Throwable)e);
        }
        catch (Exception e) {
            Global.dLog.write("ReportEngineServer", "MemorySessionReportLogI->loadSession", "Exception : " + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("MemorySessionReportLogI.31") + sessionId, (Throwable)e);
        }
        this.refreshSession(this.mainEngine.getSessionID());
        this.reportStatus = 1;
        this.getMemoryLogger().info(sessionId + Messages.getString("MemorySessionReportLogI.32"));
        return mEngine;
    }

    public int updateChildSessions(MainEngineI mainEngine) throws EngineExceptionI {
        int ret = 0;
        String sessionId = mainEngine.getSessionID();
        int sessIter = mainEngine.getSessionIter();
        try {
            mainEngine.lstChildSessions.putAll(mainEngine.uLog.getLstChildSessions());
        }
        catch (EngineExceptionI e) {
            Global.dLog.write(mainEngine.getSessionName(), "MemorySessionReportLogI->updateChildSessions", "EngineExceptionI : " + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("MemorySessionReportLogI.33"), (Throwable)e);
        }
        return ret;
    }

    public int updateLinks(MainEngineI mainEngine) throws EngineExceptionI {
        int ret = 0;
        String sessionId = mainEngine.getSessionID();
        int sessIter = mainEngine.getSessionIter();
        Global.dLog.write(mainEngine.getSessionName(), "MemorySessionReportLogI->updateLinks", Messages.getString("MemorySessionReportLogI.34") + sessionId, 5, 2, "DEBUG");
        Map<String, LinkDataExchangeI> lstLinksUpdates = null;
        try {
            lstLinksUpdates = mainEngine.uLog.getLstLinkChanges();
            if (lstLinksUpdates != null) {
                LinkDataExchangeI lde2 = null;
                ActionGraphLinkI agl = null;
                for (LinkDataExchangeI lde2 : lstLinksUpdates.values()) {
                    agl = mainEngine.lstLinks.get(lde2.linkId);
                    if (agl == null) continue;
                    agl.setIter(lde2.linkIter);
                    if (lde2.linkStatus == 1) {
                        Global.dLog.write(mainEngine.getSessionName(), "MemorySessionReportLogI->updateLinks", Messages.getString("MemorySessionReportLogI.35") + agl.getActionSource().getActionName() + Messages.getString("MemorySessionReportLogI.36") + agl.getActionTarget().getActionName(), 6, 2, "DEBUG");
                    }
                    agl.setState(lde2.linkStatus);
                    agl.setDate(lde2.linkDate);
                    if (lde2.linkCondition != null) {
                        agl.sCondition.sOriginScript = lde2.linkCondition;
                    }
                    if (lde2.linkExecutedCondition == null) continue;
                    agl.sCondition.sScript = lde2.linkExecutedCondition;
                }
                lstLinksUpdates.clear();
                lstLinksUpdates = null;
            }
        }
        catch (EngineExceptionI e) {
            Global.dLog.write(mainEngine.getSessionName(), "MemorySessionReportLogI->updateLinks", "EngineExceptionI : " + e.getMessage(), 0, 0, "ERROR");
            throw new EngineExceptionI(Messages.getString("MemorySessionReportLogI.37") + sessionId, (Throwable)e);
        }
        return ret;
    }

    public int updateSession(ISessionDataExchange sde) throws EngineExceptionI {
        int ret = 0;
        if (sde == null) {
            throw new EngineExceptionI(Messages.getString("MemorySessionReportLogI.38"));
        }
        this.mainEngine.setBeginDate(sde.getBeginDate());
        this.mainEngine.setEndDate(sde.getEndDate());
        this.mainEngine.setSessionName(sde.getName());
        this.mainEngine.setSessionMsg(sde.getMessage());
        this.mainEngine.setSessionStatus(sde.getStatus());
        this.mainEngine.setSessionIter(sde.getIter());
        this.mainEngine.setExecutionMode(sde.getExecutionMode());
        this.mainEngine.setLaunchMode(sde.getLaunchMode());
        this.mainEngine.setGuestHost(sde.getGuestHost());
        this.mainEngine.setConfiguration(sde.getConfiguration());
        this.mainEngine.setVersion(sde.getVersion());
        return ret;
    }
}

