/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.Global;
import com.indy.engine.common.security.SecurityConfiguration;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.main.repository.impl.AnalyticsV3Repository;
import com.indy.engine.userLog.UserLogManagerI;
import com.indy.engine.wsdl.HttpSoapWrapper;
import com.indy.engine.wsdl.InvocationRest;
import com.indy.engine.wsdl.Messages;
import com.indy.engine.wsdl.WsdlAPI;
import com.semarchy.xdi.runtime.httpserver.HttpErrorHandler;
import com.semarchy.xdi.runtime.httpserver.RestInvocationHandler;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class DeliveryRestServlet2
extends HttpServlet {
    protected final transient WsdlAPI wsdlApi;
    private static final HttpErrorHandler errorHandler = new HttpErrorHandler();

    public DeliveryRestServlet2(WsdlAPI wsdlAPI2) {
        this.wsdlApi = wsdlAPI2;
    }

    protected static boolean checkExecutionPermission(Principal userPrincipal) {
        if (Global.hasUser()) {
            String username;
            if (userPrincipal != null && (username = userPrincipal.getName()) != null && !username.isEmpty()) {
                SecurityConfiguration.User user = Global.getUser(username);
                return user != null && (user.isAdmin() || user.canExecute());
            }
            return Global.getAnonymousUser() != null && Global.getAnonymousUser().canExecute();
        }
        return true;
    }

    public static String encode(Map<Delivery.Parameter, String> params, String encoding) throws UnsupportedEncodingException {
        StringBuilder queryString = null;
        if (params == null) {
            return null;
        }
        for (Map.Entry<Delivery.Parameter, String> e : params.entrySet()) {
            if (e.getKey() == null || !e.getKey().isOutput() || e.getKey().getName() == null || e.getValue() == null) continue;
            if (queryString == null) {
                queryString = new StringBuilder();
            } else {
                queryString.append("&");
            }
            if (encoding == null) {
                throw new IllegalArgumentException("The encoding parameter cannot be null");
            }
            queryString.append(e.getKey().getName() + "=" + URLEncoder.encode(e.getValue(), encoding));
        }
        if (queryString == null) {
            return null;
        }
        return queryString.toString();
    }

    URIParse parseURI(String requestURI, String contentType, String httpMethod) throws Exception {
        String lastPart;
        requestURI = requestURI.replace("/rest/DeliveryService/3/default/", "/rest/DeliveryService/2/").replace("/rest/StambiaDeliveryService/3/default/", "/rest/DeliveryService/2/");
        URIParse urlParse = new URIParse();
        int index = requestURI.indexOf("/2/");
        urlParse.localPath = lastPart = requestURI.substring(index + 3);
        String deliveryName = null;
        urlParse.parts = Arrays.asList(lastPart.split("/"));
        IDeliveryRepository repo = this.wsdlApi.getRepository();
        if (repo == null) {
            throw new Exception(Messages.getString("HttpRestEndpoint02.0"));
        }
        if (repo.getPlugin() instanceof AnalyticsV3Repository) {
            int cpt = 0;
            index = lastPart.indexOf("/");
            while (index > -1 && cpt < 2) {
                index = lastPart.indexOf("/", index + 1);
                ++cpt;
            }
            deliveryName = lastPart.endsWith("/") ? lastPart.substring(0, index) : lastPart;
            if (repo.exists(deliveryName)) {
                urlParse.delivery = repo.getDelivery(deliveryName, false);
            }
        } else {
            index = lastPart.indexOf("/");
            deliveryName = index > -1 ? lastPart.substring(0, lastPart.indexOf("/")) : lastPart;
            Delivery deliv = this.wsdlApi.getAllDeliveries().get(deliveryName);
            if (!this.restrictOriginalName(deliv)) {
                urlParse.delivery = deliv;
            }
        }
        if (urlParse.delivery == null) {
            Delivery deliv = this.getCustomPathDelivery(urlParse.parts, httpMethod);
            if (deliv != null) {
                urlParse.delivery = deliv;
            } else {
                throw new Exception(Messages.getString("HttpRestEndpoint02.1") + deliveryName + Messages.getString("HttpRestEndpoint02.2"));
            }
        }
        return urlParse;
    }

    protected boolean restrictOriginalName(Delivery deliv) {
        return false;
    }

    private Delivery getCustomPathDelivery(List<String> pathParts, String httpMethod) {
        for (Delivery deliv : this.wsdlApi.getAllDeliveries().values()) {
            if (deliv.getHttpRestDeliveryProperties() == null || !deliv.getHttpRestDeliveryProperties().testRequest(pathParts) || !deliv.getHttpRestDeliveryProperties().testMethod(httpMethod)) continue;
            return deliv;
        }
        return null;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getMethod() != null && !req.getMethod().isEmpty()) {
            String method = req.getMethod();
            if (HttpMethod.GET.name().equals(method) || HttpMethod.POST.name().equals(method) || HttpMethod.PUT.name().equals(method) || HttpMethod.DELETE.name().equals(method) || HttpMethod.PATCH.name().equals(method)) {
                this.invokeDelivery(req, resp);
            } else {
                super.service(req, resp);
            }
        } else {
            super.service(req, resp);
        }
    }

    private void setClassLoader() {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
    }

    protected void invokeDelivery(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.setClassLoader();
        try {
            if (!DeliveryRestServlet2.checkExecutionPermission(req.getUserPrincipal())) {
                resp.sendError(HttpStatus.FORBIDDEN.value());
                return;
            }
            String contentType = req.getHeader("Content-Type");
            boolean urlEncoded = contentType != null && contentType.contains("application/x-www-form-urlencoded");
            Map<String, String> requestQueryPair = HttpSoapWrapper.splitQuery(req.getQueryString());
            if (urlEncoded) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InvocationRest.copy((InputStream)req.getInputStream(), baos);
                String query = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                Map<String, String> localQueryPair = HttpSoapWrapper.splitQuery(query);
                requestQueryPair.putAll(localQueryPair);
            }
            HashMap<String, String> input = new HashMap<String, String>();
            requestQueryPair.entrySet().stream().forEach(e -> {
                String string = input.put("~/" + (String)e.getKey(), (String)e.getValue());
            });
            input.put("~/CORE_HTTP_REQUEST_METHOD", req.getMethod());
            URIParse uriParse = this.parseURI(req.getContextPath() + req.getServletPath() + req.getPathInfo(), contentType, req.getMethod());
            List<String> parts = uriParse.parts;
            Delivery delivery = uriParse.delivery;
            InvocationRest invok = new InvocationRest((InputStream)req.getInputStream(), (OutputStream)resp.getOutputStream(), delivery, uriParse.localPath, this.wsdlApi, input, req.getUserPrincipal() == null ? null : req.getUserPrincipal().getName(), req.getRemoteAddr());
            String headerLogLevel = req.getHeader("X-logLevel");
            String headerParentSessionId = req.getHeader("X-parentSessionId");
            String headerSessionName = req.getHeader("X-sessionName");
            String headerSynchLogMode = req.getHeader("X-synchLogMode");
            UserLogManagerI.SynchMode synchLogMode = null;
            if (headerSynchLogMode != null && !headerSynchLogMode.isEmpty()) {
                synchLogMode = UserLogManagerI.SynchMode.valueOf(headerSynchLogMode);
            }
            String headerInputMessageManagement = req.getHeader("X-keepInputMessage");
            String headerOutputMessageManagement = req.getHeader("X-keepOutputMessage");
            String headerFaultMessageManagement = req.getHeader("X-keepFaultMessage");
            if (delivery != null) {
                if (headerInputMessageManagement == null || headerInputMessageManagement.isEmpty()) {
                    headerInputMessageManagement = delivery.getKeepInputMessage();
                }
                if (headerOutputMessageManagement == null || headerOutputMessageManagement.isEmpty()) {
                    headerOutputMessageManagement = delivery.getKeepOutputMessage();
                }
                if (headerFaultMessageManagement == null || headerFaultMessageManagement.isEmpty()) {
                    headerFaultMessageManagement = delivery.getKeepFaultMessage();
                }
            }
            invok.setInputMessageManagement(headerInputMessageManagement);
            invok.setOutputMessageManagement(headerOutputMessageManagement);
            invok.setFaultMessageManagement(headerFaultMessageManagement);
            String headerExecutionConfiguration = req.getHeader("X-Delivery-Configuration-Name");
            invok.setExecutionConfiguration(headerExecutionConfiguration);
            invok.setAsynchronous(req.getHeader("X-asynchronous"));
            Integer logLevel = null;
            if (headerLogLevel != null && !headerLogLevel.isEmpty()) {
                logLevel = Integer.valueOf(headerLogLevel);
            }
            invok.invoke(new RestInvocationHandler(req, resp, parts, urlEncoded), headerParentSessionId, headerSessionName, logLevel, synchLogMode);
        }
        catch (Exception e2) {
            this.handleError("HttpRest Delivery invocation failed", e2, resp);
        }
    }

    protected void handleError(String message, Exception t, HttpServletResponse resp) {
        Consumer<String> errorConsumer = errorMessage -> {
            try {
                resp.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), errorMessage);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        errorHandler.handleError(message, t, errorConsumer);
    }

    class URIParse {
        Delivery delivery;
        List<String> parts;
        String localPath;
        String contentType;

        URIParse() {
        }
    }
}

