/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.scheduler.EngineSchedulerI;
import com.indy.engine.service.ServiceManager;
import com.indy.engine.service.ServiceState;
import com.semarchy.xdi.runtime.httpserver.ControllerAdvice;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SchedulerConfiguration {
    @Bean
    public Scheduler scheduler() {
        return new SchedulerWrapper();
    }

    private static class SchedulerWrapper
    implements Scheduler {
        private SchedulerWrapper() {
        }

        private Scheduler getScheduler() {
            EngineSchedulerI scheduler = (EngineSchedulerI)ServiceManager.INSTANCE.getService("scheduler");
            if (scheduler != null && scheduler.getState() == ServiceState.Running) {
                return scheduler.getScheduler();
            }
            throw new ControllerAdvice.SchedulerNotRunningException();
        }

        public void addCalendar(String calName, Calendar calendar, boolean replace, boolean updateTriggers) throws SchedulerException {
            this.getScheduler().addCalendar(calName, calendar, replace, updateTriggers);
        }

        public void addJob(JobDetail jobDetail, boolean replace, boolean storeNonDurableWhileAwaitingScheduling) throws SchedulerException {
            this.getScheduler().addJob(jobDetail, replace, storeNonDurableWhileAwaitingScheduling);
        }

        public void addJob(JobDetail jobDetail, boolean replace) throws SchedulerException {
            this.getScheduler().addJob(jobDetail, replace);
        }

        public boolean checkExists(JobKey jobKey) throws SchedulerException {
            return this.getScheduler().checkExists(jobKey);
        }

        public boolean checkExists(TriggerKey triggerKey) throws SchedulerException {
            return this.getScheduler().checkExists(triggerKey);
        }

        public void clear() throws SchedulerException {
            this.getScheduler().clear();
        }

        public boolean deleteCalendar(String calName) throws SchedulerException {
            return this.getScheduler().deleteCalendar(calName);
        }

        public boolean deleteJob(JobKey jobKey) throws SchedulerException {
            return this.getScheduler().deleteJob(jobKey);
        }

        public boolean deleteJobs(List<JobKey> jobKeys) throws SchedulerException {
            return this.getScheduler().deleteJobs(jobKeys);
        }

        public Calendar getCalendar(String calName) throws SchedulerException {
            return this.getScheduler().getCalendar(calName);
        }

        public List<String> getCalendarNames() throws SchedulerException {
            return this.getScheduler().getCalendarNames();
        }

        public SchedulerContext getContext() throws SchedulerException {
            return this.getScheduler().getContext();
        }

        public List<JobExecutionContext> getCurrentlyExecutingJobs() throws SchedulerException {
            return this.getScheduler().getCurrentlyExecutingJobs();
        }

        public JobDetail getJobDetail(JobKey jobKey) throws SchedulerException {
            return this.getScheduler().getJobDetail(jobKey);
        }

        public List<String> getJobGroupNames() throws SchedulerException {
            return this.getScheduler().getJobGroupNames();
        }

        public Set<JobKey> getJobKeys(GroupMatcher<JobKey> matcher) throws SchedulerException {
            return this.getScheduler().getJobKeys(matcher);
        }

        public ListenerManager getListenerManager() throws SchedulerException {
            return this.getScheduler().getListenerManager();
        }

        public SchedulerMetaData getMetaData() throws SchedulerException {
            return this.getScheduler().getMetaData();
        }

        public Set<String> getPausedTriggerGroups() throws SchedulerException {
            return this.getScheduler().getPausedTriggerGroups();
        }

        public String getSchedulerInstanceId() throws SchedulerException {
            return this.getScheduler().getSchedulerInstanceId();
        }

        public String getSchedulerName() throws SchedulerException {
            return this.getScheduler().getSchedulerName();
        }

        public Trigger getTrigger(TriggerKey triggerKey) throws SchedulerException {
            return this.getScheduler().getTrigger(triggerKey);
        }

        public List<String> getTriggerGroupNames() throws SchedulerException {
            return this.getScheduler().getTriggerGroupNames();
        }

        public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> matcher) throws SchedulerException {
            return this.getScheduler().getTriggerKeys(matcher);
        }

        public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws SchedulerException {
            return this.getScheduler().getTriggerState(triggerKey);
        }

        public List<? extends Trigger> getTriggersOfJob(JobKey jobKey) throws SchedulerException {
            return this.getScheduler().getTriggersOfJob(jobKey);
        }

        public boolean interrupt(JobKey jobKey) throws UnableToInterruptJobException {
            return this.getScheduler().interrupt(jobKey);
        }

        public boolean interrupt(String fireInstanceId) throws UnableToInterruptJobException {
            return this.getScheduler().interrupt(fireInstanceId);
        }

        public boolean isInStandbyMode() throws SchedulerException {
            return this.getScheduler().isInStandbyMode();
        }

        public boolean isShutdown() throws SchedulerException {
            return this.getScheduler().isShutdown();
        }

        public boolean isStarted() throws SchedulerException {
            return this.getScheduler().isStarted();
        }

        public void pauseAll() throws SchedulerException {
            this.getScheduler().pauseAll();
        }

        public void pauseJob(JobKey jobKey) throws SchedulerException {
            this.getScheduler().pauseJob(jobKey);
        }

        public void pauseJobs(GroupMatcher<JobKey> matcher) throws SchedulerException {
            this.getScheduler().pauseJobs(matcher);
        }

        public void pauseTrigger(TriggerKey triggerKey) throws SchedulerException {
            this.getScheduler().pauseTrigger(triggerKey);
        }

        public void pauseTriggers(GroupMatcher<TriggerKey> matcher) throws SchedulerException {
            this.getScheduler().pauseTriggers(matcher);
        }

        public Date rescheduleJob(TriggerKey triggerKey, Trigger trigger) throws SchedulerException {
            return this.getScheduler().rescheduleJob(triggerKey, trigger);
        }

        public void resetTriggerFromErrorState(TriggerKey triggerKey) throws SchedulerException {
            this.getScheduler().resetTriggerFromErrorState(triggerKey);
        }

        public void resumeAll() throws SchedulerException {
            this.getScheduler().resumeAll();
        }

        public void resumeJob(JobKey jobKey) throws SchedulerException {
            this.getScheduler().resumeJob(jobKey);
        }

        public void resumeJobs(GroupMatcher<JobKey> matcher) throws SchedulerException {
            this.getScheduler().resumeJobs(matcher);
        }

        public void resumeTrigger(TriggerKey triggerKey) throws SchedulerException {
            this.getScheduler().resumeTrigger(triggerKey);
        }

        public void resumeTriggers(GroupMatcher<TriggerKey> matcher) throws SchedulerException {
            this.getScheduler().resumeTriggers(matcher);
        }

        public void scheduleJob(JobDetail jobDetail, Set<? extends Trigger> triggersForJob, boolean replace) throws SchedulerException {
            this.getScheduler().scheduleJob(jobDetail, triggersForJob, replace);
        }

        public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
            return this.getScheduler().scheduleJob(jobDetail, trigger);
        }

        public Date scheduleJob(Trigger trigger) throws SchedulerException {
            return this.getScheduler().scheduleJob(trigger);
        }

        public void scheduleJobs(Map<JobDetail, Set<? extends Trigger>> triggersAndJobs, boolean replace) throws SchedulerException {
            this.getScheduler().scheduleJobs(triggersAndJobs, replace);
        }

        public void setJobFactory(JobFactory factory) throws SchedulerException {
            this.getScheduler().setJobFactory(factory);
        }

        public void shutdown() throws SchedulerException {
            this.getScheduler().shutdown();
        }

        public void shutdown(boolean waitForJobsToComplete) throws SchedulerException {
            this.getScheduler().shutdown(waitForJobsToComplete);
        }

        public void standby() throws SchedulerException {
            this.getScheduler().standby();
        }

        public void start() throws SchedulerException {
            this.getScheduler().start();
        }

        public void startDelayed(int seconds) throws SchedulerException {
            this.getScheduler().startDelayed(seconds);
        }

        public void triggerJob(JobKey jobKey, JobDataMap data) throws SchedulerException {
            this.getScheduler().triggerJob(jobKey, data);
        }

        public void triggerJob(JobKey jobKey) throws SchedulerException {
            this.getScheduler().triggerJob(jobKey);
        }

        public boolean unscheduleJob(TriggerKey triggerKey) throws SchedulerException {
            return this.getScheduler().unscheduleJob(triggerKey);
        }

        public boolean unscheduleJobs(List<TriggerKey> triggerKeys) throws SchedulerException {
            return this.getScheduler().unscheduleJobs(triggerKeys);
        }
    }
}

