/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver.api.v1.deliveryrepository;

import com.indy.engine.Global;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.semarchy.xdi.runtime.httpserver.HttpErrorHandler;
import com.semarchy.xdi.runtime.httpserver.api.v1.deliveryrepository.Messages;
import com.semarchy.xdi.runtime.httpserver.api.v1.exception.ResourceNotFoundException;
import com.semarchy.xdi.runtime.httpserver.api.v1.utils.StringSanitizer;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/1/delivery-repositories"})
public class DeliveryRepositoryController {
    private static final HttpErrorHandler errorHandler = new HttpErrorHandler();
    private static final String TECHNICAL_ERROR_MESSAGE = "DeliveryRepositoryController_Technical_Error";
    private static final String REPOSITORY_NOT_FOUND_ERROR_MESSAGE = "DeliveryRepositoryController_Repository_Not_Found";

    @GetMapping
    public RepositoryAPI getDeliveryRepositories(HttpServletResponse response) {
        try {
            ArrayList<RepositoryDetailAPI> repositoryDetailAPIList = new ArrayList<RepositoryDetailAPI>();
            Set<String> repositoryNameList = Global.getRepositories();
            for (String repositoryName : repositoryNameList) {
                RepositoryDetailAPI repositoryDetailAPI = this.getInternalRepositoryDetails(repositoryName);
                repositoryDetailAPIList.add(repositoryDetailAPI);
            }
            return new RepositoryAPI(Messages.getString("DeliveryRepositoryController_Description"), repositoryDetailAPIList);
        }
        catch (Exception e) {
            this.handleError(HttpStatus.INTERNAL_SERVER_ERROR.value(), Messages.getString(TECHNICAL_ERROR_MESSAGE), e, response);
            return null;
        }
    }

    @GetMapping(value={"/{name}"})
    public RepositoryAPI getRepositoryDetails(@PathVariable(value="name") String name, HttpServletResponse response) {
        try {
            StringSanitizer.normalizeAndSanitize(name);
            RepositoryDetailAPI repositoryDetailAPI = this.getInternalRepositoryDetails(name);
            return new RepositoryAPI(Messages.getString("DeliveryRepositoryController_Description"), Arrays.asList(repositoryDetailAPI));
        }
        catch (ResourceNotFoundException e) {
            this.handleError(HttpStatus.NOT_FOUND.value(), "", e, response);
        }
        catch (Exception e) {
            this.handleError(HttpStatus.INTERNAL_SERVER_ERROR.value(), Messages.getString(TECHNICAL_ERROR_MESSAGE), e, response);
        }
        return null;
    }

    protected void handleError(int httpErrorCode, String message, Exception t, HttpServletResponse response) {
        Consumer<String> errorConsumer = errorMessage -> {
            try {
                response.sendError(httpErrorCode, errorMessage);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        errorHandler.handleError(message, t, errorConsumer);
    }

    private RepositoryDetailAPI getInternalRepositoryDetails(String repositoryName) throws ResourceNotFoundException {
        RepositoryDetailAPI repositoryDetailAPI = new RepositoryDetailAPI();
        IDeliveryRepository repository = this.getRepositoryByName(repositoryName);
        repositoryDetailAPI.setName(repository.getName());
        repositoryDetailAPI.setType(repository.getType());
        repositoryDetailAPI.setScanMode(repository.getScanMode());
        repositoryDetailAPI.setSynchronizationPollingInterval(repository.getSynchronizationPollingInterval());
        repositoryDetailAPI.setDefault(repository.isDefault());
        repositoryDetailAPI.setWebservice(repository.isWebservice());
        return repositoryDetailAPI;
    }

    private IDeliveryRepository getRepositoryByName(String repositoryName) throws ResourceNotFoundException {
        IDeliveryRepository repository;
        try {
            repository = Global.getRepository(repositoryName);
        }
        catch (Exception e) {
            throw new ResourceNotFoundException(String.format(Messages.getString(REPOSITORY_NOT_FOUND_ERROR_MESSAGE), repositoryName));
        }
        return repository;
    }

    public record RepositoryAPI(String description, List<RepositoryDetailAPI> repositories) {
    }

    public record RepositoryAttributeDetailAPI(String value) {
    }

    public class RepositoryDetailAPI {
        private boolean isWebservice;
        private boolean isDefault;
        private long synchronizationPollingInterval;
        private String name;
        private String scanMode;
        private String type;

        public boolean isWebservice() {
            return this.isWebservice;
        }

        public void setWebservice(boolean isWebservice) {
            this.isWebservice = isWebservice;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        public long getSynchronizationPollingInterval() {
            return this.synchronizationPollingInterval;
        }

        public void setSynchronizationPollingInterval(long synchronizationPollingInterval) {
            this.synchronizationPollingInterval = synchronizationPollingInterval;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getScanMode() {
            return this.scanMode;
        }

        public void setScanMode(String scanMode) {
            this.scanMode = scanMode;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

