/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver.api.v1.utils;

import com.semarchy.xdi.runtime.httpserver.api.v1.exception.InvalidInputDataException;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringSanitizer {
    private static final Pattern angleBracketsPattern = Pattern.compile("[<>]");

    private StringSanitizer() {
    }

    public static void normalizeAndSanitize(String inputString) throws InvalidInputDataException {
        if (inputString != null) {
            String normalizedInputString = StringSanitizer.normalize(inputString);
            StringSanitizer.sanitize(normalizedInputString);
        }
    }

    private static String normalize(String inputString) throws InvalidInputDataException {
        String normalizedString = Normalizer.normalize(inputString, Normalizer.Form.NFKC);
        Matcher matcher = angleBracketsPattern.matcher(normalizedString);
        if (matcher.find()) {
            throw new InvalidInputDataException("Invalid input detected");
        }
        return normalizedString;
    }

    private static String sanitize(String input) throws InvalidInputDataException {
        if (input == null || input.isEmpty() || input.contains("..") || input.contains("\\")) {
            throw new InvalidInputDataException("Invalid input detected");
        }
        return input;
    }
}

