/*
 * Decompiled with CFR 0.152.
 */
package com.indy.quartz.cron.editor.composite;

import com.indy.quartz.cron.editor.composite.Messages;
import com.indy.quartz.cron.editor.composite.TriggerComposite;
import com.indy.ui.utils.FormMessageWrapper;
import com.stambia.quartz.cron.CronPackage;
import com.stambia.quartz.cron.Day;
import com.stambia.quartz.cron.IntervalUnit;
import com.stambia.quartz.cron.Trigger;
import com.stambia.ui.tools.binding.BindingEnumeration;
import com.stambia.ui.tools.binding.BindingText;
import com.stambia.ui.tools.binding.BindingTime;
import com.stambia.ui.tools.binding.CustomBindingList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DailyIntervalTriggerComposite
extends TriggerComposite {
    public static Set<Day> ALL_DAYS_OF_THE_WEEK = new HashSet<Day>();
    public static Set<Day> MONDAY_THROUGH_FRIDAY = new HashSet<Day>();
    public static Set<Day> SATURDAY_AND_SUNDAY = new HashSet<Day>();
    private IObservableList observableList;
    private Button everyDayBtn;
    private Button mondayThroughFridayBtn;
    private Button saturdayAndSundayBtn;
    private final String intervalValueError = Messages.DailyIntervalTriggerComposite_0;
    private final String errorKey = Messages.DailyIntervalTriggerComposite_1;
    private final String intervalValueEmptyError = Messages.DailyIntervalTriggerComposite_2;

    public DailyIntervalTriggerComposite(Composite parent, FormToolkit toolkit, Trigger triggerEObject, EditingDomain domain, ComposedAdapterFactory adapterFactory, FormMessageWrapper mmng, EMFDataBindingContext ctx) {
        super(parent, toolkit, triggerEObject, domain, adapterFactory, mmng, ctx);
        this.initDaySet();
    }

    private void initDaySet() {
        int i = 0;
        while (i < 7) {
            ALL_DAYS_OF_THE_WEEK.add(Day.get((int)i));
            ++i;
        }
        i = 0;
        while (i <= 4) {
            MONDAY_THROUGH_FRIDAY.add(Day.get((int)i));
            ++i;
        }
        SATURDAY_AND_SUNDAY.add(Day.get((int)5));
        SATURDAY_AND_SUNDAY.add(Day.get((int)6));
    }

    private void refreshDayOfWeekBtn(IObservableList observableList) {
        if (!observableList.isEmpty()) {
            if (observableList.size() == 2) {
                if (observableList.containsAll(SATURDAY_AND_SUNDAY)) {
                    this.mondayThroughFridayBtn.setSelection(false);
                    this.everyDayBtn.setSelection(false);
                    this.saturdayAndSundayBtn.setSelection(true);
                }
            } else if (observableList.size() == 5) {
                if (observableList.containsAll(MONDAY_THROUGH_FRIDAY)) {
                    this.saturdayAndSundayBtn.setSelection(false);
                    this.everyDayBtn.setSelection(false);
                    this.mondayThroughFridayBtn.setSelection(true);
                }
            } else if (observableList.size() == 7) {
                if (observableList.containsAll(ALL_DAYS_OF_THE_WEEK)) {
                    this.saturdayAndSundayBtn.setSelection(false);
                    this.mondayThroughFridayBtn.setSelection(false);
                    this.everyDayBtn.setSelection(true);
                }
            } else {
                this.saturdayAndSundayBtn.setSelection(false);
                this.mondayThroughFridayBtn.setSelection(false);
                this.everyDayBtn.setSelection(false);
            }
        }
    }

    @Override
    public void createComposite(Composite composite) {
        Composite triggerComposite = this.toolkit.createComposite(composite);
        triggerComposite.setLayout((Layout)new GridLayout(2, false));
        Composite dateAndIntervalComposite = this.toolkit.createComposite(triggerComposite);
        dateAndIntervalComposite.setLayout((Layout)new GridLayout(2, true));
        this.toolkit.createLabel(dateAndIntervalComposite, Messages.DailyIntervalTriggerComposite_3);
        DateTime dailyStart = new DateTime(dateAndIntervalComposite, 67712);
        new BindingTime((DataBindingContext)this.ctx, this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getDailyIntervalTrigger_StartTimeOfDay(), dailyStart).setEObject((EObject)this.triggerEObject);
        this.toolkit.createLabel(dateAndIntervalComposite, Messages.DailyIntervalTriggerComposite_4);
        DateTime dailyEnd = new DateTime(dateAndIntervalComposite, 67712);
        new BindingTime((DataBindingContext)this.ctx, this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getDailyIntervalTrigger_EndTimeOfDay(), dailyEnd).setEObject((EObject)this.triggerEObject);
        Composite intervalComp = this.toolkit.createComposite(dateAndIntervalComposite);
        intervalComp.setLayout((Layout)new GridLayout(2, false));
        intervalComp.setLayoutData((Object)new GridData(1808));
        this.toolkit.createLabel(intervalComp, Messages.DailyIntervalTriggerComposite_5);
        Text intervalText = this.toolkit.createText(intervalComp, "");
        intervalText.setLayoutData((Object)new GridData(35, -1));
        new BindingText((DataBindingContext)this.ctx, intervalText, (EObject)this.triggerEObject, (EStructuralFeature)CronPackage.eINSTANCE.getDailyIntervalTrigger_Interval(), this.domain);
        intervalFieldValidator valProvider = new intervalFieldValidator((Control)intervalText);
        this.ctx.addValidationStatusProvider((ValidationStatusProvider)valProvider);
        ControlDecorationSupport.create((ValidationStatusProvider)valProvider, (int)16512);
        CCombo intervalUnitCbx = new CCombo(dateAndIntervalComposite, 2048);
        GridData gridData = new GridData(3);
        intervalUnitCbx.setLayoutData((Object)gridData);
        ComboViewer intervalUnitCbxViewer = new ComboViewer(intervalUnitCbx);
        intervalUnitCbxViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ArrayList<IntervalUnit> intervalUnitCbxInput = new ArrayList<IntervalUnit>();
        intervalUnitCbxInput.add(IntervalUnit.HOUR);
        intervalUnitCbxInput.add(IntervalUnit.MINUTE);
        intervalUnitCbxInput.add(IntervalUnit.SECOND);
        intervalUnitCbxViewer.setInput(intervalUnitCbxInput);
        IViewerObservableValue unitIntervalSelection = ViewerProperties.singleSelection().observe((Viewer)intervalUnitCbxViewer);
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue((IObservableValue)unitIntervalSelection, EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getDailyIntervalTrigger_IntervalUnit()).observe((Object)this.triggerEObject));
        this.createDayOfWeekComposite(triggerComposite);
    }

    private Composite createDayOfWeekComposite(Composite parent) {
        Composite dayOfWeekComposite = this.toolkit.createComposite(parent);
        GridData dayOfWeekGd = new GridData();
        dayOfWeekComposite.setLayout((Layout)new GridLayout(3, false));
        dayOfWeekComposite.setLayoutData((Object)dayOfWeekGd);
        this.observableList = new WritableList(){

            protected void fireListChange(ListDiff diff) {
                super.fireListChange(diff);
                if (DailyIntervalTriggerComposite.this.observableList != null) {
                    DailyIntervalTriggerComposite.this.refreshDayOfWeekBtn(DailyIntervalTriggerComposite.this.observableList);
                }
            }
        };
        CustomBindingList dayOfWeekBinding = new CustomBindingList(this.observableList, (EStructuralFeature)CronPackage.eINSTANCE.getDailyIntervalTrigger_DayOfWeek(), this.domain);
        this.everyDayBtn = this.toolkit.createButton(dayOfWeekComposite, Messages.DailyIntervalTriggerComposite_7, 16);
        this.everyDayBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DailyIntervalTriggerComposite.this.observableList.clear();
                DailyIntervalTriggerComposite.this.observableList.addAll(ALL_DAYS_OF_THE_WEEK);
            }
        });
        this.mondayThroughFridayBtn = this.toolkit.createButton(dayOfWeekComposite, Messages.DailyIntervalTriggerComposite_8, 16);
        this.mondayThroughFridayBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DailyIntervalTriggerComposite.this.observableList.clear();
                DailyIntervalTriggerComposite.this.observableList.addAll(MONDAY_THROUGH_FRIDAY);
            }
        });
        this.saturdayAndSundayBtn = this.toolkit.createButton(dayOfWeekComposite, Messages.DailyIntervalTriggerComposite_9, 16);
        this.saturdayAndSundayBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DailyIntervalTriggerComposite.this.observableList.clear();
                DailyIntervalTriggerComposite.this.observableList.addAll(SATURDAY_AND_SUNDAY);
            }
        });
        dayOfWeekBinding.setEObject((EObject)this.triggerEObject);
        Composite composite = this.toolkit.createComposite(dayOfWeekComposite);
        composite.setLayout((Layout)new GridLayout(4, true));
        GridData gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 3;
        composite.setLayoutData((Object)gd);
        BindingEnumeration selectedDayOfWeekBinding = new BindingEnumeration(composite, this.toolkit, (EStructuralFeature)CronPackage.eINSTANCE.getDailyIntervalTrigger_DayOfWeek(), this.domain);
        selectedDayOfWeekBinding.addBindedCheckButton("Monday", (Object)Day.MONDAY);
        selectedDayOfWeekBinding.addBindedCheckButton("Tuesday", (Object)Day.TUESDAY);
        selectedDayOfWeekBinding.addBindedCheckButton("Wednesday", (Object)Day.WEDNESDAY);
        selectedDayOfWeekBinding.addBindedCheckButton("Thursday", (Object)Day.THURSDAY);
        selectedDayOfWeekBinding.addBindedCheckButton("Friday", (Object)Day.FRIDAY);
        selectedDayOfWeekBinding.addBindedCheckButton("Saturday", (Object)Day.SATURDAY);
        selectedDayOfWeekBinding.addBindedCheckButton("Sunday", (Object)Day.SUNDAY);
        IObservableList checkedElements = selectedDayOfWeekBinding.getTargetObservableList();
        SelectedDayValidator valProvider = new SelectedDayValidator(checkedElements, "SelectedDay", composite);
        this.ctx.addValidationStatusProvider((ValidationStatusProvider)valProvider);
        ControlDecorationSupport.create((ValidationStatusProvider)valProvider, (int)131200, (Composite)composite);
        selectedDayOfWeekBinding.setEObject((EObject)this.triggerEObject);
        return composite;
    }

    @Override
    public void bind() {
    }

    @Override
    public boolean isTriggerValid() {
        boolean noError = true;
        for (ValidationStatusProvider validationStatusProvider : this.ctx.getValidationStatusProviders()) {
            IStatus status = (IStatus)validationStatusProvider.getValidationStatus().getValue();
            if (status.getSeverity() != 4) continue;
            noError = false;
        }
        return noError;
    }

    private class SelectedDayValidator
    extends MultiValidator {
        private final IObservableList checkedElements;
        private final String key;
        private String message;
        private String errorMessage;
        private ControlDecoration controlDecoration;
        private FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");

        public SelectedDayValidator(IObservableList checkedElements, String key, Composite composite) {
            this.checkedElements = checkedElements;
            this.key = "DailyInterval/" + key;
            this.message = String.valueOf(Messages.DailyIntervalTriggerComposite_20) + ".";
            this.errorMessage = Messages.DailyIntervalTriggerComposite_22;
            this.controlDecoration = new ControlDecoration((Control)composite, 16512);
            this.controlDecoration.setDescriptionText(this.errorMessage);
            this.controlDecoration.setImage(this.fieldDecoration.getImage());
            this.controlDecoration.setMarginWidth(-10);
        }

        protected IStatus validate() {
            if (this.checkedElements.isEmpty()) {
                DailyIntervalTriggerComposite.this.mmng.addMessage((Object)this.key, this.message, null, 3);
                this.controlDecoration.show();
                return ValidationStatus.error((String)this.errorMessage);
            }
            DailyIntervalTriggerComposite.this.mmng.removeMessage((Object)this.key);
            this.controlDecoration.hide();
            return ValidationStatus.ok();
        }
    }

    class intervalFieldValidator
    extends MultiValidator {
        private IObservableValue intervalFieldObservable;

        public intervalFieldValidator(Control text) {
            this.intervalFieldObservable = WidgetProperties.text((int)24).observe((Widget)text);
        }

        public IStatus validate() {
            if (this.intervalFieldObservable.getValue() instanceof String) {
                String value = (String)this.intervalFieldObservable.getValue();
                if (value.isEmpty()) {
                    DailyIntervalTriggerComposite.this.mmng.addMessage((Object)DailyIntervalTriggerComposite.this.errorKey, DailyIntervalTriggerComposite.this.intervalValueEmptyError, null, 3);
                    return ValidationStatus.error((String)DailyIntervalTriggerComposite.this.intervalValueEmptyError);
                }
                try {
                    Integer.parseInt(value);
                }
                catch (Exception e) {
                    DailyIntervalTriggerComposite.this.mmng.addMessage((Object)DailyIntervalTriggerComposite.this.errorKey, DailyIntervalTriggerComposite.this.intervalValueError, null, 3);
                    return ValidationStatus.error((String)DailyIntervalTriggerComposite.this.intervalValueError);
                }
                DailyIntervalTriggerComposite.this.mmng.removeMessage((Object)DailyIntervalTriggerComposite.this.errorKey);
                return ValidationStatus.ok();
            }
            DailyIntervalTriggerComposite.this.mmng.addMessage((Object)DailyIntervalTriggerComposite.this.errorKey, DailyIntervalTriggerComposite.this.intervalValueError, null, 3);
            return ValidationStatus.error((String)DailyIntervalTriggerComposite.this.intervalValueError);
        }
    }
}

