/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.build;

import com.indy.gmf.map.diagram.build.DeltaBuildVisitor;
import com.indy.gmf.map.diagram.build.FullBuildVisitor;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.semarchy.xdi.designer.core.services.IMappingBuilderDelegate;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class StambiaIncrementalBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "com.indy.gmf.map.diagram.id1";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        Logger.getLogger(StambiaIncrementalBuilder.class.getName()).fine("Building Project " + String.valueOf(this.getProject()) + "...");
        switch (kind) {
            default: 
        }
        return null;
    }

    protected IProject[] fullBuild(Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        FullBuildVisitor vis = new FullBuildVisitor();
        this.getProject().accept((IResourceVisitor)vis);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)vis.getToBuild().size());
        for (IFile f : vis.getToBuild()) {
            this.notifyMappingBuilderManager(f);
            sub.worked(1);
        }
        sub.done();
        return null;
    }

    protected IProject[] incrementalBuild(Map<String, String> args, IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        DeltaBuildVisitor vis = new DeltaBuildVisitor();
        delta.accept((IResourceDeltaVisitor)vis);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)vis.getToBuild().size());
        for (IFile f : vis.getToBuild()) {
            this.notifyMappingBuilderManager(f);
            sub.worked(1);
        }
        sub.done();
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        BundleContext ctx = MapDiagramEditorPlugin.getInstance().getBundle().getBundleContext();
        ServiceReference ref = null;
        try {
            try {
                ref = ctx.getServiceReference(IMappingBuilderDelegate.IMappingBuildManager.class);
                final IMappingBuilderDelegate.IMappingBuildManager service = (IMappingBuilderDelegate.IMappingBuildManager)ctx.getService(ref);
                if (service != null) {
                    final ProjectVisitor vis = new ProjectVisitor();
                    this.getProject().accept((IResourceVisitor)vis);
                    service.askForClean(vis.mappings);
                    if (this.getProject().getWorkspace().isAutoBuilding()) {
                        Job j = new Job("Rebuild " + this.getProject().getName()){

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    1.getJobManager().join((Object)"MAPPING_BUILD_JOB_FAMILY", monitor);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                service.askForBuild(vis.mappings);
                                return Status.OK_STATUS;
                            }
                        };
                        j.setUser(true);
                        j.schedule();
                    }
                }
            }
            catch (Exception ex) {
                MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.gmf.map.diagram", Messages.StambiaIncrementalBuilder_3, (Throwable)ex));
                if (ref != null) {
                    ctx.ungetService(ref);
                }
            }
        }
        finally {
            if (ref != null) {
                ctx.ungetService(ref);
            }
        }
    }

    private void notifyMappingBuilderManager(IFile f) {
        try {
            IMappingBuilderDelegate.IMappingBuildManager service = (IMappingBuilderDelegate.IMappingBuildManager)E4InjectorHelper.getService(IMappingBuilderDelegate.IMappingBuildManager.class);
            if (service != null) {
                service.askForBuild(Collections.singletonList(URIUtils.convertIPathToEMFURI2((IPath)f.getFullPath())));
            }
        }
        catch (Exception ex) {
            MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.gmf.map.diagram", Messages.StambiaIncrementalBuilder_6, (Throwable)ex));
        }
    }

    private class ProjectVisitor
    implements IResourceVisitor {
        private List<URI> mappings = new ArrayList<URI>();

        private ProjectVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 4) {
                return resource.getProject().isOpen();
            }
            if (resource.getType() == 2) {
                if (resource.getParent() == resource.getProject() && resource.getName().equals("indy.build")) {
                    return false;
                }
            } else if ("map".equals(resource.getFileExtension())) {
                this.mappings.add(URIUtils.convertIPathToEMFURI2((IPath)resource.getFullPath()));
            }
            return true;
        }
    }
}

