/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.actions;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.Map;
import com.indy.map.MapFactory;
import com.indy.map.Parameter;
import com.indy.map.Template;
import com.indy.map.custom.commands.ComputeDatasetsCommand;
import com.indy.map.custom.commands.UpdateInstanceCommand;
import com.indy.map.diagram.edit.parts.MapEditPart;
import com.indy.map.util.IMapResource;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class RecomputeModel
extends DiagramAction {
    public static final String ID = "recomputeModel";

    public RecomputeModel(IWorkbenchPart workbenchpart) {
        super(workbenchpart);
    }

    public RecomputeModel(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public void init() {
        super.init();
        this.setId(ID);
        this.setText(Messages.RecomputeModel_1);
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected org.eclipse.gef.commands.Command getCommand(Request request) {
        EditPart mapEditPart;
        Map map;
        TransactionalEditingDomain editDomain;
        if (!ID.equals(request.getType())) {
            return UnexecutableCommand.INSTANCE;
        }
        List operationSet = this.getOperationSet();
        if (operationSet.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        Iterator editParts = operationSet.iterator();
        EditPart trgEp = null;
        final ArrayList<WeakReference<Map>> l = new ArrayList<WeakReference<Map>>();
        while (editParts.hasNext()) {
            EditPart editPart = (EditPart)editParts.next();
            if (!(editPart instanceof MapEditPart)) continue;
            if (trgEp == null) {
                trgEp = editPart;
            }
            l.add(new WeakReference<Map>((Map)((MapEditPart)editPart).resolveSemanticElement()));
        }
        if (trgEp != null && !l.isEmpty() && (editDomain = TransactionUtil.getEditingDomain((EObject)(map = (Map)((IGraphicalEditPart)(mapEditPart = trgEp)).resolveSemanticElement()))) != null) {
            AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(editDomain, Messages.RecomputeModel_2, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    try {
                        this.getEditingDomain().getCommandStack().execute((Command)new RecomputeModelCommand(this.getEditingDomain(), map));
                        return CommandResult.newOKCommandResult();
                    }
                    catch (Exception ex) {
                        return CommandResult.newErrorCommandResult((Throwable)ex);
                    }
                }
            };
            CompoundCommand cc = new CompoundCommand();
            cc.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)cmd));
            cc.add(new org.eclipse.gef.commands.Command(){

                public void execute() {
                    if (!l.isEmpty()) {
                        Map o = (Map)((WeakReference)l.get(0)).get();
                        mapEditPart.deactivate();
                        ((IMapResource)o.eResource()).getReferenceSynchronizer().reInit(o);
                        mapEditPart.activate();
                    }
                }

                public void undo() {
                }

                public void redo() {
                }
            });
            return cc;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Request createTargetRequest() {
        return new Request((Object)ID);
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        if (MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.RecomputeModel_3, (String)Messages.RecomputeModel_4)) {
            super.doRun(progressMonitor);
        }
    }

    private class RecomputeModelCommand
    extends ComputeDatasetsCommand {
        public RecomputeModelCommand(TransactionalEditingDomain domain, Map map) {
            super(domain, map);
        }

        protected void doExecute() {
            Map map = (Map)this.map.get();
            super.doExecute();
            ArrayList<TemplateInfo> templateInfo = new ArrayList<TemplateInfo>();
            for (Template t : map.getTemplate()) {
                TemplateInfo i = new TemplateInfo();
                i.name = t.getName();
                i.processUri = t.getProcess() != null ? EcoreUtil.getURI((EObject)t.getProcess()) : null;
                for (Parameter p : t.getParameter()) {
                    i.parameters.put(p.getName(), p.getValue());
                }
                i.srcContainerIds.addAll((Collection<String>)t.getSourceId());
                i.trgContainerIds.addAll((Collection<String>)t.getTargetId());
                templateInfo.add(i);
            }
            map.getTemplate().clear();
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)map);
            UpdateInstanceCommand cmd = new UpdateInstanceCommand(editingDomain, map);
            editingDomain.getCommandStack().execute((Command)cmd);
            for (TemplateInfo i : templateInfo) {
                Template t = null;
                for (Template curT : map.getTemplate()) {
                    if (curT.getName().charAt(0) != i.name.charAt(0) || !curT.getSourceId().containsAll(i.srcContainerIds) || !curT.getTargetId().containsAll(i.trgContainerIds)) continue;
                    t = curT;
                    break;
                }
                if (t == null) {
                    t = map.getTemplate(i.name);
                }
                if (t == null) continue;
                EObject proc = i.processUri == null ? null : map.eResource().getResourceSet().getEObject(i.processUri, true);
                t.setProcess(proc);
                for (String s : i.parameters.keySet()) {
                    Parameter p = null;
                    p = t.getParameter(s);
                    if (p == null) {
                        p = MapFactory.eINSTANCE.createParameter();
                        p.setName(s);
                        t.getParameter().add((Object)p);
                    }
                    p.setValue(i.parameters.get(s));
                }
            }
        }

        private class TemplateInfo {
            private String name;
            private URI processUri;
            private HashMap<String, String> parameters = new HashMap();
            private HashSet<String> srcContainerIds = new HashSet();
            private HashSet<String> trgContainerIds = new HashSet();

            private TemplateInfo() {
            }
        }
    }
}

