/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.parts;

import com.indy.gmf.map.diagram.custom.MapDiagramUtil;
import com.indy.map.Clause;
import com.indy.map.IReferencable;
import com.indy.map.MapModelItem;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RItem;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx;
import org.eclipse.gmf.runtime.notation.View;

public abstract class ClauseEditPart
extends ShapeNodeEditPart {
    private Adapter refAdapter = new EContentAdapter(){

        public void notifyChanged(Notification msg) {
            ClauseEditPart.this.handleNotificationEvent(msg);
        }
    };

    public ClauseEditPart(View view) {
        super(view);
    }

    protected abstract void refreshIcon();

    protected void handleNotificationEvent(Notification notification) {
        if (!(notification.getNotifier() instanceof RItem)) {
            super.handleNotificationEvent(notification);
        }
        if (notification.getNotifier() instanceof Clause) {
            this.refreshIcon();
        }
        if (notification.getNotifier() instanceof RClause) {
            this.refreshTooltips();
            this.refreshIcon();
        }
    }

    protected void refreshTooltips() {
        IFigure f = this.getPrimaryShape();
        EObject obj = this.resolveSemanticElement();
        if (obj instanceof Clause) {
            IFigure tooltip = MapDiagramUtil.updateExpressionToolTip((MapModelItem)obj);
            if (f != null) {
                if (tooltip == null) {
                    String val = ((Clause)obj).getExpression();
                    if (val != null && !val.isEmpty()) {
                        f.setToolTip((IFigure)new Label(val));
                    } else {
                        f.setToolTip(tooltip);
                    }
                } else {
                    f.setToolTip(tooltip);
                }
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshTooltips();
    }

    protected abstract IFigure getPrimaryShape();

    public void activate() {
        try {
            RItem it = (RItem)((IReferencable)this.resolveSemanticElement()).getMapReference();
            if (!it.eAdapters().contains((Object)this.refAdapter)) {
                it.eAdapters().add((Object)this.refAdapter);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.activate();
    }

    public void deactivate() {
        block5: {
            try {
                if (this.refAdapter.getTarget() == null) break block5;
                Notifier trg = this.refAdapter.getTarget();
                boolean deliver = trg.eDeliver();
                try {
                    trg.eSetDeliver(false);
                    this.refAdapter.getTarget().eAdapters().remove((Object)this.refAdapter);
                }
                finally {
                    trg.eSetDeliver(deliver);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.deactivate();
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        EditPolicy policy = this.getEditPolicy("PrimaryDrag Policy");
        return policy != null ? policy : new NonResizableEditPolicyEx();
    }
}

