/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.parts;

import com.indy.gmf.map.diagram.custom.MapDiagramUtil;
import com.indy.gmf.map.diagram.custom.actions.FilterAction;
import com.indy.gmf.map.diagram.custom.edit.parts.LinkEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.TargetFilterEditPart;
import com.indy.gmf.map.diagram.custom.edit.policies.DataSetDecorationEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.SourceSetDecorationEditPolicy;
import com.indy.gmf.map.diagram.custom.figures.ContainerFigure;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.IReferencable;
import com.indy.map.ItemProperty;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.MapPackage;
import com.indy.map.SetDescriptor;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.ref.RContainer;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RTargetSet;
import com.indy.map.ref.RefPackage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.MouseWheelHelper;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ViewportMouseWheelHelper;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DecorationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PrecisionPointList;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public abstract class ContainerEditPart
extends ShapeNodeEditPart
implements TargetFilterEditPart.AnchorSupport {
    private Adapter refAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == RefPackage.eINSTANCE.getRItem_Problem()) {
                ContainerEditPart.this.handleNotificationEvent(msg);
            }
        }
    };
    private Set<TargetFilterFigureListener> targetFiltersListeners = new HashSet<TargetFilterFigureListener>();
    private List<String> additionalSemanticListenerFilterIds = new ArrayList<String>();

    public ContainerEditPart(View view) {
        super(view);
    }

    public void activate() {
        RContainer r;
        EObject obj = this.resolveSemanticElement();
        if (obj instanceof IContainer && (r = (RContainer)((IReferencable)obj).getMapReference()) != null) {
            r.eAdapters().add((Object)this.refAdapter);
        }
        super.activate();
        this.handleWidthChange();
        this.refreshAlias();
    }

    public void deactivate() {
        if (this.refAdapter.getTarget() != null) {
            this.refAdapter.getTarget().eAdapters().remove((Object)this.refAdapter);
        }
        for (String key : this.additionalSemanticListenerFilterIds) {
            this.removeListenerFilter(key);
        }
        this.additionalSemanticListenerFilterIds.clear();
        super.deactivate();
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(0);
            layout.setStretchMajorAxis(false);
            layout.setStretchMinorAxis(false);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        EObject obj = this.resolveSemanticElement();
        if (obj instanceof IContainer) {
            IContainer model = (IContainer)obj;
            for (ItemProperty p : model.getProperty()) {
                this.addSemanticListener((MapModelItem)p);
            }
        }
    }

    protected void addSemanticListener(MapModelItem it) {
        StringBuffer b = new StringBuffer("Semantic");
        b.append(it.eClass().getName());
        b.append("_");
        b.append(it.getId());
        String id = b.toString();
        this.addListenerFilter(id, (NotificationListener)this, (EObject)it);
        this.additionalSemanticListenerFilterIds.add(id);
    }

    protected void removeSemanticListener(MapModelItem it) {
        StringBuffer b = new StringBuffer("Semantic");
        b.append(it.eClass().getName());
        b.append("_");
        b.append(it.getId());
        String id = b.toString();
        this.removeListenerFilter(id);
    }

    protected void removeSemanticListeners() {
        for (String s : this.additionalSemanticListenerFilterIds) {
            this.removeListenerFilter(s);
        }
        this.additionalSemanticListenerFilterIds.clear();
        super.removeSemanticListeners();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        return super.getSourceConnectionAnchor(connEditPart);
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        if (connEditPart instanceof LinkEditPart) {
            if ("targetSetLink".equals(((LinkEditPart)connEditPart).getNotationView().getType())) {
                try {
                    ContainerEditPart gep = this;
                    IContainer c = (IContainer)gep.resolveSemanticElement();
                    SourceSetDecorationEditPolicy ep = (SourceSetDecorationEditPolicy)gep.findEditPart((EditPart)gep.getRoot(), c.eContainer()).getEditPolicy((Object)"sourceSet.role");
                    RTargetSet rts = ((RMap)((Map)c.eContainer()).getMapReference()).getTargetSetRef(c);
                    Polygon poly = ep.getPolygon(rts.getSourceSet(), (SetDescriptor)((LinkEditPart)connEditPart).getNotationView().getElement());
                    if (poly != null) {
                        return new SlidableAnchor((IFigure)poly){

                            protected PointList getPolygonPoints() {
                                if (this.getOwner() instanceof Polygon) {
                                    PrecisionPointList polyList = new PrecisionPointList(((Polygon)this.getOwner()).getPoints());
                                    this.getOwner().translateToAbsolute((Translatable)polyList);
                                    return polyList;
                                }
                                return super.getPolygonPoints();
                            }

                            protected PointList getIntersectionPoints(Point ownReference, Point foreignReference) {
                                PointList polygon = this.getPolygonPoints();
                                if (polygon.size() == 0) {
                                    MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(2, "com.indy.gmf.map.diagram", Messages.ContainerEditPart_2, (Throwable)new Exception(Messages.ContainerEditPart_3)));
                                    return new PointList();
                                }
                                return super.getIntersectionPoints(ownReference, foreignReference);
                            }
                        };
                    }
                }
                catch (Exception gep) {}
            } else if ("targetDataSetLink".equals(((LinkEditPart)connEditPart).getNotationView().getType())) {
                try {
                    ContainerEditPart gep = this;
                    IContainer c = (IContainer)gep.resolveSemanticElement();
                    DataSetDecorationEditPolicy ep = (DataSetDecorationEditPolicy)gep.findEditPart((EditPart)gep.getRoot(), c.eContainer()).getEditPolicy((Object)"dataSet.role");
                    Polygon poly = ep.getPolygon((DataSet)((LinkEditPart)connEditPart).getNotationView().getElement());
                    if (poly != null) {
                        return new SlidableAnchor((IFigure)poly){

                            protected PointList getPolygonPoints() {
                                if (this.getOwner() instanceof Polygon) {
                                    PrecisionPointList polyList = new PrecisionPointList(((Polygon)this.getOwner()).getPoints());
                                    this.getOwner().translateToAbsolute((Translatable)polyList);
                                    return polyList;
                                }
                                return super.getPolygonPoints();
                            }

                            protected PointList getIntersectionPoints(Point ownReference, Point foreignReference) {
                                PointList polygon = this.getPolygonPoints();
                                if (polygon.size() == 0) {
                                    MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(2, "com.indy.gmf.map.diagram", Messages.ContainerEditPart_4, (Throwable)new Exception(Messages.ContainerEditPart_5)));
                                    return new PointList();
                                }
                                return super.getIntersectionPoints(ownReference, foreignReference);
                            }
                        };
                    }
                }
                catch (Exception exception) {}
            } else {
                "joinLink".equals(((LinkEditPart)connEditPart).getNotationView().getType());
            }
        }
        return super.getTargetConnectionAnchor(connEditPart);
    }

    void handleWidthChange() {
        LayoutConstraint lc = ((Node)this.getPrimaryView()).getLayoutConstraint();
        if (lc instanceof Bounds) {
            boolean autoSizeY;
            boolean autoSizeX = ((Bounds)lc).getWidth() == -1;
            boolean bl = autoSizeY = ((Bounds)lc).getHeight() == -1;
            if (autoSizeX) {
                if (this.getFigure().getMaximumSize() == IFigure.MAX_DIMENSION) {
                    this.getFigure().setMaximumSize(new Dimension(600, Integer.MAX_VALUE));
                }
            } else if (this.getFigure().getMaximumSize() != IFigure.MAX_DIMENSION) {
                this.getFigure().setMaximumSize(null);
            }
        }
    }

    protected void handleNotificationEvent(Notification notification) {
        DecorationEditPolicy p;
        CanonicalEditPolicy mapCanonialEP;
        super.handleNotificationEvent(notification);
        boolean refreshLabel = false;
        if (notification.getFeature() == MapPackage.eINSTANCE.getMapModelItem_Property()) {
            if (notification.getEventType() == 3) {
                this.addSemanticListener((MapModelItem)notification.getNewValue());
            } else if (notification.getEventType() == 4) {
                this.removeSemanticListener((MapModelItem)notification.getOldValue());
            }
            refreshLabel = true;
        }
        if (notification.getFeature() == MapPackage.eINSTANCE.getItemProperty_Value()) {
            refreshLabel = true;
        }
        if ((notification.getFeature() == MapPackage.eINSTANCE.getDatastore_TargetFilter() || notification.getFeature() == MapPackage.eINSTANCE.getQuery_TargetFilter()) && (mapCanonialEP = (CanonicalEditPolicy)this.getParent().getEditPolicy((Object)"Canonical")) != null) {
            mapCanonialEP.refresh();
        }
        if (notification.getFeature() == NotationPackage.eINSTANCE.getSize_Width() || notification.getFeature() == NotationPackage.eINSTANCE.getNode_LayoutConstraint()) {
            this.handleWidthChange();
        }
        EAnnotation annote = FilterAction.getSortAnnotation((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this);
        Boolean filterIcon = null;
        if (3 == notification.getEventType() && notification.getNewValue() instanceof EAnnotation) {
            filterIcon = !"com.indy.gmf.map.diagram.filter.disable".equals(notification.getNewValue());
        } else if (3 == notification.getEventType() && notification.getOldValue() instanceof EAnnotation) {
            filterIcon = !"com.indy.gmf.map.diagram.filter.disable".equals(notification.getNewValue());
        } else if (annote != null && annote.getDetails().entrySet().contains(notification.getNotifier())) {
            filterIcon = !"com.indy.gmf.map.diagram.filter.disable".equals(notification.getNewValue());
        }
        if (this.isActive() && this.resolveSemanticElement() instanceof IContainer) {
            if (filterIcon != null) {
                refreshLabel = true;
            } else if (notification.getFeature() == RefPackage.eINSTANCE.getRItem_Problem() || notification.getFeature() == MapPackage.eINSTANCE.getMapModelItem_Tag()) {
                refreshLabel = true;
            } else if (notification.getEventType() == 9 && (notification.getFeature() == MapPackage.eINSTANCE.getDatastore_Ref() || notification.getFeature() == MapPackage.eINSTANCE.getQuery_StagingArea())) {
                refreshLabel = true;
            }
        }
        if ((notification.getFeature() == MapPackage.eINSTANCE.getDatastore_PriorityOrder() || notification.getFeature() == MapPackage.eINSTANCE.getQuery_PriorityOrder()) && (p = (DecorationEditPolicy)this.getEditPolicy("DecorationPolicy")) != null) {
            p.refresh();
        }
        if (refreshLabel) {
            this.refreshAlias();
        }
    }

    protected abstract void refreshAlias();

    public EditPolicy getPrimaryDragEditPolicy() {
        EditPolicy policy = this.getEditPolicy("PrimaryDrag Policy");
        return policy != null ? policy : new ResizableShapeEditPolicy(){

            protected Command getAutoSizeCommand(Request request) {
                return super.getAutoSizeCommand(request);
            }

            protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
                super.showChangeBoundsFeedback(request);
                IFigure feedback = this.getDragSourceFeedbackFigure();
                PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                this.getHostFigure().translateToAbsolute((Translatable)rect);
                rect.translate(request.getMoveDelta());
                rect.resize(request.getSizeDelta());
                IFigure f = this.getHostFigure();
                Dimension min = f.getMinimumSize().getCopy();
                f.translateToAbsolute((Translatable)min);
                Dimension max = f.getMaximumSize().getCopy();
                f.translateToAbsolute((Translatable)max);
                feedback.translateToRelative((Translatable)rect);
                feedback.setBounds((Rectangle)rect);
            }
        };
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected void refreshTooltip() {
        EObject o = this.resolveSemanticElement();
        if (!(o instanceof IContainer)) {
            return;
        }
        IFigure tooltip = MapDiagramUtil.updateExpressionToolTip((MapModelItem)o);
        IFigure f = this.getFigure();
        if (f != null) {
            if (tooltip == null) {
                String val = ((IContainer)o).getSubExpression();
                if (val != null && !val.isEmpty()) {
                    f.setToolTip((IFigure)new Label(val));
                } else {
                    f.setToolTip(tooltip);
                }
            } else {
                f.setToolTip(tooltip);
            }
        }
    }

    public abstract IFigure getPrimaryShape();

    public Object getAdapter(Class key) {
        if (key == MouseWheelHelper.class) {
            return new ViewportMouseWheelHelper((GraphicalEditPart)this){

                protected Viewport findViewport(GraphicalEditPart part) {
                    return ((ContainerFigure)ContainerEditPart.this.getPrimaryShape()).getViewport();
                }
            };
        }
        return super.getAdapter(key);
    }

    @Override
    public void detachTargetEditPart(TargetFilterEditPart ep) {
        ArrayList<TargetFilterFigureListener> toRemove = new ArrayList<TargetFilterFigureListener>();
        for (TargetFilterFigureListener l : this.targetFiltersListeners) {
            if (l.ep != ep) continue;
            this.getFigure().removeFigureListener((FigureListener)l);
            toRemove.add(l);
        }
        this.targetFiltersListeners.removeAll(toRemove);
    }

    @Override
    public void attachTargetEditPart(TargetFilterEditPart ep) {
        TargetFilterFigureListener l = new TargetFilterFigureListener(ep);
        this.targetFiltersListeners.add(l);
        this.getFigure().addFigureListener((FigureListener)l);
        ep.relocateFigure((GraphicalEditPart)this);
    }

    private class TargetFilterFigureListener
    implements FigureListener {
        TargetFilterEditPart ep;

        TargetFilterFigureListener(TargetFilterEditPart ep) {
            this.ep = ep;
        }

        public void figureMoved(IFigure source) {
            if (source == ContainerEditPart.this.getFigure() && this.ep != null) {
                this.ep.relocateFigure((GraphicalEditPart)ContainerEditPart.this);
            }
        }
    }
}

