/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.swt.graphics.Color;

public class JoinLeftDecoration
extends Polygon
implements RotatableDecoration {
    public static final PointList TRIANGLE_TIP = new PointList();
    private Point location = new Point();
    private PointList template = TRIANGLE_TIP;
    private Transform transform = new Transform();
    private PointList points = new PointList();
    private IFigure containerFigure;
    double xScale = 1.0;
    private PrecisionPoint newAnchorLocation;

    static {
        TRIANGLE_TIP.addPoint(1, 0);
        TRIANGLE_TIP.addPoint(0, 1);
        TRIANGLE_TIP.addPoint(0, -1);
    }

    public JoinLeftDecoration(IFigure containerFigure) {
        this.setFill(true);
        this.setScale(7.0, 3.0);
        this.containerFigure = containerFigure;
    }

    public Color getLocalBackgroundColor() {
        if (super.getLocalBackgroundColor() == null) {
            return this.getForegroundColor();
        }
        return super.getLocalBackgroundColor();
    }

    public PointList getPoints() {
        if (this.points == null) {
            this.points = new PointList();
            if (this.template != null) {
                int i = 0;
                while (i < this.template.size()) {
                    this.points.addPoint(this.transform.getTransformed(this.template.getPoint(i)));
                    ++i;
                }
            }
        }
        return this.points;
    }

    public void setLocation(Point p) {
        this.points = null;
        this.bounds = null;
        this.location.setLocation(p);
        this.transform.setTranslation((double)p.x, (double)p.y);
    }

    public void setTemplate(PointList pl) {
        this.erase();
        this.template = pl;
        this.points = null;
        this.bounds = null;
        this.repaint();
    }

    public void setScale(double x, double y) {
        this.points = null;
        this.bounds = null;
        this.transform.setScale(x, y);
        this.xScale = x;
    }

    public void setReferencePoint(Point ref) {
        Point pt = Point.SINGLETON;
        pt.setLocation(ref);
        pt.negate().translate(this.location);
        this.setRotation(Math.atan2(pt.y, pt.x));
    }

    public void setRotation(double angle) {
        this.points = null;
        this.bounds = null;
        Rectangle bounds = this.containerFigure.getBounds();
        boolean isTop = bounds.y == this.location.y;
        boolean isBottm = bounds.y + bounds.height == this.location.y;
        boolean isLeft = bounds.x == this.location.x;
        boolean isRight = bounds.x + bounds.width == this.location.x;
        this.newAnchorLocation = null;
        double teta = 0.0;
        if (isTop) {
            if (isLeft) {
                teta = 0.7853981633974483;
                this.transform.setRotation(0.7853981633974483);
            } else if (isRight) {
                teta = -0.7853981633974483;
                this.transform.setRotation(-0.7853981633974483);
            } else {
                teta = -1.5707963267948966;
                this.transform.setRotation(-1.5707963267948966);
                this.newAnchorLocation = new PrecisionPoint((double)this.location.x, (double)this.location.y - this.xScale);
            }
        } else if (isBottm) {
            if (isLeft) {
                teta = -2.356194490192345;
                this.transform.setRotation(-2.356194490192345);
            } else if (isRight) {
                teta = -0.7853981633974483;
                this.transform.setRotation(-0.7853981633974483);
            } else {
                teta = 1.5707963267948966;
                this.transform.setRotation(1.5707963267948966);
            }
        } else if (isLeft) {
            teta = Math.PI;
            this.transform.setRotation(Math.PI);
        }
        this.newAnchorLocation = new PrecisionPoint((double)this.location.x + this.xScale * Math.cos(teta), (double)this.location.y + this.xScale * Math.sin(teta));
    }

    public Point getNewContainerAnchorLocation() {
        return this.newAnchorLocation;
    }
}

