/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.policies.MappingHighlightingEditPolicy;
import com.indy.gmf.map.diagram.custom.figures.IBlendableFigure;
import com.indy.map.IContainer;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.services.IDropValidationService;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class DragBlenderEditPolicy
extends GraphicalEditPolicy {
    public static final String ROLE_DRAG_BLEND = "com.indy.gmf.map.diagram.custom.edit.policies.blendDrag";
    private int shadowWidth = 15;

    public Command getCommand(final Request request) {
        if (request instanceof BlendRequest) {
            Command cmd = new Command(){

                public boolean canExecute() {
                    return true;
                }

                public boolean canUndo() {
                    return true;
                }

                private void blend(boolean blend) {
                    IGraphicalEditPart gep = (IGraphicalEditPart)DragBlenderEditPolicy.this.getHost();
                    for (IContainer c : ((BlendRequest)request).container) {
                        IFigure f;
                        IGraphicalEditPart ep = (IGraphicalEditPart)gep.findEditPart((EditPart)gep, (EObject)c);
                        if (ep == null || !((f = ep.getContentPane()) instanceof IBlendableFigure)) continue;
                        ((IBlendableFigure)f).setAlphaBlended(blend);
                    }
                }

                public void undo() {
                    this.blend(!((BlendRequest)request).blend);
                    MappingHighlightingEditPolicy ep = (MappingHighlightingEditPolicy)DragBlenderEditPolicy.this.getHost().getEditPolicy((Object)"hightlightMappingRole");
                    if (ep != null && ep.getSelectedTargetContainer() != null) {
                        ep.refresh();
                    }
                }

                public void execute() {
                    this.blend(((BlendRequest)request).blend);
                }
            };
            return cmd;
        }
        if (request instanceof BorderRequest) {
            Command cmd = new Command(){
                private IFigure figure;

                public boolean canUndo() {
                    return this.figure != null;
                }

                public boolean canExecute() {
                    return true;
                }

                public void undo() {
                    LayerManager.Helper.find((EditPart)DragBlenderEditPolicy.this.getHost()).getLayer((Object)"borderLayer").remove(this.figure);
                    this.figure = null;
                }

                public void execute() {
                    RGB rgb1 = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColor");
                    RGB rgb2 = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.targetColor");
                    Color color1 = null;
                    Color color2 = null;
                    boolean bothColor = false;
                    switch (((BorderRequest)request).dropType) {
                        case JOIN_ALLOWED: {
                            color1 = Activator.getDefault().getColor(rgb1);
                            break;
                        }
                        case MAP_ALLOWED: {
                            color2 = Activator.getDefault().getColor(rgb2);
                            break;
                        }
                        case MAP_JOIN_ALLOWED: {
                            color1 = Activator.getDefault().getColor(rgb1);
                            color2 = Activator.getDefault().getColor(rgb2);
                        }
                    }
                    ShadowFigure f = new ShadowFigure(color1, color2);
                    f.setOpaque(true);
                    this.figure = f;
                    IGraphicalEditPart gep = (IGraphicalEditPart)DragBlenderEditPolicy.this.getHost();
                    IGraphicalEditPart ep = (IGraphicalEditPart)gep.findEditPart((EditPart)gep, (EObject)((BorderRequest)request).container);
                    Rectangle b = ep.getFigure().getBounds().getCopy();
                    ep.getFigure().translateToAbsolute((Translatable)b);
                    LayerManager.Helper.find((EditPart)DragBlenderEditPolicy.this.getHost()).getLayer((Object)"borderLayer").translateToRelative((Translatable)b);
                    this.figure.setBounds(b);
                    LayerManager.Helper.find((EditPart)DragBlenderEditPolicy.this.getHost()).getLayer((Object)"borderLayer").add(this.figure);
                }
            };
            return cmd;
        }
        return super.getCommand(request);
    }

    public static class BlendRequest
    extends Request {
        private List<IContainer> container;
        private boolean blend;

        public BlendRequest(List<IContainer> container, boolean blend) {
            this.container = container;
            this.blend = blend;
        }
    }

    public static class BorderRequest
    extends Request {
        private IContainer container;
        private IDropValidationService.DropResult dropType;

        public BorderRequest(IContainer container, IDropValidationService.DropResult dropType) {
            this.container = container;
            this.dropType = dropType;
        }
    }

    private class ShadowFigure
    extends RectangleFigure {
        Color color1;
        Color color2;

        ShadowFigure(Color color1, Color color2) {
            this.color1 = color1;
            this.color2 = color2;
        }

        protected void fillShape(Graphics graphics) {
            Rectangle shadowBounds;
            int i;
            Rectangle b = null;
            graphics.setAlpha(255);
            if (this.color1 != null) {
                b = this.getBounds().getCopy();
                b = b.shrink(DragBlenderEditPolicy.this.shadowWidth, DragBlenderEditPolicy.this.shadowWidth);
                graphics.setBackgroundColor(this.color1);
                graphics.setAlpha(255 / DragBlenderEditPolicy.this.shadowWidth * 3);
                i = 0;
                while (i < DragBlenderEditPolicy.this.shadowWidth) {
                    shadowBounds = b.getTranslated(-i, i);
                    graphics.fillRectangle(shadowBounds);
                    ++i;
                }
            }
            if (this.color2 != null) {
                b = this.getBounds().getCopy();
                b = b.shrink(DragBlenderEditPolicy.this.shadowWidth, DragBlenderEditPolicy.this.shadowWidth);
                graphics.setBackgroundColor(this.color2);
                graphics.setAlpha(255 / DragBlenderEditPolicy.this.shadowWidth * 3);
                i = 0;
                while (i < DragBlenderEditPolicy.this.shadowWidth) {
                    shadowBounds = b.getTranslated(i, -i);
                    graphics.fillRectangle(shadowBounds);
                    ++i;
                }
            }
        }

        public void setBounds(Rectangle rect) {
            rect = rect.expand(DragBlenderEditPolicy.this.shadowWidth, DragBlenderEditPolicy.this.shadowWidth);
            super.setBounds(rect);
        }

        protected void outlineShape(Graphics graphics) {
        }
    }
}

