/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.policies.DataSetInheritanceEditPolicy;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.compute.graph.Edge;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.GraphBuilderFactory;
import com.indy.map.compute.graph.Vertice;
import com.indy.map.compute.graph.tools.LoopDetector;
import java.lang.ref.WeakReference;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.ConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

public class InheritanceConnectionEditPolicy
extends ConnectionEditPolicy {
    public static final String REQ_FLIP_LINK = "com.indy.gmf.map.diagram.custom.edit.policies.InheritanceConnectionEditPolicy.flipLink";

    protected Command createDeleteViewCommand(GroupRequest deleteRequest) {
        CompoundCommand cc = new CompoundCommand();
        cc.add(super.createDeleteViewCommand(deleteRequest));
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        final DataSet parent = ((IContainer)((IGraphicalEditPart)((ConnectionNodeEditPart)this.getHost()).getSource()).resolveSemanticElement()).getDataset();
        final DataSet child = ((IContainer)((IGraphicalEditPart)((ConnectionNodeEditPart)this.getHost()).getTarget()).resolveSemanticElement()).getDataset();
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(editingDomain, Messages.InheritanceConnectionEditPolicy_1, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                DataSet p = parent;
                DataSet c = child;
                p.getChild().remove((Object)c);
                c.getParent().remove((Object)p);
                return CommandResult.newOKCommandResult();
            }
        };
        cc.add((Command)new ICommandProxy((ICommand)cmd));
        return cc;
    }

    public Command getCommand(Request request) {
        if (REQ_FLIP_LINK.equals(request.getType())) {
            return this.createFlipLinkCommand();
        }
        return super.getCommand(request);
    }

    private Command createFlipLinkCommand() {
        EObject sObj = ((IGraphicalEditPart)((ConnectionEditPart)this.getHost()).getSource()).resolveSemanticElement();
        EObject tObj = ((IGraphicalEditPart)((ConnectionEditPart)this.getHost()).getTarget()).resolveSemanticElement();
        if (sObj instanceof IContainer) {
            tObj = ((Join)tObj).getLeft() == sObj ? ((Join)tObj).getRight() : ((Join)tObj).getLeft();
        } else {
            sObj = ((Join)sObj).getLeft() == tObj ? ((Join)sObj).getRight() : ((Join)sObj).getLeft();
        }
        IContainer source = (IContainer)sObj;
        IContainer target = (IContainer)tObj;
        Map mapModel = (Map)source.eContainer();
        Graph graph = GraphBuilderFactory.INSTANCE.getGraphBuilder(GraphBuilderFactory.GraphType.DATASET, (Object)mapModel);
        Vertice vSource = graph.getVertice((Object)source.getDataset());
        graph.registerModel4Vertice((Object)source, vSource);
        Vertice vTarget = graph.getVertice((Object)target.getDataset());
        graph.registerModel4Vertice((Object)target, vTarget);
        Edge edge = graph.getEdge(vSource, vTarget);
        if (edge == null) {
            return UnexecutableCommand.INSTANCE;
        }
        edge.flip();
        LoopDetector detector = new LoopDetector(graph);
        if (detector.hasLoop_Tarjan()) {
            return UnexecutableCommand.INSTANCE;
        }
        DestroyElementRequest req = new DestroyElementRequest(false);
        req.getParameters().put("destroyLinkWithoutMerge", Boolean.TRUE);
        CompoundCommand cc = new CompoundCommand(Messages.InheritanceConnectionEditPolicy_2);
        Command delCmd = ((IGraphicalEditPart)this.getHost()).getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)req));
        cc.add(delCmd);
        EditPart sourceGep = ((IGraphicalEditPart)this.getHost()).findEditPart((EditPart)this.getHost().getRoot(), (EObject)source);
        EditPart targetGep = ((IGraphicalEditPart)this.getHost()).findEditPart((EditPart)this.getHost().getRoot(), (EObject)target);
        DataSetInheritanceEditPolicy.InheritenceRequest inheritReq = new DataSetInheritanceEditPolicy.InheritenceRequest(false, true, targetGep);
        inheritReq.setTargetEditPart(sourceGep);
        Command inheritCmd = sourceGep.getCommand((Request)inheritReq);
        cc.add(inheritCmd);
        cc.add(new Command(){
            WeakReference<EObject> modelElement;
            {
                this.modelElement = new WeakReference<EObject>(((IGraphicalEditPart)InheritanceConnectionEditPolicy.this.getHost()).getPrimaryView().getDiagram().getElement());
            }

            public void execute() {
                List editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)((EObject)this.modelElement.get()));
                for (CanonicalEditPolicy nextEditPolicy : editPolicies) {
                    nextEditPolicy.refresh();
                }
            }
        });
        return cc;
    }

    public EditPart getTargetEditPart(Request request) {
        if (REQ_FLIP_LINK.equals(request.getType())) {
            return this.getHost();
        }
        return super.getTargetEditPart(request);
    }
}

