/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies.tools;

import com.indy.gmf.map.diagram.custom.edit.policies.tools.IToolDescriptor;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ToolHandle
extends AbstractHandle {
    private IToolDescriptor descriptor;
    private ImageFigure figureImage;
    private IFigure figure = new Figure();
    protected static Color hoverColor = new Color(null, 222, 239, 255);
    protected static Color borderColor = new Color(null, 102, 167, 232);
    protected static Color selectedColor = new Color(null, 191, 223, 255);
    public static Border NO_BORDER = new MarginBorder(1);
    public static Border HOVER_BORDER = new LineBorder(borderColor);
    protected boolean isSelected;
    private Color unhoverColor;

    public ToolHandle(IGraphicalEditPart gep, IToolDescriptor descriptor) {
        super((GraphicalEditPart)gep, null);
        this.figure.setLayoutManager((LayoutManager)new StackLayout());
        this.descriptor = descriptor;
        this.figureImage = new ImageFigure(descriptor.getImage());
        this.figure.add((IFigure)this.figureImage);
        this.figure.setBorder(NO_BORDER);
        if (descriptor.getBackgroundColor() != null) {
            this.figure.setOpaque(true);
            this.figure.setBackgroundColor(descriptor.getBackgroundColor());
        }
        this.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseMoved(MouseEvent me) {
                ToolHandle.this.validate();
            }

            public void mouseEntered(MouseEvent me) {
                if (!ToolHandle.this.isSelected) {
                    ToolHandle.this.figure.setBorder(HOVER_BORDER);
                    ToolHandle.this.unhoverColor = ToolHandle.this.getBackgroundColor();
                    ToolHandle.this.validate();
                }
            }

            public void mouseExited(MouseEvent me) {
                if (!ToolHandle.this.isSelected) {
                    ToolHandle.this.figure.setBorder(NO_BORDER);
                    ToolHandle.this.validate();
                }
            }
        });
        this.setToolTip((IFigure)new Label(descriptor.getDescription()));
        this.setLocator(new Locator(){

            public void relocate(IFigure target) {
                Rectangle r = ToolHandle.this.getFigure().getBounds().getCopy();
                ToolHandle.this.getFigure().translateToAbsolute((Translatable)r);
                ToolHandle.this.translateToRelative((Translatable)r);
                target.setBounds(r);
            }
        });
    }

    public void setImage(Image img) {
        this.figureImage.setImage(img);
    }

    public IFigure getFigure() {
        return this.figure;
    }

    protected DragTracker createDragTracker() {
        return this.getDescriptor().createTracker((IGraphicalEditPart)this.getOwner(), (IFigure)this);
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (this.getBounds().contains(x, y)) {
            return this;
        }
        return super.findFigureAt(x, y, search);
    }

    public void validate() {
        super.validate();
    }

    public IToolDescriptor getDescriptor() {
        return this.descriptor;
    }
}

