/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.navigator;

import com.indy.map.diagram.navigator.MapAbstractNavigatorItem;
import com.indy.map.diagram.navigator.MapNavigatorGroup;
import com.indy.map.diagram.navigator.MapNavigatorItem;
import com.indy.map.diagram.part.MapVisualIDRegistry;
import com.indy.ui.custom.out.gmf.StambiaGMFEditingDomainFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class MapNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public MapNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = StambiaGMFEditingDomainFactory.instanceGMF.createEditingDomain();
        editingDomain.getResourceSet().getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (MapNavigatorContentProvider.this.myViewer != null) {
                    MapNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                MapNavigatorContentProvider.this.unloadAllResources();
                MapNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                MapNavigatorContentProvider.this.unloadAllResources();
                MapNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                MapNavigatorContentProvider.this.unloadAllResources();
                MapNavigatorContentProvider.this.asyncRefresh();
                return true;
            }
        });
    }

    public void dispose() {
        this.myViewer = null;
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        this.myViewer = null;
        this.unloadAllResources();
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    void unloadAllResources() {
        for (Resource nextResource : this.myEditingDomain.getResourceSet().getResources()) {
            nextResource.unload();
        }
    }

    void asyncRefresh() {
        if (this.myViewer != null && !this.myViewer.getControl().isDisposed()) {
            this.myViewer.getControl().getDisplay().asyncExec(this.myViewerRefreshRunnable);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            ArrayList<View> topViews = new ArrayList<View>(resource.getContents().size());
            for (EObject o : resource.getContents()) {
                if (!(o instanceof View)) continue;
                topViews.add((View)o);
            }
            return result.toArray();
        }
        if (parentElement instanceof MapNavigatorGroup) {
            MapNavigatorGroup group = (MapNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof MapNavigatorItem) {
            MapNavigatorItem navigatorItem = (MapNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        MapVisualIDRegistry.getVisualID(view);
        return EMPTY_ARRAY;
    }

    private Collection<View> getLinksSourceByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection<View> getLinksTargetByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection<View> getOutgoingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getSourceEdges(), type));
        }
        return result;
    }

    private Collection<View> getIncomingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getTargetEdges(), type));
        }
        return result;
    }

    private Collection<View> getChildrenByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getChildren(), type));
        }
        return result;
    }

    private Collection<View> getDiagramLinksByType(Collection<Diagram> diagrams, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection<View>)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection<View> selectViewsByType(Collection<View> views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "Map".equals(MapVisualIDRegistry.getModelID(view));
    }

    private Collection<MapNavigatorItem> createNavigatorItems(Collection<View> views, Object parent, boolean isLeafs) {
        ArrayList<MapNavigatorItem> result = new ArrayList<MapNavigatorItem>(views.size());
        for (View nextView : views) {
            result.add(new MapNavigatorItem(nextView, parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof MapAbstractNavigatorItem) {
            MapAbstractNavigatorItem abstractNavigatorItem = (MapAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

